This is Info file libc.i, produced by Makeinfo-1.55 from the input file
libc.tex.

This is the reference manual for libc.a

Copyright (c) 1993 DJ Delorie


File: libc,  Node: Top,  Next: Introduction,  Prev: (dir),  Up: (dir)

* Menu:

* Introduction::

* Overview::               A list of most libraries and what
                           they're used for.

* Functional Categories::  All public symbols listed by
                           category

* Alphabetical List::      All public symbols in alphabetical
                           order

* Index::


File: libc,  Node: Introduction,  Next: Overview,  Prev: Top,  Up: Top

Introduction
************

The standard C library, `libc.a', is automatically linked into your
programs by the `gcc' control program.  It provides many of the
functions that are normally associated with C programs.  This document
gives the proper usage information about each of the functions and
variables found in `libc.a'.

For each function or variable that the library provides, the definition
of that symbol will include information on which header files to include
in your source to obtain prototypes and type definitions relevent to the
use of that symbol.


File: libc,  Node: Overview,  Next: Functional Categories,  Prev: Introduction,  Up: Top

Each library is of the form `libXXX.a' or `libXXX_p.a', where `XXX' is
the module name.  To use a library, you must add `-lXXX' to the link
line.  Only libc.a and libgcc.a are linked in by default, so if you
want to use any of the other libraries you must give them explicitely.

Libraries with the `_p' were compiled with the `-pg' switch, and will
be used when you link with that switch.  This allows the profiler to
obtain information about library functions as well as your modules.

`libbison.a'
     This library has default functions for Bison programs.  Use this
     if you use only the .y file to define your program.

`libc.a'
`libc_p.a'
     This is the standard C library.

`libflex.a'
`libflex_.a'
     This library has default functions for Flex programs.  Use this if
     you use only the .l file to define your program.

`libiostream.a'
     This library includes the standard C++ I/O classes.  Although these
     routines are LGPL, as a special exception, if your program (all or
     part) was compiled with gcc, use of this library does not in itself
     cause your program to come under the GPL or LGPL.  See the
     copyright in the source for more information.  These classes are
     also included in libgpp.a.

`libg.a'
`libg_p.a'
     This is an empty library that the compiler sometimes includes in
     your link.

`libgcc.a'
`libgcc_p.a'
     This library has helper functions that gcc sometimes links into
     your program for runtime support.

`libgpl.a'
`libgpl_p.a'
     This library has a few routines that are protected by the GPL.

     *Warning!* Use of this library in your program may alter the
     copyright status of your program.

`libgpp.a'
     C++ support library.  You must link this for most C++ programs by
     giving "-lgpp" on the link line.  This library includes both the
     iostream routines and the GNU C++ classes.

     *Warning!* Use of this library in your program may alter the
     copyright status of your program.

`libgr.a'
`libgr_p.a'
     Simple, 256-color only graphics routines.  The GRX module has a
     more complete graphics library.

`libm.a'
`libm_p.a'
     Various math routines.  If you use `<math.h>', chances are you'll
     need this also.  Some classes in `libgplus.a' also require this, so
     you'll need `-lgplus -lm' in that case.

`libobjc.a'
     Objective-C modules.  You'll need to add `-lobjc' to your link to
     use these.

`libpc.a'
`libpc_p.a'
     Some routines found in `<pc.h>', including conio, screen, and sound
     routines.


File: libc,  Node: Functional Categories,  Next: Alphabetical List,  Prev: Overview,  Up: Top

Functional Categories
*********************

* Menu:

* bios functions::
* ctype functions::
* dos functions::
* dpmi functions::
* environment functions::
* file system functions::
* go32 functions::
* header functions::
* io functions::
* locale functions::
* math functions::
* memory functions::
* misc functions::
* posix functions::
* process functions::
* random number functions::
* signal functions::
* stdio functions::
* string functions::
* time functions::
* unix functions::


File: libc,  Node: bios functions,  Next: ctype functions,  Up: Functional Categories

* Menu:

* bioscom::
* biosdisk::
* biosequip::
* bioskey::
* biosmemory::
* biosprint::
* biostime::


File: libc,  Node: ctype functions,  Next: dos functions,  Prev: bios functions,  Up: Functional Categories

* Menu:

* _ctype_::
* isalnum::
* isalpha::
* iscntrl::
* isdigit::
* isgraph::
* islower::
* isprint::
* ispunct::
* isspace::
* isupper::
* isxdigit::
* tolower::
* toupper::


File: libc,  Node: dos functions,  Next: dpmi functions,  Prev: ctype functions,  Up: Functional Categories

* Menu:

* bdos::
* bdosptr::
* delay::
* disable::
* enable::
* _get_default_drive::
* getcbrk::
* getdisk::
* getkey::
* getxkey::
* int86::
* int86x::
* intdos::
* intdosx::
* kbhit::
* setcbrk::
* setdisk::


File: libc,  Node: dpmi functions,  Next: environment functions,  Prev: dos functions,  Up: Functional Categories

* Menu:

* Go32/DPMI Information::
* _go32_dpmi_allocate_dos_memory::
* _go32_dpmi_allocate_iret_wrapper::
* _go32_dpmi_allocate_real_mode_callback_iret::
* _go32_dpmi_allocate_real_mode_callback_retf::
* _go32_dpmi_chain_protected_mode_interrupt_vector::
* _go32_dpmi_free_dos_memory::
* _go32_dpmi_free_iret_wrapper::
* _go32_dpmi_free_real_mode_callback::
* _go32_dpmi_get_free_memory_information::
* _go32_dpmi_get_protected_mode_interrupt_vector::
* _go32_dpmi_get_real_mode_interrupt_vector::
* _go32_dpmi_remaining_physical_memory::
* _go32_dpmi_remaining_virtual_memory::
* _go32_dpmi_resize_dos_memory::
* _go32_dpmi_set_protected_mode_interrupt_vector::
* _go32_dpmi_set_real_mode_interrupt_vector::
* _go32_dpmi_simulate_fcall::
* _go32_dpmi_simulate_fcall_iret::
* _go32_dpmi_simulate_int::
* _go32_info_block::


File: libc,  Node: environment functions,  Next: file system functions,  Prev: dpmi functions,  Up: Functional Categories

* Menu:

* _findenv::
* getenv::
* putenv::
* setenv::
* unsetenv::


File: libc,  Node: file system functions,  Next: go32 functions,  Prev: environment functions,  Up: Functional Categories

* Menu:

* access::
* chdir::
* chmod::
* closedir::
* findfirst::
* findnext::
* _fixpath::
* fnmatch::
* fnmerge::
* fnsplit::
* fpathconf::
* getcwd::
* getdfree::
* getftime::
* getwd::
* mkdir::
* mkstemp::
* mktemp::
* opendir::
* readdir::
* remove::
* rename::
* rewinddir::
* rmdir::
* seekdir::
* setftime::
* statfs::
* telldir::
* umask::
* unlink::
* utime::


File: libc,  Node: go32 functions,  Next: header functions,  Prev: file system functions,  Up: Functional Categories

* Menu:

* dosmemget::
* dosmemput::
* _go32_conventional_mem_selector::
* _go32_my_cs::
* _go32_my_ds::
* _go32_my_ss::
* _go32_want_ctrl_break::
* _go32_was_ctrl_break_hit::
* _setstack::
* _stklen::


File: libc,  Node: header functions,  Next: io functions,  Prev: go32 functions,  Up: Functional Categories

* Menu:

* aout.h::
* ar.h::
* atexit.h::
* bios.h::
* bool.h::
* coff.h::
* dos.h::
* dpmi.h::
* go32.h::
* gppconio.h/conio.h::
* graphics.h::
* keys.h::
* mouse.h::
* pc.h::


File: libc,  Node: io functions,  Next: locale functions,  Prev: header functions,  Up: Functional Categories

* Menu:

* close::
* creat::
* crlf2nl::
* dup::
* dup2::
* link::
* lock::
* lseek::
* open::
* read::
* readcr::
* readv::
* setmode::
* _setmode::
* sopen::
* stat::
* stat_assist::
* tell::
* truncate::
* unlock::
* write::
* writecr::
* writev::


File: libc,  Node: locale functions,  Next: math functions,  Prev: io functions,  Up: Functional Categories

* Menu:

* localeconv::
* mblen::
* mbstowcs::
* mbtowc::
* setlocale::
* strcoll::
* strxfrm::
* wcstombs::
* wctomb::


File: libc,  Node: math functions,  Next: memory functions,  Prev: locale functions,  Up: Functional Categories

* Menu:

* abs::
* div::
* ldexp::
* ldiv::
* modf::
* modfl::


File: libc,  Node: memory functions,  Next: misc functions,  Prev: math functions,  Up: Functional Categories

* Menu:

* alloca::
* bcmp::
* bcopy::
* _bcopy::
* brk::
* bzero::
* calloc::
* cfree::
* free::
* malloc::
* memccpy::
* memchr::
* memcmp::
* memcpy::
* _memcpy::
* memmove::
* memset::
* morecore::
* movedata::
* realloc::
* realloc_srchlen::
* sbrk::
* valloc::
* xmalloc::
* xrealloc::


File: libc,  Node: misc functions,  Next: posix functions,  Prev: memory functions,  Up: Functional Categories

* Menu:

* assert::
* bsearch::
* ffs::
* getopt::
* getpagesize::
* htonl::
* htons::
* insque::
* labs::
* longjmp::
* longjmperror::
* ntohl::
* ntohs::
* offsetof::
* optarg::
* opterr::
* optind::
* optopt::
* qsort::
* remque::
* setjmp::
* setstate::
* swab::
* swap::
* va_*::


File: libc,  Node: posix functions,  Next: process functions,  Prev: misc functions,  Up: Functional Categories

* Menu:

* getdtablesize::
* pathconf::
* sysconf::


File: libc,  Node: process functions,  Next: random number functions,  Prev: posix functions,  Up: Functional Categories

* Menu:

* abort::
* atexit::
* __atexit::
* _cleanup::
* exec*::
* exit::
* _exit::
* kill::
* __main::
* on_exit::
* sleep::
* spawn*::
* system::
* usleep::


File: libc,  Node: random number functions,  Next: signal functions,  Prev: process functions,  Up: Functional Categories

* Menu:

* initstate::
* rand::
* random::
* srand::
* srandom::


File: libc,  Node: signal functions,  Next: stdio functions,  Prev: random number functions,  Up: Functional Categories

* Menu:

* sigaction::
* sigaddset::
* sigdelset::
* sigemptyset::
* sigfillset::
* sigismember::
* signal::
* sigsetmask::


File: libc,  Node: stdio functions,  Next: string functions,  Prev: signal functions,  Up: Functional Categories

* Menu:

* clearerr::
* _doprnt::
* _doscan::
* _doscan_low::
* EOF::
* errno::
* _f_morefiles::
* fclose::
* fdopen::
* feof::
* ferror::
* fflush::
* fgetc::
* fgetpos::
* fgets::
* _filbuf::
* fileno::
* _findiop::
* _flsbuf::
* _fmode::
* fopen::
* fprintf::
* fpurge::
* fputc::
* fputs::
* fread::
* freopen::
* fscanf::
* fseek::
* fsetpos::
* fstat::
* fsync::
* ftell::
* ftruncate::
* _fwalk::
* fwrite::
* getc::
* getchar::
* gets::
* getw::
* _iob::
* perror::
* printf::
* putc::
* putchar::
* puts::
* putw::
* rewind::
* scanf::
* setbuf::
* setbuffer::
* setlinebuf::
* setvbuf::
* _smallbuf::
* sprintf::
* sscanf::
* stdin/stdout/stderr/stdprn/stdaux::
* strerror::
* sys_errlist::
* sys_nerr::
* tempnam::
* tmpfile::
* tmpnam::
* ungetc::
* vfprintf::
* vprintf::
* vsprintf::


File: libc,  Node: string functions,  Next: time functions,  Prev: stdio functions,  Up: Functional Categories

* Menu:

* atof::
* atoi::
* atol::
* _atold::
* index::
* itoa::
* rindex::
* strcasecmp::
* strcat::
* strchr::
* strcmp::
* strcpy::
* strcspn::
* strdup::
* stricmp::
* strlen::
* strlwr::
* strncasecmp::
* strncat::
* strncmp::
* strncpy::
* strnicmp::
* strpbrk::
* strrchr::
* strsep::
* strspn::
* strstr::
* strtod::
* strtok::
* strtol::
* _strtold::
* strtoul::
* strupr::


File: libc,  Node: time functions,  Next: unix functions,  Prev: string functions,  Up: Functional Categories

* Menu:

* asctime::
* clock::
* ctime::
* difftime::
* ftime::
* getdate::
* gettime::
* gettimeofday::
* gmtime::
* isleap::
* localtime::
* mktime::
* rawclock::
* setdate::
* settime::
* settimeofday::
* strftime::
* time::
* timezone::
* tzname::
* tzset::
* tzsetwall::
* _tztab::


File: libc,  Node: unix functions,  Prev: time functions,  Up: Functional Categories

* Menu:

* addmntent::
* chown::
* endgrent::
* endmntent::
* endpwent::
* fchmod::
* fgetgrent::
* fgetpwent::
* fork::
* getegid::
* geteuid::
* getgid::
* getgrent::
* getgrgid::
* getgrnam::
* getgroups::
* getlogin::
* getlongpass::
* getmntent::
* getpass::
* getpid::
* getpwent::
* getpwnam::
* getpwuid::
* getrusage::
* getuid::
* hasmntopt::
* isatty::
* mkfifo::
* mknod::
* nlist::
* pclose::
* pipe::
* popen::
* setgrent::
* setmntent::
* setpwent::
* sync::
* ttyname::
* utimes::
* vfork::
* wait::


File: libc,  Node: Alphabetical List,  Prev: Functional Categories,  Up: Top

Alphabetical List
*****************

* Menu:

* abort::
* abs::
* access::
* addmntent::
* alloca::
* aout.h::
* ar.h::
* asctime::
* assert::
* atexit::
* __atexit::
* atexit.h::
* atof::
* atoi::
* atol::
* _atold::
* bcmp::
* bcopy::
* _bcopy::
* bdos::
* bdosptr::
* bios.h::
* bioscom::
* biosdisk::
* biosequip::
* bioskey::
* biosmemory::
* biosprint::
* biostime::
* bool.h::
* brk::
* bsearch::
* bzero::
* calloc::
* cfree::
* chdir::
* chmod::
* chown::
* _cleanup::
* clearerr::
* clock::
* close::
* closedir::
* coff.h::
* creat::
* crlf2nl::
* ctime::
* _ctype_::
* delay::
* difftime::
* disable::
* div::
* _doprnt::
* dos.h::
* _doscan::
* _doscan_low::
* dosmemget::
* dosmemput::
* dpmi.h::
* dup::
* dup2::
* enable::
* endgrent::
* endmntent::
* endpwent::
* EOF::
* errno::
* exec*::
* exit::
* _exit::
* _f_morefiles::
* fchmod::
* fclose::
* fdopen::
* feof::
* ferror::
* fflush::
* ffs::
* fgetc::
* fgetgrent::
* fgetpos::
* fgetpwent::
* fgets::
* _filbuf::
* fileno::
* _findenv::
* findfirst::
* _findiop::
* findnext::
* _fixpath::
* _flsbuf::
* _fmode::
* fnmatch::
* fnmerge::
* fnsplit::
* fopen::
* fork::
* fpathconf::
* fprintf::
* fpurge::
* fputc::
* fputs::
* fread::
* free::
* freopen::
* fscanf::
* fseek::
* fsetpos::
* fstat::
* fsync::
* ftell::
* ftime::
* ftruncate::
* _fwalk::
* fwrite::
* _get_default_drive::
* getc::
* getcbrk::
* getchar::
* getcwd::
* getdate::
* getdfree::
* getdisk::
* getdtablesize::
* getegid::
* getenv::
* geteuid::
* getftime::
* getgid::
* getgrent::
* getgrgid::
* getgrnam::
* getgroups::
* getkey::
* getlogin::
* getlongpass::
* getmntent::
* getopt::
* getpagesize::
* getpass::
* getpid::
* getpwent::
* getpwnam::
* getpwuid::
* getrusage::
* gets::
* gettime::
* gettimeofday::
* getuid::
* getw::
* getwd::
* getxkey::
* gmtime::
* go32.h::
* Go32/DPMI Information::
* _go32_conventional_mem_selector::
* _go32_dpmi_allocate_dos_memory::
* _go32_dpmi_allocate_iret_wrapper::
* _go32_dpmi_allocate_real_mode_callback_iret::
* _go32_dpmi_allocate_real_mode_callback_retf::
* _go32_dpmi_chain_protected_mode_interrupt_vector::
* _go32_dpmi_free_dos_memory::
* _go32_dpmi_free_iret_wrapper::
* _go32_dpmi_free_real_mode_callback::
* _go32_dpmi_get_free_memory_information::
* _go32_dpmi_get_protected_mode_interrupt_vector::
* _go32_dpmi_get_real_mode_interrupt_vector::
* _go32_dpmi_remaining_physical_memory::
* _go32_dpmi_remaining_virtual_memory::
* _go32_dpmi_resize_dos_memory::
* _go32_dpmi_set_protected_mode_interrupt_vector::
* _go32_dpmi_set_real_mode_interrupt_vector::
* _go32_dpmi_simulate_fcall::
* _go32_dpmi_simulate_fcall_iret::
* _go32_dpmi_simulate_int::
* _go32_info_block::
* _go32_my_cs::
* _go32_my_ds::
* _go32_my_ss::
* _go32_want_ctrl_break::
* _go32_was_ctrl_break_hit::
* gppconio.h/conio.h::
* graphics.h::
* hasmntopt::
* htonl::
* htons::
* index::
* initstate::
* insque::
* int86::
* int86x::
* intdos::
* intdosx::
* _iob::
* isalnum::
* isalpha::
* isatty::
* iscntrl::
* isdigit::
* isgraph::
* isleap::
* islower::
* isprint::
* ispunct::
* isspace::
* isupper::
* isxdigit::
* itoa::
* kbhit::
* keys.h::
* kill::
* labs::
* ldexp::
* ldiv::
* link::
* localeconv::
* localtime::
* lock::
* longjmp::
* longjmperror::
* lseek::
* __main::
* malloc::
* mblen::
* mbstowcs::
* mbtowc::
* memccpy::
* memchr::
* memcmp::
* memcpy::
* _memcpy::
* memmove::
* memset::
* mkdir::
* mkfifo::
* mknod::
* mkstemp::
* mktemp::
* mktime::
* modf::
* modfl::
* morecore::
* mouse.h::
* movedata::
* nlist::
* ntohl::
* ntohs::
* offsetof::
* on_exit::
* open::
* opendir::
* optarg::
* opterr::
* optind::
* optopt::
* pathconf::
* pc.h::
* pclose::
* perror::
* pipe::
* popen::
* printf::
* putc::
* putchar::
* putenv::
* puts::
* putw::
* qsort::
* rand::
* random::
* rawclock::
* read::
* readcr::
* readdir::
* readv::
* realloc::
* realloc_srchlen::
* remove::
* remque::
* rename::
* rewind::
* rewinddir::
* rindex::
* rmdir::
* sbrk::
* scanf::
* seekdir::
* setbuf::
* setbuffer::
* setcbrk::
* setdate::
* setdisk::
* setenv::
* setftime::
* setgrent::
* setjmp::
* setlinebuf::
* setlocale::
* setmntent::
* setmode::
* _setmode::
* setpwent::
* _setstack::
* setstate::
* settime::
* settimeofday::
* setvbuf::
* sigaction::
* sigaddset::
* sigdelset::
* sigemptyset::
* sigfillset::
* sigismember::
* signal::
* sigsetmask::
* sleep::
* _smallbuf::
* sopen::
* spawn*::
* sprintf::
* srand::
* srandom::
* sscanf::
* stat::
* stat_assist::
* statfs::
* stdin/stdout/stderr/stdprn/stdaux::
* _stklen::
* strcasecmp::
* strcat::
* strchr::
* strcmp::
* strcoll::
* strcpy::
* strcspn::
* strdup::
* strerror::
* strftime::
* stricmp::
* strlen::
* strlwr::
* strncasecmp::
* strncat::
* strncmp::
* strncpy::
* strnicmp::
* strpbrk::
* strrchr::
* strsep::
* strspn::
* strstr::
* strtod::
* strtok::
* strtol::
* _strtold::
* strtoul::
* strupr::
* strxfrm::
* swab::
* swap::
* sync::
* sys_errlist::
* sys_nerr::
* sysconf::
* system::
* tell::
* telldir::
* tempnam::
* time::
* timezone::
* tmpfile::
* tmpnam::
* tolower::
* toupper::
* truncate::
* ttyname::
* tzname::
* tzset::
* tzsetwall::
* _tztab::
* umask::
* ungetc::
* unlink::
* unlock::
* unsetenv::
* usleep::
* utime::
* utimes::
* va_*::
* valloc::
* vfork::
* vfprintf::
* vprintf::
* vsprintf::
* wait::
* wcstombs::
* wctomb::
* write::
* writecr::
* writev::
* xmalloc::
* xrealloc::


File: libc,  Node: abort,  Next: abs,  Up: Alphabetical List

`abort'
=======

Syntax
------

     #include <stdlib.h>
     
     void volatile abort(void);

Description
-----------

When you call `abort', the message "Abort!" is printed on stdout and
the program exits with an exit code of one.

Return Value
------------

This function does not return.

Example
-------

     if ((q = malloc(100)) == NULL)
       abort();


File: libc,  Node: abs,  Next: access,  Prev: abort,  Up: Alphabetical List

`abs'
=====

Syntax
------

     #include <stdlib.h>
     
     int abs(int value);

Return Value
------------

The absolute value of `value' is returned.

Example
-------

     int sq = 7;
     sq = sq * abs(sq) + 1;


File: libc,  Node: access,  Next: addmntent,  Prev: abs,  Up: Alphabetical List

`access'
========

Syntax
------

     #include <unistd.h>
     
     int access(const char *filename, int flags);

Description
-----------

This function determines what kind of access modes a given file allows.
The parameter FLAGS is the logical `or' of one or more of the following
flags:

`R_OK'
     Request if the file is readable.  Since all files are readable
     under MS-DOS, this access mode always exists.

`W_OK'
     Request if the file is writable.

`X_OK'
     Request if the file is executable.  This flag currently has no
     affect.

`F_OK'
     Request if the file exists.

Return Value
------------

Zero if the requested access mode is allowed, nonzero if not.

Example
-------

     if (access("file.ext", W_OK))
       return ERROR_CANNOT_WRITE;
     open("file.ext", O_RDWR);


File: libc,  Node: addmntent,  Next: alloca,  Prev: access,  Up: Alphabetical List

`addmntent'
===========

Syntax
------

     #include <mntent.h>
     
     int addmntent(FILE *filep, struct mntent *mnt);

Description
-----------

This function is a no-op for MS-DOS, but is provided to assist in Unix
ports.  *Note getmntent::

Return Value
------------

This function always returns nonzero to signify an error.


File: libc,  Node: alloca,  Next: aout.h,  Prev: addmntent,  Up: Alphabetical List

`alloca'
========

Syntax
------

     #include <stdlib.h>
     
     void *alloca(int size);

Description
-----------

This function is similar to *Note malloc::.  The difference is that the
memory allocated is in the current stack frame, so when the current
function exits the memory is automatically reclaimed.  You should never
call `free()' with a pointer returned by `alloca'.

Return Value
------------

A pointer to the temporary memory.

Example
-------

     char *x = alloca(20+strlen(y));
     sprintf(x, "The value is %s", y);
     return strdup(x);


File: libc,  Node: aout.h,  Next: ar.h,  Prev: alloca,  Up: Alphabetical List

`<aout.h>'
==========

This header provides structure definitions for the a.out object and
executable file format.  While djgpp's utilities can read a.out format,
they generate coff format, and users are discouraged from using a.out
format for new programs.


File: libc,  Node: ar.h,  Next: asctime,  Prev: aout.h,  Up: Alphabetical List

`<ar.h>'
========

This header provides structure definitions and macros that define
djgpp's "ar" format, the file format used for libraries.


File: libc,  Node: asctime,  Next: assert,  Prev: ar.h,  Up: Alphabetical List

`asctime'
=========

Syntax
------

     #include <time.h>
     
     char *asctime(const struct tm *tptr);

Description
-----------

This function returns an ASCII representation of the time represented by
TPTR.  The string returned is always 26 characters and has this format:

     Sun Jan 01 12:34:56 1993\n\0

The string pointed to is in a static buffer and will be overridden with
each call to asctime.  The data should be copied if it needs to be
preserved.

Return Value
------------

A pointer to the string.

Example
-------

     time_t now;
     time(&now);
     printf("The current time is %s", asctime(localtime(&now)));


File: libc,  Node: assert,  Next: atexit,  Prev: asctime,  Up: Alphabetical List

`assert'
========

Syntax
------

     #define NDEBUG
     #include <assert.h>
     
     assert(expression);
     assertval(expression);

Description
-----------

These macros are used to assist in debugging.  The source code includes
references to assert and assertval, passing them expressions that should
be true (or non-zero).  When the expression equals zero, a diagnostic
message is printed to stderr and the program aborts.

If you define the macro `NDEBUG' before including `assert.h', then the
macros expand to nothing to reduce code size after debugging is done.

Return Value
------------

`assert' returns one if it passes, else it aborts.

`assertval' returns the value of the expression if nonzero, else it
aborts.

Example
-------

     int strdup(char *s)
     {
       assert(s != 0);


File: libc,  Node: atexit,  Next: __atexit,  Prev: assert,  Up: Alphabetical List

`atexit'
========

Syntax
------

     #include <stdlib.h>
     
     int atexit(void (*func)(void));

Description
-----------

This function places the specified function FUNC on a list of functions
to be called when `exit' is called.  These functions are called as if a
last-in-first-out queue is used, that is, the last function registered
with `atexit' will be the first function called by `exit'.

At least 32 functions can be registered this way.

Return Value
------------

Zero on success, non-zero on error.

Example
-------

     void exit_func()
     {
       remove("file.tmp");
     }
     
     ...
     atexit(exit_func);
     ...


File: libc,  Node: __atexit,  Next: atexit.h,  Prev: atexit,  Up: Alphabetical List

`__atexit'
==========

Description
-----------

This is an internal variable used by `atexit' (*note atexit::.) and
`on_exit' (*note on_exit::.).


File: libc,  Node: atexit.h,  Next: atof,  Prev: __atexit,  Up: Alphabetical List

`<atexit.h>'
============

This header provides definitions for routines that will run when the
program exits.


File: libc,  Node: atof,  Next: atoi,  Prev: atexit.h,  Up: Alphabetical List

`atof'
======

Syntax
------

     #include <stdlib.h>
     
     double atof(const char *string);

Description
-----------

Convert as much of the string as possible to an equivalent double
precision real number.

This function is almost like `strtod(string, NULL)' (*note strtod::.).

Return Value
------------

The equivalent value, or zero if the string does not represent a number.

Example
-------

     main(int argc, char **argv)
     {
       double d = atof(argv[1]);
       ...


File: libc,  Node: atoi,  Next: atol,  Prev: atof,  Up: Alphabetical List

`atoi'
======

Syntax
------

     #include <stdlib.h>
     
     int atoi(const char *string);

Description
-----------

Convert as much of the string as possible to an equivalent integer
value.

This function is almost like `(int)strtol(string, NULL, 10)' (*note
strtol::.).

Return Value
------------

The equivalent value, or zero if the string does not represent a number.

Example
-------

     main(int argc, char **argv)
     {
       int i = atoi(argv[1]);
       ...


File: libc,  Node: atol,  Next: _atold,  Prev: atoi,  Up: Alphabetical List

`atol'
======

Syntax
------

     #include <stdlib.h>
     
     long atol(const char *string);

Description
-----------

Convert as much of the string as possible to an equivalent long integer
value.

This function is almost like `strtol(string, NULL, 10)' (*note
strtol::.).

Return Value
------------

The equivalent value, or zero if the string does not represent a number.

Example
-------

     main(int argc, char **argv)
     {
       long l = atol(argv[1]);
       ...


File: libc,  Node: _atold,  Next: bcmp,  Prev: atol,  Up: Alphabetical List

`_atold'
========

Syntax
------

     #include <stdlib.h>
     
     long double _atold(const char *string);

Description
-----------

Convert as much of the string as possible to an equivalent long double
precision real number.

This function is almost like `_strtold(string, NULL)' (*note
_strtold::.).

Return Value
------------

The equivalent value, or zero if the string does not represent a number.

Example
-------

     main(int argc, char **argv)
     {
       long double d = _atold(argv[1]);
       ...


File: libc,  Node: bcmp,  Next: bcopy,  Prev: _atold,  Up: Alphabetical List

`bcmp'
======

Syntax
------

     #include <string.h>
     
     int bcmp(const void *ptr1, const void *ptr2, int length);

Description
-----------

Compare memory pointed to by PTR1 and PTR2 for at most LENGTH bytes.

Return Value
------------

The number of bytes remaining when the first mismatch occurred, or zero
if all bytes were equal.

Example
-------

     void f(char *s1, char *s2)
     {
       int l = bcmp(s1, s2, strlen(s1));
       printf("Difference: %s, %s\n", s1+strlen(s1)-l, s2+strlen(s1)-l);
     }


File: libc,  Node: bcopy,  Next: _bcopy,  Prev: bcmp,  Up: Alphabetical List

`bcopy'
=======

Syntax
------

     #include <string.h>
     
     void bcopy(const void *source, void *dest, int length);

Description
-----------

Copy LENGTH bytes from SOURCE to DEST.  Overlapping regions are handled
properly, although this behavior is not portable.

Return Value
------------

No value is returned.

Example
-------

     struct s a, b;
     bcopy(a, b, sizeof(struct s));


File: libc,  Node: _bcopy,  Next: bdos,  Prev: bcopy,  Up: Alphabetical List

`_bcopy'
========

Syntax
------

     #include <string.h>
     
     void _bcopy(const void *source, void *dest, int length);

Description
-----------

Copy LENGTH bytes from SOURCE to DEST.  This is just like `bcopy'
(*note bcopy::.), except that the loads and stores are done with
different opcodes in case SOURCE and DEST can't be paged in at the same
time (like blitting in the graphics buffer).

Return Value
------------

No value is returned.

Example
-------

     bcopy(ScreenPrimary+ScreenCols()*2, ScreenPrimary,
       (ScreenRows()-1)*ScreenCols()*2);


File: libc,  Node: bdos,  Next: bdosptr,  Prev: _bcopy,  Up: Alphabetical List

`bdos'
======

Syntax
------

     #include <dos.h>
     
     int bdos(int func, unsigned edx, unsigned al);

Description
-----------

Performs a software interrupt type 0x21, passing %al and %edx as
specified, with FUNC in %ah.

Return Value
------------

%eax is returned.

Example
-------

     /* read a character */
     int ch = bdos(1, 0, 0) & 0xff;


File: libc,  Node: bdosptr,  Next: bios.h,  Prev: bdos,  Up: Alphabetical List

`bdosptr'
=========

Syntax
------

     #include <dos.h>
     
     int bdosptr(int func, void *edx, unsigned al);

Description
-----------

Performs a software interrupt type 0x21, passing %al and %edx as
specified, with FUNC in %ah.

Return Value
------------

%eax is returned.

Example
-------

     /* print a string */
     bdos(9, "Hello, there$", 0);


File: libc,  Node: bios.h,  Next: bioscom,  Prev: bdosptr,  Up: Alphabetical List

`<bios.h>'
==========

This function prototypes all the functions that deal with BIOS calls.


File: libc,  Node: bioscom,  Next: biosdisk,  Prev: bios.h,  Up: Alphabetical List

`bioscom'
=========

Syntax
------

     #include <bios.h>
     
     int bioscom(int cmd, char data, int port);

Description
-----------

This function accesses the BIOS interrupt 0x14 function, serial
communication services.  The valid values of cmd are:

0 - initialize com port (DATA is the settings)
1 - write byte to port
2 - read byte from port
3 - get port status

For initialization, the byte is made up of the following bits:

     0000 0000
     7654 3210  Meaning
     
     ---- --10  7 bits/character
     ---- --11  8 bits/character
     ---- -0--  1 stop bit
     ---- -1--  2 stop bits
     ---X 0---  no parity
     ---0 1---  odd parity
     ---1 1---  even parity
     000- ----  110 baud
     001- ----  150 baud
     010- ----  300 baud
     011- ----  600 baud
     100- ----  1200 baud
     101- ----  2400 baud
     110- ----  4800 baud
     111- ----  9600 baud

Return Value
------------

The return value is a sequence of bits that indicate the port status
and, for cmd=0 and 3, the modem status.  For read/write operations, the
lower eight bits are the character read.

     1111 1100 0000 0000
     5432 1098 7654 3210  Meaning
     
     ---- ---- ---- ---1  CTS change
     ---- ---- ---- --1-  DSR change
     ---- ---- ---- -1--  ring change
     ---- ---- ---- 1---  carrier detect change
     ---- ---- ---1 ----  CTS present
     ---- ---- --1- ----  DSR present
     ---- ---- -1-- ----  ring present
     ---- ---- 1--- ----  carrier detect
     ---- ---1 ---- ----  data ready
     ---- --1- ---- ----  overrun error
     ---- -1-- ---- ----  parity error
     ---- 1--- ---- ----  framing error
     ---1 ---- ---- ----  break detected
     --1- ---- ---- ----  transmit holding register empty
     -1-- ---- ---- ----  transmit shift register empty
     1--- ---- ---- ----  time out (=1 if error present for cmd=1,2)

Example
-------

     bioscom(0, 0xe3); /* 9600 baud, no parity, one stop, 8 bits */
     for (i=0; buf[i]; i++)
       bioscom(1, buf[i]);


File: libc,  Node: biosdisk,  Next: biosequip,  Prev: bioscom,  Up: Alphabetical List

`biosdisk'
==========

Syntax
------

     #include <bios.h>
     
     int biosdisk(int cmd, int drive, int head, int track,
     	     int sector, int nsects, void *buffer);

Description
-----------

This function interfaces with the BIOS disk sevice (interrupt 0x13).
Please refer to a BIOS reference manual for detailed information about
the parameters of this call.  All known calls are supported.

0 - reset disk subsystem
1 - get disk subsystem status
2 - read one or more sectors
3 - write one or more sectors
5 - format a track
6 - format back track
7 - format drive
8 - get drive parameters
9 - initialize drive parameters
10 - read long sectors
11 - write long sectors
12 - seek to cylinder
13 - alternate fixed disk reset
14 - read test buffer
15 - write test buffer
16 - test for drive ready
17 - recalibrate drive
18 - controller RAM diagnostic
19 - controller drive diagnostic
20 - controller internal diagnostic
15 - read fixed disk type
22 - read disk change line status
23 - set DASD type (pass dasd in NSECTS)
24 - set media type for format

The first request with more than eight sectors will cause a DOS buffer
to be allocated.  This buffer is automatically freed when your
application exits.  Since this buffer is big enough to hold 18 sectors,
requests for more sectors than that will fail.

Request eight returns values in buffer as follows:

byte 0 = sectors per track (bits 0..5) and top two bits of cylinder (in bits 6..7)
byte 1 = cyliders (bits 0..7)
byte 2 = number of drives
byte 3 = number of heads

Return Value
------------

The value of AH returned by the BIOS.

Example
-------

     char buffer[512];
     if (biosdisk(2, 0x80, 0, 0, 0, 1, buffer))
       error("disk");


File: libc,  Node: biosequip,  Next: bioskey,  Prev: biosdisk,  Up: Alphabetical List

`biosequip'
===========

Syntax
------

     #include <bios.h>
     
     int biosequip(void);

Description
-----------

This function returns the equipment word from BIOS request 0x11.  The
bits correspond to the following values:

     1111 1100 0000 0000
     5432 1098 7654 3210  Meaning
     
     ---- ---- ---- ---X  1 = disk drive(s) installed
     ---- ---- ---- --X-  1 = math coprocessor installed
     ---- ---- ---- XX--  System memory 00=16k 01=32k 10=48k 11=64k (non PS/2)
     ---- ---- ---- -X--  1 = pointing device installed (PS/2)
     ---- ---- ---- X---  not used on PS/2
     ---- ---- --XX ----  initial video mode: 01=CO40 10=CO80 11=MONO
     ---- ---- XX-- ----  disk drives 00=1 01=2 10=3 11=4 (zero if bit 1=0)
     ---- ---X ---- ----  1 = no DMA available
     ---- XXX- ---- ----  number of serial ports installed (000=0 001=1 etc)
     ---X ---- ---- ----  1 = game port adapter installed
     --X- ---- ---- ----  1 = internal modem installed (PS/2)
     --X- ---- ---- ----  1 = serial printer attached (non PS/2)
     XX-- ---- ---- ----  number of printers installed (00=0 01=1 10=2 11=3)

Return Value
------------

The equipment word.

Example
-------

     if (biosequip() & 0xc000)
       do_printing();


File: libc,  Node: bioskey,  Next: biosmemory,  Prev: biosequip,  Up: Alphabetical List

`bioskey'
=========

Syntax
------

     #include <bios.h>
     
     int bioskey(int command)

Description
-----------

COMMAND = 0
     Returns the next key pressed

COMMAND = 1
     Checks the keyboard, returns zero if no key pressed, else the key.
     Does not dequeue the key.

COMMAND = 2
     Returns the shift state:

          7654 3210  Meaning
          
          ---- ---X  Right shift key down
          ---- --X-  Left shift key down
          ---- -X--  Ctrl key down
          ---- X---  Alt key down
          ---X ----  Scroll lock on
          --X- ----  Num lock on
          -X-- ----  Caps lock on
          X--- ----  Insert on

Return Value
------------

Depends on COMMAND.

Example
-------

     while (!bioskey(1))
       do_stuff();


File: libc,  Node: biosmemory,  Next: biosprint,  Prev: bioskey,  Up: Alphabetical List

`biosmemory'
============

Syntax
------

     #include <bios.h>
     
     unsigned biosmemory(void);

Description
-----------

This function returns the amount of system memory in 1k blocks.

Note that this function will return 65535 if the system has more than
64M of memory.  This is a limitation of the BIOS.

Return Value
------------

Bytes of memory / 1024.

Example
-------

     printf("This system has %d bytes of memory\n", biosmemory()/1024);


File: libc,  Node: biosprint,  Next: biostime,  Prev: biosmemory,  Up: Alphabetical List

`biosprint'
===========

Syntax
------

     #include <stdio.h>
     
     int biosprint(int cmd, int byte, int port)

Description
-----------

COMMAND = 0
     `byte' is sent to parallel port PORT.

COMMAND = 1
     Parallel port PORT is reset and initialized.

COMMAND = 2
     The status of parallel port PORT is returned.

          7654 3210  Meaning
          
          ---- ---X  Timeout
          ---- -XX-  Unused
          ---- X---  I/O Error
          ---X ----  Selected
          --X- ----  Out of paper
          -X-- ----  Acknowledged
          X--- ----  Idle

Return Value
------------

The printer status.

Example
-------

     while (*c)
       biosprint(0, 0, *c++);


File: libc,  Node: biostime,  Next: bool.h,  Prev: biosprint,  Up: Alphabetical List

`biostime'
==========

Syntax
------

     #include <bios.h>
     
     long biostime(int cmd, long newtime);

Description
-----------

This function reads (CMD=0) or sets (CMD=1) the internal tick counter,
which is the number of 18.2 Hz ticks since midnight.

Return Value
------------

When reading, the number of ticks since midnight.

Example
-------

     long ticks = biostime(0, 0);


File: libc,  Node: bool.h,  Next: brk,  Prev: biostime,  Up: Alphabetical List

`<bool.h>'
==========

This header defines the type `bool', which has values `TRUE' and
`FALSE'.


File: libc,  Node: brk,  Next: bsearch,  Prev: bool.h,  Up: Alphabetical List

`brk'
=====

Syntax
------

     #include <stdlib.h>
     
     int brk(void *ptr);

Description
-----------

This function changes the *break* for the program.  This is the first
address that, if referenced, will cause a fault to occur.  The program
asks for more memory by specifying larger values for PTR.  Normally,
this is done transparently through the `malloc' function.

Return Value
------------

zero if the break was changed, -1 if not.  ERRNO is set to the error.

Example
-------

     if (brk(old_brk+1000))
       printf("no memory\n");


File: libc,  Node: bsearch,  Next: bzero,  Prev: brk,  Up: Alphabetical List

`bsearch'
=========

Syntax
------

     #include <stdlib.h>
     
     void *bsearch (const void *key, const void *base, size_t num,
       size_t size, int (*ptf)(const void *ckey, const void *celem));

Description
-----------

Given an array of values, perform a binary search on the values looking
for value that "matches" the given key.  A match is determined by
calling the provided function PTF and passing it the key as CKEY and a
pointer to one of the elements of the array as CELEM.  This function
must return a negative number if the key is closer than the element to
the beginning of the array, positive if it is closer to the end, and
zero if the element matches the key.

The array begins at address BASE and contains NUM elements, each of
size SIZE.

Return Value
------------

Returns a pointer to the element that matches the key, else NULL.

Example
-------

     typedef struct {
       int a, b;
     } q;
     
     int compare(void *key, void *elem)
     {
       return *(int *)key - ((q *)elem)->a;
     }
     
     q qlist[100];
     
     ...
     q *match = bsearch(4, qlist, 100, sizeof(q), compare);
     printf("4->%d=n", match->b);
     ...


File: libc,  Node: bzero,  Next: calloc,  Prev: bsearch,  Up: Alphabetical List

`bzero'
=======

Syntax
------

     #include <string.h>
     
     void bzero(void *pointer, int length);

Description
-----------

The data at POINTER is filled with LENGTH zeros.

Return Value
------------

None.

Example
-------

     char foo[100];
     bzero(foo,100);


File: libc,  Node: calloc,  Next: cfree,  Prev: bzero,  Up: Alphabetical List

`calloc'
========

Syntax
------

     #include <malloc.h>
     
     void *calloc(size_t num_elements, size_t size);

Description
-----------

This function allocates enough memory for NUM_ELEMENTS objects of size
SIZE.  The memory returned is initialized to all zeros.  The pointer
returned should later be passed to cfree (*note cfree::.) so that the
memory can be returned to the heap.

Return Value
------------

A pointer to the memory, or `NULL' if no more memory is available.

Example
-------

     Complex *x = calloc(12, sizeof(Complex));
     cfree(x);


File: libc,  Node: cfree,  Next: chdir,  Prev: calloc,  Up: Alphabetical List

`cfree'
=======

Syntax
------

     #include <malloc.h>
     
     void cfree(void *pointer);

Description
-----------

This function returns the memory allocated by calloc (*note calloc::.)
to the heap.

Return Value
------------

None.

Example
-------

     Complex *x = calloc(12, sizeof(Complex));
     cfree(x);


File: libc,  Node: chdir,  Next: chmod,  Prev: cfree,  Up: Alphabetical List

`chdir'
=======

Syntax
------

     #include <osfcn.h>
     
     int chdir(const char *new_directory);

Description
-----------

This function changes the current directory to NEW_DIRECTORY.  If a
drive letter is specified, the current directory for that drive is
changed, else the current drive is changed.

Return Value
------------

Zero if the new directory exists, else nonzero and ERRNO set if error.

Example
-------

     if (chdir("/tmp"))
       perror("/tmp");


File: libc,  Node: chmod,  Next: chown,  Prev: chdir,  Up: Alphabetical List

`chmod'
=======

Syntax
------

     #include <osfcn.h>
     
     int chmod(const char *filename, int mode);

Description
-----------

This function changes the mode (writable or write-only) of the specified
file.  The value of MODE can be a combination of one or more of the
following:

`S_IREAD'
     Make the file readable

`S_IWRITE'
     Make the file writable

Return Value
------------

Zero if the file exists and the mode was changed, else nonzero.

Example
-------

     chmod("/tmp/dj.dat", S_IWRITE|S_IREAD);


File: libc,  Node: chown,  Next: _cleanup,  Prev: chmod,  Up: Alphabetical List

`chown'
=======

Syntax
------

     #include <osfcn.h>
     
     int chown(const char *file, int owner, int group);

Description
-----------

This function does nothing under MS-DOS

Return Value
------------

This function always returns zero.


File: libc,  Node: _cleanup,  Next: clearerr,  Prev: chown,  Up: Alphabetical List

`_cleanup'
==========

Description
-----------

This is an internal function used to clean up file descriptors when the
program calls `exit'.


File: libc,  Node: clearerr,  Next: clock,  Prev: _cleanup,  Up: Alphabetical List

`clearerr'
==========

Syntax
------

     #include <stdio.h>
     
     void clearerr(FILE *stream);

Description
-----------

This function clears the EOF and error indicators for the file STREAM.

Return Value
------------

None.

Example
-------

     clearerr(stdout);


File: libc,  Node: clock,  Next: close,  Prev: clearerr,  Up: Alphabetical List

`clock'
=======

Syntax
------

     #include <time.h>
     
     clock_t clock(void);

Description
-----------

This function returns the number of clock ticks since an arbitrary time,
actually, since the first call to `clock', which itself returns zero.
The number of tics per second is CLOCKS_PER_SEC.

Return Value
------------

The number of tics.

Example
-------

     printf("%d seconds have elapsed\n", clock()/CLOCKS_PER_SEC);


File: libc,  Node: close,  Next: closedir,  Prev: clock,  Up: Alphabetical List

`close'
=======

Syntax
------

     #include <osfcn.h>
     
     int close(int fd);

Description
-----------

The open file associated with FD is closed.

Return Value
------------

Zero if the file was closed, nonzero if FD was invalid or already
closed.

Example
-------

     int fd = open("data", O_RDONLY);
     close(fd);


File: libc,  Node: closedir,  Next: coff.h,  Prev: close,  Up: Alphabetical List

`closedir'
==========

Syntax
------

     #include <dirent.h>
     
     int closedir(DIR *dir);

Description
-----------

This function closes a directory opened by opendir (*note opendir::.).

Return Value
------------

Zero on success, nonzero if DIR is invalid.


File: libc,  Node: coff.h,  Next: creat,  Prev: closedir,  Up: Alphabetical List

`<coff.h>'
==========

This header provides structure definitions and macros that describe
djgpp's COFF object and executable file format.


File: libc,  Node: creat,  Next: crlf2nl,  Prev: coff.h,  Up: Alphabetical List

`creat'
=======

Syntax
------

     #include <osfcn.h>
     #include <sys/stat.h>
     
     int creat(const char *filename, unsigned long int mode);

Description
-----------

This function creates the given file and opens it for writing.  If the
file exists, it is truncated to zero size, unless it is read-only, in
which case the function fails.  If the file does not exist, it will be
created read-only if MODE does not have `S_IWRITE' set.

Return Value
------------

A file descriptor >= 0, or a negative number on error.

Example
-------

     int fd = creat("data", S_IWRITE);
     write(fd, buf, 1024);
     close(fd);


File: libc,  Node: crlf2nl,  Next: ctime,  Prev: creat,  Up: Alphabetical List

`crlf2nl'
=========

Syntax
------

     unsigned crlf2nl(char *buf, unsigned len);

Description
-----------

This function removes Ctrl-M characters from the given BUF.

Return Value
------------

The number of characters remaining in the buffer are returned.


File: libc,  Node: ctime,  Next: _ctype_,  Prev: crlf2nl,  Up: Alphabetical List

`ctime'
=======

Syntax
------

     #include <time.h>
     
     char *ctime(const time_t *cal);

Description
-----------

This function returns an ASCII representation of the time in CAL.  This
is equivalent to `asctime(localtime(cal))'.  *Note asctime:: *Note
localtime::

Return Value
------------

The ascii representation of the time.


File: libc,  Node: _ctype_,  Next: delay,  Prev: ctime,  Up: Alphabetical List

`_ctype_'
=========

Syntax
------

     #include <ctype.h>
     
     extern char _ctype_[257];

Description
-----------

This is an array used by the functions and macros in `<ctype.h>'.


File: libc,  Node: delay,  Next: difftime,  Prev: _ctype_,  Up: Alphabetical List

`delay'
=======

Syntax
------

     void delay(unsigned msec);

Description
-----------

This function causes the program to pause for MSEC milliseconds.  It
uses the `int 15h' delay function to relinquish the CPU to other
programs that might need it.

Return Value
------------

None.

Example
-------

     delay(200); /* delay for 1/5 second */


File: libc,  Node: difftime,  Next: disable,  Prev: delay,  Up: Alphabetical List

`difftime'
==========

Syntax
------

     #include <time.h>
     
     double difftime(time_t t1, time_t t0);

Description
-----------

This function returns the difference in time, in seconds, from T0 to T1.

Return Value
------------

The number of seconds.

Example
-------

     time_t t1, t0;
     double elapsed;
     time(&t0);
     do_something();
     time(&t1);
     elapsed = difftime(t1, t0);


File: libc,  Node: disable,  Next: div,  Prev: difftime,  Up: Alphabetical List

`disable'
=========

Syntax
------

     #include <dos.h>
     
     int disable(void);

Description
-----------

This function disables interrupts.

*Note enable::

Return Value
------------

Returns nonzero if the interrupts had been enabled before this call,
zero if they were already disabled.

Example
-------

     int ints_were_enabled;
     
     ints_were_enabled = disable();
     . . . do some stuff . . .
     if (ints_were_enabled)
       enable();


File: libc,  Node: div,  Next: _doprnt,  Prev: disable,  Up: Alphabetical List

`div'
=====

Syntax
------

     #include <stdlib.h>
     
     div_t div(int numberator, int denomonator);

Description
-----------

Returns the quotient and remainder of the division NUMBERATOR divided
by DENOMONATOR.  The return type is as follows:

     typedef struct {
       int quot;
       int rem;
     } div_t;

Return Value
------------

The results of the division are returned.

Example
-------

     div_t d = div(42, 3);
     printf("42 = %d x 3 + %d\n", d.quot, d.rem);


File: libc,  Node: _doprnt,  Next: dos.h,  Prev: div,  Up: Alphabetical List

`_doprnt'
=========

Syntax
------

     #include <stdio.h>
     
     int _doprnt(const char *format, void *params, FILE *file);

Description
-----------

This is an internal function that is used by all the `printf' style
functions, which simply pass their format, arguments, and stream to this
function.

*Note printf:: for a discussion of the allowed formats and arguments.

Return Value
------------

The number of characters generated is returned.

Example
-------

     int args[] = { 1, 2, 3, 66 };
     _doprnt("%d %d %d %c\n", args, stdout);


File: libc,  Node: dos.h,  Next: _doscan,  Prev: _doprnt,  Up: Alphabetical List

`<dos.h>'
=========

This header provides structure definitions and functions used to access
dos-specific functions.


File: libc,  Node: _doscan,  Next: _doscan_low,  Prev: dos.h,  Up: Alphabetical List

`_doscan'
=========

Syntax
------

     #include <stdio.h>
     
     int _doscan(FILE *file, const char *format, void **ptrs_to_args);

Description
-----------

This is an internal function that is used by all the `scanf' style
functions, which simply pass their format, arguments, and stream to this
function.

*Note scanf:: for a discussion of the allowed formats and arguments.

Return Value
------------

The number of characters successfully scanned is returned, or -1 on
error.

Example
-------

     int x, y;
     int *args[2];
     args[0] = &x;
     args[1] = &y;
     _doscan(stdin, "%d %d", args);


File: libc,  Node: _doscan_low,  Next: dosmemget,  Prev: _doscan,  Up: Alphabetical List

`_doscan_low'
=============

Description
-----------

This is an internal function used by _doscan.


File: libc,  Node: dosmemget,  Next: dosmemput,  Prev: _doscan_low,  Up: Alphabetical List

`dosmemget'
===========

Syntax
------

     #include <go32.h>
     
     void dosmemget(int offset, int length, void *buffer);

Description
-----------

This function transfers data from MS-DOS's conventional memory space to
the program's virtual address space.  The OFFSET is a physical address,
which can be computed from a real-mode segment/offset pair as follows:

     offset = segment * 16 + offset;

The LENGTH is the number of bytes to transfer, and BUFFER is a pointer
to somewhere in your virtual address space (such as memory obtained
from `malloc') where the data will go.

Return Value
------------

None.

Example
-------

     unsigned short shift_state;
     dosmemget(0x417, 2, &shift_state);
     if (shift_state & 0x0004)
       /* Ctrl key pressed */;


File: libc,  Node: dosmemput,  Next: dpmi.h,  Prev: dosmemget,  Up: Alphabetical List

`dosmemput'
===========

Syntax
------

     #include <go32.h>
     
     void dosmemput(const void *buffer, int length, int offset);

Description
-----------

This function transfers data from the program's virtual address space to
MS-DOS's conventional memory space.  The OFFSET is a physical address,
which can be computed from a real-mode segment/offset pair as follows:

     offset = segment * 16 + offset;

The LENGTH is the number of bytes to transfer, and BUFFER is a pointer
to somewhere in your virtual address space (such as memory obtained
from `malloc') where the data will come from.

Return Value
------------

None.

Example
-------

     unsigned short save_screen[25][80];
     dosmemput(save_screen, 0xb8000, 80*2*25);


File: libc,  Node: dpmi.h,  Next: dup,  Prev: dosmemput,  Up: Alphabetical List

`<dpmi.h>'
==========

This header provides structure definitions and functions that access
that part of the DPMI specification that go32 supports in all operating
modes.


File: libc,  Node: dup,  Next: dup2,  Prev: dpmi.h,  Up: Alphabetical List

`dup'
=====

Syntax
------

     #include <osfcn.h>
     
     int dup(int old_handle);

Description
-----------

This function duplicates the given file handle.  Both handles refer to
the same file and file pointer.

Return Value
------------

The new file handle, or -1 if error.

Example
-------

     do_file(dup(fileno(stdin)));


File: libc,  Node: dup2,  Next: enable,  Prev: dup,  Up: Alphabetical List

`dup2'
======

Syntax
------

     #include <osfcn.h>
     
     int dup2(int existing_handle, int new_handle);

Description
-----------

This call causes NEW_HANDLE to refer to the same file and file pointer
as EXISTING_HANDLE.  If NEW_HANDLE is an open file, it is closed.

Return Value
------------

The new handle, or -1 on error.

Example
-------

     /* copy new file to stdin stream */
     close(0);
     dup2(new_stdin, 0);
     close(new_stdin);


File: libc,  Node: enable,  Next: endgrent,  Prev: dup2,  Up: Alphabetical List

`enable'
========

Syntax
------

     #include <dos.h>
     
     int enable(void);

Description
-----------

This function enables interrupts.

*Note disable::

Return Value
------------

Returns nonzero if the interrupts were already enabled, zero if they
had been disabled before this call.

Example
-------

     int ints_were_enabled;
     
     ints_were_enabled = enable();
     . . . do some stuff . . .
     if (!ints_were_enabled)
       disable();


File: libc,  Node: endgrent,  Next: endmntent,  Prev: enable,  Up: Alphabetical List

`endgrent'
==========

Syntax
------

     #include <grp.h>
     
     void endgrent(void);

Description
-----------

This function should be called after all calls to getgrent, getgrgid, or
getgrnam.

Return Value
------------

None.

Example
-------

*Note getgrent::


File: libc,  Node: endmntent,  Next: endpwent,  Prev: endgrent,  Up: Alphabetical List

`endmntent'
===========

Syntax
------

     #include <mntent.h>
     
     int endmntent(FILE *filep);

Description
-----------

This function should be called after the last call to getmntent (*note
getmntent::.).

Return Value
------------

This function always returns one.


File: libc,  Node: endpwent,  Next: EOF,  Prev: endmntent,  Up: Alphabetical List

`endpwent'
==========

Syntax
------

     #include <pwd.h>
     
     void endpwent(void);

Description
-----------

This function should be called after the last call to getpwent (*note
getpwent::.).

Return Value
------------

None.


File: libc,  Node: EOF,  Next: errno,  Prev: endpwent,  Up: Alphabetical List

`EOF'
=====

Syntax
------

     #include <stdio.h>
     
     if (c == EOF)

Description
-----------

This macro defines the value returned by stdio functions to indicate
that the end of the file has been reached.  Note that variables
expected to hold this value must be wider than characters; EOF does not
match any character value.

Example
-------

int c; while ((c = getchar()) != EOF)   do_it(c);



File: libc,  Node: errno,  Next: exec*,  Prev: EOF,  Up: Alphabetical List

`errno'
=======

Syntax
------

     #include <errno.h>
     
     extern int errno;

Description
-----------

This variable is used to hold the value of the error of the last
function call.  For details about the various error types, please refer
to the file `include/errno.h'.

*Note perror::


File: libc,  Node: exec*,  Next: exit,  Prev: errno,  Up: Alphabetical List

`exec*'
=======

Syntax
------

     #include <process.h>
     
     int execl(const char *path, const char *argv0, ...);
     int execle(const char *path, const char *argv0, ... /*, const char **envp */);
     int execlp(const char *path, const char *argv0, ...);
     int execlpe(const char *path, const char *argv0, ... /*, const char **envp */);
     
     int execv(const char *path, const char **argv);
     int execve(const char *path, const char **argv, const char **envp);
     int execvp(const char *path, const char **argv);
     int execvpe(const char *path, const char **argv, const char **envp);

Description
-----------

These functions operate by calling `spawn*' with a type of `P_OVERLAY'.
Refer to *Note spawn*:: for a full description.

Return Value
------------

If successful, these functions do not return.  If there is an error,
these functions return -1 and set `errno' to indicate the error.

Example
-------

     execlp("gcc", "gcc", "-v", "hello.c", 0);


File: libc,  Node: exit,  Next: _exit,  Prev: exec*,  Up: Alphabetical List

`exit'
======

Syntax
------

     #include <stdlib.h>
     
     void volatile exit(int exit_code);

Description
-----------

This function exits the program, returning EXIT_CODE to the calling
process.  Before exiting, all open files are closed and all `atexit'
and `on_exit' requests are processed.

Return Value
------------

This function does not return.

Example
-------

     if (argc < 4)
     {
       print_usage();
       exit(1);
     }


File: libc,  Node: _exit,  Next: _f_morefiles,  Prev: exit,  Up: Alphabetical List

`_exit'
=======

Syntax
------

     #include <stdlib.h>
     
     void volatile _exit(int exit_code);

Description
-----------

This function exits the application immediately, without performing any
`atexit' or `on_exit' requests or closing any files.  The program will
return EXIT_CODE to the calling process as the exit code.

Return Value
------------

This function does not return.


File: libc,  Node: _f_morefiles,  Next: fchmod,  Prev: _exit,  Up: Alphabetical List

`_f_morefiles'
==============

Description
-----------

This is an internal function used by `fopen'. *Note fopen::


File: libc,  Node: fchmod,  Next: fclose,  Prev: _f_morefiles,  Up: Alphabetical List

`fchmod'
========

Syntax
------

     #include <unistd.h>
     
     int fchmod(int file, int mode);

Description
-----------

This function is not implemented under MS-DOS.  If you call it, it will
only write a warning to stderr.


File: libc,  Node: fclose,  Next: fdopen,  Prev: fchmod,  Up: Alphabetical List

`fclose'
========

Syntax
------

     #include <stdio.h>
     
     int fclose(FILE *file);

Description
-----------

This function closes the given FILE.

Return Value
------------

Zero on success, else `EOF'.

Example
-------

     FILE *f = fopen("data", "r");
     fprintf(f, "Hello\n");
     fclose(f);


File: libc,  Node: fdopen,  Next: feof,  Prev: fclose,  Up: Alphabetical List

`fdopen'
========

Syntax
------

     #include <stdio.h>
     
     FILE *fdopen(int fd, const char *mode);

Description
-----------

This function opens a stream-type file that uses the given FD file,
which must already be open.  The file is opened with the modes
specified by MODE, which is the same as for `fopen'.  *Note fopen::

Return Value
------------

The newly created `FILE *', or `NULL' on error.

Example
-------

     FILE *stdprn = fdopen(4, "w");


File: libc,  Node: feof,  Next: ferror,  Prev: fdopen,  Up: Alphabetical List

`feof'
======

Syntax
------

     #include <stdio.h>
     
     int feof(FILE *file);

Description
-----------

This function (actually a macro) can be used to indicate if the given
FILE is at the end-of-file or not.

Return Value
------------

Nonzero at end-of-file, zero otherwise.

Example
-------

     while (!feof(stdin))
       gets(line);


File: libc,  Node: ferror,  Next: fflush,  Prev: feof,  Up: Alphabetical List

`ferror'
========

Syntax
------

     #include <stdio.h>
     
     int ferror(FILE *file);

Description
-----------

This function (actually a macro) can be used to indicate if the given
FILE has encountered an error or not.  *Note clearerr::

Return Value
------------

Nonzero for an error, zero otherwize.

Example
-------

     if (ferror(stdin))
       exit(1);


File: libc,  Node: fflush,  Next: ffs,  Prev: ferror,  Up: Alphabetical List

`fflush'
========

Syntax
------

     #include <stdio.h>
     
     int fflush(FILE *file);

Description
-----------

This function causes any unwritten buffered data to be written out to
the given FILE.  This is useful in cases where the output is line
buffered and you want to write a partial line.

Return Value
------------

Zero on success, -1 on error.

Example
-------

     printf("Enter value : ");
     fflush(stdout);
     scanf(result);


File: libc,  Node: ffs,  Next: fgetc,  Prev: fflush,  Up: Alphabetical List

`ffs'
=====

Syntax
------

     #include <string.h>
     int ffs(int mask);

Description
-----------

This function returns the position of the least significant bit set in
MASK.  For example:

     ffs(0x00000000) == 0
     ffs(0x00000001) == 1
     ffs(0x00000002) == 2
     ffs(0x00000004) == 3
     ffs(0x00010000) == 17
     ffs(0x00010010) == 5

Return Value
------------

The position of the bit, or zero if none are set.


File: libc,  Node: fgetc,  Next: fgetgrent,  Prev: ffs,  Up: Alphabetical List

`fgetc'
=======

Syntax
------

     #include <stdio.h>
     
     int fgetc(FILE *file);

Description
-----------

Returns the next character in the given FILE as an unsigned char.

Return Value
------------

The given char (value 0..255) or `EOF' at end-of-file.

Example
-------

     int c;
     while((c=fgetc(stdin)) != EOF)
       fputc(c, stdout);


File: libc,  Node: fgetgrent,  Next: fgetpos,  Prev: fgetc,  Up: Alphabetical List

`fgetgrent'
===========

Syntax
------

     #include <grp.h>
     
     struct group *fgetgrent(FILE *file);

Description
-----------

This function, in MS-DOS, is exactly the same as getgrent (*note
getgrent::.).


File: libc,  Node: fgetpos,  Next: fgetpwent,  Prev: fgetgrent,  Up: Alphabetical List

`fgetpos'
=========

Syntax
------

     #include <stdio.h>
     
     int fgetpos(FILE *file, fpos_t *offset);

Description
-----------

This function records the current file pointer for FILE, for later use
by `fsetpos'.

*Note fsetpos::.

*Note ftell::.

Return Value
------------

Zero if successful, nonzero if not.


File: libc,  Node: fgetpwent,  Next: fgets,  Prev: fgetpos,  Up: Alphabetical List

`fgetpwent'
===========

Syntax
------

     #include <pwd.h>
     
     struct passwd *fgetpwent(FILE *file);

Description
-----------

This function, in MS-DOS, is exactly like `getpwent' (*note
getpwent::.).


File: libc,  Node: fgets,  Next: _filbuf,  Prev: fgetpwent,  Up: Alphabetical List

`fgets'
=======

Syntax
------

     #include <stdio.h>
     
     char *fgets(char *buffer, int maxlength, FILE *file);

Description
-----------

This function reads as much of a line from a file as possible, stopping
when the buffer is full (MAXLENGTH-1 characters), an end-of-line is
detected, or `EOF' or an error is detected.  It then stores a `NULL' to
terminate the string.

Return Value
------------

The address of the buffer is returned on success, if `EOF' is
encountered before any characters are stored, or if an error is
detected, `NULL' is returned instead.

Example
-------

     char buf[100];
     while (fgets(buf, 100, stdin))
       fputs(buf, stdout);


File: libc,  Node: _filbuf,  Next: fileno,  Prev: fgets,  Up: Alphabetical List

`_filbuf'
=========

Description
-----------

This is an internal function used to implement stream buffering.


File: libc,  Node: fileno,  Next: _findenv,  Prev: _filbuf,  Up: Alphabetical List

`fileno'
========

Syntax
------

     #include <stdio.h>
     
     int fileno(FILE *file);

Description
-----------

This function returns the raw file descriptor number that FILE uses for
I/O.

Return Value
------------

The file descriptor number.


File: libc,  Node: _findenv,  Next: findfirst,  Prev: fileno,  Up: Alphabetical List

`_findenv'
==========

Description
-----------

This is an internal function used by `getenv' and `setenv'.  *Note
getenv:: *Note setenv::


File: libc,  Node: findfirst,  Next: _findiop,  Prev: _findenv,  Up: Alphabetical List

`findfirst'
===========

Syntax
------

     #include <dir.h>
     
     int findfirst(const char *pathname, struct ffblk *ffblk, int attrib);

Description
-----------

This function and the related `findnext' are used to scan directories
for the list of files therein.  The PATHNAME is a wildcard that
specifies the directory and files to search for (such as `subdir/*.c'),
FFBLK is a structure to hold the results and state of the search, and
ATTRIB is a combination of the following:

`FA_RDONLY'
     Include read-only files in the search

`FA_HIDDEN'
     Include hidden files in the search

`FA_SYSTEM'
     Include system files in the search

`FA_LABEL'
     Include the volume label in the search

`FA_DIREC'
     Include subdirectories in the search

`FA_ARCH'
     Include modified files in the search

Any file that doesn't have any flag bits that aren't specified is
selected for the search.  Thus, if you specified `FA_DIREC' and
`FA_LABEL', you would get all subdirectories, the volume label, and any
file that is neither read-only or modified.

The results of the search are stored in FFBLK:

     struct ffblk {
       char ff_reserved[21];  /* used to hold the state of the search */
       char ff_attrib;        /* actual attributes of the file found */
       short ff_ftime;        /* hours:5, minutes:6, (seconds/2):5 */
       short ff_fdate;        /* (year-1980):7, month:4, day:5 */
       short ff_filler;       /* gcc aligns "long" different than DOS */
       long ff_fsize;         /* size of file */
       char ff_name[16];      /* name of file as ASCIIZ string */
     }

Return Value
------------

Zero if a match is found, nonzero if none found.

Example
-------

     struct ffblk f;
     int done = findfirst("*.exe", &f, FA_ARCH|FA_RDONLY);
     while (!done)
     {
       printf("%10u %2d:%02d:%02d %2d/%02d/%4d %s\n",
         f.ff_fsize,
         (f.ff_ftime >> 11) & 0x1f,
         (f.ff_ftime >>  5) & 0x3f,
         (f.ff_ftime & 0x1f) * 2,
         (f.ff_fdate >>  5) & 0x0f,
         (f.ff_fdate & 0x1f),
         ((f.ff_fdate >> 9) & 0x7f) + 1980,
         f.ff_name);
       done = findnext(&f);
     }


File: libc,  Node: _findiop,  Next: findnext,  Prev: findfirst,  Up: Alphabetical List

`_findiop'
==========

Description
-----------

This is an internal function used by `fopen'. *Note fopen::


File: libc,  Node: findnext,  Next: _fixpath,  Prev: _findiop,  Up: Alphabetical List

`findnext'
==========

Syntax
------

     #include <dir.h>
     
     int findnext(struct ffblk *ffblk);

Description
-----------

This finds the next file in the search started by `findfirst'. *Note
findfirst::

Return Value
------------

Zero if there was a match, else nonzero.


File: libc,  Node: _fixpath,  Next: _flsbuf,  Prev: findnext,  Up: Alphabetical List

`_fixpath'
==========

Syntax
------

     void _fixpath(const char *in_path, char *out_path);

Description
-----------

This function canonacalizes the input path IN_PATH and stores the
result in the buffer pointed to by OUT_PATH.

The path is fixed by removing consecutive and trailing slashes, making
the path absolute if it's relative, removing "." components, collapsing
".." components, adding a drive specifier if needed, and converting all
slashes to '/'.

Return Value
------------

None.

Example
-------

     char oldpath[100], newpath[100];
     scanf(oldpath);
     _fixpath(oldpath, newpath);
     printf("that really is %s\n", newpath);


File: libc,  Node: _flsbuf,  Next: _fmode,  Prev: _fixpath,  Up: Alphabetical List

`_flsbuf'
=========

Description
-----------

This is an internal function used to implement stream buffering.


File: libc,  Node: _fmode,  Next: fnmatch,  Prev: _flsbuf,  Up: Alphabetical List

`_fmode'
========

Syntax
------

     #include <fcntl.h>
     
     extern int _fmode;

Description
-----------

This variable may be set to `O_TEXT' or `O_BINARY' to specify the mode
that newly opened files should be opened in if the open call did not
specify.  *Note open:: *Note fopen::

The default value is `O_TEXT'.

Example
-------

     _fmode = O_BINARY;


File: libc,  Node: fnmatch,  Next: fnmerge,  Prev: _fmode,  Up: Alphabetical List

`fnmatch'
=========

Syntax
------

     #include <fnmatch.h>
     
     int fnmatch(const char *pattern, const char *string, int flags);

Description
-----------

This function indicates if STRING matches the PATTERN.  The pattern may
include the following special characters:

`*'
     Matches zero of more characters.

`?'
     Matches exactly one character

`[...]'
     Matches one character if it's in a range of characters.  If the
     first character is `!', matches if the character is not in the
     range.  Between the brackets, the range is specified by listing
     the characters that are in the range, or two characters separated
     by `-' to indicate all characters in that range.  For example,
     `[a-d]' matches `a', `b', `c', or `d'.

`\'
     Causes the next character to not be treated as a wildcard.  For
     example, `\*' matches an asterisk.  This is only available if FLAGS
     includes `FNM_QUOTE'.

The value of FLAGS is a combination of zero of more of the following:

`FNM_PATHNAME'
     This means that the string should be treated as a pathname, in
     that the slash character `/' never matches any of the wildcards.

`FNM_QUOTE'
     This means that the backslash `\\' may be used for quoting special
     characters in the pattern.

Return Value
------------

Zero if the string matches, FNM_NOMATCH if it does not.

Example
-------

     if (fnmatch("*.[ch]", filename, FNM_PATH|FNM_QUOTE))
       do_source_file(filename);


File: libc,  Node: fnmerge,  Next: fnsplit,  Prev: fnmatch,  Up: Alphabetical List

`fnmerge'
=========

Syntax
------

     #include <dir.h>
     
     void fnmerge (char *path, const char *drive, const char *dir,
     		const char *name, const char *ext);

Description
-----------

This function constructs a file PATH from its components.

*Note fnsplit::

Return Value
------------

None.

Example
-------

     char buf[MAXPATH];
     fnmerge(buf, "d:", "/foo/", "data", ".txt");


File: libc,  Node: fnsplit,  Next: fopen,  Prev: fnmerge,  Up: Alphabetical List

`fnsplit'
=========

Syntax
------

     #include <dir.h>
     
     int fnsplit (const char *path, char *drive, char *dir,
     		char *name, char *ext);

Description
-----------

This function decomposes a PATH into its components.

*Note fnmerge::

Return Value
------------

A flag that indicates which components were found:

`DRIVE'
     The drive letter was found.

`DIRECTORY'
     A directory or subdirectories was found.

`FILENAME'
     A filename was found.

`EXTENSION'
     An extension was found.

`WILDCARDS'
     The path included `*' or `?'.

Example
-------

     char d[MAXDRIVE], p[MAXDIR], f[MAXFILE], e[MAXEXT];
     int which = fnsplit("d:/djgpp/bin/gcc.exe", d, p, f, e);
     d = "d:"
     p = "/djgpp/bin/"
     f = "gcc"
     e = ".exe"


File: libc,  Node: fopen,  Next: fork,  Prev: fnsplit,  Up: Alphabetical List

`fopen'
=======

Syntax
------

     #include <stdio.h>
     FILE *fopen(const char *filename, const char *mode);

Description
-----------

This function opens a stream corresponding to the named FILENAME with
the given MODE.  The mode can be one of the following:

`r'
     Open an existing file for reading.

`w'
     Create a new file (or truncate an existing file) and open it for
     writing.

`a'
     Open an existing file (or create a new one) for writing.  The file
     pointer is positioned to the end of the file before every write.

Followed by any of these characters:

`b'
     Force the file to be open in binary mode instead of the default
     mode.

`t'
     Force the file to be open in text mode instead of the default mode.

`+'
     Open the file as with `O_RDWR' so that both reads and writes can
     be done to the same file.

If the file is open for both reading and writing, you must call
`fflush', `fseek', or `rewind' before switching from read to write or
from write to read.

The open file is set to line buffered if the underlying object is a
device (stdin, stdout, etc), or is fully buffered if the underlying
object is a disk file (data.c, etc).

If `b' or `t' is not specified in MODE, the file type is chosen by the
value of `fmode' (*note _fmode::.).

Return Value
------------

A pointer to the `FILE' object, or `NULL' if there was an error.

Example
-------

     FILE *f = fopen("foo", "rb+"); /* open existing file for read/write, binary mode */


File: libc,  Node: fork,  Next: fpathconf,  Prev: fopen,  Up: Alphabetical List

`fork'
======

Description
-----------

This function always returns -1, as MS-DOS does not support multiple
processes.  It exists only to assist in porting Unix programs.


File: libc,  Node: fpathconf,  Next: fprintf,  Prev: fork,  Up: Alphabetical List

`fpathconf'
===========

Syntax
------

     #include <unistd.h>
     
     long fpathconf(int fd, int name);

Description
-----------

Returns configuration information on the filesystem that the open file
resides on.  *Note pathconf::

Return Value
------------

The configuration value.


File: libc,  Node: fprintf,  Next: fpurge,  Prev: fpathconf,  Up: Alphabetical List

`fprintf'
=========

Syntax
------

     #include <stdio.h>
     
     int fprintf(FILE *file, const char *format, ...);

Description
-----------

Prints formatted output to the named file.  *Note printf::

Return Value
------------

The number of characters written.


File: libc,  Node: fpurge,  Next: fputc,  Prev: fprintf,  Up: Alphabetical List

`fpurge'
========

Syntax
------

     #include <stdio.h>
     
     int fpurge(FILE *file);

Description
-----------

This function purges the buffer for FILE without writing it to disk.

Return Value
------------

Zero on success, -1 on failure.


File: libc,  Node: fputc,  Next: fputs,  Prev: fpurge,  Up: Alphabetical List

`fputc'
=======

Syntax
------

     #include <stdio.h>
     
     int fputc(int character, FILE *file);

Description
-----------

This function writes the given CHARACTER to the given `file'.

Return Value
------------

The given character [0..255] or `EOF'.

Example
-------

     fputc('\n', stdout);


File: libc,  Node: fputs,  Next: fread,  Prev: fputc,  Up: Alphabetical List

`fputs'
=======

Syntax
------

     #include <stdio.h>
     
     int fputs(const char *string, FILE *file);

Description
-----------

This function all the characters of STRING (except the trailing `NULL')
to the given FILE.

Return Value
------------

A nonnegative number on success, `EOF' on error.

Example
-------

     fputs("Hello\n", stdout);


File: libc,  Node: fread,  Next: free,  Prev: fputs,  Up: Alphabetical List

`fread'
=======

Syntax
------

     #include <stdio.h>
     
     size_t fread(void *buffer, size_t size, size_t number, FILE *file);

Description
-----------

This function reads SIZE*NUMBER characters from FILE to BUFFER.

Return Value
------------

The number of items of size SIZE read, or -1 on error.

Example
-------

     int foo[10];
     fread(foo, sizeof(int), 10, stdin);


File: libc,  Node: free,  Next: freopen,  Prev: fread,  Up: Alphabetical List

`free'
======

Syntax
------

     #include <stdio.h>
     
     void free(void *ptr);

Description
-----------

Returns the allocated memory to the heap (*note malloc::.).  If the PTR
is `NULL', it does nothing.

Return Value
------------

None.

Example
-------

     char *q = (char *)malloc(20);
     free(q);


File: libc,  Node: freopen,  Next: fscanf,  Prev: free,  Up: Alphabetical List

`freopen'
=========

Syntax
------

     #include <stdio.h>
     
     FILE *freopen(const char *filename, const char *mode, FILE *file);

Description
-----------

This function closes FILE if it was open, then opens a new file like
`fopen(filename, mode)' but it reuses FILE.

This is useful to, for example, associate `stdout' with a new file.

Return Value
------------

The new file, or `NULL' on error.

Example
-------

     freopen("/tmp/stdout.dat", "wb", stdout);


File: libc,  Node: fscanf,  Next: fseek,  Prev: freopen,  Up: Alphabetical List

`fscanf'
========

Syntax
------

     #include <stdio.h>
     
     int fscanf(FILE *file, const char *format, ...);

Description
-----------

This function scans formatted text from FILE and stores it in the
variables pointed to by the arguments.  *Note scanf::

Return Value
------------

The number of items successfully scanned.


File: libc,  Node: fseek,  Next: fsetpos,  Prev: fscanf,  Up: Alphabetical List

`fseek'
=======

Syntax
------

     #include <stdio.h>
     
     int fseek(FILE *file, long offset, int mode);

Description
-----------

This function moves the file pointer for FILE according to MODE:

`SEEK_SET'
     The file pointer is moved to the offset specified.

`SEEK_CUR'
     The file pointer is moved relative to its current position.

`SEEK_END'
     The file pointer is moved to a position OFFSET bytes from the end
     of the file.  The offset is usually nonpositive in this case.

*Warning!* The ANSI standard only allows values of zero for OFFSET when
WHENCE is not `SEEK_SET' and the file has been opened as a text file.
Although this restriction is not enforced, beware that there is not a
one-to-one correspondence between file characters and text characters
under MS-DOS, so some `fseek' operations may not do exactly what you
expect.

Return Value
------------

Zero if successful, nonzero if not.

Example
-------

     fseek(stdin, 12, SEEK_CUR); /* skip 12 bytes */


File: libc,  Node: fsetpos,  Next: fstat,  Prev: fseek,  Up: Alphabetical List

`fsetpos'
=========

Syntax
------

     #include <stdio.h>
     
     int fsetpos(FILE *file, const fpos_t *offset);

Description
-----------

This function moves the file pointer for FILE to position OFFSET, as
recorded by `fgetpos'.

*Note fgetpos::.

*Note fseek::.

Return Value
------------

Zero if successful, nonzero if not.


File: libc,  Node: fstat,  Next: fsync,  Prev: fsetpos,  Up: Alphabetical List

`fstat'
=======

Syntax
------

     #include <sys/stat.h>
     
     int fstat(int file, struct stat *sbuf);

Description
-----------

This function obtains the status of the open file FILE and stores it in
SBUF.  *Note stat::

Return Value
------------

Zero on success, nonzero on failure.


File: libc,  Node: fsync,  Next: ftell,  Prev: fstat,  Up: Alphabetical List

`fsync'
=======

Syntax
------

     #include <osfcn.h>
     
     int fsync(int file);

Description
-----------

Forces all information about the file to be synchronized with the disk
image.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     fsync(fileno(stdout));


File: libc,  Node: ftell,  Next: ftime,  Prev: fsync,  Up: Alphabetical List

`ftell'
=======

Syntax
------

     #include <stdio.h>
     
     long ftell(FILE *file);

Description
-----------

Returns the current file position for `file'.  This is suitable for a
future call to `fseek'.

Return Value
------------

The file position, or -1 on error.

Example
-------

     long p = ftell(stdout);


File: libc,  Node: ftime,  Next: ftruncate,  Prev: ftell,  Up: Alphabetical List

`ftime'
=======

Syntax
------

     #include <sys/timeb.h>
     
     int ftime(struct timeb *buf);

Description
-----------

This function stores the current time in the structure BUF.  The format
of `struct timeb' is:

     struct timeb {
       time_t         time;     /* seconds since 00:00:00 GMT 1/1/1970 */
       unsigned short millitm;  /* milliseconds */
       short          timezone; /* difference between GMT and local, minutes */
       short          dstflag;  /* set if daylight savings time in affect */
     };

Return Value
------------

Zero on success, nonzero on error.

Example
-------

     struct timeb t;
     ftime(&t);


File: libc,  Node: ftruncate,  Next: _fwalk,  Prev: ftime,  Up: Alphabetical List

`ftruncate'
===========

Syntax
------

     #include <osfcn.h>
     
     int ftruncate(int file, unsigned long where);

Description
-----------

This function truncates FILE at WHERE length.  This only works if the
file is closed right after this call.

Return Value
------------

Zero for success, nonzero for failure.

Example
-------

     int x = open("data", O_WRONLY);
     ftruncate(x, 1000);
     close(x);


File: libc,  Node: _fwalk,  Next: fwrite,  Prev: ftruncate,  Up: Alphabetical List

`_fwalk'
========

Syntax
------

     void _fwalk(void (*function)(FILE *file));

Description
-----------

For each open file in the system, the given FUNCTION is called, passing
the file pointer as it's only argument

Return Value
------------

None.

Example
-------

     void pfile(FILE *x)
     { printf("FILE at %x\n", x); }
     
     _fwalk(pfile);


File: libc,  Node: fwrite,  Next: _get_default_drive,  Prev: _fwalk,  Up: Alphabetical List

`fwrite'
========

Syntax
------

     #include <stdio.h>
     
     size_t fwrite(void *buffer, size_t size, size_t number, FILE *file);

Description
-----------

This function writes SIZE*NUMBER characters from BUFFER to FILE.

Return Value
------------

The number of items of size SIZE written, or -1 on error.

Example
-------

     int foo[10];
     fwrite(foo, sizeof(int), 10, stdin);


File: libc,  Node: _get_default_drive,  Next: getc,  Prev: fwrite,  Up: Alphabetical List

`_get_default_drive'
====================

Syntax
------

     int _get_default_drive(void);

Description
-----------

Gets the default drive.

Return Value
------------

0 for drive A:, 1 for drive B:, etc, up to 26 for Z:

Example
-------

     printf("Current drive is %c:\n", _get_current_drive()+'a');


File: libc,  Node: getc,  Next: getcbrk,  Prev: _get_default_drive,  Up: Alphabetical List

`getc'
======

Syntax
------

     #include <stdio.h>
     
     int getc(FILE *file);

Description
-----------

Get one character from FILE.

Return Value
------------

The character ([0..255]) or `EOF' if eof or error.

Example
-------

     int c;
     while ((c=getc(stdin)) != EOF)
       putc(c, stdout);


File: libc,  Node: getcbrk,  Next: getchar,  Prev: getc,  Up: Alphabetical List

`getcbrk'
=========

Syntax
------

     #include <dos.h>
     
     int getcbrk(void);

Description
-----------

Get the setting of the Ctrl-C checking flag in MS-DOS.

*Note setcbrk::

Return Value
------------

0 if not checking, 1 if checking.


File: libc,  Node: getchar,  Next: getcwd,  Prev: getcbrk,  Up: Alphabetical List

`getchar'
=========

Syntax
------

     #include <stdio.h>
     
     int getchar(void);

Description
-----------

The same as `fgetc(stdin)' (*note fgetc::.).

Return Value
------------

The character, or `EOF'.


File: libc,  Node: getcwd,  Next: getdate,  Prev: getchar,  Up: Alphabetical List

`getcwd'
========

Syntax
------

     #include <osfcn.h>
     
     char *getcwd(char *buffer, int max);

Description
-----------

Get the current directory.  The return value includes the drive
specifier.  If BUFFER is `NULL', a buffer of size MAX is allocated.
This call fails if more than MAX characters are required to specify the
current directory.

If `getcwd' allocates a buffer for you, you may later free is with
`free'.

Return Value
------------

The buffer, either BUFFER or a newly-allocated buffer, or `NULL' on
error.

Example
-------

     char *buf = getcwd(0, PATH_MAX);
     printf("cwd is %s\n", buf);
     free(buf);


File: libc,  Node: getdate,  Next: getdfree,  Prev: getcwd,  Up: Alphabetical List

`getdate'
=========

Syntax
------

     #include <dos.h>
     
     void getdate(struct date *);

Description
-----------

This function gets the current date.  The return structure is as
follows:

     struct date {
       short da_year;
       char  da_day;
       char  da_mon;
     };

*Note setdate:: *Note gettime::

Return Value
------------

None.

Example
-------

     struct date d;
     getdate(&d);


File: libc,  Node: getdfree,  Next: getdisk,  Prev: getdate,  Up: Alphabetical List

`getdfree'
==========

Syntax
------

     #include <dos.h>
     
     void getdfree(unsigned char drive, struct dfree *ptr);

Description
-----------

This function gets information about the size and fullness of the given
drive (0=default, 1=A:, etc).  The return structure is as follows:

     struct dfree {
       unsigned df_avail; /* number of available clusters */
       unsigned df_total; /* total number of clusters */
       unsigned df_bsec;  /* bytes per sector */
       unsigned df_sclus; /* sectors per cluster */
     };

Return Value
------------

None.

Example
-------

     struct dfree d;
     getdfree(3, &d); /* drive C: */


File: libc,  Node: getdisk,  Next: getdtablesize,  Prev: getdfree,  Up: Alphabetical List

`getdisk'
=========

Syntax
------

     #include <dir.h
     
     int getdisk(void);

Description
-----------

Gets the current disk (0=A).

*Note setdisk::

Return Value
------------

The current disk.

Example
-------

     printf("This drive is %c:\n", getdisk() + 'A');


File: libc,  Node: getdtablesize,  Next: getegid,  Prev: getdisk,  Up: Alphabetical List

`getdtablesize'
===============

Syntax
------

     #include <osfcn.h>
     
     int getdtablesize(void);

Description
-----------

Get the maximum number of open file descriptors the system supports.
Should depend on the setting of `FILES=' in `config.sys', but is
currently hardcoded to 50.

Return Value
------------

The number of file descriptors.


File: libc,  Node: getegid,  Next: getenv,  Prev: getdtablesize,  Up: Alphabetical List

`getegid'
=========

Syntax
------

     #include <osfcn.h>
     
     int getegid(void);

Description
-----------

Get the effective group id.

Return Value
------------

42


File: libc,  Node: getenv,  Next: geteuid,  Prev: getegid,  Up: Alphabetical List

`getenv'
========

Syntax
------

     #include <stdlib.h>
     
     char *getenv(const char *name);

Description
-----------

Get the setting of the environment variable NAME.  Do not alter or free
the returned value.

Return Value
------------

The value, or `NULL' if that variable does not exist.

Example
-------

     char *term = getenv("TERM");


File: libc,  Node: geteuid,  Next: getftime,  Prev: getenv,  Up: Alphabetical List

`geteuid'
=========

Syntax
------

     #include <osfcn.h>
     
     int geteuid(void);

Description
-----------

Gets the effective UID.

Return Value
------------

42


File: libc,  Node: getftime,  Next: getgid,  Prev: geteuid,  Up: Alphabetical List

`getftime'
==========

Syntax
------

     #include <dos.h>
     
     int getftime(int handle, struct ftime *ptr);

Description
-----------

Get the timestamp for the given file handle.  The return structure is as
follows:

     struct ftime {
       unsigned ft_tsec:5;	/* 0-29, double to get real seconds */
       unsigned ft_min:6;	/* 0-59 */
       unsigned ft_hour:5;	/* 0-23 */
       unsigned ft_day:5;	/* 1-31 */
       unsigned ft_month:4;	/* 1-12 */
       unsigned ft_year:7;	/* since 1980 */
     }

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     struct ftime t;
     getftime(fd, &t);


File: libc,  Node: getgid,  Next: getgrent,  Prev: getftime,  Up: Alphabetical List

`getgid'
========

Syntax
------

     #include <osfcn.h>
     
     int getgid(void);

Description
-----------

Get the current group id.

Return Value
------------

42


File: libc,  Node: getgrent,  Next: getgrgid,  Prev: getgid,  Up: Alphabetical List

`getgrent'
==========

Syntax
------

     #include <grp.h>
     
     struct group *getgrent(void);

Description
-----------

This function returns the next available group entry.  Note that for
MS-DOS, this is simulated.  If the environment variable GROUP is set,
that is the name of the only group returned, else the only group is
"other".

The return type of this and related function is as follows:

     struct group {
       char *  gr_name;   /* "other" or getenv("GROUP"); */
       char *  gr_passwd; /* "*" */
       int     gr_gid;    /* result of getgid() */
       char ** gr_mem;    /* always empty */
     };

Return Value
------------

The next structure, or `NULL' at the end of the list.

Example
-------


     struct group *g;
     setgrent();
     while ((g = getgrent()) != NULL)
     {
       printf("group %s gid %d\n", g->gr_name, g->gr_gid);
     }
     endgrent();


File: libc,  Node: getgrgid,  Next: getgrnam,  Prev: getgrent,  Up: Alphabetical List

`getgrgid'
==========

Syntax
------

     #include <grp.h>
     
     extern struct group *getgrgid(int gid);

Description
-----------

This function returns the group entry that matches GID.  *Note
getgrent::

Return Value
------------

The matching group, or `NULL' if none match.


File: libc,  Node: getgrnam,  Next: getgroups,  Prev: getgrgid,  Up: Alphabetical List

`getgrnam'
==========

Syntax
------

     #include <grp.h>
     
     struct group *getgrnam(char *name);

Description
-----------

This function returns the group entry for the group named NAME.  *Note
getgrent::

Return Value
------------

The matching group, or `NULL' if none match.


File: libc,  Node: getgroups,  Next: getkey,  Prev: getgrnam,  Up: Alphabetical List

`getgroups'
===========

Description
-----------

This function is provided only to assist in porting from Unix.  It
always returns an error condition.


File: libc,  Node: getkey,  Next: getlogin,  Prev: getgroups,  Up: Alphabetical List

`getkey'
========

Syntax
------

     #include <pc.h>
     #include <keys.h>
     
     int getkey(void);

Description
-----------

Waits for the user to press one key, then returns that key.  Alt-key
combinations have 0x100 added to them.  Extended keys return their
non-extended codes.

The file `keys.h' has symbolic names for many of the keys.

*Note getxkey::

Return Value
------------

The key pressed.

Example
-------

     while (getkey() != K_Alt_3)
       do_something();


File: libc,  Node: getlogin,  Next: getlongpass,  Prev: getkey,  Up: Alphabetical List

`getlogin'
==========

Syntax
------

     #include <unistd.h>
     
     char *getlogin(void);

Description
-----------

Get the login ID of the user.

Return Value
------------

Returns the value of the `USER' environment variable, else the
`LOGNAME' environment variable, else `"dosuser"'.

Example
-------

     printf("I am %s\n", getlogin());


File: libc,  Node: getlongpass,  Next: getmntent,  Prev: getlogin,  Up: Alphabetical List

`getlongpass'
=============

Syntax
------

     int getlongpass(const char *prompt, char *password, int max_length);

Description
-----------

Read a password from the user.  First, the prompt is sent to `stderr'.
The characters typed are not echoed, and backspace can be used to edit
the line.  The password will be stored in PASSWORD, up to MAX_LENGTH
characters.  When the user hits Return or Enter, a newline is printed
to `stderr' and the password is returned.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------



File: libc,  Node: getmntent,  Next: getopt,  Prev: getlongpass,  Up: Alphabetical List

`getmntent'
===========

Syntax
------

     #include <mntent.h>
     
     struct mntent *getmntent(FILE *filep);

Description
-----------

This function returns information about the various drives that are
available to your program.  Beginning with drive `A:', information is
retrieved for successive drives with successive calls to `getmntent'.
Note that drives `A:' and `B:' will only be returned if they are the
current drive, otherwise the first drive returned is `C:'.

This function operates by reading the volume label, so unlabelled disks
will not be available.  For each drive scanned, a pointer to a static
structure of the following type is returned:

     struct mntent
     {
         char * mnt_fsname;  /* The volume name */
         char * mnt_dir;     /* The drive name (like "c:") */
         char * mnt_type;    /* "dos" */
         char * mnt_opts;    /* "rw" */
         int    mnt_freq;    /* -1 */
         int    mnt_passno;  /* -1 */
         long   mnt_time;    /* -1 */
     };

Return Value
------------

This function returns a pointer to an `struct' `mntent', or NULL if
there are no more drives to report on.

Example
-------

     struct mntent *m;
     FILE *f;
     f = setmntent("", "");
     while (m = getmntent(f))
       printf("Drive %s, name %s\n", m->mnt_dir, m->mnt_fsname);
     endmntent(f);


File: libc,  Node: getopt,  Next: getpagesize,  Prev: getmntent,  Up: Alphabetical List

`getopt'
========

Syntax
------

     int getopt(int argc, char * const *argv, const char *options);
     extern char *optarg;
     extern int optind, opterr;
     extern char optopt;

Description
-----------

Parse options from the command line.  The OPTIONS are a string of valid
option characters.  If a given option takes a parameter, that character
should be followed by a colon.

For each valid switch, this function sets `optarg' to the argument (if
the switch takes one), sets `optind' to the index in ARGV that it is
using, sets `optopt' to the option letter found, and returns the option
letter found.

If an unexpected option is found, `getopt' will return `?', and if
`opterr' is nonzero, will print an error message to stderr.

The special option `--' indicates that no more options follow on the
command line, and cause `getopt' to stop looking.

Return Value
------------

The option found, or -1 if no more options.

Example
-------

     int c;
     opterr = 0;
     while ((c=getopt(argc, argv, "vbf:")) != -1)
     {
       switch (c)
       {
         case 'v':
           verbose_flag ++;
           break;
         case 'b':
           binary_flag ++;
           break;
         case 'f':
           output_filename = optarg;
           break;
         case '?':
           printf("Unknown option %c\n", c);
           usage();
           exit(1);
       }
     }


File: libc,  Node: getpagesize,  Next: getpass,  Prev: getopt,  Up: Alphabetical List

`getpagesize'
=============

Syntax
------

     #include <osfcn.h>
     
     int getpagesize(void);

Description
-----------

Return the size of the native virtual memory page size.

Return Value
------------

4096 for the i386 and higher processors.


File: libc,  Node: getpass,  Next: getpid,  Prev: getpagesize,  Up: Alphabetical List

`getpass'
=========

Syntax
------

     #include <unistd.h>
     
     char *getpass(const char *prompt);

Description
-----------

Prompts the user with PROMPT and accepts a non-echoed password.  *Note
getlongpass::

Return Value
------------

A pointer to a static buffer is returned.  This buffer is overridden
with each call to `getpass'.

Example
-------

     char *pw = getpass("Enter password : ");


File: libc,  Node: getpid,  Next: getpwent,  Prev: getpass,  Up: Alphabetical List

`getpid'
========

Syntax
------

     #include <osfcn.h>
     
     int getpid(void);

Description
-----------

Get the process ID, which uniquely identifies each program running on
the system.

Return Value
------------

The process ID.


File: libc,  Node: getpwent,  Next: getpwnam,  Prev: getpid,  Up: Alphabetical List

`getpwent'
==========

Syntax
------

     #include <pwd.h>
     
     struct passwd *getpwent(void);

Description
-----------

This function retrieves the next available password file entry.  For
MS-DOS, this is simulated by providing exactly one entry:

     struct passwd {
       char * pw_name;    /* getlogin() */
       char * pw_passwd;  /* "*" */
       int    pw_uid;     /* getuid() */
       int    pw_gid;     /* getgid() */
       char * pw_age;     /* "" */
       char * pw_comment; /* "" */
       char * pw_gecos;   /* "DOS User" */
       char * pw_dir;     /* "/" or getenv("HOME") */
       char * pw_shell;   /* "/bin/sh" or getenv("SHELL") */
       long   pw_audid;   /* -1 */
       int    pw_audflg;  /* -1 */
     };

Return Value
------------

The next passwd entry, or `NULL' if there are no more.

Example
-------

     struct passwd *p;
     setpwent();
     while ((p = getpwent()) != NULL)
     {
       printf("user %s name %s\n", p->pw_name, p->pw_gecos);
     }
     endpwent();


File: libc,  Node: getpwnam,  Next: getpwuid,  Prev: getpwent,  Up: Alphabetical List

`getpwnam'
==========

Syntax
------

     #include <pwd.h>
     
     struct passwd *getpwnam(char *name);

Description
-----------

This function gets the password file entry matchine NAME.  *Note
getpwent::

Return Value
------------

The matching record, or `NULL' if none match.


File: libc,  Node: getpwuid,  Next: getrusage,  Prev: getpwnam,  Up: Alphabetical List

`getpwuid'
==========

#include <pwd.h>

struct passwd *getpwuid(int uid);

Syntax
------


Description
-----------

This function gets the password file entry matchine UID.  *Note
getpwent::

Return Value
------------

The matching record, or `NULL' if none match.


File: libc,  Node: getrusage,  Next: gets,  Prev: getpwuid,  Up: Alphabetical List

`getrusage'
===========

Syntax
------

     #include <sys/time.h>
     #include <sys/resource.h
     
     int getrusage(int who, struct rusage *rusage);

Description
-----------

This function returns information about the running process.  Currently,
the only field that is computed is this:

     struct rusage {
       struct timeval ru_utime;  /* total time used by process */
     };

The remainder of the fields are set to zero.

The WHO parameter must be `RUSAGE_SELF' or `RUSAGE_CHILDREN'.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     struct rusage r;
     getrusage(RUSAGE_SELF, &r);


File: libc,  Node: gets,  Next: gettime,  Prev: getrusage,  Up: Alphabetical List

`gets'
======

Syntax
------

     #include <stdio.h>
     
     char *gets(char *buffer);

Description
-----------

Reads characters from `stdin', storing them in BUFFER, until either end
of file or a newline is encountered.  If any characters were stored,
the BUFFER is then `NULL' terminated and it's address is returned, else
`NULL' is returned.

Return Value
------------

The address of the buffer, or `NULL'.

Example
-------

     char buf[1000];
     while (gets(buf))
       puts(buf);


File: libc,  Node: gettime,  Next: gettimeofday,  Prev: gets,  Up: Alphabetical List

`gettime'
=========

Syntax
------

     #include <dos.h>
     
     void gettime(struct time *);

Description
-----------

This function gets the current time.  The return structure is as
follows:

     struct time {
       unsigned char ti_min;
       unsigned char ti_hour;
       unsigned char ti_hund;
       unsigned char ti_sec;
     };

*Note settime:: *Note getdate::

Return Value
------------

None.

Example
-------

     struct time t;
     gettime(&t);


File: libc,  Node: gettimeofday,  Next: getuid,  Prev: gettime,  Up: Alphabetical List

`gettimeofday'
==============

Syntax
------

     #include <sys/time.h>
     
     int gettimeofday(struct timeval *tp, struct timezone *tzp);

Description
-----------

Gets the current GMT time and the local timezone information.  The
return structures are as follows:

     struct timeval {
       long tv_sec;  /* seconds since 00:00:00 GMT 1/1/1970 */
       long tv_usec; /* microseconds */
     };
     struct timezone {
       int tz_minuteswest; /* west of GMT */
       int tz_dsttime;     /* set if daylight saving time in affect */
     };

If either TP or TZP are `NULL', that information is not provided.

*Note settimeofday::

Return Value
------------

Zero on success, nonzero on failure.


File: libc,  Node: getuid,  Next: getw,  Prev: gettimeofday,  Up: Alphabetical List

`getuid'
========

Syntax
------

     #include <osfcn.h>
     
     int getuid(void);

Description
-----------

Returns the user ID.

Return Value
------------

42


File: libc,  Node: getw,  Next: getwd,  Prev: getuid,  Up: Alphabetical List

`getw'
======

Syntax
------

     #include <stdio.h>
     
     int getw(FILE *file);

Description
-----------

Reads a single binary word in native format from FILE.

*Note putw::

Return Value
------------

The value read, or `EOF' for end-of-file or error.  Since `EOF' is a
valid integer, you should use `feof' or `ferror' to detect this
situation.

Example
-------

     int i = getw(stdin);


File: libc,  Node: getwd,  Next: getxkey,  Prev: getw,  Up: Alphabetical List

`getwd'
=======

Syntax
------

     #include <osfcn.h>
     
     char *getwd(char *buffer);

Description
-----------

Get the current directory and put it in BUFFER.  The return value
includes the drive specifier.

Return Value
------------

BUFFER is returned.

Example
-------

     char buf[PATH_MAX];
     getwd(buf);


File: libc,  Node: getxkey,  Next: gmtime,  Prev: getwd,  Up: Alphabetical List

`getxkey'
=========

Syntax
------

     #include <pc.h>
     #include <keys.h>
     
     int getxkey(void);

Description
-----------

Waits for the user to press one key, then returns that key.  Alt-key
combinations have 0x100 added to them, and extended keys have 0x200
added to them.

The file `keys.h' has symbolic names for many of the keys.

*Note getkey::

Return Value
------------

The key pressed.

Example
-------

     while (getxkey() != K_EEnd)
       do_something();


File: libc,  Node: gmtime,  Next: go32.h,  Prev: getxkey,  Up: Alphabetical List

`gmtime'
========

Syntax
------

     #include <time.h>
     
     struct tm *gmtime(const time_t *tod);

Description
-----------

Converts the time represented by TOD into a structure.

The return structure has this format:

     struct tm {
       int    tm_sec;    /* seconds after the minute [0-60] */
       int    tm_min;    /* minutes after the hour [0-59] */
       int    tm_hour;   /* hours since midnight [0-23] */
       int    tm_mday;   /* day of the month [1-31] */
       int    tm_mon;    /* months since January [0-11] */
       int    tm_year;   /* years since 1900 */
       int    tm_wday;   /* days since Sunday [0-6] */
       int    tm_yday;   /* days since January 1 [0-365] */
       int    tm_isdst;  /* Daylight Savings Time flag */
       long   tm_gmtoff; /* offset from GMT in seconds */
       char * tm_zone;   /* timezone abbreviation */
     };

Return Value
------------

A pointer to a static structure which is overridden with each call.

Example
-------

     time_t x;
     struct tm *t;
     time(&x);
     t = gmtime(&t);


File: libc,  Node: go32.h,  Next: Go32/DPMI Information,  Prev: gmtime,  Up: Alphabetical List

`<go32.h>'
==========

This header provides structure definitions and functions that access
functionality that is only available because of go32.


File: libc,  Node: Go32/DPMI Information,  Next: _go32_conventional_mem_selector,  Prev: go32.h,  Up: Alphabetical List

GO32/DPMI structures
====================

Syntax
------

     #include <dpmi.h>

Description
-----------

DPMI is an interface to the program controlling the protected mode of
the PC.  For more information on DPMI, order Intel document number
240977-001.  If there is no DPMI server running on the PC, go32 itself
will provide a subset of the DPMI functions.  For maximum portability,
programs should confine themselves to the specifications listed in the
file `docs/djgpp/dpmi.doc' in the DJGPP distribution.  The convenience
functions listed in `include/dpmi.h' comply with these restrictions and
thus will always be usable on a given PC.

The DPMI convenience functions provided by go32 use two structures to
pass information around in.  These structures are shown below.

     typedef union {
       struct {
         u_long edi;
         u_long esi;
         u_long ebp;
         u_long res;
         u_long ebx;
         u_long edx;
         u_long ecx;
         u_long eax;
       } d;
       struct {
         u_short di, di_hi;
         u_short si, si_hi;
         u_short bp, bp_hi;
         u_short res, res_hi;
         u_short bx, bx_hi;
         u_short dx, dx_hi;
         u_short cx, cx_hi;
         u_short ax, ax_hi;
         u_short flags;
         u_short es;
         u_short ds;
         u_short fs;
         u_short gs;
         u_short ip;
         u_short cs;
         u_short sp;
         u_short ss;
       } x;
       struct {
         u_char edi[4];
         u_char esi[4];
         u_char ebp[4];
         u_char res[4];
         u_char bl, bh, ebx_b2, ebx_b3;
         u_char dl, dh, edx_b2, edx_b3;
         u_char cl, ch, ecx_b2, ecx_b3;
         u_char al, ah, eax_b2, eax_b3;
       } h;
     } _go32_dpmi_registers;

The `_go32_dpmi_registers' structure is used to pass a CPU state image
between protected and real mode.

     typedef struct {
       u_long  size;
       u_long  pm_offset;
       u_short pm_selector;
       u_short rm_offset;
       u_short rm_segment;
     } _go32_dpmi_seginfo;

The `_go32_dpmi_seginfo' structure is used to pass information about
protected mode and real mode pointers to the convenience functions.
Unless stated otherwise, you should not modify any field in this
structure.  Many calls store important information in otherwise unused
fields that is used in cleanup-style functions.  For example,
`_go32_dpmi_allocate_dos_memory' stores a value in pm_selector that is
only used by `_go32_dpmi_free_dos_memory'.


File: libc,  Node: _go32_conventional_mem_selector,  Next: _go32_dpmi_allocate_dos_memory,  Prev: Go32/DPMI Information,  Up: Alphabetical List

`_go32_conventional_mem_selector'
=================================

Syntax
------

     #include <go32.h>
     
     u_short _go32_conventional_mem_selector();

Description
-----------

This function returns a selector which has a physical base address
corresponding to the beginning of conventional memory.  This selector
can be used as a parameter to `movedata' (*note movedata::.) to
manipulate memory in the conventional address space.

Return Value
------------

The selector.

Example
-------

     short blank_row_buf[ScreenCols()];
     /* scroll screen */
     movedata(_go32_conventional_mem_selector(), 0xb8000 + ScreenCols()*2,
              _go32_conventional_mem_selector(), 0xb8000,
              ScreenCols() * (ScreenRows()-1) * 2);
     /* fill last row */
     movedata(_go32_my_ds, (int)blank_row_buf,
              _go32_conventional_mem_selector(),
                 0xb8000 + ScreenCols()*(ScreenRows()-1)*2,
               ScreenCols() * 2);


File: libc,  Node: _go32_dpmi_allocate_dos_memory,  Next: _go32_dpmi_allocate_iret_wrapper,  Prev: _go32_conventional_mem_selector,  Up: Alphabetical List

`_go32_dpmi_allocate_dos_memory'
================================

Syntax
------

     #include <dpmi.h>
     
     int _go32_dpmi_allocate_dos_memory(_go32_dpmi_seginfo *info);

Description
-----------

*Note Go32/DPMI Information::

Allocate a part of the conventional memory area (the first 640K).  Set
the `size' field of INFO to the number of paragraphs requested (this is
(size in bytes + 15)/16), then call.  The `rm_segment' field of INFO
contains the segment of the allocated memory.

The memory may be resized with `_go32_dpmi_resize_dos_memory' and must
be freed with `_go32_dpmi_free_dos_memory'.

If there isn't enough memory in the system, the `size' field of INFO
has the largest available size, and an error is returned.

*Note dosmemput:: *Note dosmemget::

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     _go32_dpmi_seginfo info;
     info.size = (want_size+15) / 16;
     _go32_dpmi_allocate_dos_memory(&info);
     dosmemput(buffer, want_size, info.rm_segment*16);
     _go32_dpmi_free_dos_memory(&info);


File: libc,  Node: _go32_dpmi_allocate_iret_wrapper,  Next: _go32_dpmi_allocate_real_mode_callback_iret,  Prev: _go32_dpmi_allocate_dos_memory,  Up: Alphabetical List

`_go32_dpmi_allocate_iret_wrapper'
==================================

Syntax
------

     #include <dpmi.h>
     
     int _go32_dpmi_allocate_iret_wrapper(_go32_dpmi_seginfo *info);

Description
-----------

*Note Go32/DPMI Information::

This function creates a small assembler function that handles the
overhead of servicing an interrupt.  To use, put the address of your
servicing function in the `pm_offset' field of INFO and call this
function.  The `pm_field' will get replaced with the address of the
wrapper function, which you pass to both
`_go32_dpmi_set_protected_mode_interrupt_vector' and
`_go32_dpmi_free_iret_wrapper'.

*Note _go32_dpmi_set_protected_mode_interrupt_vector:: *Note
_go32_dpmi_free_iret_wrapper::

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     _go32_dpmi_seginfo info;
     info.pm_offset = my_handler;
     _go32_dpmi_allocate_iret_wrapper(&info);
     _go32_dpmi_set_protected_mode_interrupt_handler(0x75, &info);
     ...
     _go32_dpmi_free_iret_wrapper(&info);


File: libc,  Node: _go32_dpmi_allocate_real_mode_callback_iret,  Next: _go32_dpmi_allocate_real_mode_callback_retf,  Prev: _go32_dpmi_allocate_iret_wrapper,  Up: Alphabetical List

`_go32_dpmi_allocate_real_mode_callback_iret'
=============================================

Syntax
------

     #include <dpmi.h>
     
     int _go32_dpmi_allocate_real_mode_callback_iret(_go32_dpmi_seginfo *info, _go32_dpmi_registers *regs);

Description
-----------

*Note Go32/DPMI Information::

This function allocates a "real-mode callback".  Fill in the
`pm_offset' field of INFO and call this function.  It will fill in the
`rm_segment' and `rm_offset' fields.  Any time a real-mode program
calls the real-mode address, your function gets called.  The registers
in affect will be stored in REGS, which should be a global, and will be
passed to your function.  Any changes in REGS will be reflected back
into real mode.  A wrapper will be added to your function to simulate
the effects of an `iret' instruction, so this function is useful for
trapping real-mode software interrupts (like 0x1b - `Ctrl-Break' hit).

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     _go32_dpmi_registers regs;
     
     my_handler(_go32_dpmi_registers *r)
     {
       r.d.eax = 4;
     }
     
     setup()
     {
       _go32_dpmi_seginfo info;
       _go32_dpmi_seginfo old_vector;
       _go32_dpmi_get_real_mode_interrupt_vector(0x84, &old_vector);
       info.pm_offset = my_handler;
       _go32_dpmi_allocate_real_mode_callback_iret(&info, &regs);
       _go32_dpmi_set_real_mode_interrupt_vector(0x84, &info);
       do_stuff();
       _go32_dpmi_set_real_mode_interrupt_vector(0x84, &old_vector);
       _go32_dpmi_free_real_mode_callback(&info);
     }


File: libc,  Node: _go32_dpmi_allocate_real_mode_callback_retf,  Next: _go32_dpmi_chain_protected_mode_interrupt_vector,  Prev: _go32_dpmi_allocate_real_mode_callback_iret,  Up: Alphabetical List

`_go32_dpmi_allocate_real_mode_callback_retf'
=============================================

Syntax
------

     #include <dpmi.h>
     
     int _go32_dpmi_allocate_real_mode_callback_retf(_go32_dpmi_seginfo *info, _go32_dpmi_registers *regs);

Description
-----------

*Note Go32/DPMI Information::

This function allocates a "real-mode callback".  Fill in the
`pm_offset' field of INFO and call this function.  It will fill in the
`rm_segment' and `rm_offset' fields.  Any time a real-mode program
calls the real-mode address, your function gets called.  The registers
in affect will be stored in REGS, which should be a global, and will be
passed to your function.  Any changes in REGS will be reflected back
into real mode.  A wrapper will be added to your function to simulate
the effects of a far return, such as the callback for the packet driver
receiver.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

*Note _go32_dpmi_allocate_real_mode_callback_iret::


File: libc,  Node: _go32_dpmi_chain_protected_mode_interrupt_vector,  Next: _go32_dpmi_free_dos_memory,  Prev: _go32_dpmi_allocate_real_mode_callback_retf,  Up: Alphabetical List

`_go32_dpmi_chain_protected_mode_interrupt_vector'
==================================================

Syntax
------

     #include <dpmi.h>
     
     int _go32_dpmi_chain_protected_mode_interrupt_vector(int vector, _go32_dpmi_seginfo *info);

Description
-----------

*Note Go32/DPMI Information::

This function is used to chain a protected mode interrupt.  It will
build a suitable wrapper that will call your function and then jump to
the next handler.  Your function need not perform any special handling.

*Warning!* Because of the way DPMI works, you may *not* `longjmp' out
of an interrupt handler or perform any system calls (such as `printf')
from within an interrupt handler.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

*Note _go32_dpmi_set_protected_mode_interrupt_vector::


File: libc,  Node: _go32_dpmi_free_dos_memory,  Next: _go32_dpmi_free_iret_wrapper,  Prev: _go32_dpmi_chain_protected_mode_interrupt_vector,  Up: Alphabetical List

`_go32_dpmi_free_dos_memory'
============================

Syntax
------

     #include <dpmi.h>
     
     int _go32_dpmi_free_dos_memory(_go32_dpmi_seginfo *info);

Description
-----------

*Note Go32/DPMI Information::

This function frees the conventional memory allocated by
`_go32_dpmi_allocate_real_mode_memory'.  You should pass it the same
structure as was used to allocate it.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     _go32_dpmi_seginfo info;
     info.size = 100;
     _go32_dpmi_allocate_dos_memory(&info);
     _go32_dpmi_free_dos_memory(&info);


File: libc,  Node: _go32_dpmi_free_iret_wrapper,  Next: _go32_dpmi_free_real_mode_callback,  Prev: _go32_dpmi_free_dos_memory,  Up: Alphabetical List

`_go32_dpmi_free_iret_wrapper'
==============================

Syntax
------

     #include <dpmi.h>
     
     int _go32_dpmi_free_iret_wrapper(_go32_dpmi_seginfo *info);

Description
-----------

*Note Go32/DPMI Information::

This function frees the memory used by the wrapper created by
`_go32_dpmi_allocate_iret_wrapper'.  You should not free a wrapper that
is still in use.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

*Note _go32_dpmi_allocate_iret_wrapper::


File: libc,  Node: _go32_dpmi_free_real_mode_callback,  Next: _go32_dpmi_get_free_memory_information,  Prev: _go32_dpmi_free_iret_wrapper,  Up: Alphabetical List

`_go32_dpmi_free_real_mode_callback'
====================================

Syntax
------

     #include <dpmi.h>
     
     int _go32_dpmi_free_real_mode_callback(_go32_dpmi_seginfo *info);

Description
-----------

*Note Go32/DPMI Information::

This function frees the real-mode callbacks and wrappers allocated by
`_go32_dpmi_allocate_real_mode_callback_iret' and
`_go32_dpmi_allocate_real_mode_callback_retf'.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

*Note _go32_dpmi_allocate_real_mode_callback_iret::


File: libc,  Node: _go32_dpmi_get_free_memory_information,  Next: _go32_dpmi_get_protected_mode_interrupt_vector,  Prev: _go32_dpmi_free_real_mode_callback,  Up: Alphabetical List

`_go32_dpmi_get_free_memory_information'
========================================

Syntax
------

     #include <dpmi.h
     
     int _go32_dpmi_get_free_memory_information(_go32_dpmi_meminfo *info);

Description
-----------

This function fills in the following structure:

     typedef struct {
       u_long available_memory;
       u_long available_pages;
       u_long available_lockable_pages;
       u_long linear_space;
       u_long unlocked_pages;
       u_long available_physical_pages;
       u_long total_physical_pages;
       u_long free_linear_space;
       u_long max_pages_in_paging_file;
       u_long reserved[3];
     } _go32_dpmi_meminfo;

The only field that is guaranteed to have useful data is
`available_memory'.  Any unavailable field has -1 in it.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     int phys_mem_left()
     {
       _go32_dpmi_meminfo info;
       _go32_dpmi_get_free_memory_information(&info);
       if (info.available_physical_pages != -1)
         return info.available_physical_pages * 4096;
       return info.available_memory;
     }


File: libc,  Node: _go32_dpmi_get_protected_mode_interrupt_vector,  Next: _go32_dpmi_get_real_mode_interrupt_vector,  Prev: _go32_dpmi_get_free_memory_information,  Up: Alphabetical List

`_go32_dpmi_get_protected_mode_interrupt_vector'
================================================

Syntax
------

     #include <dpmi.h>
     
     int _go32_dpmi_get_protected_mode_interrupt_vector(int vector, _go32_dpmi_seginfo *info);

Description
-----------

*Note Go32/DPMI Information::

This function puts the selector and offset of the specified interrupt
vector into the `pm_selector' and `pm_offset' fields of INFO.  This
structure can be saved and later passed to
`_go32_dpmi_get_protected_mode_interrupt_vector' to restore a vector.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

*Note _go32_dpmi_set_protected_mode_interrupt_vector::


File: libc,  Node: _go32_dpmi_get_real_mode_interrupt_vector,  Next: _go32_dpmi_remaining_physical_memory,  Prev: _go32_dpmi_get_protected_mode_interrupt_vector,  Up: Alphabetical List

`_go32_dpmi_get_real_mode_interrupt_vector'
===========================================

Syntax
------

     #include <dpmi.h>
     
     int _go32_dpmi_get_real_mode_interrupt_vector(int vector, _go32_dpmi_seginfo *info);

Description
-----------

*Note Go32/DPMI Information::

This function fills in the `rm_segment' and `rm_offset' fields of INFO
with the address of the specified real-mode interrupt vector.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

*Note _go32_dpmi_allocate_real_mode_callback_iret::


File: libc,  Node: _go32_dpmi_remaining_physical_memory,  Next: _go32_dpmi_remaining_virtual_memory,  Prev: _go32_dpmi_get_real_mode_interrupt_vector,  Up: Alphabetical List

`_go32_dpmi_remaining_physical_memory'
======================================

Syntax
------

     #include <dpmi.h>
     
     u_long _go32_dpmi_remaining_physical_memory();

Description
-----------

Returns the amount of physical memory that is still available in the
system.

Return Value
------------

The amount in bytes.


File: libc,  Node: _go32_dpmi_remaining_virtual_memory,  Next: _go32_dpmi_resize_dos_memory,  Prev: _go32_dpmi_remaining_physical_memory,  Up: Alphabetical List

`_go32_dpmi_remaining_virtual_memory'
=====================================

Syntax
------

     #include <dpmi.h>
     
     u_long _go32_dpmi_remaining_virtual_memory();

Description
-----------

Returns the amount of virtual memory that is still available in the
system.

Return Value
------------

The amount in bytes.


File: libc,  Node: _go32_dpmi_resize_dos_memory,  Next: _go32_dpmi_set_protected_mode_interrupt_vector,  Prev: _go32_dpmi_remaining_virtual_memory,  Up: Alphabetical List

`_go32_dpmi_resize_dos_memory'
==============================

Syntax
------

     #include <dpmi.h>
     
     int _go32_dpmi_resize_dos_memory(_go32_dpmi_seginfo *info);

Description
-----------

*Note Go32/DPMI Information::

The INFO structure is the same one used to allocate the memory.  Fill
in a new value for `size' and call this function.  If there is not
enough memory to satisfy the request, the largest size is filled in to
the `size' field, the memory is not resized, and this function fails.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     _go32_dpmi_seginfo info;
     info.size = 10;
     _go32_dpmi_allocate_dos_memory(&info);
     info.size = 20;
     _go32_dpmi_resize_dos_memory(&info);
     _go32_dpmi_free_dos_memory(&info);


File: libc,  Node: _go32_dpmi_set_protected_mode_interrupt_vector,  Next: _go32_dpmi_set_real_mode_interrupt_vector,  Prev: _go32_dpmi_resize_dos_memory,  Up: Alphabetical List

`_go32_dpmi_set_protected_mode_interrupt_vector'
================================================

Syntax
------

     #include <dpmi.h>
     
     int _go32_dpmi_set_protected_mode_interrupt_vector(int vector, _go32_dpmi_seginfo *info);

Description
-----------

*Note Go32/DPMI Information::

This function sets the protected mode interrupt vector specified to
point to the given function.  The `pm_offset' and `pm_selector' fields
of INFO must be filled in (*note _go32_my_cs::.).  The following should
be noted:

   *  You may not `longjmp' out of an interrupt handler.

   *  You may not make any function calls that require go32's
     assistance, such as `printf'.

   *  This function will not wrap the handler for you.  The
     `_go32_dpmi_allocate_iret_wrapper' and
     `_go32_dpmi_chain_protected_mode_interrupt_vector' functions can
     wrap your function if you want.

   *  You must set the pm_selector field of INFO.  Use `_go32_my_cs' to
     get a selector valid for your functions.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     volatile int tics = 0;
     
     timer_handler()
     {
       tics++;
     }
     
     int main()
     {
       _go32_dpmi_seginfo old_handler, new_handler;
     
       printf("grabbing timer interrupt\n");
       _go32_dpmi_get_protected_mode_interrupt_vector(8, &old_handler);
     
       new_handler.pm_offset = (int)tic_handler;
       new_handler.pm_selector = _go32_my_cs();
       _go32_dpmi_chain_protected_mode_interrupt_vector(8, &new_handler);
     
       getkey();
     
       printf("releasing timer interrupt\n");
       _go32_dpmi_set_protected_mode_interrupt_vector(8, &old_handler);
     
       return 0;
     }


File: libc,  Node: _go32_dpmi_set_real_mode_interrupt_vector,  Next: _go32_dpmi_simulate_fcall,  Prev: _go32_dpmi_set_protected_mode_interrupt_vector,  Up: Alphabetical List

`_go32_dpmi_set_real_mode_interrupt_vector'
===========================================

Syntax
------

     #include <dpmi.h>
     
     int _go32_dpmi_set_real_mode_interrupt_vector(int vector, _go32_dpmi_seginfo *info);

Description
-----------

*Note Go32/DPMI Information::

This function sets the real-mode interrupt vector specified to point to
the address in the `rm_segment' and `rm_offset' fields in INFO.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

*Note _go32_dpmi_allocate_real_mode_callback_iret::


File: libc,  Node: _go32_dpmi_simulate_fcall,  Next: _go32_dpmi_simulate_fcall_iret,  Prev: _go32_dpmi_set_real_mode_interrupt_vector,  Up: Alphabetical List

`_go32_dpmi_simulate_fcall'
===========================

Syntax
------

     #include <dpmi.h>
     
     int _go32_dpmi_simulate_fcall(_go32_dpmi_registers *regs);

Description
-----------

*Note Go32/DPMI Information::

This function simulates a real-mode far call to a function that returns
with a far return.  The registers are set up from REGS, including `CS'
and `IP', which indicate the address of the call.  Any registers the
function modifies are reflected in REGS on return.

If `SS' and `SP' are both zero, a small temporary stack is used when in
real mode.  If not, they are used AS IS.  It's a good idea to use
`memset' to initialize the register structure before using it.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     _go32_dpmi_registers r;
     r.x.ax = 47;
     r.x.cs = some_segment;
     r.x.ip = some_offset;
     r.x.ss = r.x.sp = 0;
     _go32_dpmi_simulate_fcall(&r);
     printf("returns %d\n", r.x.ax);


File: libc,  Node: _go32_dpmi_simulate_fcall_iret,  Next: _go32_dpmi_simulate_int,  Prev: _go32_dpmi_simulate_fcall,  Up: Alphabetical List

`_go32_dpmi_simulate_fcall_iret'
================================

Syntax
------

     #include <dpmi.h>
     
     int _go32_dpmi_simulate_fcall_iret(_go32_dpmi_registers *regs);

Description
-----------

*Note Go32/DPMI Information::

This function simulates a real-mode far call to a function that returns
with an `iret' instruction.  The registers are set up from REGS,
including `CS' and `IP', which indicate the address of the call.  Any
registers the function modifies are reflected in REGS on return.

If `SS' and `SP' are both zero, a small temporary stack is used when in
real mode.  If not, they are used AS IS.  It's a good idea to use
`memset' to initialize the register structure before using it.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     _go32_dpmi_registers r;
     r.x.ax = 47;
     r.x.cs = some_segment;
     r.x.ip = some_offset;
     r.x.ss = r.x.sp = 0;
     _go32_dpmi_simulate_fcall_iret(&r);
     printf("returns %d\n", r.x.ax);


File: libc,  Node: _go32_dpmi_simulate_int,  Next: _go32_info_block,  Prev: _go32_dpmi_simulate_fcall_iret,  Up: Alphabetical List

`_go32_dpmi_simulate_int'
=========================

Syntax
------

     #include <dpmi.h>
     
     int _go32_dpmi_simulate_int(int vector, _go32_dpmi_registers *regs);

Description
-----------

*Note Go32/DPMI Information::

This function simulates a real-mode interrup.  The registers are set up
from REGS, including `CS' and `IP', which indicate the address of the
call.  Any registers the function modifies are reflected in REGS on
return.

If `SS' and `SP' are both zero, a small temporary stack is used when in
real mode.  If not, they are used AS IS.  It's a good idea to use
`memset' to initialize the register structure before using it.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     _go32_dpmi_registers r;
     r.h.ah = 0x08;
     r.h.dl = 0x80; /* drive C: */
     r.x.ss = r.x.sp = 0;
     _go32_dpmi_simulate_int(0x13, &r);
     printf("disk is %d cyl, %d head, %d sect\n",
            r.h.ch | ((r.x.cl<<2)&0x300),
            r.h.dh, r.h.cl & 0x3f));


File: libc,  Node: _go32_info_block,  Next: _go32_my_cs,  Prev: _go32_dpmi_simulate_int,  Up: Alphabetical List

`_go32_info_block'
==================

Syntax
------

     #include <go32.h>
     
     extern Go32_Info_Block _go32_info_block;

Description
-----------

The go32 information block is a mechanism for `go32' to pass
information to the application.  Some of this information is generally
useful, such as the pid or the transfer buffer, while some is used
internally to `libc.a' only.

The structure has this format:

     typedef struct {
       u_long size_of_this_structure_in_bytes;
       u_long linear_address_of_primary_screen;
       u_long linear_address_of_secondary_screen;
       u_long linear_address_of_transfer_buffer;
       u_long size_of_transfer_buffer;
       u_long pid;
       u_char master_interrupt_controller_base;
       u_char slave_interrupt_controller_base;
       u_short selector_for_linear_memory;
       u_long linear_address_of_stub_info_structure;
       u_long linear_address_of_original_psp;
       u_short run_mode;
       u_short run_mode_info;
     } Go32_Info_Block;

The linear address fields provide values that are suitable for
`dosmemget' and `dosmemput'.  If you want to use them with movedata,
you must mask off the top four bits, which are set to special values
that go32 uses to detect when you've already transferred the data to
the transfer buffer.

The `run_mode' field indicates the mode that the program is running in.
The following modes are defined:

`_GO32_RUN_MODE_UNDEF'
     This indicates that the extender did not (or could not) determine
     or provide the mode information.  The most probable reason is that
     it's an older extender that does not support this field.  The
     program should not assume anything about the run mode if it is
     this value.

`_GO32_RUN_MODE_RAW'
     This indicates that no CPU manager is being used, and no XMS
     manager is present.  The CPU is being managed directly from the
     extender, and memory was allocated from the extended memory pool.

`_GO32_RUN_MODE_XMS'
     This indicates that the extender is managing the CPU, but an XMS
     driver is managing the memory pool.

`_GO32_RUN_MODE_VCPI'
     This indicates that a VCPI server (like `emm386' or `qemm') is
     managing both the CPU and the memory.

`_GO32_RUN_MODE_DPMI'
     This indicates that a DPMI server (like `qdpmi' or Windows) is
     managing both the CPU and memory.  Programs may rely on this value
     to determine if it is safe to use DPMI 0.9 functions.

     If this value is set, the `run_mode_info' field has the DPMI
     specification version, in hex, shifted eight bits.  For example,
     DPMI 0.9 has 0x0090 in the `run_mode_info' field.

Note that the program should not assume that the value will be one of
the listed values.  If the program is running with an extender that
provides some other mode (say, a newly released extender) then the
program should be able to handle that case gracefully.

Example
-------

     dosmemget(_go32_info_block.linear_address_of_primary_screen, 80*25*2, buf);


File: libc,  Node: _go32_my_cs,  Next: _go32_my_ds,  Prev: _go32_info_block,  Up: Alphabetical List

`_go32_my_cs'
=============

Syntax
------

     #include <go32.h>
     
     u_short _go32_my_cs();

Description
-----------

Returns the current `CS'.  This is useful for setting up interrupt
vectors and such.

Return Value
------------

`CS'


File: libc,  Node: _go32_my_ds,  Next: _go32_my_ss,  Prev: _go32_my_cs,  Up: Alphabetical List

`_go32_my_ds'
=============

Syntax
------

     #include <go32.h>
     
     u_short _go32_my_ds();

Description
-----------

Returns the current `DS'.  This is useful for setting up interrupt
handlers and such.

Return Value
------------

`DS'


File: libc,  Node: _go32_my_ss,  Next: _go32_want_ctrl_break,  Prev: _go32_my_ds,  Up: Alphabetical List

`_go32_my_ss'
=============

Syntax
------

     #include <go32.h>
     
     u_short _go32_my_ss();

Description
-----------

Returns the current `SS'.  This is useful for setting up interrupt
handlers and such.

Return Value
------------

`SS'


File: libc,  Node: _go32_want_ctrl_break,  Next: _go32_was_ctrl_break_hit,  Prev: _go32_my_ss,  Up: Alphabetical List

`_go32_want_ctrl_break'
=======================

Syntax
------

     #include <go32.h>
     
     void   _go32_want_ctrl_break(int yes);

Description
-----------

This function tells go32 whether or not it wants `Ctrl-Break' to be an
exception or passed to the application.  If you pass a nonzero value
for YES, pressing `Ctrl-Break' will set a flag that can be detected
with `_go32_was_ctrl_break_hit' (*note _go32_was_ctrl_break_hit::.).
If you pass zero for YES, When you press `Ctrl-Break' the program will
be terminated.

Note that if you call `_go32_was_ctrl_break_hit', this function
automatically gets called to ask for `Ctrl-Break' events.

Return Value
------------

None.

Example
-------

     _g32_want_ctrl_break(1);
     do_something_long();
     _g32_want_ctrl_break(0);


File: libc,  Node: _go32_was_ctrl_break_hit,  Next: gppconio.h/conio.h,  Prev: _go32_want_ctrl_break,  Up: Alphabetical List

`_go32_was_ctrl_break_hit'
==========================

Syntax
------

     #include <go32.h>
     
     u_long _go32_was_ctrl_break_hit();

Description
-----------

This function returns the number of times that `Ctrl-Break' was hit
since the last call to this function or `_go32_want_ctrl_break' (*note
_go32_want_ctrl_break::.).

Return Value
------------

Zero if `Ctrl-Break' hasn't been hit, nonzero to indicate how many
times if it has been hit.

Note that `_go32_want_ctrl_break' is automatically called to request
these events, so you don't have to set up for this call.

Example
-------

     while (!_go32_was_ctrl_break_hit())
       do_something();


File: libc,  Node: gppconio.h/conio.h,  Next: graphics.h,  Prev: _go32_was_ctrl_break_hit,  Up: Alphabetical List

`<gppconio.h>', `<conio.h>'
===========================

These headers provide Borland-compatible functions for dealing with the
console.


File: libc,  Node: graphics.h,  Next: hasmntopt,  Prev: gppconio.h/conio.h,  Up: Alphabetical List

`<graphics.h>'
==============

This header provides access to the basic (GR) graphics library.  This
provides simple 256-color graphics at SVGA resolutions.  For a more
complete graphics library, obtain the GRX library or use one of the X
development systems.

To link with these functions, add `-lgr' at the end of your link
command line, like this:

`gcc foo.o -o foo -lgr'


File: libc,  Node: hasmntopt,  Next: htonl,  Prev: graphics.h,  Up: Alphabetical List

`hasmntopt'
===========

Syntax
------

     #include <mntent.h>
     
     char *hasmntopt(struct mntent *mnt, char *opt);

Description
-----------

This function is a no-op for MS-DOS, but is provided to assist in Unix
ports.  *Note getmntent::

Return Value
------------

This function always returns `NULL' to signify an error.


File: libc,  Node: htonl,  Next: htons,  Prev: hasmntopt,  Up: Alphabetical List

`htonl'
=======

Syntax
------

     u_long htonl(u_long val);

Description
-----------

This function converts from host formatted longs to network formatted
longs.  For the i386 and higher processors, this means that the bytes
are swapped from 1234 order to 4321 order.

Return Value
------------

The network-order value.

Example
-------

     packet.ipaddr = htonl(ip);


File: libc,  Node: htons,  Next: index,  Prev: htonl,  Up: Alphabetical List

`htons'
=======

Syntax
------

     u_short htonl(u_short val);

Description
-----------

This function converts from host formatted shorts to network formatted
shorts.  For the i386 and higher processors, this means that the bytes
are swapped from 12 order to 21 order.

Return Value
------------

The network-order value.

Example
-------

     tcp.port = htons(port);


File: libc,  Node: index,  Next: initstate,  Prev: htons,  Up: Alphabetical List

`index'
=======

Syntax
------

     #include <strings.h>
     
     char *index(const char *string, int ch);

Description
-----------

Returns a pointer to the first occurrence of CH in STRING.  Note that
the `NULL' character counts, so if you pass zero as CH you'll get a
pointer to the end of the string back.

Return Value
------------

A pointer to the character, or `NULL' if it wasn't found.

Example
-------

     if (index(path, '*'))
       do_wildcards(path);


File: libc,  Node: initstate,  Next: insque,  Prev: index,  Up: Alphabetical List

`initstate'
===========

Syntax
------

     #include <std.h>
     
     char *initstate(unsigned int seed, char *state, int n);

Description
-----------

This function fully initializes the random number generator (*note
random::.).  For more information on the random number generator,
consult the source code `libsrc/c/gen/random.c'.

Return Value
------------

A pointer to the old state.


File: libc,  Node: insque,  Next: int86,  Prev: initstate,  Up: Alphabetical List

`insque'
========

Syntax
------

     void insque(struct vaxque *elem, struct vaxque *prev);

Description
-----------

Given a queue of elements derived from this structure:

     struct vaxque {
       struct vaxque *vq_next;
       struct vaxque *vq_prev;
     };

This function inserts a new element ELEM in the queue after the element
specified (PREV).  This function emulates the VAX `insque' opcode.
*Note remque::

Return Value
------------

None.


File: libc,  Node: int86,  Next: int86x,  Prev: insque,  Up: Alphabetical List

`int86'
=======

Syntax
------

     #include <dos.h>
     
     int int86(int ivec, union REGS *in, union REGS *out);

Description
-----------

This function is just like `int86x' (*note int86x::.) except that
suitable default values are used for the segment registers.

Return Value
------------

The returned value of `EAX'.

Example
-------

     union REGS r;
     r.x.ax = 0x0100;
     r.h.dl = 'c';
     int86(0x21, &r, &r);


File: libc,  Node: int86x,  Next: intdos,  Prev: int86,  Up: Alphabetical List

`int86x'
========

Syntax
------

     #include <dos.h>
     
     int int86x(int ivec, union REGS *in, union REGS *out, struct SREGS *seg);

Description
-----------

This function simulates a software interrupt.  Note that, unlike the
`_go32_dpmi_*' functions, requests that go through `int86x' and similar
functions are normally processed by go32 to make it easier for the
programmer to use these functions.  For example, if a particular
routine takes a pointer in `ES:BX', go32 expects you to put a virtual
pointer in `EBX' and it ignores `ES'.  This is mostly because segments
aren't used in protected mode the way they are in real mode, so go32
takes care of the conversion for you - and it knows what your segment
selectors are anyway.

When the interrupt is invoked, the CPU registers are copied from IN.
After the interrupt, the CPU registers are copied to OUT.  In addition,
the segment registers are loaded from SEG and afterwards stored back
into SEG.

*Note int86:: *Note intdos:: *Note bdos::

Return Value
------------

The value of `EAX' is returned.

Example
-------

     union REGS r;
     struct SREGS s;
     r.h.ah = 0x31;
     r.h.dl = 'c';
     r.x.si = si_val;
     s.ds = ds_val;
     int86x(0x21, &r, &r, &s);


File: libc,  Node: intdos,  Next: intdosx,  Prev: int86x,  Up: Alphabetical List

`intdos'
========

Syntax
------

     #include <dos.h>
     
     int intdos(union REGS *in, union REGS *out);

Description
-----------

This function is just like `int86x' (*note int86x::.) except that
suitable default values are used for the segment registers and the
interrupt vector is 0x21.

Return Value
------------

`EAX'


File: libc,  Node: intdosx,  Next: _iob,  Prev: intdos,  Up: Alphabetical List

`intdosx'
=========

Syntax
------

     #include <dos.h>
     
     int intdosx(union REGS *in, union REGS *out, struct SREGS *s);

Description
-----------

This function is just like `int86x' (*note int86x::.) except that the
interrupt vector is 0x21.

Return Value
------------

`EAX'


File: libc,  Node: _iob,  Next: isalnum,  Prev: intdosx,  Up: Alphabetical List

`_iob'
======

Description
-----------

This is an internal variable used to keep track of open `FILE*' files.


File: libc,  Node: isalnum,  Next: isalpha,  Prev: _iob,  Up: Alphabetical List

`isalnum'
=========

Syntax
------

     #include <ctype.h>
     
     int isalnum(int c);

Description
-----------

Tells if C is any letter or digit.

Return Value
------------

Nonzero if C is a letter or digit, else zero.

Example
-------


File: libc,  Node: isalpha,  Next: isatty,  Prev: isalnum,  Up: Alphabetical List

`isalpha'
=========

Syntax
------

     #include <ctype.h>
     
     int isalpha(int c);

Description
-----------

Tells if C is a letter.

Return Value
------------

Nonzero if C is a letter, else zero.


File: libc,  Node: isatty,  Next: iscntrl,  Prev: isalpha,  Up: Alphabetical List

`isatty'
========

Syntax
------

     #include <osfcn.h>
     
     int isatty(int fd);

Description
-----------

Tells if the file descriptor refers to a physical device or a disk file.

Return Value
------------

Nonzero if FD is a device, zero if it is a disk file.

Example
-------

     if (isatty(1))
       fflush(stdout);


File: libc,  Node: iscntrl,  Next: isdigit,  Prev: isatty,  Up: Alphabetical List

`iscntrl'
=========

Syntax
------

     #include <ctype.h>
     
     int iscntrl(int c);

Description
-----------

Tells if C is a control character.

Return Value
------------

Nonzero if C is a control character, else zero.


File: libc,  Node: isdigit,  Next: isgraph,  Prev: iscntrl,  Up: Alphabetical List

`isdigit'
=========

Syntax
------

     #include <ctype.h>
     
     int isdigit(int c);

Description
-----------

Tells if C is a digit.

Return Value
------------

Nonzero if C is a digit, else zero.


File: libc,  Node: isgraph,  Next: isleap,  Prev: isdigit,  Up: Alphabetical List

`isgraph'
=========

Syntax
------

     #include <ctype.h>
     
     int isgraph(int c);

Description
-----------

Tells if C is a visible printing character.  Space is not included.

Return Value
------------

Nonzero if C is a visible printing character, else zero.


File: libc,  Node: isleap,  Next: islower,  Prev: isgraph,  Up: Alphabetical List

`isleap'
========

Syntax
------

     #include <tzfile.h>
     
     int isleap(int year);

Description
-----------

This function determines if the given year is a leap year.

Return Value
------------

True if it is a leap year, else false.

Example
-------

     if (isleap(year))
       printf("Feb 29");


File: libc,  Node: islower,  Next: isprint,  Prev: isleap,  Up: Alphabetical List

`islower'
=========

Syntax
------

     #include <ctype.h>
     
     int islower(int c);

Description
-----------

Tells if C is lower case or not.

Return Value
------------

Nonzero if C is lower case, else zero.


File: libc,  Node: isprint,  Next: ispunct,  Prev: islower,  Up: Alphabetical List

`isprint'
=========

Syntax
------

     #include <ctype.h>
     
     int isprint(int c);

Description
-----------

Tells if C is a printing character, which includes the space character.

Return Value
------------

Nonzero if C is a printing character, else zero.


File: libc,  Node: ispunct,  Next: isspace,  Prev: isprint,  Up: Alphabetical List

`ispunct'
=========

Syntax
------

     #include <ctype.h>
     
     int ispunct(int c);

Description
-----------

Tells if C is any printing character except space and those indicated
by `isalnum'.

Return Value
------------

Nonzero if C is punctuation, else zero.


File: libc,  Node: isspace,  Next: isupper,  Prev: ispunct,  Up: Alphabetical List

`isspace'
=========

Syntax
------

     #include <ctype.h>
     
     int isspace(int c);

Description
-----------

Tells if C is whitespace, that is, carriage return, newline, form feed,
tab, vertical tab, or space.

Return Value
------------

Nonzero if C is whitespace, else zero.


File: libc,  Node: isupper,  Next: isxdigit,  Prev: isspace,  Up: Alphabetical List

`isupper'
=========

Syntax
------

     #include <ctype.h>
     
     int isupper(int c);

Description
-----------

Tells if C is an upper case character or not.

Return Value
------------

Nonzero if C is upper case, else zero.


File: libc,  Node: isxdigit,  Next: itoa,  Prev: isupper,  Up: Alphabetical List

`isxdigit'
==========

Syntax
------

     #include <ctype.h>
     
     int isxdigit(int c);

Description
-----------

Tells if C is a valid hexidecimal digit or not.  This includes
`[0-9a-fA-f]'.

Return Value
------------

Nonzero if C is a hex digit, else zero.


File: libc,  Node: itoa,  Next: kbhit,  Prev: isxdigit,  Up: Alphabetical List

`itoa'
======

Syntax
------

     #include <stdlib.h>
     
     char *    itoa(int value, char *buffer, int radix);

Description
-----------

This function converts an integer VALUE to it's string representation.
If RADIX is 10, the value is treated as a signed value, and the
resulting string may have a prepended minus sign.  For all other values
of RADIX, the value is treated as unsigned.

The buffer you pass must be large enough to hold the largest returned
string.  Since RADIX must be in the range 2 through 36, the largest
buffer would be 33 characters (including the trailing null).  If you
pass NULL for the BUFFER, one is allocated for you, which you must
later free.

For values of RADIX larger than 10, characters in the range `a' through
`z' are used to represent the digits after `9'.

Return Value
------------

A pointer to BUFFER or the allocated buffer.

Example
-------

     char buf[33];
     itoa(val, buf, 16);
     printf("%d = 0x%s\n", val, buf);


File: libc,  Node: kbhit,  Next: keys.h,  Prev: itoa,  Up: Alphabetical List

`kbhit'
=======

Syntax
------

     #include <pc.h>
     
     int kbhit(void);

Description
-----------

If the user has hit a key, this function will detect it.  This function
is very fast when there is no key waiting, so it may be used inside
loops as needed.

If you test shift/alt/ctrl status with bios calls (e.g., using `bioskey
(2)' or `bioskey (0x12)') then you should also use bios calls for
testing for keys.  This can be done with by `bioskey (1)' or `bioskey
(0x11)'.  Failing to do so can cause trouble in multitasking
environments like DESQview/X.

Return Value
------------

Nonzero if a key has been hit, else zero.

Example
-------

     while (!kbhit())
       do_stuff();


File: libc,  Node: keys.h,  Next: kill,  Prev: kbhit,  Up: Alphabetical List

`<keys.h>'
==========

This header defines all the possible values that `getkey()' can return
(*note getkey::.).


File: libc,  Node: kill,  Next: labs,  Prev: keys.h,  Up: Alphabetical List

`kill'
======

Description
-----------

This function does nothing.  It exists to assist in porting Unix
programs.


File: libc,  Node: labs,  Next: ldexp,  Prev: kill,  Up: Alphabetical List

`labs'
======

Syntax
------

     #include <stdlib.h>
     
     long labs(long x);

Description
-----------

This function takes the absolute value of X.  *Note abs::

Return Value
------------

|X|


File: libc,  Node: ldexp,  Next: ldiv,  Prev: labs,  Up: Alphabetical List

`ldexp'
=======

Syntax
------

     #include <math.h>
     
     double ldexp(double val, int exp);

Return Value
------------

This function returns VAL * 2 ** EXP.

Example
-------

     ldexp(3.5,4) == 3.5 * 16 == 56.0


File: libc,  Node: ldiv,  Next: link,  Prev: ldexp,  Up: Alphabetical List

`ldiv'
======

Syntax
------

     #include <stdlib.h>
     
     ldiv_t ldiv(long numerator, long denomonator);

Description
-----------

Returns the quotient and remainder of the division NUMBERATOR divided
by DENOMONATOR.  The return type is as follows:

     typedef struct {
       long quot;
       long rem;
     } ldiv_t;

Return Value
------------

The results of the division are returned.

Example
-------

     ldiv_t l = div(42, 3);
     printf("42 = %ld x 3 + %ld\n", l.quot, l.rem);


File: libc,  Node: link,  Next: localeconv,  Prev: ldiv,  Up: Alphabetical List

`link'
======

Syntax
------

     #include <osfcn.h>
     
     int link(const char *exists, const char *new);

Description
-----------

Because of limitations of MS-DOS, this function doesn't really link two
files together.  However, it simulates a real `link' by copying the
file at EXISTS to NEW.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     link("foo.c", "foo.bak");


File: libc,  Node: localeconv,  Next: localtime,  Prev: link,  Up: Alphabetical List

`localeconv'
============

Syntax
------

     #include <locale.h>
     
     struct lconv *localeconv(void);

Description
-----------

This function returns a pointer to a static structure that contains
information about the current locale.  The structure contains these
fields:

`char *currency_symbol'
     A string that should be used when printing local currency.

`char *decimal_point'
     A string that is used to separate the integer and fractional
     portions of real numbers in `printf'.  Currently, only the first
     character is significant.

`char *grouping'
     An array of numbers indicating the size of groupings for
     non-monetary values to the left of the decimal point.  The first
     number is the size of the grouping just before the decimal point.
     A number of zero means to repeat the previous number indefinitely.
     A number of `CHAR_MAX' means to group the remainder of the digits
     together.

`char *int_curr_symbol'
     A string that should be used when formatting monetary values for
     local currency when the result will be used internationally.

`char *mon_decimal_point'
     A string that separates the interger and fractional parts of
     monetary values.

`char *mon_grouping'
     Same as grouping, but for monetary values.

`char *negative_sign'
     A string that is used to represent negative monetary values.

`char *positive_sign'
     A string that is used to represent positive monetary values.

`char *thousands_sep'
     The grouping separator for non-monetary values.

`char frac_digits'
     The number of digits to the right of the decinal point for monetary
     values.

`char int_frac_digits'
     Like frac_digits, but when formatting for international use.

`char n_cs_precedes'
     If nonzero, the currency string should precede the monetary value
     if the monetary value is negative.

`char n_sep_by_space'
     If nonzero, the currency string and the monetary value should be
     separated by a space if the monetary value is negative.

`char n_sign_posn'
     Determines the placement of the negative indication string if the
     monetary value is negative.

    0
          ($value), (value$)

    1
          -$value, -value$

    2
          $value-, value$-

    3
          -$value, value-$

    4
          $-value, value$-

`char p_cs_precedes'
`char p_sep_by_space'
`char p_sign_posn'
     These are the same as n_*, but for when the monetary value is
     positive.

Note that any numeric field may have a value of `CHAR_MAX', which
indicates that no information is available.

Return Value
------------

A pointer to the `struct lconv' structure.

Example
-------

     struct lconv *l = localeconv;
     printf("%s%d\n", l->negative_sign, value);


File: libc,  Node: localtime,  Next: lock,  Prev: localeconv,  Up: Alphabetical List

`localtime'
===========

Syntax
------

     #include <time.h>
     
     struct tm *localtime(const time_t *tod);

Description
-----------

Converts the time represented by TOD into a structure, correcting for
the local timezone.  *Note gmtime::

Return Value
------------

A pointer to a static structure which is overridden with each call.


File: libc,  Node: lock,  Next: longjmp,  Prev: localtime,  Up: Alphabetical List

`lock'
======

Syntax
------

     #include <io.h>
     
     int lock(int fd, long offset, long length);

Description
-----------

Locks a region in file FD using MS-DOS file sharing interface.  The
region of LENGTH bytes, starting from OFFSET, will become entirely
inaccessible to other processes. If multiple locks are used on a single
file they must be non-overlapping. The lock must be removed before the
file is closed.

This function will fail unless SHARE, or a network software providing
similar interface, is installed. This function is compatible with
Borland C++ function of the same name.

*Note unlock::.

Return Value
------------

Zero if successful, nonzero if not.


File: libc,  Node: longjmp,  Next: longjmperror,  Prev: lock,  Up: Alphabetical List

`longjmp'
=========

Syntax
------

     #include <setjmp.h>
     
     void longjmp(jmp_buf env, int val);

Description
-----------

This function reverts back to a CPU state that was stored in ENV by
`setjmp' (*note setjmp::.).  The state includes all CPU registers, so
any variable in a register when `setjmp' was called will be preserved,
and all else will be indeterminate.

The value passed as VAL will be the return value of `setjmp' when it
resumes processing there.  If VAL is zero, the return value will be one.

Return Value
------------

This function does not return.

Example
-------

     jmp_buf j;
     if (setjmp(j))
       return;
     do_something();
     longjmp(j);


File: libc,  Node: longjmperror,  Next: lseek,  Prev: longjmp,  Up: Alphabetical List

`longjmperror'
==============

Syntax
------

     void longjmperr(void);

Description
-----------

This function is internal and is used by setjmp and longjmp when they
detect an invalid longjmp request.

Return Value
------------

None.


File: libc,  Node: lseek,  Next: __main,  Prev: longjmperror,  Up: Alphabetical List

`lseek'
=======

Syntax
------

     #include <osfcn.h>
     
     long lseek(nit fd, long offset, int whence);

Description
-----------

This function moves the file pointer for FD according to MODE:

`SEEK_SET'
     The file pointer is moved to the offset specified.

`SEEK_CUR'
     The file pointer is moved relative to its current position.

`SEEK_END'
     The file pointer is moved to a position OFFSET bytes from the end
     of the file.  The offset is usually nonpositive in this case.

Return Value
------------

The new offset is returned.

Example
-------

     lseek(fd, 12, SEEK_CUR); /* skip 12 bytes */


File: libc,  Node: __main,  Next: malloc,  Prev: lseek,  Up: Alphabetical List

`__main'
========

Description
-----------

This function is used internally to initialize the application, and
should not be directly called by the programmer.


File: libc,  Node: malloc,  Next: mblen,  Prev: __main,  Up: Alphabetical List

`malloc'
========

Syntax
------

     #include <stdlib.h>
     
     void *malloc(size_t size);

Description
-----------

This function allocates a chunk of memory from the heap large enough to
hold any object that is SIZE bytes in length.  This memory must be
returned to the heap with `free' (*note free::.).

Return Value
------------

A pointer to the allocated memory, or `NULL' if there isn't enough free
memory to satisfy the request.

Example
-------

     char *c = (char *)malloc(100);


File: libc,  Node: mblen,  Next: mbstowcs,  Prev: malloc,  Up: Alphabetical List

`mblen'
=======

Syntax
------

     #include <stdlib.h>
     
     int mblen(const char *s, size_t n);

Description
-----------

This function returns the number of characters of string S that make up
the next multibyte character.  No more than N characters are checked.

If S is `NULL', the internal shift state is reset.

Return Value
------------

The number of characters that comprise the next multibyte character.

Example
-------

     int n = mblen(string, INT_MAX);
     string += n;


File: libc,  Node: mbstowcs,  Next: mbtowc,  Prev: mblen,  Up: Alphabetical List

`mbstowcs'
==========

Syntax
------

     #include <stdlib.h>
     
     size_t mbstowcs(wchar_t *wcs, const char *s, size_t n);

Description
-----------

Converts a multibyte string to a wide character string.  The result
will be no more than N wide characters.

Return Value
------------

The number of wide characters stored.

Example
-------

     int wlen = mbtowcs(wbuf, string, sizeof(wbuf)/sizeof(wchar_t));


File: libc,  Node: mbtowc,  Next: memccpy,  Prev: mbstowcs,  Up: Alphabetical List

`mbtowc'
========

Syntax
------

     #include <stdlib.h>
     
     int mbtowc(wchar_t *pwc, const char *s, size_t n);

Description
-----------

Convert the first multibyte sequence in S to a wide character.  At most
N characters are checked.  If PWC is not `NULL', the result is stored
there.  If S is null, the internal shift state is reset.

Return Value
------------

The number of characters used by the multibyte sequence.

Example
-------

     string += mbtowc(&wc, string, strlen(string));


File: libc,  Node: memccpy,  Next: memchr,  Prev: mbtowc,  Up: Alphabetical List

`memccpy'
=========

Syntax
------

     #include <string.h>
     
     void *memccpy(void *dest, const void *source, int ch, size_t num);

Description
-----------

This function copies at most NUM bytes from SOURCE to DEST, stopping if
the character CH is copied.

Return Value
------------

A pointer to the character after CH, if it was found, else `NULL'.

Example
-------

     char buf[20];
     memccpy(buf, "hello!", 'l', 20);


File: libc,  Node: memchr,  Next: memcmp,  Prev: memccpy,  Up: Alphabetical List

`memchr'
========

Syntax
------

     void *memchr(const void *string, int ch, size_t num);

Description
-----------

This function searches NUM bytes starting at STRING, looking for the
first occurence of CH.

Return Value
------------

A pointer to the first match, or `NULL' if it wasn't found.

Example
-------

     if (memchr(path, '/', strlen(path))
       do_slash();


File: libc,  Node: memcmp,  Next: memcpy,  Prev: memchr,  Up: Alphabetical List

`memcmp'
========

Syntax
------

     #include <string.h>
     
     int memcmp(const void *s1, const void *s2, size_t num);

Description
-----------

This function compares two regions of memory, at S1 and S2, for NUM
bytes.

Return Value
------------

zero
     s1 == s2

positive
     s1 > s2

negative
     s1 < s2


File: libc,  Node: memcpy,  Next: _memcpy,  Prev: memcmp,  Up: Alphabetical List

`memcpy'
========

Syntax
------

     #include <string.h>
     
     void *memcpy(void *dest, const void *src, int num);

Description
-----------

This function copies NUM bytes from SOURCE to DEST.

Return Value
------------

DEST

Example
-------

     memcpy(buffer, temp_buffer, BUF_MAX);


File: libc,  Node: _memcpy,  Next: memmove,  Prev: memcpy,  Up: Alphabetical List

`_memcpy'
=========

Syntax
------

     #include <string.h>
     
     void *_memcpy(void *dest, const void *src, int num);

Description
-----------

This function is just like `memcpy' (*note memcpy::.), but it doesn't
use the i386 `movs' opcode, in case the source and destination are on
memory pages that can't reside in the system at the same time.  This is
used primarily for screen to screen copies of the graphics screen, in
case the two regions are in different graphics windows.

Return Value
------------

DEST


File: libc,  Node: memmove,  Next: memset,  Prev: _memcpy,  Up: Alphabetical List

`memmove'
=========

Syntax
------

     #include <string.h>
     
     void *memmove(void *dest, const void *source, int num);

Description
-----------

This function copies NUM bytes from SOURCE to DEST.  The copy is done
in such a way that if the two regions overlap, the source is always
read before that byte is changed by writing to the destination.

Return Value
------------

DEST

Example
-------

     memmove(buf+1, buf, 99);
     memmove(buf, buf+1, 99);


File: libc,  Node: memset,  Next: mkdir,  Prev: memmove,  Up: Alphabetical List

`memset'
========

Syntax
------

     #include <string.h>
     
     void *memset(void *buffer, int ch, size_t num);

Description
-----------

This function stores NUM copies of CH, starting at BUFFER.  This is
often used to initialize objects to a known value.

Return Value
------------

BUFFER

Example
-------

     struct tm t;
     memset(&t, 0, sizeof(t));


File: libc,  Node: mkdir,  Next: mkfifo,  Prev: memset,  Up: Alphabetical List

`mkdir'
=======

Syntax
------

     #include <osfcn.h>
     
     int mkdir(const char *path, int mode);

Description
-----------

This function creates a subdirectory.  The MODE field is ignored under
MS-DOS.

Return Value
------------

Zero if the subdirectory was created, nonzero on failure.

Example
-------

     mkdir("/usr/tmp");


File: libc,  Node: mkfifo,  Next: mknod,  Prev: mkdir,  Up: Alphabetical List

`mkfifo'
========

Description
-----------

This function is provided only to assist in porting from Unix.  It
always returns an error condition.


File: libc,  Node: mknod,  Next: mkstemp,  Prev: mkfifo,  Up: Alphabetical List

`mknod'
=======

Description
-----------

This function is provided only to assist in porting from Unix.  It
always returns an error condition.


File: libc,  Node: mkstemp,  Next: mktemp,  Prev: mknod,  Up: Alphabetical List

`mkstemp'
=========

Syntax
------

     #include <stdio.h>
     
     int mkstemp(char *template);

Description
-----------

TEMPLATE is a file specification that ends with six trailing `X'
characters.  This function replaces the `XXXXXX' with a set of
characters such that the resulting file name names a nonexisting file.
It then creates and opens the file.

Note that since MS-DOS is limited to eight characters for the file name,
and since none of the `X''s get replaced by a dot, you can only have
two additional characters before the `X''s.

Return Value
------------

The open file descriptor.

Example
-------

     int fd = mkstemp("/tmp/ccXXXXXX");


File: libc,  Node: mktemp,  Next: mktime,  Prev: mkstemp,  Up: Alphabetical List

`mktemp'
========

Syntax
------

     #include <stdio.h>
     
     char *mktemp(char *template);

Description
-----------

TEMPLATE is a file specification that ends with six trailing `X'
characters.  This function replaces the `XXXXXX' with a set of
characters such that the resulting file name names a nonexisting file.

Note that since MS-DOS is limited to eight characters for the file name,
and since none of the `X''s get replaced by a dot, you can only have
two additional characters before the `X''s.

Return Value
------------

The resulting filename.

Example
-------

     char template[] = "/tmp/ccXXXXXX";
     mktemp(template);
     FILE *q = fopen(template, "w");


File: libc,  Node: mktime,  Next: modf,  Prev: mktemp,  Up: Alphabetical List

`mktime'
========

Syntax
------

     #include <time.h>
     
     time_t mktime(struct tm *tptr);

Description
-----------

This function converts a time structure into the number of seconds since
00:00:00 GMT 1/1/1970.  It also attempts to normalize the fields of
TPTR.

Return Value
------------

The resulting time, or -1 if the time in TPTR cannot be described in
that format.


File: libc,  Node: modf,  Next: modfl,  Prev: mktime,  Up: Alphabetical List

`modf'
======

Syntax
------

     #include <math.h>
     
     double modf(double x, double *pint);

Description
-----------

This function decomposes X into it's integer part (*PINT) and it's
fractional part (return value) such that the two have the same sign and
add up to X.

Return Value
------------

The fractional part.

Example
-------

     double f, i;
     f = modf(2.3, &i);
     /* f == 0.3, i == 2.0 */


File: libc,  Node: modfl,  Next: morecore,  Prev: modf,  Up: Alphabetical List

`modfl'
=======

Syntax
------

     #include <math.h>
     
     long double modfl(long double x, long double *pint);

Description
-----------

This function decomposes X into it's integer part (*PINT) and it's
fractional part (return value) such that the two have the same sign and
add up to X.

Return Value
------------

The fractional part.

Example
-------

     long double f, i;
     f = modf(2.3L, &i);
     /* f == 0.3, i == 2.0 */


File: libc,  Node: morecore,  Next: mouse.h,  Prev: modfl,  Up: Alphabetical List

`morecore'
==========

Description
-----------

This is an internal function used by `malloc' (*note malloc::.).


File: libc,  Node: mouse.h,  Next: movedata,  Prev: morecore,  Up: Alphabetical List

`<mouse.h>'
===========

This header defines a simple mouse API.  For a more complete mouse API,
obtain GRX or one of the X development systems.  To use these
functions, add `-lgr' at the end of your link line.


File: libc,  Node: movedata,  Next: nlist,  Prev: mouse.h,  Up: Alphabetical List

`movedata'
==========

Syntax
------

     #include <go32.h>
     
     void movedata(unsigned source_selector, unsigned source_offset,
                   unsigned dest_selector, unsigned dest_offset,
                   size_t length);

Description
-----------

This function allows the caller to directly transfer information between
conventional and linear memory, and among each as well.  The selectors
passed are *not* segment values like in DOS.  They are protected mode
selectors that can be obtained by the `_go32_my_ds' and
`_go32_conventional_mem_selector' functions (*note _go32_my_ds::.
*Note _go32_conventional_mem_selector::).  The offsets are linear
offsets.  If the selector is for the program's data area, this offset
corresponds to the address of a buffer (like `(int)&something').  If the
selector is for the conventional memory area, the offset is the physical
address of the memory, which can be computed from a traditional
segment/offset pair as `segment'*16+`offset'.  For example, the color
text screen buffer is at offset 0xb8000.

Return Value
------------

None.

Example
-------

     short blank_row_buf[ScreenCols()];
     /* scroll screen */
     movedata(_go32_conventional_mem_selector(), 0xb8000 + ScreenCols()*2,
              _go32_conventional_mem_selector(), 0xb8000,
              ScreenCols() * (ScreenRows()-1) * 2);
     /* fill last row */
     movedata(_go32_my_ds, (int)blank_row_buf,
              _go32_conventional_mem_selector(),
                 0xb8000 + ScreenCols()*(ScreenRows()-1)*2,
               ScreenCols() * 2);


File: libc,  Node: nlist,  Next: ntohl,  Prev: movedata,  Up: Alphabetical List

`nlist'
=======

Description
-----------

This function reads synbol addresses out of a.out style executables.  It
doesn't work and djgpp uses COFF style, so don't use it.


File: libc,  Node: ntohl,  Next: ntohs,  Prev: nlist,  Up: Alphabetical List

`ntohl'
=======

Syntax
------

     u_long ntohl(u_long val);

Description
-----------

This function converts from network formatted longs to host formatted
longs.  For the i386 and higher processors, this means that the bytes
are swapped from 1234 order to 4321 order.

Return Value
------------

The host-order value.

Example
-------

     ip = htonl(packet.ipaddr);


File: libc,  Node: ntohs,  Next: offsetof,  Prev: ntohl,  Up: Alphabetical List

`ntohs'
=======

Syntax
------

     u_short ntohl(u_short val);

Description
-----------

This function converts from network formatted shorts to host formatted
shorts.  For the i386 and higher processors, this means that the bytes
are swapped from 12 order to 21 order.

Return Value
------------

The host-order value.

Example
-------

     port = htons(tcp.port);


File: libc,  Node: offsetof,  Next: on_exit,  Prev: ntohs,  Up: Alphabetical List

`offsetof'
==========

Syntax
------

     #include <stddef.h>
     
     size_t offsetof(struct_type, member)

Description
-----------

This macro returns the byte offset from a structure of type STRUCT_TYPE
to a member MEMBER therein.

Return Value
------------

The byte offset

Example
-------


     struct foo {
       int a;
       int b;
     };
     
     struct foo f;
     read(0, (char *)f+offsetof(struct foo, b), 4);


File: libc,  Node: on_exit,  Next: open,  Prev: offsetof,  Up: Alphabetical List

`on_exit'
=========

Syntax
------

     #include <atexit.h>
     
     int on_exit(void (*func)(int), int value);

Description
-----------

This function registers a function to be called when the program is
exiting.  The function is passed the VALUE registered.  *Note atexit::

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     void my_exiter(int arg)
     {
       cleanup_me(arg, 1);
     }
     
     on_exit(my_exiter, 4);


File: libc,  Node: open,  Next: opendir,  Prev: on_exit,  Up: Alphabetical List

`open'
======

Syntax
------

     #include <fcntl.h>    /* for O_* */
     #include <sys/stat.h> /* for S_* */
     #include <osfcn.h>
     
     int open(const char *file, int mode, int permissions);

Description
-----------

This function opens the named FILE in the given MODE, which is any
combination of the following:

`O_RDONLY'
     The file is opened for reading.

`O_WRONLY'
     The file is opened for writing.

`O_RDWR'
     The file is opened for both reading and writing.

`O_CREAT'
     If the file does not exist, it is created. *Note creat::

`O_TRUNC'
     If the file does exist, it is truncated to zero bytes.

`O_EXCL'
     If the file exists, and `O_CREAT' is also specified, the `open'
     call will fail.

`O_APPEND'
     The file pointer is positioned at the end of the file before each
     write.

`O_TEXT'
     The file is opened in text mode, meaning that Ctrl-M characters are
     stripped on reading and added on writing as needed.  The default
     mode is specified by the `_fmode' variable *Note _fmode::.

`O_BINARY'
     The file is opened in binary mode.

If the file is created by this call, it will be given the read/write
permissions specified by PERMISSIONS, which may be any combination of
these values:

`S_IREAD'
     The file is readable.  This is always true for MS-DOS

`S_IWRITE'
     The file is writable.

Return Value
------------

If successful, the file descriptor is returned.  On error, a negative
number is returned and `errno' is set to indicate the error.

Example
-------

     int q = open("/tmp/foo.dat", O_RDONLY|O_BINARY);


File: libc,  Node: opendir,  Next: optarg,  Prev: open,  Up: Alphabetical List

`opendir'
=========

Syntax
------

     #include <dirent.h>
     
     DIR *opendir(char *name);

Description
-----------

This function "opens" a directory so that you can read the list of file
names in it.  The pointer returned must be passed to `closedir' when
you are done with it.  *Note readdir::.

Return Value
------------

The open directory structure, or `NULL' on error.

Example
-------

     DIR *d = opendir(".");
     closedir(d);


File: libc,  Node: optarg,  Next: opterr,  Prev: opendir,  Up: Alphabetical List

`optarg'
========

Description
-----------

*Note getopt::


File: libc,  Node: opterr,  Next: optind,  Prev: optarg,  Up: Alphabetical List

`opterr'
========

Description
-----------

*Note getopt::


File: libc,  Node: optind,  Next: optopt,  Prev: opterr,  Up: Alphabetical List

`optind'
========

Description
-----------

*Note getopt::


File: libc,  Node: optopt,  Next: pathconf,  Prev: optind,  Up: Alphabetical List

`optopt'
========

Description
-----------

*Note getopt::


File: libc,  Node: pathconf,  Next: pc.h,  Prev: optopt,  Up: Alphabetical List

`pathconf'
==========

Syntax
------

     #include <unistd.h>
     
     long pathconf(const char *filename, int name);

Description
-----------

This function returns various system-dependent configuration values.
The NAME is one of the following:

`_PC_LINK_MAX'
     The maximum number of directory entries that can refer to a single
     real file.

`_PC_MAX_CANON'
     The maximum number of bytes in an editable input line.

`_PC_MAX_INPUT'
     The maximum number of bytes in a non-editable input line.

`_PC_NAME_MAX'
     The maximum length of an individual file name.

`_PC_PATH_MAX'
     The maximum length of a complete path name.

`_PC_PIPE_BUF'
     The size of a pipe's internal buffer.

Return Value
------------

The selected configuration value is returned.

Example
-------

     char *buf = malloc(pathconf("c:/", _PC_MAX_PATH)+1);


File: libc,  Node: pc.h,  Next: pclose,  Prev: pathconf,  Up: Alphabetical List

`<pc.h>'
========

This header provides functions specific to the PC arcitecture, like
`poke' and video memory access.  To use these functions, add `-lpc' to
the end of your link line.


File: libc,  Node: pclose,  Next: perror,  Prev: pc.h,  Up: Alphabetical List

`pclose'
========

Syntax
------

     #include <stdio.h>
     
     int pclose(FILE *pipe);

Description
-----------

This function closes a pipe opened with `popen' (*note popen::.).  Note
that since MS-DOS is not multitasking, this function will actually run
the program specified in `popen' if the pipe was opened for writing.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     FILE *f = popen("sort", "w");
     write_to_pipe(f);
     pclose(f);


File: libc,  Node: perror,  Next: pipe,  Prev: pclose,  Up: Alphabetical List

`perror'
========

Syntax
------

     #include <stdio.h>
     
     void perror(const char *string);

Description
-----------

This function formats an error message and prints it to `stderr'.  The
message is the string, a colon, and a message suitable for the error
condition indicated by `errno'.

Return Value
------------

None.

Example
-------

     int x = open("foo", O_RDONLY);
     if (x < 0)
     {
       perror("foo");
       exit(1);
     }


File: libc,  Node: pipe,  Next: popen,  Prev: perror,  Up: Alphabetical List

`pipe'
======

Description
-----------

This function is provided only to assist in porting from Unix.  It
always returns an error condition.


File: libc,  Node: popen,  Next: printf,  Prev: pipe,  Up: Alphabetical List

`popen'
=======

Syntax
------

     #include <stdio.h>
     
     FILE *popen(const char *program, const char *mode);

Description
-----------

This function executes the named `program' and attaches either it's
input stream or it's output stream to the returned file.  While the file
is open, the calling program can write to the program (if the program
was open for writing) or read the program's output (if the program was
opened for reading).  When the program is done, or if you have no more
input for it, pass the file pointer to `pclose' (*note pclose::.),
which terminates the program.

Since MS-DOS does not support multitasking, this function actually runs
the entire program when the program is opened for reading, and stores
the output in a temporary file.  `pclose' then removes that file.
Similarly, when you open a program for writing, a temp file holds the
data and `pclose' runs the entire program.

The MODE is the same as for `fopen' (*note fopen::.).

Return Value
------------

An open file which can be used to read the program's output or write to
the program's input.

Example
-------

     FILE *p = popen("dir", "r");
     read_program(p);
     pclose(p);


File: libc,  Node: printf,  Next: putc,  Prev: popen,  Up: Alphabetical List

`printf'
========

Syntax
------

     #include <stdio.h>
     
     int printf(const char *format, ...);

Description
-----------

Sends formatted output from the arguments (...) to `stdout'.

The format string contains regular characters to print, as well as
conversion specifiers, which begin with a percent symbol.  Each
conversion speficier contains the following fields:

   *  an optional flag, which may alter the conversion:

    `-'
          left-justify the field.

    `+'
          Force a `+' sign on positive numbers.

    `space'
          To leave a blank space where a plus or minus sign would have
          been.

    `#'
          Alternate conversion - prefix octal numbers with `0',
          hexadecimal numbers with `0x' or `0X', or force a trailing
          decimal point if a floating point conversion would have
          omitted it.

    `0'
          To pad numbers with leading zeros.

   *  A field width specifier, which specifies the minimum width of the
     field.  This may also be an asterisk (`*'), which means that the
     actual width will be obtained from the next argument.  If the
     argument is negative, it supplies a `-' flag and a positive width.

   *  An optional decimal point and a precision.  This may also be an
     asterisk, but a negative argument for it indicates a precision of
     zero.  The precision specifies the minimum number of digits to
     print for an integer, the number of fraction digits for a floating
     point number (max for `g' or `G', actual for others), or the
     maximum number of characters for a string.

   *  An optional conversion qualifier, which may be `h' to specify
     `short', `l' to specify long ints, or `L' to specify long doubles.

   *  The conversion type specifier:

    `c'
          A single character

    `d'
          A signed integer

    `D'
          A signed long integer

    `e'
    `E'
          A floating point number (double or long double).  The
          exponent case matches the specifier case.  The representation
          always has an exponent.

    `f'
          A floating point number (double or long double).  The
          representation never has an exponent.

    `g'
    `G'
          A floating point number (double or long double).  The
          exponent case matches the specifier case.  The representation
          has an exponent if it needs one.

    `i'
          A signed integer.

    `n'
          The next argument is a pointer to an integer, and the number
          of characters generated so far is stored in that integer.

    `o'
          A unsigned integer, printed in base 8 instead of base 10.

    `p'
          A pointer.  This is printed with an `x' specifier.

    `s'
          A `NULL'-terminated string.

    `u'
          An unsigned integer.

    `U'
          An unsigned long integer.

    `x'
    `X'
          An unsigned integer, printed in base 16 instead of base 10.
          The case of the letters used matches the specifier case.

    `%'
          A single percent symbol is printed.

Return Value
------------

The number of characters written.

Example
-------

     printf("%-3d %10.2f%% Percent of %s\n", index, per[index], name[index]);


File: libc,  Node: putc,  Next: putchar,  Prev: printf,  Up: Alphabetical List

`putc'
======

Syntax
------

     #include <stdio.h>
     
     int putc(int c, FILE *file);

Description
-----------

This function writes one character to the given FILE.

Return Value
------------

The character written.

Example
-------

     while ((c=getc(stdin)) != EOF)
       putc(c, stdout);


File: libc,  Node: putchar,  Next: putenv,  Prev: putc,  Up: Alphabetical List

`putchar'
=========

Syntax
------

     #include <stdio.h>
     
     int putchar(int c);

Description
-----------

This is the same as `fputc(c, stdout)'.  *Note fputc::

Return Value
------------

The character written.

Example
-------

     while ((c = getchar()) != EOF)
       putchar(c);


File: libc,  Node: putenv,  Next: puts,  Prev: putchar,  Up: Alphabetical List

`putenv'
========

Syntax
------

     #include <stdlib.h>
     
     int putenv(const char *env);

Description
-----------

This function adds an entry to the program's environment.  The string
passed must be of the form `NAME'=`VALUE'.  Any existing value for the
environment variable is gone.

Note that the string passed to `putenv' becomes part of the environment
itself, so you must not free it.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     putenv("SHELL=ksh.exe");


File: libc,  Node: puts,  Next: putw,  Prev: putenv,  Up: Alphabetical List

`puts'
======

Syntax
------

     #include <stdio.h>
     
     int puts(const char *string);

Description
-----------

This function writes STRING to `stdout', and then writes a newline
character.

Return Value
------------

Nonnegative for success, or `EOF' on error.

Example
-------

     puts("Hello, there");


File: libc,  Node: putw,  Next: qsort,  Prev: puts,  Up: Alphabetical List

`putw'
======

Syntax
------

     #include <stdio.h>
     
     int putw(int x, FILE *file);

Description
-----------

Writes a single binary word in native format to FILE.

Return Value
------------

The value written, or `EOF' for end-of-file or error.  Since `EOF' is a
valid integer, you should use `feof' or `ferror' to detect this
situation.

Example
-------

     putw(12, stdout);


File: libc,  Node: qsort,  Next: rand,  Prev: putw,  Up: Alphabetical List

`qsort'
=======

Syntax
------

     #include <stdlib.h>
     
     void qsort(void *base, size_t numelem, size_t size,
                int (*cmp)(const void *e1, const void *e2));

Description
-----------

This function sorts the given array in place.  BASE is the address of
the first of NUMELEM array entries, each of size SIZE bytes.  `qsort'
uses the supplied function CMP to determine the sort order for any two
elements by passing the address of the two elements and using the
function's return address.

The return address of the function indicates the sort order:

Negative
     Element E1 should come before element E2 in the resulting array.

Positive
     Element E1 should come after element E2 in the resulting array.

Zero
     It doesn't matter which element comes first in the resulting array.

Return Value
------------

None.

Example
-------

     typedef struct {
       int size;
       int sequence;
     } Item;
     
     int qsort_helper_by_size(void *e1, void *e2)
     {
       return ((Item *)e2)->size - ((Item *)e1)->size;
     }
     
     Item list[100];
     
     qsort(list, 100, sizeof(Item), qsort_helper_by_size);
     
     int qsort_stringlist(void *e1, void *e2)
     {
       return strcmp(*(char **)e1, *(char **)e2);
     }
     
     char *slist[10];
     
     /* alphabetical order */
     qsort(slist, 10, sizeof(char *), qsort_stringlist);


File: libc,  Node: rand,  Next: random,  Prev: qsort,  Up: Alphabetical List

`rand'
======

Syntax
------

     #include <stdlib.h>
     
     int rand(void);

Description
-----------

Returns a pseudo-random number from zero to `RAND_MAX'.

Return Value
------------

The number.

Example
-------

     /* random pause */
     for (i=rand(); i; i--);


File: libc,  Node: random,  Next: rawclock,  Prev: rand,  Up: Alphabetical List

`random'
========

Syntax
------

     #include <stdlib.h>
     
     long random(void);

Description
-----------

This is a better random number generator than `rand'.

Return Value
------------

A random number from zero to `MAXINT'.

Example
-------

     for (i=random(); i; i>>=1);


File: libc,  Node: rawclock,  Next: read,  Prev: random,  Up: Alphabetical List

`rawclock'
==========

Syntax
------

     unsigned long rawclock(void);

Description
-----------

Returns the number of clock tics (18.2 per second) since midnight.

Return Value
------------

The number of tics.

Example
-------

     /* wait 1/4 second */
     int i = rawclock()+5;
     while (rawclock()<i);


File: libc,  Node: read,  Next: readcr,  Prev: rawclock,  Up: Alphabetical List

`read'
======

Syntax
------

     #include <osfcn.h>
     
     int read(int fd, void *buffer, unsigned length);

Description
-----------

This function reads at most LENGTH bytes from file FD into BUFFER.
Note that in some cases, such as end-of-file conditions and text files,
it may read less than the requested number of bytes.  At end-of-file,
`read' will read exactly zero bytes.

Return Value
------------

The number of bytes read, zero meaning end-of-file, or -1 for an error.

Example
-------

     char buf[10];
     int r = read(0, buf, 10);


File: libc,  Node: readcr,  Next: readdir,  Prev: read,  Up: Alphabetical List

`readcr'
========

Syntax
------

     int readcr(int fd, char *buf, unsigned length);

Description
-----------

This is just like `read', but Ctrl-M characters are stripped from the
input.  This function often returns a number less than LENGTH due to
the dropping of characters.

Return Value
------------

The number of characters read.

Example
-------

     char buf[100];
     int r = readcr(0, buf, 100);


File: libc,  Node: readdir,  Next: readv,  Prev: readcr,  Up: Alphabetical List

`readdir'
=========

Syntax
------

     #include <dirent.h>
     
     struct dirent *readdir(DIR *dir);

Description
-----------

This function reads entries from a directory opened by `opendir' (*note
opendir::.).  It returns the information in a static buffer with this
format:

     struct dirent {
       unsigned short d_namlen;  /* The length of the name (like strlen) */
       char d_name[MAXNAMLEN+1]; /* The name */
     };

Return Value
------------

A pointer to a static buffer that is overridden with each call.

Example
-------

     DIR *d = opendir(".");
     struct dirent *de;
     while (de = readdir(d))
       puts(de->d_name);
     closedir(d);


File: libc,  Node: readv,  Next: realloc,  Prev: readdir,  Up: Alphabetical List

`readv'
=======

Syntax
------

     #include <sys/uio.h>
     
     int readv(int handle, struct iovec *iov, int count);

Description
-----------

This function is like `read', but is able to supply a list of buffers
to read into.  IOV is a pointer to an array of COUNT buffer definition
structures of this format:

     struct iovec {
       void *iov_base;
       unsigned long iov_len;
     };

Characters are read into successive buffers until the requested number
of characters are read or until no more data is available.

Return Value
------------

The number of bytes read.


File: libc,  Node: realloc,  Next: realloc_srchlen,  Prev: readv,  Up: Alphabetical List

`realloc'
=========

Syntax
------

     #include <stdlib.h>
     
     void *realloc(void *ptr, size_t size);

Description
-----------

This function changes the size of the region pointed to by PTR.  If it
can, it will reuse the same memory space, but it may have to allocate a
new memory space to satisfy the request.  In either case, it will
return the pointer that you should use to refer to the (possibly new)
memory area.  The pointer passed may be `NULL', in which case this
function acts just like `malloc' (*note malloc::.).

Return Value
------------

A pointer to the memory you should now refer to.

Example
-------

     if (now+new > max)
     {
       max = now+new;
       p = realloc(p, max);
     }


File: libc,  Node: realloc_srchlen,  Next: remove,  Prev: realloc,  Up: Alphabetical List

`realloc_srchlen'
=================

Syntax
------

     extern int realloc_srchlen;

Description
-----------

This value controls certain obscure and obsolete side effect of calling
`realloc' with an already-free'd pointer.  Best not to use it.


File: libc,  Node: remove,  Next: remque,  Prev: realloc_srchlen,  Up: Alphabetical List

`remove'
========

Syntax
------

     #include <stdio.h>
     
     int remove(const char *file);

Description
-----------

This function removes the named FILE from the file system.  Unless you
have an un-erase program, the file and its contents are gone for good.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     remove("/tmp/data.tmp");


File: libc,  Node: remque,  Next: rename,  Prev: remove,  Up: Alphabetical List

`remque'
========

Syntax
------

     void remque(struct vaxque *elem);

Description
-----------

Given a queue of elements derived from this structure:

     struct vaxque {
       struct vaxque *vq_next;
       struct vaxque *vq_prev;
     };

This function removes the given element from the queue.  This function
emulates the VAX `remque' opcode.  *Note insque::

Return Value
------------

None.


File: libc,  Node: rename,  Next: rewind,  Prev: remque,  Up: Alphabetical List

`rename'
========

Syntax
------

     #include <stdio.h>
     
     int rename(const char *oldname, const char *newname);

Description
-----------

This function renames an existing file OLDNAME to NEWNAME.  Wildcards
are not allowed, but the two file names may reflect different
subdirectories on the same file system.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     rename("some.doc", "some.sav");


File: libc,  Node: rewind,  Next: rewinddir,  Prev: rename,  Up: Alphabetical List

`rewind'
========

Syntax
------

     #include <stdio.h>
     
     void rewind(FILE *file);

Description
-----------

This function repositions the file pointer to the beginning of the file
and clears the error indicator.

Return Value
------------

None.

Example
-------

     rewind(stdin);


File: libc,  Node: rewinddir,  Next: rindex,  Prev: rewind,  Up: Alphabetical List

`rewinddir'
===========

Syntax
------

     #include <dirent.h>
     
     void rewinddir(DIR *dir);

Description
-----------

This function resets the position of the DIR so that the next call to
`readdir' (*note readdir::.) starts at the beginning again.

Return Value
------------

None.

Example
-------

     DIR *d = opendir(".");
     rewinddir(d);


File: libc,  Node: rindex,  Next: rmdir,  Prev: rewinddir,  Up: Alphabetical List

`rindex'
========

Syntax
------

     #include <string.h>
     
     char *rindex(const char *string, int ch);

Description
-----------

Returns a pointer to the last occurrence of CH in STRING.  Note that
the `NULL' character counts, so if you pass zero as CH you'll get a
pointer to the end of the string back.

Return Value
------------

A pointer to the character, or `NULL' if it wasn't found.

Example
-------

     char *extension = rindex(path, '.');
     if (extension)
       extension++;


File: libc,  Node: rmdir,  Next: sbrk,  Prev: rindex,  Up: Alphabetical List

`rmdir'
=======

Syntax
------

     #include <osfcn.h>
     
     int rmdir(const char *dirname);

Description
-----------

This function removes directory DIRNAME.  The directory must be empty.

Return Value
------------

Zero if the directory was removed, nonzero on failure.

Example
-------

     rmdir("/tmp/datadir");


File: libc,  Node: sbrk,  Next: scanf,  Prev: rmdir,  Up: Alphabetical List

`sbrk'
======

Syntax
------

     #include <osfcn.h>
     
     void *sbrk(int delta)

Description
-----------

This function changes the "break" of the program by adding DELTA to it.
This is the highest address that your program can access without
causing a violation.  Since the heap is the region under the break, you
can expand the heap (where `malloc' gets memory from) by increasing the
break.

This function is normally accessed only bu `malloc' (*note malloc::.).

Return Value
------------

The address of the first byte outside of the valid address range, or -1
if no more memory could be accessed.

Example
-------

     char *buf;
     buf = sbrk(1000); /* allocate space */


File: libc,  Node: scanf,  Next: seekdir,  Prev: sbrk,  Up: Alphabetical List

`scanf'
=======

Syntax
------

     #include <stdio.h>
     
     int scanf(const char *format, ...);

Description
-----------

This function scans formatted text from `stdin' and stores it in the
variables pointed to by the arguments.  *Note scanf::

The format string contains regular characters which much match the input
exactly as well as a conversion specifiers, which begin with a percent
symbol.  Any whitespace in the format string matches zero or more of any
whitespace characters in the input.  Thus, a single space may match a
newline and two tabs in the input.  All conversions except `c' and `['
also skip leading whitespace automatically.  Each conversion specifier
contains the following fields:

   *  An asterisk (`*') which indicates that the input should be
     converted according to the conversion spec, but not stored
     anywhere.

   *  A width specifier, which specifies the maximum number of input
     characters to use in the conversion.

   *  An optional conversion qualifier, which may be `h' to specify
     `short', `l' to specify long ints, or `L' to specify long doubles.

   *  The conversion type specifier:

    `c'
          Copy the next character (or WIDTH characters) to the given
          buffer.

    `d'
          Convert the input to a signed integer.

    `e'
    `E'
    `f'
    `g'
    `G'
          Convert the input to a floating point number.

    `i'
          Convert the input, determining base automatically by the
          presence of `0x' or `0' prefixes.  *Note strtol::

    `n'
          Store the number of characters scanned so far into the
          integer pointed to.

    `o'
          Convert the input to a signed integer, using base 8.

    `p'
          Convert the input to a pointer.  This is like using the `x'
          format.

    `s'
          Copy the input to the given string, skipping leading
          whitespace and copying non-whitespace characters up to the
          next whitespace.  The string stored is then `NULL'-terminated.

    `u'
          Convert the input to an unsigned integer.

    `x'
    `X'
          Convert the input to an unsigned integer, using base 16.

    `[...]'
          Like the `c' format, except only certain characters are
          copied.  The characters between the brackets determine which
          characters are allowed, and thus when the copying stops.
          These characters may be regular characters (example:
          `[abcd]') or a range of characters (example: `[a-d]').  If
          the first character is a caret (`^'), then the set specifies
          the set of characters that do not get copied (i.e.  the set
          is negated).  To specify that the set contains a
          close-bracket (`]'), list that as the first regular character.

    `%'
          This must match a percent character in the input.

Most conversions make use of `strtol' or `strtoul' to perform the
actual conversions.

Return Value
------------

The number of items successfully scanned.

Example
-------

     int x, y;
     char buf[100];
     scanf("%d %d %s", &x, &y, buf);
     
     /* read to end-of-line */
     scanf("%d %[^\n]\n", &x, buf);
     /* read letters only */
     scanf("[a-zA-Z]", buf);


File: libc,  Node: seekdir,  Next: setbuf,  Prev: scanf,  Up: Alphabetical List

`seekdir'
=========

Syntax
------

     #include <dirent.h>
     
     void seekdir(DIR *dir, long loc);

Description
-----------

This function sets the location pointer in DIR to the specified LOC.
Note that the value used for LOC should be either zero or a value
returned by `telldir' (*note telldir::.).  The next call to `readdir'
(*note readdir::.) will read whatever entry follows that point in the
directory.

Return Value
------------

None.

Example
-------

     int q = telldir(dir);
     do_stuff();
     seekdir(dir, q);


File: libc,  Node: setbuf,  Next: setbuffer,  Prev: seekdir,  Up: Alphabetical List

`setbuf'
========

Syntax
------

     #include <stdio.h>
     
     void setbuf(FILE *file, char *buffer);

Description
-----------

This function modifies the buffering characteristics of FILE.  First,
if the file already has a buffer, it is freed.  If there was any
pending data in it, it is lost, so this function should only be used
immediately after a call to `fopen'.

If the BUFFER passed is `NULL', the file is set to unbuffered.  If a
non-`NULL' buffer is passed, it must be at least `BUFSIZ' bytes in
size, and the file is set to fully buffered.

*Note setbuffer:: *Note setlinebuf:: *Note setvbuf::

Return Value
------------

None.

Example
-------

     setbuf(stdout, malloc(BUFSIZ));


File: libc,  Node: setbuffer,  Next: setcbrk,  Prev: setbuf,  Up: Alphabetical List

`setbuffer'
===========

Syntax
------

     #include <stdio.h>
     
     void setbuffer(FILE *file, char *buffer, int length);

Description
-----------

This function modifies the buffering characteristics of FILE.  First,
if the file already has a buffer, it is freed.  If there was any
pending data in it, it is lost, so this function should only be used
immediately after a call to `fopen'.

If the BUFFER passed is `NULL', the file is set to unbuffered.  If a
non-`NULL' buffer is passed, it must be at least SIZE bytes in size,
and the file is set to fully buffered.

*Note setbuf:: *Note setlinebuf:: *Note setvbuf::

Return Value
------------

None.

Example
-------

     setbuffer(stdout, malloc(10000), 10000);


File: libc,  Node: setcbrk,  Next: setdate,  Prev: setbuffer,  Up: Alphabetical List

`setcbrk'
=========

Syntax
------

     #include <dos.h>
     
     void setcbrk(int check);

Description
-----------

Set the setting of the Ctrl-Break checking flag in MS-DOS.  If CHECK is
zero, checking is not done.  If nonzero, checking is done.

Return Value
------------

None.


File: libc,  Node: setdate,  Next: setdisk,  Prev: setcbrk,  Up: Alphabetical List

`setdate'
=========

Syntax
------

     #include <dos.h>
     
     void setdate(struct date *ptr);

Description
-----------

This function sets the current time.

*Note getdate:: *Note settime::

Return Value
------------

None.

Example
-------

     struct date d;
     setdate(&d);


File: libc,  Node: setdisk,  Next: setenv,  Prev: setdate,  Up: Alphabetical List

`setdisk'
=========

Syntax
------

     #include <dir.h>
     
     int setdisk(int drive);

Description
-----------

This function sets the current disk (0=A).

*Note getdisk::

Return Value
------------

The total number of possible drives.

Example
-------

     printf("There are %d drives\n", setdisk(getdisk()));


File: libc,  Node: setenv,  Next: setftime,  Prev: setdisk,  Up: Alphabetical List

`setenv'
========

Syntax
------

     #include <stdlib.h>
     
     int setenv(const char *name, const char *value, int rewrite);

Description
-----------

Sets the environment variable NAME to VALUE.  If REWRITE is set, then
this function will replace any existing value.  If it is not set, it
will replace the existing value only if the new value is shorter than
the old.

Return Value
------------

0 on success, nonzero on failure.

Example
-------

     setenv("TERM", "xterm", 1);


File: libc,  Node: setftime,  Next: setgrent,  Prev: setenv,  Up: Alphabetical List

`setftime'
==========

Syntax
------

     #include <dos.h>
     
     int setftime(int handle, struct ftime *ftimep);

Description
-----------

This function sets the modification time of a file.  Note that since
writing to a file, and closing a file opened for writing, also sets the
modification time, you should only use this function on files opened for
reading.

*Note getftime::

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     int q = open("data.txt", O_RDONLY);
     struct ftime f;
     f.ft_sec = f.ft_min = f.ft_hour = f.ft_day = f.ft_month = f.ft_year = 0;
     setftime(q, &f);
     close(q);


File: libc,  Node: setgrent,  Next: setjmp,  Prev: setftime,  Up: Alphabetical List

`setgrent'
==========

Syntax
------

     #include <grp.h>
     
     void setgrent(void);

Description
-----------

This function should be called before any call to getgrent, getgrgid, or
getgrnam.  *Note getgrent::

Return Value
------------

None.


File: libc,  Node: setjmp,  Next: setlinebuf,  Prev: setgrent,  Up: Alphabetical List

`setjmp'
========

Syntax
------

     #include <setjmp.h>
     
     int setjmp(jmp_buf j);

Description
-----------

This function stores the complete CPU state into J.  This information
is complete enough that `longjmp' (*note longjmp::.) can return the
program to that state.  It is also complete enough to implement
coroutines.

Return Value
------------

This function will return zero if it is returning from it's own call.
If longjmp is used to restore the state, it will return whatever value
was passed to longjmp, except if zero is passed to longjmp it will
return one.

Example
-------

     jmp_buf j;
     if (setjmp(j))
       return;
     do_something();
     longjmp(j);


File: libc,  Node: setlinebuf,  Next: setlocale,  Prev: setjmp,  Up: Alphabetical List

`setlinebuf'
============

Syntax
------

     #include <stdio.h>
     
     void setlinebuf(FILE *file);

Description
-----------

This function modifies the buffering characteristics of FILE.  First,
if the file already has a buffer, it is freed.  If there was any
pending data in it, it is lost, so this function should only be used
immediately after a call to `fopen'.

Next, a buffer is allocated and the file is set to line buffering.

*Note setbuf:: *Note setlinebuf:: *Note setvbuf::

Return Value
------------

None.

Example
-------

     setlinebuf(stderr);


File: libc,  Node: setlocale,  Next: setmntent,  Prev: setlinebuf,  Up: Alphabetical List

`setlocale'
===========

Syntax
------

     #include <locale.h>
     
     char *setlocale(int category, const char *locale);

Description
-----------

This function sets part or all of the current locale.  The CATEGORY is
one of the following:

`LC_ALL'
     Set all parts of the locale.

`LC_COLLATE'
     Set the collating information.

`LC_CTYPE'
     Set the character type information.

`LC_MONETARY'
     Set the monetary formatting information.

`LC_NUMERIC'
     Set the numeric formatting information.

`LC_TIME'
     Set the time formatting information.

The LOCALE should be the name of the current locale.  Currently, only
the "C" and "POSIX" locales are supported.  If the LOCALE is NULL, no
action is performed.  If LOCALE is "", the locale is identified by
environment variables (currently not supported).

*Note localeconv::.

Return Value
------------

A static string naming the current locale for the given category, or
NULL if the requested locale is not supported.

Example
-------

     setlocale(LC_ALL, "C");


File: libc,  Node: setmntent,  Next: setmode,  Prev: setlocale,  Up: Alphabetical List

`setmntent'
===========

Syntax
------

     #include <mntent.h>
     
     FILE *setmntent(char *filename, char *type);

Description
-----------

This function returns an open FILE* pointer which can be used by
getmntent (*note getmntent::.).

Return Value
------------

The FILE* pointer is returned.  For MS-DOS, this FILE* is not a real
pointer and may only be used by `getmntent'.


File: libc,  Node: setmode,  Next: _setmode,  Prev: setmntent,  Up: Alphabetical List

`setmode'
=========

Syntax
------

     #include <io.h>
     
     int setmode(int file, int mode);

Description
-----------

This function sets the mode of the given FILE to MODE, which is either
`O_TEXT' or `O_BINARY'.  It will also set the file into either cooked
or raw mode accordingly, and set any `FILE*' objects that use this file
into text or binary mode.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     setmode(0, O_BINARY);


File: libc,  Node: _setmode,  Next: setpwent,  Prev: setmode,  Up: Alphabetical List

`_setmode'
==========

Syntax
------

     int _setmode(int file, int mode);

Description
-----------

This function sets the mode of the given FILE to MODE, which is either
`O_TEXT' or `O_BINARY'.  It will also set the file into either cooked
or raw mode accordingly.

This function will not affect any `FILE*' objects using it.

Return Value
------------

Previous value on success, nonzero on failure.

Example
-------

     if (_setmode(0, O_BINARY) == -1)
       do_error();


File: libc,  Node: setpwent,  Next: _setstack,  Prev: _setmode,  Up: Alphabetical List

`setpwent'
==========

Syntax
------

     #include <pwd.h>
     
     void setpwent(void);

Description
-----------

This function reinitializes `getpwent' so that scanning will start from
the start of the list.  *Note getpwent::

Return Value
------------

None.


File: libc,  Node: _setstack,  Next: setstate,  Prev: setpwent,  Up: Alphabetical List

`_setstack'
===========

Description
-----------

This is an internal function used to set the size of the stack in DPMI
mode.

*Note _stklen::


File: libc,  Node: setstate,  Next: settime,  Prev: _setstack,  Up: Alphabetical List

`setstate'
==========

Syntax
------

     #include <stdlib.h>
     
     char *setstate(char *state);

Description
-----------

This function initializes the random number generator (*note random::.).
For more details, consult the source code `libsrc/c/gen/random.c'.

Return Value
------------

The old state.


File: libc,  Node: settime,  Next: settimeofday,  Prev: setstate,  Up: Alphabetical List

`settime'
=========

Syntax
------

     #include <dos.h>
     
     void settime(struct time *ptr);

Description
-----------

This function sets the current time.

*Note gettime:: *Note setdate::

Return Value
------------

None.

Example
-------

     struct time t;
     settime(&t);


File: libc,  Node: settimeofday,  Next: setvbuf,  Prev: settime,  Up: Alphabetical List

`settimeofday'
==============

Syntax
------

     #include <sys/time.h>
     
     int settimeofday(struct timeval *tp, struct timezone *tzp);

Description
-----------

Sets the current GMT time and the local timezone information.  *Note
gettimeofday:: for information on the structure types.

Return Value
------------

Zero if the time was set, nonzero on error.


File: libc,  Node: setvbuf,  Next: sigaction,  Prev: settimeofday,  Up: Alphabetical List

`setvbuf'
=========

Syntax
------

     #include <stdio.h>
     
     int setvbuf(FILE *file, char *buffer, int type, int length);

Description
-----------

This function modifies the buffering characteristics of FILE.  First,
if the file already has a buffer, it is freed.  If there was any
pending data in it, it is lost, so this function should only be used
immediately after a call to `fopen'.

If the TYPE is `_IONBF', the BUFFER and LENGTH are ignored and the file
is set to unbuffered mode.

If the TYPE is `_IOLBF' or `_IOFBF', then the file is set to line or
fully buffered, respectively.  If BUFFER is `NULL', a buffer of size
SIZE is created and used as the buffer.  If BUFFER is non-`NULL', it
must point to a buffer of at least size SIZE and will be used as the
buffer.

*Note setbuf:: *Note setbuffer:: *Note setlinebuf::

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     setbuf(stderr, NULL, _IOLBF, 1000);


File: libc,  Node: sigaction,  Next: sigaddset,  Prev: setvbuf,  Up: Alphabetical List

`sigaction'
===========

Description
-----------

This function is provided only to assist in porting from Unix.  It
always returns an error condition.


File: libc,  Node: sigaddset,  Next: sigdelset,  Prev: sigaction,  Up: Alphabetical List

`sigaddset'
===========

Description
-----------

This function is provided only to assist in porting from Unix.  It
always returns an error condition.


File: libc,  Node: sigdelset,  Next: sigemptyset,  Prev: sigaddset,  Up: Alphabetical List

`sigdelset'
===========

Description
-----------

This function is provided only to assist in porting from Unix.  It
always returns an error condition.


File: libc,  Node: sigemptyset,  Next: sigfillset,  Prev: sigdelset,  Up: Alphabetical List

`sigemptyset'
=============

Description
-----------

This function is provided only to assist in porting from Unix.  It
always returns an error condition.


File: libc,  Node: sigfillset,  Next: sigismember,  Prev: sigemptyset,  Up: Alphabetical List

`sigfillset'
============

Description
-----------

This function is provided only to assist in porting from Unix.  It
always returns an error condition.


File: libc,  Node: sigismember,  Next: signal,  Prev: sigfillset,  Up: Alphabetical List

`sigismember'
=============

Description
-----------

This function is provided only to assist in porting from Unix.  It
always returns an error condition.


File: libc,  Node: signal,  Next: sigsetmask,  Prev: sigismember,  Up: Alphabetical List

`signal'
========

Description
-----------

This function is provided only to assist in porting from Unix.  It
always returns an error condition.


File: libc,  Node: sigsetmask,  Next: sleep,  Prev: signal,  Up: Alphabetical List

`sigsetmask'
============

Description
-----------

This function is provided only to assist in porting from Unix.  It
always returns an error condition.


File: libc,  Node: sleep,  Next: _smallbuf,  Prev: sigsetmask,  Up: Alphabetical List

`sleep'
=======

Syntax
------

     #include <osfcn.h>
     
     unsigned sleep(unsigned seconds);

Description
-----------

This function causes the program to pause for SECONDS seconds.

Return Value
------------

The number of seconds that haven't passed (i.e. always zero)

Example
-------

     sleep(5);


File: libc,  Node: _smallbuf,  Next: sopen,  Prev: sleep,  Up: Alphabetical List

`_smallbuf'
===========

Description
-----------

This is an internal variable used by `fopen'.


File: libc,  Node: sopen,  Next: spawn*,  Prev: _smallbuf,  Up: Alphabetical List

`sopen'
=======

Syntax
------

     #include <fcntl.h>    /* for O_* */
     #include <sys/stat.h> /* for S_* */
     #include <io.h>
     
     int sopen(const char *file, int mode, int shflag, int permissions);

Description
-----------

This is a macro that calls open(file, mode|shflag, permissions) *Note
open::.

Return Value
------------

Example
-------



File: libc,  Node: spawn*,  Next: sprintf,  Prev: sopen,  Up: Alphabetical List

`spawn*'
========

Syntax
------

     #include <process.h>
     
     int spawnl(int mode, const char *path, const char *argv0, ...);
     int spawnle(int mode, const char *path, const char *argv0, ... /*, const char **envp */);
     int spawnlp(int mode, const char *path, const char *argv0, ...);
     int spawnlpe(int mode, const char *path, const char *argv0, ... /*, const char **envp */);
     
     int spawnv(int mode, const char *path, const char **argv);
     int spawnve(int mode, const char *path, const char **argv, const char **envp);
     int spawnvp(int mode, const char *path, const char **argv);
     int spawnvpe(int mode, const char *path, const char **argv, const char **envp);

Description
-----------

These functions run other programs.  The PATH points to the program to
run.  The extension is optional - if not given, the usual extensions
`.com', `.exe', and `.bat' are checked.

The programs are invoked with the arguments given.  The zeroth argument
is normally not used, since MS-DOS cannot pass it separately.  There are
two ways of passing arguments.  The `l' functions (like `execlp') take
a list of arguments, with a zero at the end of the list.  This is
useful when you know how many argument there will be ahead of time.
The `v' functions (like `execve') take a pointer to a list of
arguments.  This is useful when you need to compute the number of
arguments at runtime.

In either case, you may also specify `e' to indicate that you will be
giving an explicit environment, else the current environment is used.
You may also specify `p' to indicate that you would like `exec*' to
search the PATH (in either the environment you pass or the current
environment) for the executable, else it will only check the explicit
path given.

Note that these function understand about other djgpp programs, and will
call go32 directly, so that you can pass command lines longer than 128
characters to them without any special code.

*Note exec*::

Return Value
------------

If successful and `mode' is `P_WAIT', these functions return the exit
code of the child process.

If successful and MODE is `P_OVERLAY', these functions will not return.

If there is an error, these functions return -1 and set `errno' to
indicate the error.

Example
-------


     char *environ[] = {
       "PATH=c:\\dos;c:\\djgpp;c:\\usr\\local\\bin",
       "DJGPP=c:/djgpp",
       0
     };
     
     char *args[] = {
       "gcc",
       "-v",
       "hello.c",
       0
     };
     
     spawnvpe("gcc", args, environ);


File: libc,  Node: sprintf,  Next: srand,  Prev: spawn*,  Up: Alphabetical List

`sprintf'
=========

Syntax
------

     #include <stdio.h>
     
     int sprintf(char *buffer, const char *format, ...);

Description
-----------

Sends formatted output from the arguments (...) to the BUFFER.  *Note
printf::

Return Value
------------

The number of characters written.


File: libc,  Node: srand,  Next: srandom,  Prev: sprintf,  Up: Alphabetical List

`srand'
=======

Syntax
------

     #include <stdlib.h>
     
     void srand(unsigned seed);

Description
-----------

This function initialized the random number generator (*note rand::.).
Passing the same SEED results in `rand' returning predictable sequences
of numbers.

Return Value
------------

None.

Example
-------

     srand(45);


File: libc,  Node: srandom,  Next: sscanf,  Prev: srand,  Up: Alphabetical List

`srandom'
=========

Syntax
------

     #include <stdlib.h>
     
     void srandom(int seed);

Description
-----------

This function initialized the random number generator (*note random::.).
Passing the same SEED results in `random' returning predictable
sequences of numbers.

Return Value
------------

None.

Example
-------

     srandom(45);


File: libc,  Node: sscanf,  Next: stat,  Prev: srandom,  Up: Alphabetical List

`sscanf'
========

Syntax
------

     #include <stdio.h>
     
     int sscanf(const char *string, const char *format, ...);

Description
-----------

This function scans formatted text from the STRING and stores it in the
variables pointed to by the arguments.  *Note scanf::

Return Value
------------

The number of items successfully scanned.


File: libc,  Node: stat,  Next: stat_assist,  Prev: sscanf,  Up: Alphabetical List

`stat'
======

Syntax
------

     #include <sys/stat.h>
     
     int stat(const char *file, struct stat *sbuf);

Description
-----------

This function obtains the status of the file FILE and stores it in
SBUF, which has this structure:

     struct  stat {
             short    st_dev;         /* The drive number */
             short    st_ino;         /* a unique identifier */
             unsigned short st_mode;  /* file mode - S_IF* and S_IREAD/S_IWRITE */
             short    st_nlink;       /* 1 */
             short    st_uid;         /* getuid() */
             short    st_gid;         /* getgid() */
             short    st_rdev;        /* the drive number */
             short    st_align_for_word32;
             long     st_size;        /* size of file in bytes */
             long     st_atime;       /* time of last modification */
             long     st_mtime;       /*            ''             */
             long     st_ctime;       /*            ''             */
             long     st_blksize;     /* 512 */
     };

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     struct stat s;
     stat("data.txt", &s);
     if (S_ISDIR(s.st_mode))
       printf("is directory\n");


File: libc,  Node: stat_assist,  Next: statfs,  Prev: stat,  Up: Alphabetical List

`stat_assist'
=============

Description
-----------

This is an internal function used by `stat'.


File: libc,  Node: statfs,  Next: stdin/stdout/stderr/stdprn/stdaux,  Prev: stat_assist,  Up: Alphabetical List

`statfs'
========

Syntax
------

     #include <sys/vfs.h>
     
     int statfs(const char *filename, struct statfs *buf);

Description
-----------

This function returns information about the given "filesystem".  The
drive letter of the given FILENAME, or the default drive if none is
given, is used to retrieve the following structure:

     struct statfs
     {
         long	f_type;   /* 0 */
         long	f_bsize;  /* bytes per cluster */
         long	f_blocks; /* clusters on drive */
         long	f_bfree;  /* available clusters */
         long	f_bavail; /* available clusters */
         long	f_files;  /* clusters on drive */
         long	f_ffree;  /* available clusters */
         fsid_t	f_fsid;   /* [0]=drive_number, [1]=MOUNT_UFS
         long	f_magic;  /* FS_MAGIC */
     };

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     struct statfs fs;
     statfs("anything", &fs);
     printf("%d bytes left\n", fs.f_bfree * fs.f_bsize);


File: libc,  Node: stdin/stdout/stderr/stdprn/stdaux,  Next: _stklen,  Prev: statfs,  Up: Alphabetical List

`stdin', `stdout', `stderr', `stdprn', `stdaux'
===============================================

Syntax
------

     #include <stdio.h>
     
     extern FILE *stdin, *stdou, *stderr;

Description
-----------

These predefined files represent the "standard" input and output files
that are available to a program.

Example
-------

       fprintf(stdprn, "This goes to the printer\n");


File: libc,  Node: _stklen,  Next: strcasecmp,  Prev: stdin/stdout/stderr/stdprn/stdaux,  Up: Alphabetical List

`_stklen'
=========

Syntax
------

     extern int _stklen;

Description
-----------

This variable sets the minimum stack length that the program requires.
Note that the stack may be much larger than this.  This value should be
set statically, as it is only used at startup.

Example
-------

     extern int _stklen = 256000;


File: libc,  Node: strcasecmp,  Next: strcat,  Prev: _stklen,  Up: Alphabetical List

`strcasecmp'
============

Syntax
------

     #include <string.h>
     
     int strcasecmp(const char *s1, const char *s2);

Description
-----------

This function compares the two strings, disregarding case.

Return Value
------------

Zero if they're the same, nonzero if different, the sign indicates
"order".

Example
-------

     if (strcasecmp(arg, "-i") == 0)
       do_include();


File: libc,  Node: strcat,  Next: strchr,  Prev: strcasecmp,  Up: Alphabetical List

`strcat'
========

Syntax
------

     #include <string.h>
     
     char *strcat(char *s1, const char *s2);

Description
-----------

This function concatenates S2 to the end of S1.

Return Value
------------

S1

Example
-------

     char buf[100] = "hello";
     strcat(buf, " there");


File: libc,  Node: strchr,  Next: strcmp,  Prev: strcat,  Up: Alphabetical List

`strchr'
========

Syntax
------

     #include <string.h>
     
     char *strchr(const char *s, int c);

Description
-----------

This function returns a pointer to the first occurrence of C in S.
Note that if C is `NULL', this will return a pointer to the end of the
string.

Return Value
------------

A pointer to the character, or `NULL' if it wasn't found.

Example
-------

     char *slash = strchr(filename, '/');


File: libc,  Node: strcmp,  Next: strcoll,  Prev: strchr,  Up: Alphabetical List

`strcmp'
========

Syntax
------

     #include <string.h>
     
     int strcmp(const char *s1, const char *s2);

Description
-----------

This function compares S1 and S2.

Return Value
------------

Zero if the strings are equal, a positive number if S1 comes after S2
in the ASCII collating sequense, else a negative number.

Example
-------

     if (strcmp(arg, "-i") == 0)
       do_include();


File: libc,  Node: strcoll,  Next: strcpy,  Prev: strcmp,  Up: Alphabetical List

`strcoll'
=========

Syntax
------

     #include <string.h>
     
     int strcoll(const char *s1, const char *s2);

Description
-----------

This function compares S1 and S2, using the collating sequences from
the current locale.

Return Value
------------

Zero if the strings are equal, a positive number if S1 comes after S2
in the collating sequense, else a negative number.

Example
-------

     while (strcoll(var, list[i]) < 0)
       i++;


File: libc,  Node: strcpy,  Next: strcspn,  Prev: strcoll,  Up: Alphabetical List

`strcpy'
========

Syntax
------

     #include <string.h>
     
     char *strcpy(char *s1, const char *s2);

Description
-----------

This function copies S2 into S1.

Return Value
------------

S1

Example
-------

     char buf[100];
     strcpy(buf, arg);


File: libc,  Node: strcspn,  Next: strdup,  Prev: strcpy,  Up: Alphabetical List

`strcspn'
=========

Syntax
------

     #include <string.h>
     
     size_t strcspn(const char *s1, const char *set);

Description
-----------

This function finds the first character in S1 that matches any
character in SET.  Note that the `NULL' bytes at the end of each string
counts, so you'll at least get a pointer to the end of the string if
nothing else.

Return Value
------------

The index of the found character.

Example
-------

     int i = strcspn(command, "<>|");
     if (command[i])
       do_redirection();


File: libc,  Node: strdup,  Next: strerror,  Prev: strcspn,  Up: Alphabetical List

`strdup'
========

Syntax
------

     #include <string.h>
     
     char * strdup (const char *source);

Description
-----------

Returns a newly allocated area of memory that contains a duplicate of
the string pointed to by SOURCE.  The memory returned by this call must
be freed by the caller.

Return Value
------------

Returns the newly allocated string, or NULL if there is no more memory.

Example
-------

     char *foo()
     {
       return strdup("hello");
     }


File: libc,  Node: strerror,  Next: strftime,  Prev: strdup,  Up: Alphabetical List

`strerror'
==========

Syntax
------

     #include <string.h>
     
     char *strerror(int error);

Description
-----------

This function returns a string that describes the ERROR.

Return Value
------------

A pointer to a static string that should not be modified or free'd.

Example
-------

     if (f=fopen("foo", "r") == 0)
       printf("Error! %s: %s\n", "foo", strerror(errno));


File: libc,  Node: strftime,  Next: stricmp,  Prev: strerror,  Up: Alphabetical List

`strftime'
==========

Syntax
------

     #include <time.h>
     
     size_t strftime(char *buf, size_t n, const char *format, const struct tm *time);

Description
-----------

This function formats the given TIME according to the given FORMAT and
stores it in BUF, not exceeding N bytes.

The format string is like `printf' in that any character other than `%'
is added to the output string, and for each character following a `%' a
pattern is added to the string as follows, with the examples as if the
time was Friday, October 1, 1993, at 03:30:34 PM EDT:

`%A'
     The full weekday name (`Friday')

`%a'
     The abbreviated weekday name (`Fri')

`%B'
     The full month name (`October')

`%b'
`%h'
     The abbreviated month name (`Oct')

`%C'
     Short for `%a %b %e %H:%M:%S %Y' (`Fri Oct  1 15:30:34 1993')

`%c'
     Short for `%m/%d/%y %H:%M:%S' (`10/01/93 15:30:34')

`%e'
     The day of the month, blank padded to two characters (` 2')

`%D'
     Short for `%m/%d/%y' (`10/01/93')

`%d'
     The day of the month, zero padded to two characters (`02')

`%H'
     The hour (0-24), zero padded to two characters (`15')

`%I'
     The hour (1-12), zero padded to two characters (`03')

`%j'
     The julien day, zero padded to three characters (`275')

`%k'
     The hour (0-24), space padded to two characters (`15')

`%l'
     The hour (1-12), space padded to two characters(` 3')

`%M'
     The minutes, zero padded to two characters (`30')

`%m'
     The month (1-12), zero padded to two characters (`10')

`%n'
     A newline (`\n')

`%p'
     AM or PM (`PM')

`%R'
     Short for `%H:%M' (`15:30')

`%r'
     Short for `%I:%M:%S %p' (`03:30:35 PM')

`%S'
     The seconds, zero padded to two characters (`35')

`%T'
`%X'
     Short for `%H:%M:%S' (`15:30:35')

`%t'
     A tab (`\t')

`%U'
     The week of the year, with the first week defined by the first
     Sunday of the year, zero padded to two characters (`39')

`%W'
     The week of the year, with the first week defined by the first
     Monday of the year, zero padded to two characters (`39')

`%w'
     The day of the week (0-6) (`5')

`%x'
     Short for `%m/%d/%y' (`10/01/93')

`%y'
     The year (00-99) of the century (`93')

`%Y'
     The year, zero padded to four digits (`1993')

`%Z'
     The timezone abbreviation (`EDT')

`%%'
     A percent symbol (`%')

Return Value
------------

The number of characters stored.

Example
-------

     struct tm t;
     char buf[100];
     strftime(buf, 100, "%B %d, %Y", &t);


File: libc,  Node: stricmp,  Next: strlen,  Prev: strftime,  Up: Alphabetical List

`stricmp'
=========

Syntax
------

     #include <string.h>
     
     int stricmp(const char *s1, const char *s2);

Description
-----------

This function compares the two strings, disregarding case.

Return Value
------------

Zero if they're the same, nonzero if different, the sign indicates
"order".

Example
-------

     if (stricmp(arg, "-i") == 0)
       do_include();


File: libc,  Node: strlen,  Next: strlwr,  Prev: stricmp,  Up: Alphabetical List

`strlen'
========

Syntax
------

     #include <string.h>
     
     size_t strlen(const char *string);

Description
-----------

This function returns the number of characters in STRING.

Return Value
------------

The length of the string.

Example
-------

     if (strlen(fname) > PATH_MAX)
       invalid_file(fname);


File: libc,  Node: strlwr,  Next: strncasecmp,  Prev: strlen,  Up: Alphabetical List

`strlwr'
========

Syntax
------

     #include <string.h>
     
     char *strlwr(char *string);

Description
-----------

This function replaces all upper case letters in STRING with lower case
letters.

Return Value
------------

The string.

Example
-------

     char buf[100] = "Hello";
     strlwr(buf);


File: libc,  Node: strncasecmp,  Next: strncat,  Prev: strlwr,  Up: Alphabetical List

`strncasecmp'
=============

Syntax
------

     #include <string.h>
     
     int strncasecmp(const char *s1, const char *s2, size_t max);

Description
-----------

This function compares S1 and S2, ignoring case, up to a maximum of MAX
characters.

Return Value
------------

Zero if the strings are equal, a positive number if S1 comes after S2
in the ASCII collating sequense, else a negative number.

Example
-------

     if (strncasecmp(foo, "-i", 2) == 0)
       do_include();


File: libc,  Node: strncat,  Next: strncmp,  Prev: strncasecmp,  Up: Alphabetical List

`strncat'
=========

Syntax
------

     #include <string.h>
     
     char *strncat(char *s1, const char *s2, size_t max);

Description
-----------

This function concatenates up to MAX characters of S2 to the end of S1.

Return Value
------------

S1

Example
-------

     strncat(fname, extension, 4);


File: libc,  Node: strncmp,  Next: strncpy,  Prev: strncat,  Up: Alphabetical List

`strncmp'
=========

Syntax
------

     #include <string.h>
     
     int strncmp(const char *s1, const char *s2, size_t max);

Description
-----------

This function compares upto MAX characters of S1 and S2.

Return Value
------------

Zero if the strings are equal, a positive number if S1 comes after S2
in the ASCII collating sequense, else a negative number.

Example
-------

     if (strncmp(arg, "-i", 2) == 0)
       do_include();


File: libc,  Node: strncpy,  Next: strnicmp,  Prev: strncmp,  Up: Alphabetical List

`strncpy'
=========

Syntax
------

     #include <string.h>
     
     char *strcpy(char *s1, const char *s2, size_t max);

Description
-----------

This function copies up to MAX characters of S2 into S1.

Return Value
------------

S1

Example
-------

     char buf[100];
     strcpy(buf, arg, 99);


File: libc,  Node: strnicmp,  Next: strpbrk,  Prev: strncpy,  Up: Alphabetical List

`strnicmp'
==========

Syntax
------

     #include <string.h>
     
     int strnicmp(const char *s1, const char *s2, size_t max);

Description
-----------

This function compares S1 and S2, ignoring case, up to a maximum of MAX
characters.

Return Value
------------

Zero if the strings are equal, a positive number if S1 comes after S2
in the ASCII collating sequense, else a negative number.

Example
-------

     if (strnicmp(foo, "-i", 2) == 0)
       do_include();


File: libc,  Node: strpbrk,  Next: strrchr,  Prev: strnicmp,  Up: Alphabetical List

`strpbrk'
=========

Syntax
------

     #include <string.h>
     
     char *strpbrk(const char *s1, const char *set);

Description
-----------

This function finds the first character in S1 that matches any
character in SET.

Return Value
------------

A pointer to the first match, or `NULL' if none are found.

Example
-------

     if (strpbrk(command, "<>|"))
       do_redirection();


File: libc,  Node: strrchr,  Next: strsep,  Prev: strpbrk,  Up: Alphabetical List

`strrchr'
=========

Syntax
------

     #include <string.h>
     
     char *strrchr(const char *s1, int c);

Description
-----------

This function finds the last occurrence of `c' in `s1'.

Return Value
------------

A pointer to the last match, or `NULL' if the character isn't in the
string.

Example
-------

     char *last_slash = strrchr(filename, '/');


File: libc,  Node: strsep,  Next: strspn,  Prev: strrchr,  Up: Alphabetical List

`strsep'
========

Syntax
------

     #include <string.h>
     
     char *strsep(char **stringp, char *delim);

Description
-----------

This function retrieves the next token from the given string, where
STRINGP points to a variable holding, initially, the start of the
string.  Tokens are delimited by a character from DELIM.  Each time the
function is called, it returns a pointer to the next token, and sets
*STRINGP to the next spot to check, or `NULL'.

Return Value
------------

The next token, or NULL.

Example
-------

     main()
     {
       char *buf = "Hello  there,stranger";
       char **bp = &buf;
       char *tok;
       while (tok = strsep(bp, " ,"))
         printf("tok = `%s'\n", tok);
     }
     
     tok = `Hello'
     tok = `'
     tok = `there'
     tok = `stranger'


File: libc,  Node: strspn,  Next: strstr,  Prev: strsep,  Up: Alphabetical List

`strspn'
========

Syntax
------

     #include <string.h>
     
     size_t strspn(const char *s1, const char *set);

Description
-----------

This function finds the first character in S1 that does not match any
character in SET.  Note that the `NULL' bytes at the end of S1 counts,
so you'll at least get a pointer to the end of the string if nothing
else.

Return Value
------------

The index of the found character.

Example
-------

     int i = strcspn(entry, " \t\b");
     if (entry[i])
       do_something();


File: libc,  Node: strstr,  Next: strtod,  Prev: strspn,  Up: Alphabetical List

`strstr'
========

Syntax
------

     #include <string.h>
     
     char *strstr(const char *s1, const char *s2);

Description
-----------

This function finds the first occurrence of S2 in S1.

Return Value
------------

A pointer within S1, or `NULL' if S2 wasn't found.

Example
-------

     if (strstr(command, ".exe"))
       do_exe();


File: libc,  Node: strtod,  Next: strtok,  Prev: strstr,  Up: Alphabetical List

`strtod'
========

Syntax
------

     #include <stdlib.h>
     
     double strtod(const char *s, char **endp);

Description
-----------

This function converts as many characters of S that look like a
floating point number into one, and sets *ENDP to point to the first
unused character.

Return Value
------------

The value the string represented.

Example
-------

     char *buf = "123ret";
     char *bp;
     double x = strtod(buf, &bp);


File: libc,  Node: strtok,  Next: strtol,  Prev: strtod,  Up: Alphabetical List

`strtok'
========

Syntax
------

     #include <string.h>
     
     char *strtok(char *s1, const char *s2);

Description
-----------

This function retrieves tokens from S1 which are delimited by
characters from S2.

To initiate the search, pass the string to be searched as S1.  For the
remaining tokens, pass `NULL' instead.

Return Value
------------

A pointer to the token, or `NULL' if no more are found.

Example
-------

     main()
     {
       char *buf = "Hello there, stranger";
       char *tok;
       for (tok = strtok(buf, " ,");
            tok;
            tok=strtok(0, " ,"))
         printf("tok = `%s'\n", tok);
     }
     
     tok = `Hello'
     tok = `there'
     tok = `stranger'


File: libc,  Node: strtol,  Next: _strtold,  Prev: strtok,  Up: Alphabetical List

`strtol'
========

Syntax
------

     #include <stdlib.h>
     
     long strtol(const char *s, char **endp, int base);

Description
-----------

This function converts as much of S as looks like an appropriate number
into the value of that number, and sets *ENDP to point to the first
unused character.

The BASE argument indicates what base the digits (or letters) should be
treated as.  If BASE is zero, the base is determined by looking for
`0x', `0X', or `0' as the first part of the string, and sets the base
used to 16, 16, or 8 if it finds one.  The default base is 10 if none
of those prefixes are found.

Return Value
------------

The value.

Example
-------

     printf("Enter a number: "); fflush(stdout);
     gets(buf);
     char *bp;
     printf("The value is %d\n", strtol(buf, &bp, 0));


File: libc,  Node: _strtold,  Next: strtoul,  Prev: strtol,  Up: Alphabetical List

`_strtold'
==========

Syntax
------

     #include <stdlib.h>
     
     long double _strtold(const char *s, char **endp);

Description
-----------

This function converts as many characters of S that look like a
floating point number into one, and sets *ENDP to point to the first
unused character.

Return Value
------------

The value the string represented.

Example
-------

     char *buf = "123ret";
     char *bp;
     long double x = _strtold(buf, &bp);


File: libc,  Node: strtoul,  Next: strupr,  Prev: _strtold,  Up: Alphabetical List

`strtoul'
=========

Syntax
------

     #include <stdlib.h>
     
     unsigned long strtoul(const char *s, char **endp, int base);

Description
-----------

This is just like `strtol' (*note strtol::.) except that the result is
unsigned.

Return Value
------------

The value.

Example
-------

     printf("Enter a number: "); fflush(stdout);
     gets(buf);
     char *bp;
     printf("The value is %u\n", strtoul(buf, &bp, 0));


File: libc,  Node: strupr,  Next: strxfrm,  Prev: strtoul,  Up: Alphabetical List

`strupr'
========

Syntax
------

     #include <string.h>
     
     char *strupr(char *string);

Description
-----------

This function converts all lower case characters in STRING to upper
case.

Return Value
------------

STRING

Example
-------

     char buf[] = "Foo!";
     strupr(buf);


File: libc,  Node: strxfrm,  Next: swab,  Prev: strupr,  Up: Alphabetical List

`strxfrm'
=========

Syntax
------

     #include <string.h>
     
     size_t strxfrm(char *s1, const char *s2, size_t max);

Description
-----------

This copies characters from S2 to S1, which must be able to hold MAX
characters.  Each character is transformed according to the locale such
that `strcmp(s1b, s2b)' is just like `strcoll(s1, s2)' where `s1b' and
`s2b' are the transforms of `s1' and `s2'.

Return Value
------------

The actual number of bytes required to transform S2, including the
`NULL'.


File: libc,  Node: swab,  Next: swap,  Prev: strxfrm,  Up: Alphabetical List

`swab'
======

Syntax
------

     #include <osfcn.h>
     
     void swab(void *from, void *to, int bytes);

Description
-----------

This function swaps each pair of bytes in FROM as they're copied to TO.

Return Value
------------

None.

Example
-------

     swab(packet, header, sizeof(header);


File: libc,  Node: swap,  Next: sync,  Prev: swab,  Up: Alphabetical List

`swap'
======

Syntax
------

     #include <swap.h>
     
     swap(a,b)

Description
-----------

This macro swaps the values of two variables of the same type,
regardless of what type they actually are.

Example
-------

     double a, b;
     if (a<b)
       swap(a,b);


File: libc,  Node: sync,  Next: sys_errlist,  Prev: swap,  Up: Alphabetical List

`sync'
======

Description
-----------

This function is provided only to assist in porting from Unix.  It
always returns an error condition.


File: libc,  Node: sys_errlist,  Next: sys_nerr,  Prev: sync,  Up: Alphabetical List

`sys_errlist'
=============

Syntax
------

     #include <errno.h>
     
     extern char *sys_errlist[];

Description
-----------

This array contains error messages, indexed by `errno', that describe
the errors.

Example
-------

     printf("Error: %s\n", sys_errlist[errno]);


File: libc,  Node: sys_nerr,  Next: sysconf,  Prev: sys_errlist,  Up: Alphabetical List

`sys_nerr'
==========

Syntax
------

     #include <errno.h>
     
     extern int sys_nerr;

Description
-----------

This variable gives the number of error messages in `sys_errlist'
(*note sys_errlist::.).

Example
-------

     if (errno < sys_nerr)
       printf("Error: %s\n", sys_errlist[errno]);


File: libc,  Node: sysconf,  Next: system,  Prev: sys_nerr,  Up: Alphabetical List

`sysconf'
=========

Syntax
------

     #include <unistd.h>
     
     long sysconf(int which);

Description
-----------

This function returns various system configuration values, based on
WHICH:

     case _SC_ARG_MAX:           return ARG_MAX;
     case _SC_CHILD_MAX:         return CHILD_MAX;
     case _SC_CLK_TCK:           return CLK_TCK;
     case _SC_NGROUPS_MAX:       return NGROUPS_MAX;
     case _SC_OPEN_MAX:          return OPEN_MAX;
     case _SC_JOB_CONTROL:       return -1;
     case _SC_SAVED_IDS:         return -1;
     case _SC_VERSION:           return _POSIX_VERSION;
     case _SC_XOPEN_VERSION:     return _XOPEN_VERSION;
     case _SC_PASS_MAX:          return PASS_MAX;
     case _SC_STREAM_MAX:        return _POSIX_STREAM_MAX;
     case _SC_TZNAME_MAX:        return TZNAME_MAX;
     case _SC_BC_BASE_MAX:       return BC_BASE_MAX;
     case _SC_BC_DIM_MAX:        return BC_DIM_MAX;
     case _SC_BC_SCALE_MAX:      return BC_SCALE_MAX;
     case _SC_COLL_ELEM_MAX:     return COLL_ELEM_MAX;
     case _SC_EXPR_NEST_MAX:     return EXPR_NEST_MAX;
     case _SC_LINE_MAX:          return LINE_MAX;
     case _SC_PASTE_FILES_MAX:   return PASTE_FILES_MAX;
     case _SC_RE_DUP_MAX:        return RE_DUP_MAX;
     case _SC_SED_PATTERN_MAX:   return SED_PATTERN_MAX;
     case _SC_SENDTO_MAX:        return SENDTO_MAX;
     case _SC_SORT_LINE_MAX:     return SORT_LINE_MAX;
     case _SC_2_VERSION:         return _POSIX2_VERSION;
     case _SC_2_C_BIND:          return _POSIX2_C_BIND;
     case _SC_2_C_DEV:           return _POSIX2_C_DEV;
     case _SC_2_FORT_DEV:        return _POSIX2_FORT_DEV;
     case _SC_2_SW_DEV:          return _POSIX2_SW_DEV;
     case _SC_CLOCKS_PER_SEC:    return CLOCKS_PER_SEC;
     case _SC_AES_OS_VERSION:    return -1;
     case _SC_PAGE_SIZE:         return 4096;
     case _SC_ATEXIT_MAX:        return ATEXIT_MAX;

Return Value
------------

The value.


File: libc,  Node: system,  Next: tell,  Prev: sysconf,  Up: Alphabetical List

`system'
========

Syntax
------

     #include <stdlib.h>
     
     int system(const char *cmd);

Description
-----------

This function runs the specified command.

Go32 automatically detects if redirection is requested and will attempt
to run the program directly if not, to work around the fact that
command.com does not return the exit code of the child process.  If it
can't run it directly, command.com is used to run the child.

Return Value
------------

The return value of the child process, unless command.com doesn't return
it.

Example
-------

     system("cc1plus.exe @cc123456.gp");


File: libc,  Node: tell,  Next: telldir,  Prev: system,  Up: Alphabetical List

`tell'
======

Syntax
------

     long tell(int file);

Description
-----------

This function returns the location of the file pointer for FILE.

Return Value
------------

The file pointer, or -1 on error.

Example
-------

     long q = tell(fd);


File: libc,  Node: telldir,  Next: tempnam,  Prev: tell,  Up: Alphabetical List

`telldir'
=========

Syntax
------

     #include <dirent.h>
     
     long telldir(DIR *dir);

Description
-----------

This function returns a value which indicates the position of the
pointer in the given directory.  This value is only useful as an
argument to `seekdir' (*note seekdir::.).

Return Value
------------

The directory pointer.

Example
-------

     DIR *dir;
     long q = telldir(dir);
     do_something();
     seekdir(dir, q);


File: libc,  Node: tempnam,  Next: time,  Prev: telldir,  Up: Alphabetical List

`tempnam'
=========

Syntax
------

     #include <stdio.h>
     
     char *tempnam(const char *dir, const char *prefix);

Description
-----------

This function returns a temporary file name in a buffer allocated by
`malloc'.  The locations and filenames searched for temporary space are
as follows:

     getenv("TMPDIR")/PREFIX??????
     DIR/PREFIX??????
     `P_tmpdir'/PREFIX??????
     /tmp/PREFIX??????

Return Value
------------

A pointer to the file name, or NULL if error.

Example
-------

     char *fn = tempnam(".", "dj");
     free(fn);


File: libc,  Node: time,  Next: timezone,  Prev: tempnam,  Up: Alphabetical List

`time'
======

Syntax
------

     #include <time.h>
     
     time_t time(time_t *t);

Description
-----------

If T is not `NULL', the current time is stored in `*t'.

Return Value
------------

The current time is returned.

Example
-------

     printf("Time is %d\n", time(0));


File: libc,  Node: timezone,  Next: tmpfile,  Prev: time,  Up: Alphabetical List

`timezone'
==========

Syntax
------

     #include <time.h>
     
     char *timezone(int minutes, int daylight);

Description
-----------

Given the number of minutes west of GMT and whether or not daylight
savings time is in affect, returns the name of the timezone.

If the environment variable TZNAME is set, it should be like `EST,EDT',
and the name of the timezone will come from that.

Return Value
------------

A pointer to the timezone or `NULL' if invalid.

Example
-------

     printf("EST ? %s\n", timezone(5*60, 0));


File: libc,  Node: tmpfile,  Next: tmpnam,  Prev: timezone,  Up: Alphabetical List

`tmpfile'
=========

Syntax
------

     #include <stdio.h>
     
     FILE *tmpfile(void);

Description
-----------

This function opens a temporary file.  It will automatically be removed
when the program exits.

Return Value
------------

A newly opened file.

Example
-------

     FILE *tmp = tmpfile();


File: libc,  Node: tmpnam,  Next: tolower,  Prev: tmpfile,  Up: Alphabetical List

`tmpnam'
========

Syntax
------

     #include <stdio.h>
     
     char *tmpnam(char *s);

Description
-----------

If S is NULL, a buffer is allocated, else S is used to hold the name of
a unique file.

Return Value
------------

A pointer to the new file name.

Example
-------

     char buf[PATH_MAX];
     char *s = tmpname(buf);


File: libc,  Node: tolower,  Next: toupper,  Prev: tmpnam,  Up: Alphabetical List

`tolower'
=========

Syntax
------

     #include <ctype.h>
     
     int tolower(int c);

Description
-----------

This function returns C, converting it to lower case if it is upper
case.  *Note toupper::

Return Value
------------

The upper case letter.

Example
-------

     for (i=0; buf[i]; i++)
       buf[i] = tolower(buf[i]);


File: libc,  Node: toupper,  Next: truncate,  Prev: tolower,  Up: Alphabetical List

`toupper'
=========

Syntax
------

     #include <ctype.h>
     
     int toupper(int c);

Description
-----------

This function returns C, converting it to upper case if it is lower
case. *Note tolower::

Return Value
------------

The upper case letter.

Example
-------

     for (i=0; buf[i]; i++)
       buf[i] = toupper(buf[i]);


File: libc,  Node: truncate,  Next: ttyname,  Prev: toupper,  Up: Alphabetical List

`truncate'
==========

Syntax
------

     #include <osfcn.h>
     
     int truncate(const char *file, unsigned long size);

Description
-----------

This function truncates FILE to SIZE bytes.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     ftruncate("/tmp/data.txt", 400);


File: libc,  Node: ttyname,  Next: tzname,  Prev: truncate,  Up: Alphabetical List

`ttyname'
=========

Syntax
------

     #include <osfcn.h>
     
     char *ttyname(int file);

Description
-----------

Gives the name of the terminal associated with FILE.

Return Value
------------

Returns "/dev/con" if FILE is a device, else `NULL'.

Example
-------

     char *tty = ttyname(0);


File: libc,  Node: tzname,  Next: tzset,  Prev: ttyname,  Up: Alphabetical List

`tzname'
========

Syntax
------

     extern char *tzname[2]

Description
-----------

This array holds the names of standard and daylight savings timezones
for the local area.  You must call `tzset' to initialize these.


File: libc,  Node: tzset,  Next: tzsetwall,  Prev: tzname,  Up: Alphabetical List

`tzset'
=======

Syntax
------

     #include <time.h>
     
     void tzset(void);

Description
-----------

This function initializes the timezone information.

Return Value
------------

None.


File: libc,  Node: tzsetwall,  Next: _tztab,  Prev: tzset,  Up: Alphabetical List

`tzsetwall'
===========

Syntax
------

     #include <time.h>
     
     void tzsetwall(void)

Description
-----------

This function initializes the system to "wall clock" time.

Return Value
------------

None.


File: libc,  Node: _tztab,  Next: umask,  Prev: tzsetwall,  Up: Alphabetical List

`_tztab'
========

Description
-----------

This is an internal variable used by the `tz' functions.


File: libc,  Node: umask,  Next: ungetc,  Prev: _tztab,  Up: Alphabetical List

`umask'
=======

Description
-----------

This is an internal function used by gcc to help perform certain
operations.


File: libc,  Node: ungetc,  Next: unlink,  Prev: umask,  Up: Alphabetical List

`ungetc'
========

Syntax
------

     #include <stdio.h>
     
     int ungetc(int c, FILE *file);

Description
-----------

This function pushes C back into the FILE.  You can only push back one
character at a time.

Return Value
------------

The pushed-back character, or `EOF' on error.

Example
-------

     int q;
     while (q = getc(stdin) != 'q');
     ungetc(q);


File: libc,  Node: unlink,  Next: unlock,  Prev: ungetc,  Up: Alphabetical List

`unlink'
========

Syntax
------

     #include <osfcn.h>
     
     int unlink(const char *file);

Description
-----------

This function removes a file from the file system.

Return Value
------------

Zero on success, nonzero on failure.

Example
-------

     unlink("data.txt");


File: libc,  Node: unlock,  Next: unsetenv,  Prev: unlink,  Up: Alphabetical List

`unlock'
========

Syntax
------

     #include <io.h>
     
     int unlock(int fd, long offset, long length);

Description
-----------

Unlocks a region previously locked by `lock'.

*Note lock::.

Return Value
------------

Zero if successful, nonzero if not.


File: libc,  Node: unsetenv,  Next: usleep,  Prev: unlock,  Up: Alphabetical List

`unsetenv'
==========

Syntax
------

     #include <stdlib.h>
     
     void unsetenv(const char *name);

Description
-----------

This function removes the given environment variable from the
environment.

Return Value
------------

None.

Example
-------

     unsetenv("TERM");


File: libc,  Node: usleep,  Next: utime,  Prev: unsetenv,  Up: Alphabetical List

`usleep'
========

Syntax
------

     #include <osfcn.h>
     
     unsigned usleep(unsigned usec);

Description
-----------

This function pauses the program for USEC microseconds.

Return Value
------------

The number of unsleept microseconds (i.e. zero).

Example
-------

     usleep(500000);


File: libc,  Node: utime,  Next: utimes,  Prev: usleep,  Up: Alphabetical List

`utime'
=======

Syntax
------

     #include <utime.h>
     
     itn utime(const char *file, const struct utimbuf *time);

Description
-----------

This function sets the modification timestamp on the FILE.  The new
time is stored in this structure:

     struct utimbuf
     {
         time_t  actime;  /* access time (unused) */
         time_t  modtime; /* modification time */
     };

Return Value
------------

Zero for success, nonzero for failure.

Example
-------

     struct utimbuf t;
     t.modtime = time(0);
     utime("data.txt", &t);


File: libc,  Node: utimes,  Next: va_*,  Prev: utime,  Up: Alphabetical List

`utimes'
========

Syntax
------

     int utimes(const char *file, struct timevar tvp[2]);

Description
-----------

This function does nothing.  It is provided to assist in porting Unix
programs.

Return Value
------------

Zero for success, nonzero for failure.


File: libc,  Node: va_*,  Next: valloc,  Prev: utimes,  Up: Alphabetical List

`va_start', `va_end', `va_arg'
==============================

Syntax
------

     #include <stdarg.h>
     
     va_list v;
     va_start(v, last-formal-arg);
     va_arg(v, type)
     va_end(v);

Description
-----------

These functions provide access to the variable arguments passed to
functions prototyped with the "..." symbol (like *note printf::.).  You
must declare a variable to hold the marker, then initialize it with
`va_start'.  Then, for each value you want, call `va_arg' and pass it
tye type of the value (for example, va_arg(v, int)).  When you're done,
call va_end to clean up.

Return Value
------------

`va_arg' returns the value of the argument.

Example
-------

     void sum(int x, ...)
     {
       int s = 0, i;
       va_list v;
       va_start(v, x);
       for (i=0; i<s; i++)
         s += va_arg(v, int);
       va_end(v);
       return s;
     }

void debug(char *fmt, ...) {   va_list v;   if (!do_debug) return;
va_start(v, fmt);   vfprintf(stderr, fmt, v);   va_end(v); }


File: libc,  Node: valloc,  Next: vfork,  Prev: va_*,  Up: Alphabetical List

`valloc'
========

Syntax
------

     #include <stdlib.h>
     
     void *valloc(unsigned size);

Description
-----------

This function is just like `malloc' (*note malloc::.) except that the
returned pointer is always aligned to a CPU page boundary.  This
alignment is rarely useful in djgpp.

Return Value
------------

A pointer to a newly allocated block of memory.

Example
-------

     char *page = valloc(getpagesize());


File: libc,  Node: vfork,  Next: vfprintf,  Prev: valloc,  Up: Alphabetical List

`vfork'
=======

Description
-----------

This function is provided to assist in porting Unix programs only.  It
always fails.

Return Value
------------

-1


File: libc,  Node: vfprintf,  Next: vprintf,  Prev: vfork,  Up: Alphabetical List

`vfprintf'
==========

Syntax
------

     #include <stdio.h>
     #include <stdarg.h>
     
     int vfprintf(FILE *file, const char *format, va_list arguments);

Description
-----------

Sends formatted output from the ARGUMENTS to the FILE.  *Note printf::

Return Value
------------

The number of characters written.


File: libc,  Node: vprintf,  Next: vsprintf,  Prev: vfprintf,  Up: Alphabetical List

`vprintf'
=========

Syntax
------

     #include <stdio.h>
     #include <stdarg.h>
     
     int vprintf(const char *format, va_list arguments);

Description
-----------

Sends formatted output from the ARGUMENTS to `stdout'.  *Note printf::

Return Value
------------

The number of characters written.


File: libc,  Node: vsprintf,  Next: wait,  Prev: vprintf,  Up: Alphabetical List

`vsprintf'
==========

Syntax
------

     #include <stdio.h>
     #include <stdarg.h>
     
     int vsprintf(char *buffer, const char *format, va_list arguments);

Description
-----------

Sends formatted output from the ARGUMENTS to the BUFFER.  *Note printf::

Return Value
------------

The number of characters written.


File: libc,  Node: wait,  Next: wcstombs,  Prev: vsprintf,  Up: Alphabetical List

`wait'
======

Description
-----------

This function is provided only to assist in porting from Unix.  It
always returns an error condition.


File: libc,  Node: wcstombs,  Next: wctomb,  Prev: wait,  Up: Alphabetical List

`wcstombs'
==========

Syntax
------

     #include <stdlib.h>
     
     size_t wcstombs(char *s, const wchar_t *wcs, size_t n);

Description
-----------

Converts a wide character string to a multibyte string.  At most N
characters are stored.

Return Value
------------

The number of characters stored.

Example
-------

     int len = wcstombs(buf, wstring, sizeof(buf));


File: libc,  Node: wctomb,  Next: write,  Prev: wcstombs,  Up: Alphabetical List

`wctomb'
========

Syntax
------

     #include <stdlib.h>
     
     int wctomb(char *s, wchar_t wchar);

Description
-----------

Convert a wide character to a multibyte character.  The string S must
be at least `MB_LEN_MAX' bytes long.

Return Value
------------

The number of characters stored.

Example
-------

     char s[MB_LEN_MAX];
     int mlen = wctomb(s, wc);


File: libc,  Node: write,  Next: writecr,  Prev: wctomb,  Up: Alphabetical List

`write'
=======

Syntax
------

     #include <osfcn.h>
     
     int write(int file, const void *buffer, unsigned count);

Description
-----------

This function writes COUNT bytes from BUFFER to FILE.  It returns the
number of bytes actually written.  It will return zero at end-of-file,
and may return less than COUNT even under valid conditions.

Note that if FILE is a text file, `write' may write more bytes than it
reports.

Return Value
------------

The number of bytes written, zero at EOF, or -1 on error.

Example
-------

     write(fd, "hello", 5);


File: libc,  Node: writecr,  Next: writev,  Prev: write,  Up: Alphabetical List

`writecr'
=========

Syntax
------

     int write(int file, const void *buffer, unsigned count);

Description
-----------

This is just like `write' (*note write::.) except that the Ctrl-M
characters are inserted before each Ctrl-J character to convert from
Unix-style text lines to DOS-style text lines when writing to a binary
file.

Return Value
------------

The number of bytes written, zero at EOF, or -1 on error.

Example
-------

     writecr(fd, "hello\n", 6);


File: libc,  Node: writev,  Next: xmalloc,  Prev: writecr,  Up: Alphabetical List

`writev'
========

Syntax
------

     #include <sys/uio.h>
     
     int writev(int handle, struct iovec *iov, int count);

Description
-----------

This is just like `readv' (*note readv::.), except that it writes
instead of reading.

Return Value
------------

The number of bytes written.


File: libc,  Node: xmalloc,  Next: xrealloc,  Prev: writev,  Up: Alphabetical List

`xmalloc'
=========

Syntax
------

     void *xmalloc(size_t size);

Description
-----------

This function is just like `malloc' (*note malloc::.), except that if
there is no more memory, it prints an error message and exits.

Return Value
------------

A pointer to the newly allocated memory.

Example
-------

     char *f = xmalloc(100);


File: libc,  Node: xrealloc,  Prev: xmalloc,  Up: Alphabetical List

`xrealloc'
==========

Syntax
------

     void *xrealloc(void *ptr, size_t size);

Description
-----------

This function is just like `realloc' (*note realloc::.), except that if
there is no more memory, it prints an error message and exits.  It can
also properly handle PTR being `NULL'.

Return Value
------------

A pointer to a possibly new block.

Example
-------

     char *buf;
     buf = (char *)xrealloc(buf, new_size);


File: libc,  Node: Index,  Up: Top

* Menu:
*Note Alphabetical List::



Tag Table:
Node: Top155
Node: Introduction562
Node: Overview1202
Node: Functional Categories3830
Node: bios functions4417
Node: ctype functions4609
Node: dos functions4899
Node: dpmi functions5222
Node: environment functions6164
Node: file system functions6358
Node: go32 functions6856
Node: header functions7179
Node: io functions7468
Node: locale functions7833
Node: math functions8065
Node: memory functions8244
Node: misc functions8650
Node: posix functions9050
Node: process functions9218
Node: random number functions9503
Node: signal functions9694
Node: stdio functions9942
Node: string functions10857
Node: time functions11356
Node: unix functions11757
Node: Alphabetical List12362
Node: abort17831
Node: abs18259
Node: access18557
Node: addmntent19444
Node: alloca19864
Node: aout.h20514
Node: ar.h20854
Node: asctime21079
Node: assert21797
Node: atexit22685
Node: __atexit23417
Node: atexit.h23651
Node: atof23848
Node: atoi24419
Node: atol24974
Node: _atold25533
Node: bcmp26129
Node: bcopy26732
Node: _bcopy27209
Node: bdos27856
Node: bdosptr28297
Node: bios.h28740
Node: bioscom28919
Node: biosdisk31007
Node: biosequip32805
Node: bioskey34140
Node: biosmemory34995
Node: biosprint35543
Node: biostime36327
Node: bool.h36806
Node: brk36986
Node: bsearch37620
Node: bzero38874
Node: calloc39233
Node: cfree39880
Node: chdir40281
Node: chmod40836
Node: chown41439
Node: _cleanup41770
Node: clearerr41999
Node: clock42360
Node: close42881
Node: closedir43295
Node: coff.h43647
Node: creat43871
Node: crlf2nl44583
Node: ctime44927
Node: _ctype_45353
Node: delay45625
Node: difftime46060
Node: disable46552
Node: div47098
Node: _doprnt47668
Node: dos.h48301
Node: _doscan48503
Node: _doscan_low49204
Node: dosmemget49397
Node: dosmemput50265
Node: dpmi.h51094
Node: dup51349
Node: dup251762
Node: enable52298
Node: endgrent52842
Node: endmntent53201
Node: endpwent53570
Node: EOF53892
Node: errno54378
Node: exec*54752
Node: exit55815
Node: _exit56345
Node: _f_morefiles56822
Node: fchmod57027
Node: fclose57349
Node: fdopen57743
Node: feof58289
Node: ferror58720
Node: fflush59171
Node: ffs59702
Node: fgetc60212
Node: fgetgrent60651
Node: fgetpos60953
Node: fgetpwent61365
Node: fgets61663
Node: _filbuf62424
Node: fileno62619
Node: _findenv62958
Node: findfirst63186
Node: _findiop65429
Node: findnext65628
Node: _fixpath66000
Node: _flsbuf66742
Node: _fmode66940
Node: fnmatch67391
Node: fnmerge68945
Node: fnsplit69433
Node: fopen70283
Node: fork71855
Node: fpathconf72111
Node: fprintf72487
Node: fpurge72843
Node: fputc73175
Node: fputs73561
Node: fread73995
Node: free74460
Node: freopen74856
Node: fscanf75412
Node: fseek75830
Node: fsetpos76908
Node: fstat77325
Node: fsync77701
Node: ftell78085
Node: ftime78487
Node: ftruncate79222
Node: _fwalk79725
Node: fwrite80170
Node: _get_default_drive80659
Node: getc81060
Node: getcbrk81466
Node: getchar81798
Node: getcwd82098
Node: getdate82823
Node: getdfree83323
Node: getdisk84060
Node: getdtablesize84430
Node: getegid84878
Node: getenv85145
Node: geteuid85585
Node: getftime85843
Node: getgid86570
Node: getgrent86828
Node: getgrgid87809
Node: getgrnam88183
Node: getgroups88562
Node: getkey88803
Node: getlogin89377
Node: getlongpass89817
Node: getmntent90461
Node: getopt91893
Node: getpagesize93372
Node: getpass93715
Node: getpid94213
Node: getpwent94539
Node: getpwnam95642
Node: getpwuid96016
Node: getrusage96373
Node: gets97098
Node: gettime97680
Node: gettimeofday98236
Node: getuid99033
Node: getw99286
Node: getwd99765
Node: getxkey100171
Node: gmtime100738
Node: go32.h101888
Node: Go32/DPMI Information102133
Node: _go32_conventional_mem_selector104743
Node: _go32_dpmi_allocate_dos_memory105857
Node: _go32_dpmi_allocate_iret_wrapper107080
Node: _go32_dpmi_allocate_real_mode_callback_iret108291
Node: _go32_dpmi_allocate_real_mode_callback_retf110069
Node: _go32_dpmi_chain_protected_mode_interrupt_vector111269
Node: _go32_dpmi_free_dos_memory112278
Node: _go32_dpmi_free_iret_wrapper113052
Node: _go32_dpmi_free_real_mode_callback113710
Node: _go32_dpmi_get_free_memory_information114425
Node: _go32_dpmi_get_protected_mode_interrupt_vector115733
Node: _go32_dpmi_get_real_mode_interrupt_vector116608
Node: _go32_dpmi_remaining_physical_memory117345
Node: _go32_dpmi_remaining_virtual_memory117850
Node: _go32_dpmi_resize_dos_memory118338
Node: _go32_dpmi_set_protected_mode_interrupt_vector119301
Node: _go32_dpmi_set_real_mode_interrupt_vector121210
Node: _go32_dpmi_simulate_fcall121939
Node: _go32_dpmi_simulate_fcall_iret123072
Node: _go32_dpmi_simulate_int124216
Node: _go32_info_block125361
Node: _go32_my_cs128469
Node: _go32_my_ds128818
Node: _go32_my_ss129163
Node: _go32_want_ctrl_break129518
Node: _go32_was_ctrl_break_hit130427
Node: gppconio.h/conio.h131217
Node: graphics.h131473
Node: hasmntopt131952
Node: htonl132374
Node: htons132834
Node: index133287
Node: initstate133843
Node: insque134322
Node: int86134864
Node: int86x135379
Node: intdos136698
Node: intdosx137114
Node: _iob137485
Node: isalnum137680
Node: isalpha138007
Node: isatty138299
Node: iscntrl138716
Node: isdigit139030
Node: isgraph139321
Node: isleap139677
Node: islower140073
Node: isprint140376
Node: ispunct140729
Node: isspace141085
Node: isupper141457
Node: isxdigit141775
Node: itoa142126
Node: kbhit143185
Node: keys.h143959
Node: kill144153
Node: labs144348
Node: ldexp144628
Node: ldiv144930
Node: link145507
Node: localeconv146006
Node: localtime148840
Node: lock149272
Node: longjmp150041
Node: longjmperror150818
Node: lseek151147
Node: __main151856
Node: malloc152100
Node: mblen152680
Node: mbstowcs153259
Node: mbtowc153761
Node: memccpy154349
Node: memchr154869
Node: memcmp155331
Node: memcpy155735
Node: _memcpy156114
Node: memmove156722
Node: memset157275
Node: mkdir157724
Node: mkfifo158146
Node: mknod158374
Node: mkstemp158602
Node: mktemp159346
Node: mktime160112
Node: modf160577
Node: modfl161076
Node: morecore161601
Node: mouse.h161800
Node: movedata162100
Node: nlist163758
Node: ntohl164014
Node: ntohs164467
Node: offsetof164920
Node: on_exit165437
Node: open165989
Node: opendir167662
Node: optarg168192
Node: opterr168336
Node: optind168479
Node: optopt168622
Node: pathconf168767
Node: pc.h169704
Node: pclose169973
Node: perror170543
Node: pipe171081
Node: popen171304
Node: printf172568
Node: putc175874
Node: putchar176260
Node: putenv176639
Node: puts177237
Node: putw177633
Node: qsort178102
Node: rand179571
Node: random179927
Node: rawclock180298
Node: read180695
Node: readcr181333
Node: readdir181827
Node: readv182581
Node: realloc183249
Node: realloc_srchlen184060
Node: remove184400
Node: remque184873
Node: rename185359
Node: rewind185884
Node: rewinddir186267
Node: rindex186711
Node: rmdir187297
Node: sbrk187703
Node: scanf188471
Node: seekdir191790
Node: setbuf192410
Node: setbuffer193198
Node: setcbrk194009
Node: setdate194383
Node: setdisk194757
Node: setenv195163
Node: setftime195739
Node: setgrent196473
Node: setjmp196814
Node: setlinebuf197592
Node: setlocale198252
Node: setmntent199381
Node: setmode199858
Node: _setmode200424
Node: setpwent200993
Node: _setstack201349
Node: setstate201584
Node: settime201986
Node: settimeofday202366
Node: setvbuf202824
Node: sigaction203879
Node: sigaddset204122
Node: sigdelset204367
Node: sigemptyset204614
Node: sigfillset204866
Node: sigismember205118
Node: signal205367
Node: sigsetmask205606
Node: sleep205847
Node: _smallbuf206249
Node: sopen206430
Node: spawn*206879
Node: sprintf209491
Node: srand209865
Node: srandom210294
Node: sscanf210729
Node: stat211160
Node: stat_assist212496
Node: statfs212682
Node: stdin/stdout/stderr/stdprn/stdaux213789
Node: _stklen214287
Node: strcasecmp214732
Node: strcat215212
Node: strchr215591
Node: strcmp216099
Node: strcoll216585
Node: strcpy217120
Node: strcspn217467
Node: strdup218081
Node: strerror218646
Node: strftime219125
Node: stricmp221723
Node: strlen222189
Node: strlwr222598
Node: strncasecmp222998
Node: strncat223574
Node: strncmp223972
Node: strncpy224502
Node: strnicmp224893
Node: strpbrk225455
Node: strrchr225934
Node: strsep226383
Node: strspn227269
Node: strstr227873
Node: strtod228301
Node: strtok228831
Node: strtol229625
Node: _strtold230518
Node: strtoul231069
Node: strupr231589
Node: strxfrm231970
Node: swab232563
Node: swap232945
Node: sync233297
Node: sys_errlist233524
Node: sys_nerr233894
Node: sysconf234291
Node: system236301
Node: tell236985
Node: telldir237319
Node: tempnam237853
Node: time238492
Node: timezone238861
Node: tmpfile239479
Node: tmpnam239875
Node: tolower240298
Node: toupper240722
Node: truncate241147
Node: ttyname241551
Node: tzname241941
Node: tzset242247
Node: tzsetwall242529
Node: _tztab242829
Node: umask243016
Node: ungetc243218
Node: unlink243676
Node: unlock244044
Node: unsetenv244393
Node: usleep244762
Node: utime245146
Node: utimes245782
Node: va_*246128
Node: valloc247220
Node: vfork247733
Node: vfprintf247976
Node: vprintf248384
Node: vsprintf248780
Node: wait249191
Node: wcstombs249419
Node: wctomb249880
Node: write250339
Node: writecr250987
Node: writev251543
Node: xmalloc251923
Node: xrealloc252354
Node: Index252858

End Tag Table
