


RCSMERGE(1)                                           RCSMERGE(1)


NAME
       rcsmerge - merge RCS revisions

SYNOPSIS
       rcsmerge [options] file

DESCRIPTION
       rcsmerge incorporates the changes between two revisions of
       an RCS file into the corresponding working file.

       Pathnames matching an RCS suffix  denote  RCS  files;  all
       others   denote   working  files.   Names  are  paired  as
       explained in ci(1).

       At least one revision must be specified with  one  of  the
       options  described  below,  usually -r.  At most two revi-
       sions may be specified.  If only one  revision  is  speci-
       fied,  the latest revision on the default branch (normally
       the highest branch on the trunk) is assumed for the second
       revision.   Revisions may be specified numerically or sym-
       bolically.

       rcsmerge prints a  warning  if  there  are  overlaps,  and
       delimits the overlapping regions as explained in merge(1).
       The command is useful for  incorporating  changes  into  a
       checked-out revision.

OPTIONS
       -A     Output conflicts using the -A style of diff3(1), if
              supported by diff3.  This merges all changes  lead-
              ing  from  file2 to file3 into file1, and generates
              the most verbose output.

       -E, -e These options specify conflict styles that generate
              less   information   than  -A.   See  diff3(1)  for
              details.  The default is  -E.   With  -e,  rcsmerge
              does not warn about conflicts.

       -ksubst
              Use  subst  style  keyword substitution.  See co(1)
              for details.  For example, -kk -r1.1 -r1.2  ignores
              differences  in  keyword  values  when  merging the
              changes from 1.1 to 1.2.  It normally does not make
              sense  to  merge binary files as if they were text,
              so rcsmerge refuses to merge files if -kb expansion
              is used.

       -p[rev]
              Send the result to standard output instead of over-
              writing the working file.

       -q[rev]
              Run quietly; do not print diagnostics.




GNU                         1995/06/01                          1





RCSMERGE(1)                                           RCSMERGE(1)


       -r[rev]
              Merge with respect to revision rev.  Here an  empty
              rev  stands  for the latest revision on the default
              branch, normally the head.

       -T     This option has no effect; it is present  for  com-
              patibility with other RCS commands.

       -V     Print RCS's version number.

       -Vn    Emulate RCS version n.  See co(1) for details.

       -xsuffixes
              Use  suffixes to characterize RCS files.  See ci(1)
              for details.

       -zzone Use zone as the time zone for keyword substitution.
              See co(1) for details.

EXAMPLES
       Suppose  you  have  released  revision 2.8 of f.c.  Assume
       furthermore that after you complete an unreleased revision
       3.4, you receive updates to release 2.8 from someone else.
       To combine the updates to 2.8 and your changes between 2.8
       and 3.4, put the updates to 2.8 into file f.c and execute

           rcsmerge  -p  -r2.8  -r3.4  f.c  >f.merged.c

       Then  examine  f.merged.c.   Alternatively, if you want to
       save the updates to 2.8 in the RCS file, check them in  as
       revision 2.8.1.1 and execute co -j:

           ci  -r2.8.1.1  f.c
           co  -r3.4  -j2.8:2.8.1.1  f.c

       As  another  example,  the  following  command  undoes the
       changes between revision 2.4 and  2.8  in  your  currently
       checked out revision in f.c.

           rcsmerge  -r2.8  -r2.4  f.c

       Note  the  order  of  the  arguments, and that f.c will be
       overwritten.

ENVIRONMENT
       RCSINIT
              options prepended to the argument  list,  separated
              by spaces.  See ci(1) for details.

DIAGNOSTICS
       Exit  status  is 0 for no overlaps, 1 for some overlaps, 2
       for trouble.





GNU                         1995/06/01                          2





RCSMERGE(1)                                           RCSMERGE(1)


IDENTIFICATION
       Author: Walter F. Tichy.
       Manual Page Revision: 5.6; Release Date: 1995/06/01.
       Copyright (C) 1982, 1988, 1989 Walter F. Tichy.
       Copyright (C) 1990, 1991,  1992,  1993,  1994,  1995  Paul
       Eggert.

SEE ALSO
       ci(1),  co(1),  ident(1),  merge(1),  rcs(1),  rcsdiff(1),
       rcsintro(1), rlog(1), rcsfile(5)
       Walter  F.  Tichy,  RCS--A  System  for  Version  Control,
       Software--Practice   &   Experience  15,  7  (July  1985),
       637-654.












































GNU                         1995/06/01                          3


