/*
 * Copyright (c) 1995, by Thinkage Ltd.
 *
 * signal.h - manifests for the signal routine.
 */

#ifndef _D_SIGNAL
#	define	_D_SIGNAL
#	pragma idempotent

	typedef int sig_atomic_t;
	typedef void (*_SIGACT)();

#	protoset signal

#	define SIGBASE		0
#	define SIGABRT		(SIGBASE+0)
#	define SIGFPE		(SIGBASE+1)
#	define SIGILL		(SIGBASE+2)
#	define SIGINT		(SIGBASE+3)
#	define SIGSEGV		(SIGBASE+4)
#	define SIGTERM		(SIGBASE+5)

#	define SIG_IGN	_sig_ign
#	define SIG_DFL	_sig_dfl
#	define SIG_ERR	_sig_err

#ifndef BUILTIN_FUNCTION_PTR_TYPES       /* not now -- complicated prototype */
	void
(*signal( int _sig, void (*_func)(int) )) (int);
#endif

#endif /* _D_SIGNAL */
