@ECHO OFF
REM ---------------------------------------------------------------------------
REM  This file does a very simple setup of the environment for CIDLib
REM  development. It assumes that the CIDDRIVE environment variable is
REM  already set up to the value of the drive that CIDLib is installed on.
REM
REM  CIDDRIVE should include the colon, X: for instance!
REM
REM  You can pass a parameter of Dev or Prod to choose whether you want to
REM  set up the paths for the production or development builds. If none, it
REM  defaults to development build.
REM ---------------------------------------------------------------------------

SET CIDBUILD=Dev

IF "%1"=="Prod" GOTO SET_PROD
IF "%1"=="prod" GOTO SET_PROD
IF "%1"=="PROD" GOTO SET_PROD
GOTO DO_WORK

:SET_PROD
SET CIDBUILD=Prod

:DO_WORK

REM ---------------------------------------------------------------------------
REM  Add the debug directory to the path and the Cmd directory so that batch
REM  files and regular debug development executable files will be found.
REM ---------------------------------------------------------------------------
SET PATH=%PATH%%CIDDRIVE%\CID_Dev\%CIDBUILD%Result;%CIDDRIVE%\CID_Dev\Source\Cmd;


REM ---------------------------------------------------------------------------
REM  Set up the _NT_SYMBOL_PATH variable to point to the main debug output
REM  directory, which is where the PDB files will be.
REM ---------------------------------------------------------------------------
SET _NT_SYMBOL_PATH=%CIDDRIVE%\CID_Dev\%CIDBUILD%Result


REM ---------------------------------------------------------------------------
REM  Set up the standard local log file and logging sync semaphore to point
REM  to some reasonable values.
REM
REM  Note that these are platform specific since they are not done via CIDLib
REM  itself.
REM ---------------------------------------------------------------------------
SET CIDLOCALLOG=%CIDDRIVE%\CID_Dev\%CIDBUILD%Result\Log.Text
SET CIDLOGSEM=CIDLib.Logging.Mtx
SET CIDERRDUMPDIR=%CIDDRIVE%\CID_Dev\%CIDBUILD%Result\


REM ---------------------------------------------------------------------------
REM  These are just for the testing program TestCIDLib, which needs to be able
REM  to test for some values that it knows exist and have a particular value.
REM  You can throw away these lines if you don't run the test programs.
REM ---------------------------------------------------------------------------
SET TestVar1=The value of TestVar1
SET TestVar2=The value of TestVar2

SET CIDBUILD=
