//
//  FILE NAME: TestKernel_SysExceptions.Cpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/12/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This module tests the TKrnlSysExcept class.
//
//  CAVEATS/GOTCHAS:
//

// ----------------------------------------------------------------------------
//  Includes
// ----------------------------------------------------------------------------
#include    "TestKernel.Hpp"


// ----------------------------------------------------------------------------
//   CLASS: TTestSysExcept
//  PREFIX: ksexc
// ----------------------------------------------------------------------------
class TTestSysExcept : public TKrnlSysExcept
{
    public :
        // --------------------------------------------------------------------
        //  Constructors and Destructor
        // --------------------------------------------------------------------
        TTestSysExcept() {}

        ~TTestSysExcept() {}


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TBoolean bGotIt() const;

        tCIDLib::TVoid TestExcept
        (
            const   tCIDLib::ESysExcepts    eToTest
        );


    protected :
        // --------------------------------------------------------------------
        //  Protected, inherited methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid _DoWork();

        tCIDLib::ESysExceptRes _eRecoverTest();

        tCIDLib::TVoid _Handler();


    private:
        // --------------------------------------------------------------------
        //  Private Data
        //
        //  __bGotIt
        //      Set by the handler to indicate that it got the exception.
        //
        //  __eThisException
        //      The exception that is generated this time.
        //
        //  __pszExceptText
        //      The text for the exception that is being tested. This is for
        //      the error reporting.
        // --------------------------------------------------------------------
        tCIDLib::TBoolean       __bGotIt;
        tCIDLib::ESysExcepts    __eThisExcept;
        tCIDLib::Tch*           __pszExceptText;
};


// ----------------------------------------------------------------------------
//  TTestSysExcept: Public, non-virtual methods
// ----------------------------------------------------------------------------

tCIDLib::TBoolean TTestSysExcept::bGotIt() const
{
    return __bGotIt;
}

tCIDLib::TVoid TTestSysExcept::TestExcept(const tCIDLib::ESysExcepts eToTest)
{
    __bGotIt = kCIDLib::False;
    __eThisExcept = eToTest;
    DoWork();
}


// ----------------------------------------------------------------------------
//  TTestSysExcept: Protected, inherited methods
// ----------------------------------------------------------------------------

tCIDLib::TVoid TTestSysExcept::_DoWork()
{
    tCIDLib::Tch        chTmp;
    tCIDLib::TInt4      i4Res;
    tCIDLib::TInt4      i4Tmp = 0;
    tCIDLib::Tch*       pszTmp = 0;

    if (__eThisExcept == tCIDLib::ESysExcept_Int_DivByZero)
    {
        i4Res = 10 / i4Tmp;
    }
     else if (__eThisExcept == tCIDLib::ESysExcept_ReadAccess)
    {
        __pszExceptText = L"Read Access";
        chTmp = *pszTmp;
    }
     else if (__eThisExcept == tCIDLib::ESysExcept_WriteAccess)
    {
        // First cause a write access error
        __pszExceptText = L"Write Access";
        *pszTmp = 0;
    }
}

tCIDLib::ESysExceptRes TTestSysExcept::_eRecoverTest()
{
    // Make sure that its the exception that we expected.
    if (__eThisExcept != _eExceptCode())
    {
        cout << _CurLn_ << "Got wrong exception code in recover test. "
                           "Expected: " << TUNIStr(__pszExceptText)
                        << " but got: " << tCIDLib::TInt4(_eExceptCode())
                        << "\r\n";

        // Its not ours, so let it go                            
        return tCIDLib::ESysExceptRes_Propogate;
    }

    // Its ours, so eat it
    return tCIDLib::ESysExceptRes_ExecuteHandler;
}

tCIDLib::TVoid TTestSysExcept::_Handler()
{
    // Make sure that its the exception that we expected.
    if (__eThisExcept != _eExceptCode())
    {
        cout << _CurLn_ << "Got wrong exception code in handler. "
                           "Excected: " << TUNIStr(__pszExceptText)
                        << " but got: " << tCIDLib::TInt4(_eExceptCode())
                        << "\r\n";
    }

    __bGotIt = kCIDLib::True;
}



// ----------------------------------------------------------------------------
//  Intrafacility functions
// ----------------------------------------------------------------------------

//
// FUNCTION/METHOD NAME: TestSysExcepts
//
// DESCRIPTION:
//
//  This method is called from the main module to test the TKrnlSysExcept
//  class.
// -------------------------------------
//   INPUT: None
//
//  OUTPUT: None
//
//  RETURN: None
//
tCIDLib::TVoid TestSysExcepts()
{
    // Create one of our test objects and run it
    TTestSysExcept sexcTest;

    sexcTest.TestExcept(tCIDLib::ESysExcept_Int_DivByZero);
    if (!sexcTest.bGotIt())
        cout << _CurLn_ << "Did not get Int Div By Zero exception\r\n";

    sexcTest.TestExcept(tCIDLib::ESysExcept_ReadAccess);
    if (!sexcTest.bGotIt())
        cout << _CurLn_ << "Did not get Read Access exception\r\n";

    sexcTest.TestExcept(tCIDLib::ESysExcept_WriteAccess);
    if (!sexcTest.bGotIt())
        cout << _CurLn_ << "Did not get Write Access exception\r\n";
}
