//
// NAME: TestKernel_SortSearch.Cpp
//
// DESCRIPTION:
//
//  This module is part of the TestKernel.Exe program and is called from
//  the program's main() function. The functions in this module test the
//  search and sort templates and functions.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 07/03/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//
// MODIFICATION LOG:
//


// -----------------------------------------------------------------------------
//  Facility specific includes
// -----------------------------------------------------------------------------
#include    "TestKernel.Hpp"


// -----------------------------------------------------------------------------
//  Local functions
// -----------------------------------------------------------------------------

//
// FUNCTION/METHOD NAME: __TestXXXX
//
// DESCRIPTION:
//
//  Tests out the various search and sort functions and templates.
// ---------------------------------------
//   INPUT: strmOut is the text stream to send messages to.
//
//  OUTPUT: None
//
//  RETURN: None
//
static tCIDLib::TVoid __TestQSort()
{
    tCIDLib::TCard4 c4Index;

    //
    //  Do a very simple sort of a small array. This one is for debugging
    //  purposes since its easy to trace through, unlike the ones below.
    //
    tCIDLib::TInt4 ai4ToSort[6];
    for (tCIDLib::TInt4 i4Number = 0; i4Number < 6; i4Number++)
        ai4ToSort[i4Number] = 3 - i4Number;

    CIDSort::QSortArray(ai4ToSort, 0, c4ArrayElems(ai4ToSort)-1);

    // Make sure it got sorted
    for (c4Index = 0; c4Index < c4ArrayElems(ai4ToSort)-2; c4Index++)
    {
        if (ai4ToSort[c4Index] > ai4ToSort[c4Index+1])
        {
            cout    << _CurLn_ << "Array was not sorted. Element "
                    << c4Index << " was > than element " << c4Index+1
                    << "\r\n";
            break;
        }
    }

    //
    //  Create an array of cardinal values fill with random values and
    //  then sort it.
    //
    const tCIDLib::TCard4 c4ArraySize = 512;
    tCIDLib::TCard4 ac4ToSort[c4ArraySize];

    // Seed rand number generator with current thread id
    TMathLib::SeedRandom(TKrnlSysInfo::tidCurrent());

    for (c4Index = 0; c4Index < c4ArraySize; c4Index++)
        ac4ToSort[c4Index] = TMathLib::c4RandomNum();

    CIDSort::QSortArray(ac4ToSort, 0, c4ArraySize-1);

    // Make sure that it got sorted
    for (c4Index = 0; c4Index < c4ArraySize-1; c4Index++)
    {
        if (ac4ToSort[c4Index] > ac4ToSort[c4Index+1])
        {
            cout    << _CurLn_ << "Array was not sorted. Element "
                    << c4Index << " was > than element " << c4Index+1
                    << "\r\n";
            break;
        }
    }
}


static tCIDLib::TVoid __TestBinarySearch()
{
    const tCIDLib::TCard4   ac4Test[] = 
    {
        1, 5, 9, 10, 14, 18, 29, 50, 190, 200, 410
    };
    const tCIDLib::TCard4 c4ElemCount = c4ArrayElems(ac4Test);

    for (tCIDLib::TCard4 c4Index = 0; c4Index < c4ElemCount; c4Index++)
    {
        tCIDLib::TCard4 c4FoundAt;
        if (!CIDSearch::bBinarySearch
        (
            ac4Test
            , ac4Test[c4Index]
            , c4FoundAt
            , c4ElemCount))
        {
            cout << _CurLn_ << "Failed to find element with value "
                 << ac4Test[c4Index] << "\r\n";
        }
         else if (c4FoundAt != c4Index)
        {
            cout << _CurLn_ << "Element found at:" << c4FoundAt
                 << " instead of " << c4Index << " as expected\r\n";
        }
    }
}


// -----------------------------------------------------------------------------
//  TFacTestCIDLib: Public, non-virtual methods
// -----------------------------------------------------------------------------

//
// FUNCTION/METHOD NAME: TestSearchSort
//
// DESCRIPTION:
//
//  This method calls a number of local functions that test various
//  aspects of the search and sort system.
// ---------------------------------------
//   INPUT: None
//
//  OUTPUT: None
//
//  RETURN: None
//
tCIDLib::TVoid TestSearchAndSort()
{
    __TestQSort();
    __TestBinarySearch();
}
