//
//  FILE NAME: TestKernel_RawMemory.Cpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/12/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This module tests the raw memory manipulation APIs.
//
//  CAVEATS/GOTCHAS:
//

// ----------------------------------------------------------------------------
//  Includes
// ----------------------------------------------------------------------------
#include    "TestKernel.Hpp"
#include    <memory.h>



// ----------------------------------------------------------------------------
//  Local static functions
// ----------------------------------------------------------------------------

static tCIDLib::TVoid __TestFills()
{
    //
    //  Create a memory buffer and fill it using each fill method and test
    //  its results. Allocate it so that any overruns are caught by the
    //  heap checking tools.
    //
    const tCIDLib::TCard4   c4Size = 512;
    tCIDLib::TCard4         c4Index;
    {
        tCIDLib::TCard1* pc1Test = new tCIDLib::TCard1[c4Size];

        // Set by raw RTL to all zeros, then set to test pattern
        memset(pc1Test, 0, c4Size);
        TRawMem::SetMemBuf(pc1Test, tCIDLib::TCard1(0xAC), c4Size);

        // Test it for the pattern
        for (c4Index = 0; c4Index < c4Size; c4Index++)
        {
            if (pc1Test[c4Index] != 0xAC)
            {
                cout << _CurLn_ << "TCard1 buffer fill failed\r\n";
                break;
            }
        }
        delete [] pc1Test;
    }

    {
        tCIDLib::TCard2* pc2Test = new tCIDLib::TCard2[c4Size];

        // Set by raw RTL to all zeros, then set to test pattern
        memset(pc2Test, 0, c4Size * 2);
        TRawMem::SetMemBuf(pc2Test, tCIDLib::TCard2(0xFACE), c4Size);

        // Test it for the pattern
        for (c4Index = 0; c4Index < c4Size; c4Index++)
        {
            if (pc2Test[c4Index] != 0xFACE)
            {
                cout << _CurLn_ << "TCard2 buffer fill failed\r\n";
                break;
            }
        }

        //
        //  Set by raw RTL to all zeros, then set using test pattern with
        //  same upper and lower byte. This will use an optimized fill.
        //
        memset(pc2Test, 0, c4Size * 2);
        TRawMem::SetMemBuf(pc2Test, tCIDLib::TCard2(0xCACA), c4Size);

        // Test it for the pattern
        for (c4Index = 0; c4Index < c4Size; c4Index++)
        {
            if (pc2Test[c4Index] != 0xCACA)
            {
                cout << _CurLn_ << "TCard2 buffer fill failed\r\n";
                break;
            }
        }
        delete pc2Test;
    }

    {
        tCIDLib::TCard4* pc4Test = new tCIDLib::TCard4[c4Size];

        // Set by raw RTL to all zeros, then set to test pattern
        memset(pc4Test, 0, c4Size * 4);
        TRawMem::SetMemBuf(pc4Test, tCIDLib::TCard4(0x90ABCDEF), c4Size);

        // Test it for the pattern
        for (c4Index = 0; c4Index < c4Size; c4Index++)
        {
            if (pc4Test[c4Index] != 0x90ABCDEF)
            {
                cout << _CurLn_ << "TCard4 buffer fill failed\r\n";
                break;
            }
        }
        delete [] pc4Test;
    }
}

static tCIDLib::TVoid __TestHash()
{
    // This one is just for use in the debugger mainly
    const tCIDLib::TCard4 c4Size = 16;
    const tCIDLib::TCard4 c4Modulus = 23;

    tCIDLib::TCard1 c1Test[c4Size];
    for (tCIDLib::TCard4 c4Index = 0; c4Index < c4Size; c4Index++)
        c1Test[c4Index] = tCIDLib::TCard1(c4Index)+4;

    tCIDLib::THashVal hshRet = TRawMem::hshHashBuffer(c1Test, c4Modulus, c4Size);

    if (hshRet > c4Modulus)
    {
        cout << _CurLn_ << "Hash was larger than modulus\r\n";
        return;
    }
}


// ----------------------------------------------------------------------------
//  Intrafacility functions
// ----------------------------------------------------------------------------

tCIDLib::TVoid TestRawMemory()
{
    __TestFills();
    __TestHash();
}
