//
//  FILE NAME: TestKernel_TestModule.Cpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 06/29/99
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This module tests the TKrnlModule class, which is a very key class and
//  the basis for the TFacility class in CIDLib.Dll.
//
//  CAVEATS/GOTCHAS:
//

// ----------------------------------------------------------------------------
//  Includes
// ----------------------------------------------------------------------------
#include    "TestKernel.Hpp"


// ----------------------------------------------------------------------------
//  Local functions
// ----------------------------------------------------------------------------

static tCIDLib::TVoid __MsgFileTest()
{
    const tCIDLib::TCard4 c4TextLen = 1024;
    tCIDLib::Tch szText[c4TextLen+1];

    // Use our global module object to try to load the test messages
    if (!kmodTestKernel.bLoadCIDMsg
    (
        kTestKrnlMsgs::midTestId1
        , szText
        , c4TextLen))
    {
        cout << _CurLn_ << "Could not load message id: "
             << kTestKrnlMsgs::midTestId1 << "\r\n";
    }

    if (TRawStr::eCompareStr(szText, L"This is the text for Test id 1"))
    {
        cout << _CurLn_ << "Text for message id: "
             << kTestKrnlMsgs::midTestId1
             << " did not match expected text\r\n";
    }


    // Use our global module object to try to load the test messages
    if (!kmodTestKernel.bLoadCIDMsg
    (
        kTestKrnlMsgs::midTestId3
        , szText
        , c4TextLen))
    {
        cout << _CurLn_ << "Could not load message id: "
             << kTestKrnlMsgs::midTestId3 << "\r\n";
    }

    if (TRawStr::eCompareStr
    (
        szText
        , L"This is the text for Test id 3, which is longer than the others"))
    {
        cout << _CurLn_ << "Text for message id: "
             << kTestKrnlMsgs::midTestId3
             << " did not match expected text\r\n";
    }


    //
    //  Try one via the other mechanism, where it returns us the const pointer
    //  to the string.
    //
    const tCIDLib::Tch* pszMsg = kmodTestKernel.pszLoadCIDMsg
    (
        kTestKrnlMsgs::midTestId2
    );

    if (TRawStr::eCompareStr(pszMsg, L"This is the text for Test id 2"))
    {
        cout << _CurLn_ << "Text for message id: "
             << kTestKrnlMsgs::midTestId2
             << " did not match expected text\r\n";
    }
}


static tCIDLib::TVoid __ResourceStringTest()
{
    const tCIDLib::TCard4 c4TextLen = 1024;
    tCIDLib::Tch szText[c4TextLen+1];

    // Use our global module object to try to load the test strings
    if (!kmodTestKernel.bLoadResString
    (
        SID_TEST_STRING1
        , szText
        , c4TextLen))
    {
        cout << _CurLn_ << "Could not load resource string id: "
             << SID_TEST_STRING1 << "\r\n";
    }

    if (TRawStr::eCompareStr(szText, L"This is the text for string 1"))
    {
        cout << _CurLn_ << "Text for string id: "
             << SID_TEST_STRING1
             << " did not match expected text\r\n";
    }


    //
    //  Try one via the other mechanism, where it allocates the string
    //  for us.
    //
    const tCIDLib::Tch* pszStr = kmodTestKernel.pszLoadResString(SID_TEST_STRING2);
    if (TRawStr::eCompareStr(pszStr, L"This is the text for string 2"))
    {
        cout << _CurLn_ << "Text for message id: "
             << SID_TEST_STRING2
             << " did not match expected text\r\n";
    }
}


// ----------------------------------------------------------------------------
//  Intrafacility functions
// ----------------------------------------------------------------------------

//
// FUNCTION/METHOD NAME: TestModules
//
// DESCRIPTION:
//
//  This method is called from the main module to test the TKrnlModule
//  class. It calls some local functions to do the testing.
// -------------------------------------
//   INPUT: None
//
//  OUTPUT: None
//
//  RETURN: None
//
tCIDLib::TVoid TestModules()
{
    // Make sure we can access CIDLib type message files ok
    __MsgFileTest();

    // Make sure we can access resource based strings
    __ResourceStringTest();
}
