//
//  FILE NAME: TestKernel_Helper.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/10/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the TestKernel_Helper.Cpp module. This module
//  implements some grunt work stuff that we just want to keep separated
//  out.
//
//  CAVEATS/GOTCHAS:
//


// ----------------------------------------------------------------------------
//  A macro to help with putting out the current file and line to the standard
//  out. This is done a lot so this saves a LOT of typing.
// ----------------------------------------------------------------------------
class TCurLn
{
    public :
        // --------------------------------------------------------------------
        //  Constructors and Destructors
        // --------------------------------------------------------------------
        TCurLn
        (
            const   tCIDLib::Tsch* const    pszFile
            , const tCIDLib::TCard4         c4Line
        );

        ~TCurLn();


    private :
        // --------------------------------------------------------------------
        //  Declare our friends
        // --------------------------------------------------------------------
        friend ostream& operator<<
        (
                    ostream&                OutStream
            , const TCurLn&                 clnToStream
        );


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __c4Line
        //      The line number passed in the constructor.
        //
        //  __pszFile
        //      The name of the file. The path is stripped off so its only
        //      the name part.
        // --------------------------------------------------------------------
        tCIDLib::TCard4         __c4Line;
        tCIDLib::Tch*           __pszFile;
};

// ----------------------------------------------------------------------------
//  A streaming operator to get them to a stream
// ----------------------------------------------------------------------------
extern ostream& operator<<(ostream& OutStream, const TCurLn& clnToStream);

// ----------------------------------------------------------------------------
//  A macro to generate the constructor
// ----------------------------------------------------------------------------
#define _CurLn_ TCurLn(__FILE__, __LINE__)





// ----------------------------------------------------------------------------
//  A simple class to get UNICODE strings to the standard output stream, since
//  we have to use standard out in this one fundamental test program.
// ----------------------------------------------------------------------------
class TUNIStr
{
    public :
        // --------------------------------------------------------------------
        //  Constructors and Destructors
        // --------------------------------------------------------------------
        TUNIStr
        (
            const   tCIDLib::Tch* const     pszStr
        );

        TUNIStr
        (
            const   tCIDLib::Tch            chChar
        );

        ~TUNIStr();


    private :
        // --------------------------------------------------------------------
        //  Declare our friends
        // --------------------------------------------------------------------
        friend ostream& operator<<
        (
                    ostream&                OutStream
            , const TUNIStr&                ustrToStream
        );


        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TUNIStr();

        TUNIStr
        (
            const   TUNIStr&                ustrToCopy
        );

        tCIDLib::TVoid operator=
        (
            const   TUNIStr&                ustrToAssign
        );


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __pszStr
        //      This is the pointer to the string. We cannot change it or
        //      point it at anything else.
        //
        //  __szStr
        //      This is used to make a string out of a single wide character.
        //      if !__pszStr, then its here.
        // --------------------------------------------------------------------
        const tCIDLib::Tch* const   __pszStr;
        tCIDLib::Tch                __szStr[2];
};

// ----------------------------------------------------------------------------
//  Constructors and destructors
// ----------------------------------------------------------------------------
inline TUNIStr::TUNIStr(const tCIDLib::Tch* const pszStr) :

    __pszStr(pszStr)
{
}

inline TUNIStr::TUNIStr(const tCIDLib::Tch chChar) :

    __pszStr(0)
{
    __szStr[0] = chChar;
    __szStr[1] = 0;
}

inline TUNIStr::~TUNIStr()
{
}


// ----------------------------------------------------------------------------
//  Streaming operators to stream out some things
// ----------------------------------------------------------------------------
extern ostream& operator<<(ostream& OutStream, const TUNIStr& ustrToStream);
extern ostream& operator<<(ostream& OutStream, const TKrnlError& kerrToStream);
