//
//  FILE NAME: TestKernel.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/07/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the main header for the program. It brings in any other headers
//  required and provides a single point of inclusion for our own sub headers.
//
//  CAVEATS/GOTCHAS:
//
//  1)  Since each testing module only has a single entry point, they don't
//      use headers to export them. The main module just provides it own
//      extern prototypes.
//

// ----------------------------------------------------------------------------
//  CIDLib includes
//
//  We bring in the special memory checking class here. Its not normally
//  included since its only for use in debugging programs.
// ----------------------------------------------------------------------------
#include    "CIDKernel.Hpp"
#include    "CIDKernel_MemCheck.Hpp"


// ----------------------------------------------------------------------------
//  System Includes
// ----------------------------------------------------------------------------
#include    <iostream.h>
#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>


// ----------------------------------------------------------------------------
//  Facility sub-includes
// ----------------------------------------------------------------------------
#include    "TestKernel_Helper.Hpp"
#include    "TestKernel_ErrorIds.Hpp"
#include    "TestKernel_MessageIds.Hpp"
#include    "TestKernel_ResourceIds.H"


// ----------------------------------------------------------------------------
//  Define a small record that is used by the main module to set up a list
//  of test functions and their names. We have to provide a function
//  prototype that all of the test functions use.
// ----------------------------------------------------------------------------
typedef tCIDLib::TVoid (*TTestFunction)();

struct TTestFuncRecord
{
    TTestFunction           pfnTester;
    const tCIDLib::Tch*     pszName;
    tCIDLib::TBoolean       bRun;
};


// ----------------------------------------------------------------------------
//  Intrafacility stuff from TestKernel.Cpp
// ----------------------------------------------------------------------------
extern TKrnlModule kmodTestKernel;
