//
//  FILE NAME: TestCIDWnd_MyWindow.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 06/04/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the TestCIDWnd_MyWinodw.Cpp module. This module
//  implements a simple derivative of TWindow to use as the main window of
//  the program.
//
//  CAVEATS/GOTCHAS:
//


// -----------------------------------------------------------------------------
//  CLASS: TMyWindow
// PREFIX: wnd
// -----------------------------------------------------------------------------
class TMyWindow : public TWindow
{
    RTTIMacros(TMyWindow,TWindow)

    public  :
        // ---------------------------------------------------------------------
        // Constructors and destructors
        // ---------------------------------------------------------------------
        TMyWindow(const tCIDWnd::TWindowId widToUse) :

            TWindow(widToUse)
        {
            SetBorder(new T3DBorder(3, tCIDWnd::E3DBorder_Raised));
        }

        ~TMyWindow() {}


        tCIDLib::TVoid Create
        (
            const   TWindow&                wndParent
            , const TString&                strText
            , const tCIDWnd::EWndStyles     eStyles
            , const TArea&                  areaInit = NUL_TArea
        );


    protected :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _Created
        (
            const   TArea&                  areaInit
        );

        tCIDWnd::EEventResponses _eClick
        (
            const   tCIDWnd::EMouseButtons  eButton
            , const tCIDWnd::EMouseClicks   eClickType
            , const TPoint&                 pntAt
            , const tCIDLib::TBoolean       bControlDown
            , const tCIDLib::TBoolean       bShiftDown
        );

        tCIDLib::TVoid _EraseBgn
        (
                    TGraphicDevice&         gdevTouse
            , const TArea&                  areaUpdate
        );

        tCIDLib::TVoid _Paint
        (
                    TGraphicDevice&         gdevTouse
            , const TArea&                  areaUpdate
        );
};

inline tCIDLib::TVoid
TMyWindow::Create(  const   TWindow&            wndParent
                    , const TString&            strText
                    , const tCIDWnd::EWndStyles eStyles
                    , const TArea&              areaInit)
{
    _Create(wndParent, strText, eStyles, areaInit);
}
