//
//  FILE NAME: TestCIDWnd_MyWindow.Cpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 06/04/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This module implements the TMyWindow class, which is our simple derivative
//  of TWindow. We use one of these as our main window.
//
//  CAVEATS/GOTCHAS:
//

// ----------------------------------------------------------------------------
//  Includes
// ----------------------------------------------------------------------------
#include    "TestCIDWnd.Hpp"


// ----------------------------------------------------------------------------
//  Do our RTTI macros
// ----------------------------------------------------------------------------
RTTIData(TMyWindow,TWindow)


// -----------------------------------------------------------------------------

//  CLASS: TMyWindow
// PREFIX: wnd
// -----------------------------------------------------------------------------

tCIDLib::TVoid TMyWindow::_Created(const TArea& areaInit)
{
}


tCIDWnd::EEventResponses
TMyWindow::_eClick( const   tCIDWnd::EMouseButtons  eButton
                    , const tCIDWnd::EMouseClicks   eClickType
                    , const TPoint&                 pntAt
                    , const tCIDLib::TBoolean       bControlDown
                    , const tCIDLib::TBoolean       bShiftDown)
{
    if ((eButton == tCIDWnd::EMouseButton_Left)
    &&  (eClickType == tCIDWnd::EMouseClick_Double))
    {
        TFacCIDWnd::ExitMessageLoop(0);
        return tCIDWnd::EEventResponse_Handled;
    }
    return tCIDWnd::EEventResponse_Propogate;
}


tCIDLib::TVoid
TMyWindow::_EraseBgn(TGraphicDevice& gdevToUse, const TArea& areaUpdate)
{
    gdevToUse.Fill(areaUpdate, TRGBClr(tCIDLib::ESysClr_DialogBgn));
}


tCIDLib::TVoid
TMyWindow::_Paint(TGraphicDevice& gdevToUse, const TArea& areaUpdate)
{
    // Call our parent to draw the border
    TParent::_Paint(gdevToUse, areaUpdate);

    // Get the height of a string with the current font
    TArea areaText = gdevToUse.areaString(L"Testing");
    tCIDLib::TCard4 c4Height = areaText.c4Height();

    // Create a starting point for the text
    TPoint pntText(10, 10);

    gdevToUse.SetTextColor(TRGBClr(0, 0xFF, 00));
    gdevToUse.c4DrawText(L"Testing, 1, 2, 3", pntText);

    gdevToUse.SetTextColor(TRGBClr(0, 0, 0xFF));
    pntText.Adjust(0, c4Height+4);
    gdevToUse.c4DrawText(L"Testing, 1, 2, 3", pntText);

    // Set up two different pens
    TPen penText1(TRGBClr(0, 0xFF, 0));
    TPen penText2(TRGBClr(0, 0, 0xFF));
}
