//
//  FILE NAME: TestCIDWnd.Cpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 05/28/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the main module of the program. This program tests the
//  services of the CIDWnd.Dll facility.
//
//  CAVEATS/GOTCHAS:
//

// ----------------------------------------------------------------------------
//  Includes
// ----------------------------------------------------------------------------
#include    "TestCIDWnd.Hpp"


// ----------------------------------------------------------------------------
//  Local data
//
//  __pszTitle1
//  __pszTitle2
//      Titles used in emergency popups
// ----------------------------------------------------------------------------
const tCIDLib::Tch* const   __pszTitle1 = L"TestCIDWnd.Exe";
const tCIDLib::Tch* const   __pszTitle2 = L"CIDLib Windowing Tester";


// ----------------------------------------------------------------------------
//  Forward references
// ----------------------------------------------------------------------------
static tCIDLib::EExitCodes __eMainThreadFunc
(
        TThread&            thrThis
        , tCIDLib::TVoid*   pData
);


// ----------------------------------------------------------------------------
//  Magic main module code
// ----------------------------------------------------------------------------
CIDLib_MainGUIModule(TThread(L"MainThread", __eMainThreadFunc))



// ----------------------------------------------------------------------------
//  Local functions
// ----------------------------------------------------------------------------

static tCIDLib::EExitCodes __eMainThreadFunc(TThread& thrThis, tCIDLib::TVoid*)
{
    // We have to let our calling thread go first
    thrThis.Sync();

    // Set the processes state to terminating
    TProcessRegistry::SetProcessState(tCIDLib::EProcState_Ready);

    tCIDLib::TUInt uReturn = 0;
    try
    {
        // Create a window object
        TMyWindow wndTest(1);
        wndTest.Create
        (
            NUL_TWindow
            , L"This is the text"
            , tCIDWnd::EWndStyles
              (
                tCIDWnd::EWndStyle_Visible
              )
            , TArea(10, 10, 200, 200)
        );

        // Enter the message loop
        uReturn = TFacCIDWnd::uMessageLoop();
    }

    //
    //  Since this is a test program just catch all exceptions so that
    //  we will know that we died during testing since we can put break
    //  points here.
    //
    //  We use ESev_Status for all of the logging here so that they don't
    //  cause more throws.
    //
    catch(const TError& errToCatch)
    {
        TFacCIDLib::PopUpErr
        (
            __FILE__
            , __LINE__
            , __pszTitle1
            , __pszTitle2
            , errToCatch.errcId()
            , errToCatch.errcKrnlId()
            , errToCatch.errcHostId()
            , errToCatch.strErrText().pszData()
            , errToCatch.strAuxText().pszData()
        );
    }

    // Make sure that kernel errors get logged
    catch(const TKrnlError& kerrToCatch)
    {
        facCIDLib.LogKrnlErr
        (
            __FILE__
            , __LINE__
            , 0
            , kerrToCatch
            , tCIDLib::ESev_Status
            , tCIDLib::EClass_Internal
        );

        TFacCIDLib::PopUpErr
        (
            __FILE__
            , __LINE__
            , __pszTitle1
            , __pszTitle2
            , 0
            , kerrToCatch.errcId()
            , kerrToCatch.errcHostId()
            , L"A kernel error occured"
            , kCIDLib::pszEmptyZStr
        );
    }

    catch(...)
    {
        facCIDLib.LogMsg
        (
            __FILE__
            , __LINE__
            , L"An unknown exception occured"
            , tCIDLib::ESev_Status
            , tCIDLib::EClass_Internal
        );

        TFacCIDLib::PopUpMsg
        (
            __FILE__
            , __LINE__
            , __pszTitle1
            , __pszTitle2
            , L"An unknown exception occured"
            , kCIDLib::pszEmptyZStr
        );
    }

    // Set the processes state to terminating
    TProcessRegistry::SetProcessState(tCIDLib::EProcState_Terminating);

    return tCIDLib::EExitCodes(uReturn);
}
