//
//  FILE NAME: TestCIDLib.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/23/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the main header for the facility. It includes anything that is
//  needed by our program, and is the precompiled headers file.
//
//
//  CAVEATS/GOTCHAS:
//

// ----------------------------------------------------------------------------
//  Bring in the CIDLib facility header that we are testing. Also bring in
//  the special memory checking header which is not normally included.
// ----------------------------------------------------------------------------
#include    "CIDLib.Hpp"
#include    "CIDKernel_MemCheck.Hpp"


// ----------------------------------------------------------------------------
//  Bring in any intrafacility headers that we have
// ----------------------------------------------------------------------------
#include    "TestCIDLib_ResourceIds.H"
#include    "TestCIDLib_ErrorIds.Hpp"
#include    "TestCIDLib_MessageIds.Hpp"


// ----------------------------------------------------------------------------
//  A tiny little class that allows me to easily format the current file and
//  line to the output stream.
// ----------------------------------------------------------------------------
class TCurLn
{
    public :
        TCurLn(   const   tCIDLib::Tsch* const  pszFile
                  , const tCIDLib::TCard4       c4Line) :
            __pszFile(0)
            , __c4Line(c4Line)
        {
            __pszFile = TRawStr::pszConvert(pszFile);
        }

        ~TCurLn()
        {
            delete __pszFile;
        }

        tCIDLib::Tch*   __pszFile;
        tCIDLib::TCard4 __c4Line;
};

inline TTextStream& operator<<(TTextStream& strmOut, const TCurLn& Cur)
{
    strmOut << L"(" << Cur.__pszFile << L"." << Cur.__c4Line << L") - ";
    return strmOut;
}

#define _CurLn_ TCurLn(__FILE__, __LINE__)



// ----------------------------------------------------------------------------
//  CLASS: TFacTestCIDLib
// PREFIX: fac
// ----------------------------------------------------------------------------
class TFacTestCIDLib : public TFacility
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors.
        // --------------------------------------------------------------------
        TFacTestCIDLib();

        ~TFacTestCIDLib();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        static tCIDLib::TVoid Announce();

        static TTextStream& strmOut();

        static tCIDLib::TVoid ShowSystemInfo();

        static tCIDLib::TVoid ShowTests();

        static tCIDLib::TVoid TestBaseArrays();

        static tCIDLib::TVoid TestBags();

        static tCIDLib::TVoid TestBinStreams();

        static tCIDLib::TVoid TestCoordinates();

        static tCIDLib::TVoid TestDeques();

        static tCIDLib::TVoid TestEnvironment();

        static tCIDLib::TVoid TestFiles();

        static tCIDLib::TVoid TestHashMap();

        static tCIDLib::TVoid TestHashSet();

        static tCIDLib::TVoid TestMemoryClasses();

        static tCIDLib::TVoid TestNumericClasses();

        static tCIDLib::TVoid TestObjArrays();

        static tCIDLib::TVoid TestPointerClasses();

        static tCIDLib::TVoid TestProcess();

        static tCIDLib::TVoid TestQueues();

        static tCIDLib::TVoid TestRTTI();

        static tCIDLib::TVoid TestSearchSort();

        static tCIDLib::TVoid TestStacks();

        static tCIDLib::TVoid TestStrings();

        static tCIDLib::TVoid TestTextStreams();

        static tCIDLib::TVoid TestTime();


    private :
        // ---------------------------------------------------------------------
        //  Unimplimented constructors and operators
        // ---------------------------------------------------------------------
        TFacTestCIDLib(const TFacTestCIDLib&);

        tCIDLib::TVoid operator=(const TFacTestCIDLib&);


        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __pstrmOutput
        //      This is the stream to which all output will go. This allows
        //      us to redirect the output to where it is desired.
        // ---------------------------------------------------------------------
        static TTextStream*     __pstrmOutput;
};

// ----------------------------------------------------------------------------
//  Public, non-virtual methods
// ----------------------------------------------------------------------------
inline TTextStream& TFacTestCIDLib::strmOut()
{
    return *__pstrmOutput;
}


// ----------------------------------------------------------------------------
//  Let everyone see the facility object
// ----------------------------------------------------------------------------
extern TFacTestCIDLib   facTestCIDLib;


// ----------------------------------------------------------------------------
//  Define a small record that is used by the main module to set up a list
//  of test functions and their names. We have to provide a function
//  prototype that all of the test functions use.
// ----------------------------------------------------------------------------
typedef tCIDLib::TVoid (*TTestFunction)();

struct TTestFuncRecord
{
    TTestFunction           pfnTester;
    const tCIDLib::Tch*     pszName;
    tCIDLib::TBoolean       bRun;
};
