//
// NAME: TestCIDCrypto_Xor.Cpp
//
// DESCRIPTION:
//
//  This module is part of the TestCIDCrypto.Exe program and is called from
//  the program's main() function. The functions in this module test the
//  Xor encryption class.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 10/22/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//
// MODIFICATION LOG:
//


// -----------------------------------------------------------------------------
//  Facility specific includes
// -----------------------------------------------------------------------------
#include    "TestCIDCrypto.Hpp"


// -----------------------------------------------------------------------------
//  TFacTestCIDCrypto: Public, static methods
// -----------------------------------------------------------------------------

//
// FUNCTION/METHOD NAME: TestXor
//
// DESCRIPTION:
//
//  This method tests the Xor encryptor.
// ---------------------------------------
//   INPUT: None
//
//  OUTPUT: None
//
//  RETURN: None
//
tCIDLib::TVoid TFacTestCIDCrypto::TestXor()
{
    const tCIDLib::Tch* pszCurTest = L"None";
    try
    {
        TKrnlMemCheck kmchkTest;

        // Do the common tests, which are all we have for this class
        pszCurTest = L"Common";
        TXorEncrypter crypToTest;
        CommonTests(crypToTest);
    }

    catch(...)
    {
        strmOut()   << L"Exception occured during the " << pszCurTest
                    << L" Xor test" << NewLn;
        throw;
    }
}
