//
//  FILE NAME: TestCIDCrypto_Common.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 10/22/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This header provides some common tests that all encryptors need to be
//  able to do. It looks at them all via the basic interface and just does
//  some encryption and decryption of some standard data buffers and makes
//  sure that they are symmetric and gets back the original plain text.
//
//  CAVEATS/GOTCHAS:
//


// -----------------------------------------------------------------------------
//  Facility specific includes
// -----------------------------------------------------------------------------
#include    "TestCIDCrypto.Hpp"



// -----------------------------------------------------------------------------
//  Local data
//
//  __apszPlainText
//      A UNICode plain text buffer to translate.
// -----------------------------------------------------------------------------
static const tCIDLib::Tch* const    __apszPlainText = 
{
    L"This is a test of the encryption of some UNICode text. UNICode text is "
    L"kind of special because a lot of the time it will have every other byte "
    L"as a zero. And its also sensitive to byte order since each char is two "
    L"bytes in size, as apposed to ANSI text which is single byte.\r\n"
    L"What can you say about this kind of text? Its really the kind of text "
    L"that makes a man swell with pride as he reads it. And men now abed in "
    L"England shall hold their manhood cheap, as any speaks who fought with "
    L"us here upon Saint Crispen's day. blah blah blah"
};



// -----------------------------------------------------------------------------
//  TFacTestCIDCrypto: Public, static methods
// -----------------------------------------------------------------------------

//
// FUNCTION/METHOD NAME: CommonTests
//
// DESCRIPTION:
//
//  This method provide a common test that just runs some data through all
//  of the encryptors that it is given.
// ---------------------------------------
//   INPUT: None
//
//  OUTPUT: None
//
//  RETURN: None
//
tCIDLib::TVoid TFacTestCIDCrypto::CommonTests(TEncrypter& crypToTest)
{
    tCIDLib::TCard4     c4BytesDone;
    tCIDLib::TCard4     c4BytesToDo;

    //
    //  Create a memory buffer to encrypt into. This one is just made
    //  big enough to hold any cypher text that our tests will ever
    //  create. The cypher text can often be larger than the plain text
    //  and there is no way to know for sure, so you just have to have
    //  plenty of room. Memory buffers can auto expand, so you don't have
    //  to commit it all up front.
    //
    THeapBuf mbufCypher(512, 2048);

    //
    //  First do an encryption of a string. So we put the predefined text
    //  above into the string.
    //
    TString strToUse(__apszPlainText);
    c4BytesDone = crypToTest.c4Encrypt(strToUse, mbufCypher);

    //
    //  Calculate how many bytes should have been done. This is the length
    //  of the text in bytes rounded up to the next even block size of the
    //  passed encrypter.
    //
    c4BytesToDo = strToUse.c4Length() * kCIDLib::c4CharBytes;
    if (c4BytesToDo % crypToTest.c4BlockSize())
    {
        c4BytesToDo = ((c4BytesToDo / crypToTest.c4BlockSize()) + 1)
                        * crypToTest.c4BlockSize();
    }

    // Make sure it did the number of bytes expected
    if (c4BytesDone != c4BytesToDo)
    {
        strmOut() << _CurLn_ << L"Bytes encrypted was wrong. Expected: "
                  << c4BytesToDo << L" but got: " << c4BytesDone << NewLn;
        return;
    }

    //
    //  Now decrypt the data and make sure it comes back as it should,
    //  i.e. we get the same text back.
    //
    strToUse.Clear();
    c4BytesDone = crypToTest.c4Decrypt(mbufCypher, strToUse, c4BytesToDo);

    if (c4BytesDone != c4BytesToDo)
    {
        strmOut() << _CurLn_ << L"Bytes decrypted was wrong. Expected: "
                  << c4BytesToDo << L" but got: " << c4BytesDone << NewLn;
        return;
    }

    // And make sure the text is the same
    if (strToUse != __apszPlainText)
    {
        strmOut() << _CurLn_ << L"Decrypted text not equal to original" << NewLn;
        return;
    }


    //
    //  Now lets build up a 
}
