//
//  FILE NAME: TestCIDCrypto.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 10/22/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the main header for the facility. It includes anything that is
//  needed by our program, and is the precompiled headers file.
//
//  CAVEATS/GOTCHAS:
//

// ----------------------------------------------------------------------------
//  Bring in the CIDCrypto facility header that we are testing. Also bring in
//  the special memory checking header which is not normally included.
// ----------------------------------------------------------------------------
#include    "CIDCrypto.Hpp"
#include    "CIDKernel_MemCheck.Hpp"


// ----------------------------------------------------------------------------
//  Bring in any intrafacility headers that we have
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
//  A tiny little class that allows me to easily format the current file and
//  line to the output stream.
// ----------------------------------------------------------------------------
class TCurLn
{
    public :
        TCurLn(   const   tCIDLib::Tsch* const  pszFile
                  , const tCIDLib::TCard4       c4Line) :
            __pszFile(0)
            , __c4Line(c4Line)
        {
            __pszFile = TRawStr::pszConvert(pszFile);
        }

        ~TCurLn()
        {
            delete __pszFile;
        }

        tCIDLib::Tch*   __pszFile;
        tCIDLib::TCard4 __c4Line;
};

inline TTextStream& operator<<(TTextStream& strmOut, const TCurLn& Cur)
{
    strmOut << L"(" << Cur.__pszFile << L"." << Cur.__c4Line << L") - ";
    return strmOut;
}

#define _CurLn_ TCurLn(__FILE__, __LINE__)



// ----------------------------------------------------------------------------
//  CLASS: TFacTestCIDCrypto
// PREFIX: fac
// ----------------------------------------------------------------------------
class TFacTestCIDCrypto : public TFacility
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors.
        // --------------------------------------------------------------------
        TFacTestCIDCrypto();

        ~TFacTestCIDCrypto();


        // --------------------------------------------------------------------
        //  Public, static methods
        // --------------------------------------------------------------------
        static tCIDLib::TVoid Announce();

        static tCIDLib::TVoid CommonTests
        (
                    TEncrypter&             crypToTest
        );

        static TTextStream& strmOut();

        static tCIDLib::TVoid ShowTests();

        static tCIDLib::TVoid TestBlowfish();

        static tCIDLib::TVoid TestXor();


    private :
        // ---------------------------------------------------------------------
        //  Unimplimented constructors and operators
        // ---------------------------------------------------------------------
        TFacTestCIDCrypto(const TFacTestCIDCrypto&);

        tCIDLib::TVoid operator=(const TFacTestCIDCrypto&);


        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __pstrmOutput
        //      This is the stream to which all output will go. This allows
        //      us to redirect the output to where it is desired.
        // ---------------------------------------------------------------------
        static TTextStream*     __pstrmOutput;
};

// ----------------------------------------------------------------------------
//  Public, non-virtual methods
// ----------------------------------------------------------------------------
inline TTextStream& TFacTestCIDCrypto::strmOut()
{
    return *__pstrmOutput;
}


// ----------------------------------------------------------------------------
//  Let everyone see the facility object
// ----------------------------------------------------------------------------
extern TFacTestCIDCrypto   facTestCIDCrypto;


// ----------------------------------------------------------------------------
//  Define a small record that is used by the main module to set up a list
//  of test functions and their names. We have to provide a function
//  prototype that all of the test functions use.
// ----------------------------------------------------------------------------
typedef tCIDLib::TVoid (*TTestFunction)();

struct TTestFuncRecord
{
    TTestFunction           pfnTester;
    const tCIDLib::Tch*     pszName;
    tCIDLib::TBoolean       bRun;
};
