//
// NAME: MakeDocs_Translator.Hpp
//
// DESCRIPTION: 
//
//  This header defines the interface for the class that translates our
//  generic formatting tags to the desired target format. This is an
//  abstract base class from which actual translator classes are derived.
//
//  The supported formatting tags are defined by the ETags enum.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/10/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//
// MODIFICATION LOG: 
//


// ----------------------------------------------------------------------------
//  Forward references
// ----------------------------------------------------------------------------
class   TDocParser;


// ----------------------------------------------------------------------------
//  CLASS: TTranslator
// PREFIX: trans
// ----------------------------------------------------------------------------
class TTranslator : public TObject
{
    RTTIMacros(TTranslator,TObject)

    public:
        // --------------------------------------------------------------------
        //  Public types
        // --------------------------------------------------------------------
        enum ETags
        {
            ETag_None
            , ETag_Bold
            , ETag_Break
            , ETag_Divider
            , ETag_EndBold
            , ETag_EndHeading1
            , ETag_EndHeading2
            , ETag_EndHeading3
            , ETag_EndParagraph
            , ETag_EndItalic
            , ETag_EndList
            , ETag_EndSource
            , ETag_EndTable
            , ETag_EndTableCol1
            , ETag_EndTableCol2
            , ETag_Heading1
            , ETag_Heading2
            , ETag_Heading3
            , ETag_Indent
            , ETag_Italic
            , ETag_List
            , ETag_ListItem
            , ETag_Outdent
            , ETag_Paragraph
            , ETag_Source
            , ETag_Table
            , ETag_TableCol1
            , ETag_TableCol2
        };


        // --------------------------------------------------------------------
        //  Constructors and Destructors.
        // --------------------------------------------------------------------
        TTranslator
        (
            const   TString&                strSpecialChars
        );

        virtual ~TTranslator();


        // --------------------------------------------------------------------
        //  Public, virtual methods
        // --------------------------------------------------------------------
        virtual tCIDLib::TVoid OutputLink
        (
            const   TString&                strLinkText
            , const TString&                strLinkTarget
        ) = 0;

        virtual tCIDLib::TVoid OutputPageFooter() = 0;

        virtual tCIDLib::TVoid OutputPageHeader
        (
            const   TString&                strTitle
        ) = 0;

        virtual tCIDLib::TVoid OutputTag
        (
            const   ETags                   eTag
        ) = 0;

        virtual const TString& strFileExtension() const = 0;

        virtual tCIDLib::TVoid TranslateSpecialChar
        (
            const   tCIDLib::Tch            chToXlat
        ) = 0;


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid SetOutputStream
        (
                    TTextStream&            strmOut
        );

        tCIDLib::TVoid TranslateTagText
        (
                    TDocParser&             prsrSource
        );


    protected :
        // --------------------------------------------------------------------
        //  Protected, non-virtual methods
        // --------------------------------------------------------------------
        TTextStream& strmOut();


    private :
        // --------------------------------------------------------------------
        //  Private, non-virtual methods
        // --------------------------------------------------------------------
        TTranslator::ETags __eMapToTag
        (
            const   TString&                strToken
        );


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __pstrmTarget
        //      This is the output stream to output our translated text to.
        //
        //  __strSpecialChars
        //      This is a list of special chars that the derived class can
        //      provide us. When the TranslateTagText() method sees one, it
        //      will let the derived class output by calling the method
        //      TranslateSpecialChar().
        // --------------------------------------------------------------------
        TTextStream*        __pstrmTarget;
        TString             __strSpecialChars;
};

// ----------------------------------------------------------------------------
//  Constructors and destructors
// ----------------------------------------------------------------------------
inline TTranslator::~TTranslator()
{
}


// ----------------------------------------------------------------------------
//  Public, non-virtual methods
// ----------------------------------------------------------------------------
inline tCIDLib::TVoid
TTranslator::SetOutputStream(TTextStream& strmOut)
{
    __pstrmTarget = &strmOut;
}


// ----------------------------------------------------------------------------
//  Protected, non-virtual methods
// ----------------------------------------------------------------------------
inline TTextStream& TTranslator::strmOut()
{
    return *__pstrmTarget;
}
