//
// NAME: MakeDocs_ThisFacility.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the MakeDocs_ThisFacility.Cpp module. This module
//  implements the facility class for this program.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/10/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//
// MODIFICATION LOG: 
//


// ----------------------------------------------------------------------------
//  CLASS: TFacMakeDocs
// PREFIX: fac
// ----------------------------------------------------------------------------
class TFacMakeDocs : public TFacility
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors.
        // --------------------------------------------------------------------
        TFacMakeDocs();

        ~TFacMakeDocs();


        // --------------------------------------------------------------------
        //  Public, non-static methods
        // --------------------------------------------------------------------
        tCIDLib::TBoolean bParseCommandLine();

        tCIDLib::TVoid GenerateDocs();

        TTextStream& strmOut();

        tCIDLib::TVoid ShowBlurb();


    private :
        // --------------------------------------------------------------------
        //  Private, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TBoolean __bCheckPath
        (
            const   TString&                strToCheck
            , const tCIDLib::TBoolean       bCreateOk = kCIDLib::False
        );

        tCIDLib::TBoolean __bOutOfDate
        (
            const   TString&                strFileToCheck
            , const TString&                strSourceFile
        );

        tCIDLib::TVoid __CopyFiles
        (
            const   TString&                strSubDir
        );

        tCIDLib::TVoid __DoSubSystem
        (
            const   TString&                strSubName
        );

        tCIDLib::TVoid __GenSubSystemPage
        (
            const   TString&                strSubName
        );

        tCIDLib::TVoid __TranslateOverview
        (
                    TDocParser&             prsrSource
            , const TString&                strFileName
        );

        tCIDLib::TVoid __TranslateMethod
        (
                    TDocParser&             prsrSource
            , const TString&                strMethodName
            , const TString&                strFileName
        );

        tCIDLib::TVoid __TranslateSource
        (
                    TDocParser&             prsrSource
            ,       TTextStream&            strmTarget
        );


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __bForceUpdate
        //      This is set if the user uses the /FORCE option on the command
        //      line. This will force all files to be updated, even if they
        //      are not out of date.
        //
        //  __conOut
        //      This is our console object for user interaction. TConsole is
        //      a specialized text stream class that provides command recall
        //      and editing (i.e. it allows you to turn a program into a
        //      command shell type of interface easily.)
        //
        //  __pathSourceDir
        //  __pathTargetDir
        //      These are the paths to the source directory, where the
        //      ClassDoc files are, and the output directory, where we put
        //      the corresponding formatted files.
        //
        //  __ptransOut
        //      This is the translator object that handles the translation of
        //      formatting tags to the output.
        // --------------------------------------------------------------------
        tCIDLib::TBoolean   __bForceUpdate;
        TConsole            __conOut;
        TPathStr            __pathSourceDir;
        TPathStr            __pathTargetDir;
        TTranslator*        __ptransOut;
};

inline TTextStream& TFacMakeDocs::strmOut()
{
    return __conOut;
}
