//
// NAME: MakeDocs_ParseError.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the MakeDocs_ParseError.Cpp module. This module
//  implements the TDocError class, which is the exception thrown when an
//  error occurs during parsing. It contains the info that should be shown
//  to the caller.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/10/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


// ----------------------------------------------------------------------------
//  CLASS: TDocError
// PREFIX: err
// ----------------------------------------------------------------------------
class TDocError : public TObject
{
    RTTIMacros(TDocError,TObject)

    public  :
        // --------------------------------------------------------------------
        //  Constructors and destructors
        // --------------------------------------------------------------------
        TDocError
        (
            const   tCIDLib::TErrCode       errcId
            , const tCIDLib::TCard4         c4SourceLine
        );

        TDocError
        (
            const   tCIDLib::TErrCode       errcId
            , const tCIDLib::TCard4         c4SourceLine
            , const TString&                strText1
            , const TString&                strText2 = NUL_TString
        );

        ~TDocError();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TCard4 c4Line() const;

        tCIDLib::TErrCode errcId() const;

        const TString& strText() const;

    private :
        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __c4SourceLine
        //      This is the line in the source file where the error occured.
        //
        //  __errcId
        //      This is the id of the error that was thrown.
        //
        //  __strText
        //      The text of the error.
        // --------------------------------------------------------------------
        tCIDLib::TCard4     __c4SourceLine;
        tCIDLib::TErrCode   __errcId;
        TString             __strText;
};

inline tCIDLib::TCard4 TDocError::c4Line() const
{
    return __c4SourceLine;
}

inline tCIDLib::TErrCode TDocError::errcId() const
{
    return __errcId;
}

inline const TString& TDocError::strText() const
{
    return __strText;
}
