//
// NAME: MakeDocs_ParserError.Cpp
//
// DESCRIPTION: 
//
//  This module implements the TDocError class, which is the exception thrown
//  when parsing errors occur.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/10/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//

// -----------------------------------------------------------------------------
//  Include underlying headers.
// -----------------------------------------------------------------------------
#include    "MakeDocs.Hpp"


// -----------------------------------------------------------------------------
//   CLASS: TDocError
//  PREFIX: err
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//  TDocError: Constructors and destructors
// -----------------------------------------------------------------------------

//
// FUNCTION/METHOD NAME: TDocParser
//
// DESCRIPTION:
//
// -------------------------------------
//   INPUT: strmSource is the source stream to parse from. It is not adopted
//              in this case.
//
//  OUTPUT: None
//
//  RETURN: None
//
TDocError::TDocError(   const   tCIDLib::TErrCode   errcId
                        , const tCIDLib::TCard4     c4SourceLine) :

    __c4SourceLine(c4SourceLine)
    , __errcId(errcId)
    , __strText(kCIDLib::pszEmptyZStr, 1024)
{
    facMakeDocs.LoadCIDMsg(errcId, __strText);
}

TDocError::TDocError(   const   tCIDLib::TErrCode   errcId
                        , const tCIDLib::TCard4     c4SourceLine
                        , const TString&            strText1
                        , const TString&            strText2) :

    __c4SourceLine(c4SourceLine)
    , __errcId(errcId)
    , __strText(kCIDLib::pszEmptyZStr, 1024)
{
    // Load the message
    facMakeDocs.LoadCIDMsg(errcId, __strText, strText1, strText2);
}

TDocError::~TDocError()
{
}
