//
// NAME: MakeDocs_Parser.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the MakeDocs_Parser.Cpp module, which implements
//  the TDocParser class. This class is a derivative of the standard text
//  stream parser, from CIDLib.Dll. Our derivative just adds a little value
//  by building on the functionality of the base parser class.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/10/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//
//  1)  We don't tell the underlying parser to adopt the stream.
//
//  2)  eNextToken() provides the smarts to look for our own higher level
//      tokens (e.g. @Description and whatnot.) It will get the next token,
//      and translate it to one of the tag enums supported by the syntax.
//      If the tag is not a valid tag, it ungets the token and returns the
//      ETag_None value.
//
// MODIFICATION LOG: 
//


// ----------------------------------------------------------------------------
//  CLASS: TDocParser
// PREFIX: prsr
// ----------------------------------------------------------------------------
class TDocParser : public TStreamParser
{
    public  :
        // --------------------------------------------------------------------
        //  Public types
        //
        //  ETokens
        //      This enum represents the available tokens in the source.
        //      These are the actual syntax tokens, but not the embedded
        //      formatting tags. They are dealt with separately.
        //
        //      These MUST be in alphabetical order because its used to
        //      access an array internally which is in this order. The
        //      special ones must be at the end because they have no array
        //      entries.
        // --------------------------------------------------------------------
        enum ETokens
        {
            EToken_Caveats          // @Caveats
            , EToken_Class          // @Class
            , EToken_Description    // @Description
            , EToken_EndExceptions  // @EndExceptions
            , EToken_EndMethod      // @EndMethod
            , EToken_EndOverview    // @EndOverview
            , EToken_EndParams      // @EndParams
            , EToken_Exception      // @Exception
            , EToken_Exceptions     // @Exceptions
            , EToken_Facility       // @Facility
            , EToken_Group          // @Group
            , EToken_Header         // @Header
            , EToken_Method         // @Method
            , EToken_Mixins         // @Mixins
            , EToken_Overview       // @Overview
            , EToken_Param          // @Param
            , EToken_Params         // @Params
            , EToken_ParentClass    // @Parent
            , EToken_Prefix         // @Prefix
            , EToken_Related        // @Related
            , EToken_Return         // @Return
            , EToken_Comment

            // These are special ones for parsing purposes
            , EToken_None
            , EToken_End
        };


        // --------------------------------------------------------------------
        //  Constructors and Destructors.
        // --------------------------------------------------------------------
        TDocParser
        (
                    TTextStream&            strmSource
            , const TString&                strClassName
        );

        ~TDocParser();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        TDocParser::ETokens eNextToken();

        const TString& strClassName() const;

        TString strTokenText
        (
            const   ETokens                 eToken
        )   const;


    private :
        // --------------------------------------------------------------------
        //  Private, non-static methods
        // --------------------------------------------------------------------
        TDocParser::ETokens __eMapToken
        (
            const   TString&                strText
        )   const;


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __strClassName
        //      The name of the class whose file we are parsing.
        // --------------------------------------------------------------------
        TString     __strClassName;
};

extern TTextStream& operator<<
(
            TTextStream&        strmOut
    , const TDocParser::ETokens eToken
);

inline const TString& TDocParser::strClassName() const
{
    return __strClassName;
}
