//
// NAME: MakeDocs_HtmlTranslator.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the MakeDocs_HtmlTranslator.Cpp module. This
//  module implements a derivative of the abstract TTranslator class. This
//  derivative handles translations for the HTML format.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/10/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//
// MODIFICATION LOG: 
//

// ----------------------------------------------------------------------------
//  CLASS: THtmlTranslator
// PREFIX: trans
// ----------------------------------------------------------------------------
class THtmlTranslator : public TTranslator
{
    RTTIMacros(THtmlTranslator,TTranslator)

    public :
        // --------------------------------------------------------------------
        //  Constructors and Destructors.
        // --------------------------------------------------------------------
        THtmlTranslator();

        ~THtmlTranslator();


        // --------------------------------------------------------------------
        //  Public, inherited methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid OutputLink
        (
            const   TString&                strLinkText
            , const TString&                strLinkTarget
        );

        tCIDLib::TVoid OutputPageFooter();

        tCIDLib::TVoid OutputPageHeader
        (
            const   TString&                strTitle
        );

        tCIDLib::TVoid OutputTag
        (
            const   ETags                   eTag
        );

        const TString& strFileExtension() const;

        tCIDLib::TVoid TranslateSpecialChar
        (
            const   tCIDLib::Tch            chToXlat
        );


    private :
        // --------------------------------------------------------------------
        //  Private, static data members
        //
        //  __strExtension
        //      This is the text for the extension we use ("Html"). Its
        //      returned from strFileExtension().
        // --------------------------------------------------------------------
        static TString  __strExtension;
};


// ----------------------------------------------------------------------------
//  Constructors and destructors
// ----------------------------------------------------------------------------
inline THtmlTranslator::THtmlTranslator() :

    TTranslator(L"<>&")
{
}

inline THtmlTranslator::~THtmlTranslator()
{
}

// ----------------------------------------------------------------------------
//  Public, inherited methods
// ----------------------------------------------------------------------------
inline const TString& THtmlTranslator::strFileExtension() const
{
    return __strExtension;
}
