//
// NAME: MakeDocs_HtmlTranslator.Cpp
//
// DESCRIPTION: 
//
//  This module implements the Html derivative of the abstract translator
//  class. This guy outputs HTML tags to the provided output text stream.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/10/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//

// -----------------------------------------------------------------------------
//  Include underlying headers.
// -----------------------------------------------------------------------------
#include    "MakeDocs.Hpp"


// ----------------------------------------------------------------------------
//  Do our RTTI macros
// ----------------------------------------------------------------------------
RTTIData(THtmlTranslator,TTranslator)


// ----------------------------------------------------------------------------
//  CLASS: THtmlTranslator
// PREFIX: trans
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  THtmlTranslator: Public, inherited methods
// ----------------------------------------------------------------------------

//
// FUNCTION/METHOD NAME: OutputExtension
//
// DESCRIPTION:
//
//  This method outputs an hyperlink in the Html format. The link text is
//  what the user sees. The link target is the target file, just the base
//  name so we add the extension as required.
// -------------------------------------
//   INPUT: strLinkText is the text that the user should see for the link.
//          strLinkTarget is the target file to link to.
//
//  OUTPUT: None
//
//  RETURN: None
//
tCIDLib::TVoid
THtmlTranslator::OutputLink(const   TString&    strLinkText
                            , const TString&    strLinkTarget)
{
    // Build the file name
    TPathStr pathTarget(strLinkTarget);
    pathTarget.AppendExtension(__strExtension);

    strmOut() << L"<A HREF=\"" << pathTarget << L"\">"
              << strLinkText
              << L"</A>";
}


//
// FUNCTION/METHOD NAME: OutputPageFooter
//                       OutputPageTrailer
//
// DESCRIPTION:
//
//  These methods output any needed header and footer information for each
//  page. This includes the standard visual stuff plus any book keeping
//  stuff required by the output format.
// -------------------------------------
//   INPUT: strTitle is the title text for the page.
//
//  OUTPUT: None
//
//  RETURN: None
//
tCIDLib::TVoid
THtmlTranslator::OutputPageFooter()
{
    strmOut() << 
        L"<br><left><img src=\"MainFooter.Jpg\"></left>"

        L"</BODY>"
        L"</HTML>\r\n";
}

tCIDLib::TVoid THtmlTranslator::OutputPageHeader(const TString& strTitle)
{
    strmOut() <<
        L"<HMTL>\r\n"
        L"<HEAD>\r\n"
        L"<TITLE> " << strTitle << L"</TITLE>\r\n"
        L"<P>\r\n"
        L"<left><img src=\"ClassAndMemberHeader.Jpg\"></left>"
        L"</HEAD>\r\n"
        L"<BODY BGCOLOR=\"FFFFFF\"><br>\r\n\n";
}


//
// FUNCTION/METHOD NAME: OutputTag
//
// DESCRIPTION:
//
//  This method outputs the requested tag in the Html format.
// -------------------------------------
//   INPUT: eTag is the requested tag to output.
//
//  OUTPUT: None
//
//  RETURN: None
//
tCIDLib::TVoid THtmlTranslator::OutputTag(const ETags eTag)
{
    if (eTag == TTranslator::ETag_Bold)
        strmOut() << L"<B>";
    else if (eTag == TTranslator::ETag_Break)
        strmOut() << L"<BR>";
    else if (eTag == TTranslator::ETag_Divider)
        strmOut() << L"<HR WIDTH=85%>";
    else if (eTag == TTranslator::ETag_EndBold)
        strmOut() << L"</B>";
    else if (eTag == TTranslator::ETag_EndHeading1)
        strmOut() << L"</H2>";
    else if (eTag == TTranslator::ETag_EndHeading2)
        strmOut() << L"</H3>";
    else if (eTag == TTranslator::ETag_EndHeading3)
        strmOut() << L"</H4>";
    else if (eTag == TTranslator::ETag_EndItalic)
        strmOut() << L"</I>";
    else if (eTag == TTranslator::ETag_EndList)
        strmOut() << L"</UL>";
    else if (eTag == TTranslator::ETag_EndSource)
        strmOut() << L"</TT></B></PRE></BLOCKQUOTE>";
    else if (eTag == TTranslator::ETag_EndTable)
        strmOut() << L"</TABLE>";
    else if (eTag == TTranslator::ETag_EndTableCol1)
        strmOut() << L"</TD>";
    else if (eTag == TTranslator::ETag_EndTableCol2)
        strmOut() << L"</TD></TR>";
    else if (eTag == TTranslator::ETag_Heading1)
        strmOut() << L"<H2>";
    else if (eTag == TTranslator::ETag_Heading2)
        strmOut() << L"<H3>";
    else if (eTag == TTranslator::ETag_Heading3)
        strmOut() << L"<H4>";
    else if (eTag == TTranslator::ETag_Indent)
        strmOut() << L"<BLOCKQUOTE>";
    else if (eTag == TTranslator::ETag_Italic)
        strmOut() << L"<I>";
    else if (eTag == TTranslator::ETag_List)
        strmOut() << L"<UL>";
    else if (eTag == TTranslator::ETag_ListItem)
        strmOut() << L"<LI>";
    else if (eTag == TTranslator::ETag_Outdent)
        strmOut() << L"</BLOCKQUOTE>";
    else if (eTag == TTranslator::ETag_Paragraph)
        strmOut() << L"<P>";
    else if (eTag == TTranslator::ETag_Source)
        strmOut() << L"<BLOCKQUOTE><PRE><B><TT>";
    else if (eTag == TTranslator::ETag_Table)
        strmOut() << L"<TABLE CELLPADDING=10>";
    else if (eTag == TTranslator::ETag_TableCol1)
        strmOut() << L"<TR><TD VALIGN=\"TOP\">";
    else if (eTag == TTranslator::ETag_TableCol2)
        strmOut() << L"<TD VALIGN=\"TOP\" COLSPAN=5>";
    else
    {
        facMakeDocs.LogErr
        (
            __FILE__
            , __LINE__
            , kDocErrs::errcTransBadTag
            , tCIDLib::ESev_ProcessFatal
            , tCIDLib::EClass_Internal
            , TInteger(eTag)
        );
    }
}


//
// FUNCTION/METHOD NAME: TranslateSpecialChar
//
// DESCRIPTION:
//
//  This method will output the translated special character.
// -------------------------------------
//   INPUT: chToXlat is the character to translate and output.
//
//  OUTPUT: None
//
//  RETURN: None
//
tCIDLib::TVoid
THtmlTranslator::TranslateSpecialChar(const tCIDLib::Tch chToXlat)
{
    if (chToXlat == L'>')
        strmOut() << L"&gt;";
    else if (chToXlat == L'<')
        strmOut() << L"&lt;";
    else if (chToXlat == L'&')
        strmOut() << L"&amp;";
    else
    {
        TString strChar(L" ");
        strChar[0] = chToXlat;
        facMakeDocs.LogErr
        (
            __FILE__
            , __LINE__
            , kDocErrs::errcTransBadSpecialChar
            , tCIDLib::ESev_ProcessFatal
            , tCIDLib::EClass_Internal
            , strChar
            , clsIsA()
        );
    }
}


// ----------------------------------------------------------------------------
//  THtmlTranslator: Private, static data members
// ----------------------------------------------------------------------------
TString  THtmlTranslator::__strExtension = L"Html";
