//
//  FILE NAME: Collect3_Thread.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 08/07/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the Collect3_Thread.Cpp module. This module
//  implements the thread class used by this program.
//
//  CAVEATS/GOTCHAS:
//

// ----------------------------------------------------------------------------
//   CLASS: TColThread
//  PREFIX: thr
// ----------------------------------------------------------------------------
class TColThread : public TThread
{
    public :
        // --------------------------------------------------------------------
        //  Public types
        // --------------------------------------------------------------------
        enum EThreadTypes
        {
            EThreadType_Adder
            , EThreadType_Remover
        };


        // --------------------------------------------------------------------
        //  Constructors and destructors
        // --------------------------------------------------------------------
        TColThread
        (
                    TTestCol* const         pcolToUse
            , const EThreadTypes            eType
            ,       TTextStream* const      pstrmOut
        );

        ~TColThread();


    protected   :
        // --------------------------------------------------------------------
        //  Protected, inherited methods
        // --------------------------------------------------------------------
        tCIDLib::EExitCodes _eProcess();


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TColThread();

        TColThread(const TColThread&);

        tCIDLib::TVoid operator=(const TColThread&);


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __eType
        //      The type of thread this instance should be, an adder or a
        //      remover.
        //
        //  __pcolToUse
        //      This is a pointer to the collection that the thread works
        //      on. Its not adopted, just referenced. The type is just a
        //      typedef of a template collection.
        //
        //  __pstrmOut
        //      The stream to use for text output. Note that text output
        //      is effectively synchronized using the collection lock. Since
        //      the thread only outputs when the collection is locked, the
        //      output is naturally synchronized.
        // --------------------------------------------------------------------
        EThreadTypes    __eType;
        TTestCol*       __pcolToUse;
        TTextStream*    __pstrmOut;


        // --------------------------------------------------------------------
        //  Do any required macros
        // --------------------------------------------------------------------
        RTTIMacros(TColThread,TThread)
};
