//
//  FILE NAME: CIDWnd_WindowClr.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 05/27/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDWnd_WindowClr.Cpp module, which implements
//  the TWndClr class. This class is used by the window classes to hold
//  special colors that are used by them, and overridable by client code.
//  Each window color can be based on a system color to get its default value,
//  but it can be overridden as well.
//
//  CAVEATS/GOTCHAS:
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//   CLASS: TWndClr
//  PREFIX: wclr
// -----------------------------------------------------------------------------
class CIDWNDEXP TWndClr : public TObject, public MDuplicable
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors.
        // ---------------------------------------------------------------------
        TWndClr
        (
            const   tCIDLib::ESysColors     eSysColor
        );

        TWndClr
        (
            const   TRGBClr&                rgbInit
        );

        TWndClr
        (
            const   TWndClr&                wclrToCopy
        );

        ~TWndClr() {}


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        TObject* pobjDuplicate() const;


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        tCIDLib::TVoid operator=
        (
            const   TWndClr&                wclrToAssign
        );


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::ESysColors eSysColor() const;

        tCIDLib::ESysColors eSysColor
        (
            const   tCIDLib::ESysColors     eNewClr
        );

        const TRGBClr& rgbColor() const;

        tCIDLib::TVoid UpdateFromSysColor();


    private :
        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __bOverridden
        //      Indicates whether this one has been overridden manually. If
        //      so it will not update when its system color has changed.
        //
        //  __eSysColor
        //      The system color, if any, that this color item should be given
        //      by default.
        //
        //  __rgbColor
        //      This is the current color represented by this color item.
        // ---------------------------------------------------------------------
        tCIDLib::TBoolean       __bOverridden;
        tCIDLib::ESysColors     __eSysColor;
        TRGBClr                 __rgbColor;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TWndClr,TObject)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  TWndClr: Public non-virtual methods
// -----------------------------------------------------------------------------
inline tCIDLib::ESysColors TWndClr::eSysColor() const
{
    return __eSysColor;
}

inline TObject* TWndClr::pobjDuplicate() const
{
    return new TWndClr(*this);
}

inline const TRGBClr& TWndClr::rgbColor() const
{
    return __rgbColor;
}
