//
//  FILE NAME: CIDWnd_WindowClr.Cpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 05/27/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This module implements the TWndClr class, which is a way for window
//  classes to provide user settable colors that they will use to draw parts
//  of themselves.
//
//  CAVEATS/GOTCHAS:
//

// ----------------------------------------------------------------------------
//  Includes
// ----------------------------------------------------------------------------
#include    "CIDWnd_.Hpp"


// ----------------------------------------------------------------------------
//  Do our RTTI macros
// ----------------------------------------------------------------------------
RTTIData(TWndClr,TObject)



// -----------------------------------------------------------------------------
//   CLASS: TWndClr
//  PREFIX: wclr
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//  TWndClr: Constructors and Destructors
// -----------------------------------------------------------------------------

//
TWndClr::TWndClr(const tCIDLib::ESysColors eSysColor) :

    __bOverridden(kCIDLib::False)
    , __eSysColor(eSysColor)
{
    __rgbColor = TSysInfo::rgbSystemColor(eSysColor);
}

TWndClr::TWndClr(const TRGBClr& rgbInit) :

    __bOverridden(kCIDLib::False)
    , __eSysColor(tCIDLib::ESysClr_None)
    , __rgbColor(rgbInit)
{
}

TWndClr::TWndClr(const TWndClr& wclrToCopy) :

    __bOverridden(wclrToCopy.__bOverridden)
    , __eSysColor(wclrToCopy.__eSysColor)
    , __rgbColor(wclrToCopy.__rgbColor)
{
}


// -----------------------------------------------------------------------------
//  TWndClr: Public operators
// -----------------------------------------------------------------------------

tCIDLib::TVoid TWndClr::operator=(const TWndClr& wclrToAssign)
{
    __bOverridden   = wclrToAssign.__bOverridden;
    __eSysColor     = wclrToAssign.__eSysColor;
    __rgbColor      = wclrToAssign.__rgbColor;
}


// -----------------------------------------------------------------------------
//  TWndClr: Public, non-virtual methods
// -----------------------------------------------------------------------------

tCIDLib::ESysColors TWndClr::eSysColor(const tCIDLib::ESysColors eNewColor)
{
    __eSysColor = eNewColor;

    if (!__bOverridden && (__eSysColor != tCIDLib::ESysClr_None))
        __rgbColor = TSysInfo::rgbSystemColor(__eSysColor);

    return __eSysColor;
}


tCIDLib::TVoid TWndClr::UpdateFromSysColor()
{
    if (!__bOverridden && (__eSysColor != tCIDLib::ESysClr_None))
        __rgbColor = TSysInfo::rgbSystemColor(__eSysColor);
}
