//
//  FILE NAME: CIDWnd_Window2.Cpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 05/27/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is an overflow module for the CIDWnd_Window.Cpp. Since TWindow
//  is a relatively large class, this makes it easier to deal with. All of
//  the protected and private methods are implemented here.
//
//  CAVEATS/GOTCHAS:
//

// ----------------------------------------------------------------------------
//  Includes
// ----------------------------------------------------------------------------
#include    "CIDWnd_.Hpp"



// -----------------------------------------------------------------------------
//  TWindow: Public, virtual methods
// -----------------------------------------------------------------------------

tCIDLib::TBoolean CIDWNDEXP
TWindow::bMatchesMnemonic(const tCIDLib::Tch chToCheck)
{
    tCIDLib::TCard4 c4Ind;
    if (__strWndText.bFirstOccurrence(kCIDWnd::chMnemonic, c4Ind))
    {
        if (c4Ind < __strWndText.c4Length()-1)
        {
            if (TRawStr::chUpper(__strWndText[c4Ind+1]) == TRawStr::chUpper(chToCheck))
                return kCIDLib::True;
        }
    }
    return kCIDLib::False;
}


tCIDLib::TVoid CIDWNDEXP TWindow::QueryColors()
{
    __wclrBgn.UpdateFromSysColor();
    __wclrActiveBorder.UpdateFromSysColor();
    __wclrInactiveBorder.UpdateFromSysColor();
    __wclrBorderContrast.UpdateFromSysColor();
    __wclrRaised.UpdateFromSysColor();
    __wclrSunken.UpdateFromSysColor();
}


const TRGBClr& CIDWNDEXP TWindow::rgbBorder() const
{
    if (bIsActivated())
        return __wclrActiveBorder.rgbColor();
    else
        return __wclrInactiveBorder.rgbColor();
}



// -----------------------------------------------------------------------------
//  TWindow: Protected, virtual methods
// -----------------------------------------------------------------------------

TArea TWindow::_areaBorder() const
{
    // Default border is whole window
    return areaWndSize();
}


tCIDLib::TVoid TWindow::_ActivationChanged(const tCIDLib::TBoolean bNewState)
{
    // Just an empty default implementation
}


tCIDLib::TBoolean TWindow::_bQuerySizeLimits(TArea& areaMin, TArea& areaMax)
{
    // Return False to say we don't care
    return kCIDLib::False;
}


tCIDLib::TBoolean TWindow::_bSetPointer()
{
    // Return False to say we don't handle it.
    return kCIDLib::False;
}


tCIDLib::TVoid
TWindow::_BorderChanged(const TWndBorder* const, const TWndBorder* const)
{
    // Just an empty default implementation
}


tCIDLib::TVoid TWindow::_Created(const TArea& areaInit)
{
    // Just an empty default implementation
}


tCIDLib::TVoid TWindow::_Destroy()
{
    // Just an empty default implementation
}


tCIDWnd::EEventResponses
TWindow::_eClick(   const   tCIDWnd::EMouseButtons
                    , const tCIDWnd::EMouseClicks
                    , const TPoint&
                    , const tCIDLib::TBoolean
                    , const tCIDLib::TBoolean)
{
    return tCIDWnd::EEventResponse_Propogate;
}


tCIDLib::TVoid TWindow::_EnableStateChanged(const tCIDLib::TBoolean)
{
    // Just an empty default implementation
}


tCIDLib::TVoid TWindow::_EndSizeMove()
{
    // Just an empty default implementation
}


tCIDLib::TVoid
TWindow::_EraseBgn(TGraphicDevice& gdevToUse, const TArea& areaUpdate)
{
    gdevToUse.Fill(areaUpdate, TRGBClr(0xFF, 0, 0));
}


tCIDLib::TVoid TWindow::_LostCapture()
{
    // Just an empty default implementation
}


tCIDLib::TVoid TWindow::_MouseMove( const   TPoint&
                                    , const tCIDLib::TBoolean
                                    , const tCIDLib::TBoolean)
{
    // Just an empty default implementation
}


tCIDLib::TVoid TWindow::_Moving(const TArea&)
{
    // Just an empty default implementation
}


tCIDLib::TVoid TWindow::_MoveComplete(const TPoint&)
{
    // Just an empty default implementation
}


tCIDLib::TVoid
TWindow::_Paint(TGraphicDevice& gdevToUse, const TArea& areaUpdate)
{
    //
    //  If there is a border, then draw it. We call the virtual method
    //  that gets this window's desired border area.
    //
    if (__pwndbThis)
        __pwndbThis->DrawBorder(*this, gdevToUse, _areaBorder());
}


tCIDLib::TVoid TWindow::_SizeChanged(const TArea&, const TArea&)
{
    // Just an empty default implementation
}


tCIDLib::TVoid TWindow::_StartSizeMove()
{
    // Just an empty default implementation
}


tCIDLib::TVoid TWindow::_VisibilityChanged(const tCIDLib::TBoolean)
{
    // Just an empty default implementation
}


tCIDLib::TVoid TWindow::_WndStylesChanged(  const   tCIDWnd::EWndStyles
                                            , const tCIDWnd::EWndStyles)
{
    // Just an empty default implementation
}


tCIDLib::TVoid TWindow::_WndTextChanged(const TString&, const TString&)
{
    // Just an empty default implementation
}


// -----------------------------------------------------------------------------
//  TWindow: Protected, non-virtual methods
// -----------------------------------------------------------------------------

tCIDLib::TVoid TWindow::_Create(const   TWindow&            wndParent
                                , const TString&            strText
                                , const tCIDWnd::EWndStyles eStyles
                                , const TArea&              areaInit
                                , const tCIDLib::TCard4     c4ExtraHostStyles
                                , const TString&            strClass)
{
    struct TWndData InitData;
    InitData.c2Size     = sizeof(InitData);
    InitData.pwndThis   = this;

    //
    //  If there is an initial size, then get it, else we just use the
    //  empty area default constructed into areaActual.
    //
    TArea   areaActual;
    if (&areaInit)
        areaActual = areaInit;

    // Figure out the actual parent
    tCIDWnd::TWindowHandle hwndParent = 0;
    if (&wndParent)
        hwndParent = wndParent.hwndThis();

    //
    //  Figure out the actual window class. If the user did not pass one,
    //  then we use the internal one.
    //
    const tCIDLib::Tch* pszClass = kCIDWnd_::pszCIDLibClass;
    if (&strClass)
        pszClass = strClass.pszData();

    //
    //  Figure out the actual styles. We map the passed style enum to the
    //  correct host styles first.
    //
    tCIDLib::TCard4 c4Styles = __c4MapStyles(eStyles);
    
    //  
    //  If we are using our own internal class, then we adjust the passed
    //  styles to make it either a child or popup windwo according to
    //  whether there is a parent window or not.
    //
    if (!(&strClass))
        c4Styles |= (hwndParent ? WS_CHILD : WS_POPUP);

    // Add in any extra host styles
    c4Styles |= c4ExtraHostStyles;

    tCIDWnd::TWindowHandle hwndTmp = CreateWindowExW
    (
        __c4MapExStyles(eStyles)
        , pszClass
        , strText.pszData()
        , c4Styles
        , areaActual.i4X()
        , areaActual.i4Y()
        , areaActual.c4Width()
        , areaActual.c4Height()
        , hwndParent
        , hwndParent ? (HMENU__*)__widThis : 0
        , facCIDWnd.kmodThis().hmodThis()
        , &InitData
    );

    if (!hwndTmp)
    {
        //
        //  This can fail for application specific reasons, so if the error
        //  is 0, use AppError class; else, use CantDo class.
        //
        TKrnlError kerrToLog;
        facCIDWnd.LogKrnlErr
        (
            __FILE__
            , __LINE__
            , kCIDWErrs::errcWnd_Create
            , kerrToLog
            , tCIDLib::ESev_APIFailed
            , kerrToLog.errcId() ? tCIDLib::EClass_CantDo : tCIDLib::EClass_AppError
            , TCardinal(__widThis)
        );
    }

    // It worked so store the window
    __hwndThis = hwndTmp;
}


// -----------------------------------------------------------------------------
//  TWindow: Private, non-virtual methods
// -----------------------------------------------------------------------------

tCIDWnd::TWindowHandle
TWindow::__hwndGetChild(const tCIDWnd::TWindowId widChild) const
{
    return GetDlgItem(__hwndThis, widChild);
}

tCIDWnd::TWindowHandle
TWindow::__hwndGetChild(const   tCIDWnd::TWindowId  widChild
                        , const tCIDLib::TCard4     c4Line) const
{
    tCIDWnd::TWindowHandle hwndChild = GetDlgItem(__hwndThis, widChild);

    if (!hwndChild)
    {
        facCIDWnd.LogErr
        (
            __FILE__
            , c4Line
            , kCIDWErrs::errcWnd_NoChildWithId
            , tCIDLib::ESev_ProcessFatal
            , tCIDLib::EClass_BadParms
            , TCardinal(widChild)
        );
    }
    return hwndChild;
}


tCIDLib::TVoid TWindow::__QueryInitialState()
{
    // Get the initial enabled state
    if (GetWindowLong(__hwndThis, GWL_STYLE) & WS_DISABLED)
        __bEnabled = kCIDLib::False;
    else
        __bEnabled = kCIDLib::True;
}


// -----------------------------------------------------------------------------
//  TWindow: Private, static methods
// -----------------------------------------------------------------------------

tCIDLib::TCard4 TWindow::__c4MapExStyles(const tCIDWnd::EWndStyles eStyles)
{
    tCIDLib::TCard4 c4Ret = 0;

    if (eStyles & tCIDWnd::EWndStyle_Transparent)
        c4Ret |= WS_EX_TRANSPARENT;

    if (eStyles & tCIDWnd::EWndStyle_Topmost)
        c4Ret |= WS_EX_TOPMOST;

    return c4Ret;
}

tCIDLib::TCard4 TWindow::__c4MapStyles(const tCIDWnd::EWndStyles eStyles)
{
    tCIDLib::TCard4 c4Ret = 0;

    if (eStyles & tCIDWnd::EWndStyle_ClipChildren)
        c4Ret |= WS_CLIPCHILDREN;

    if (eStyles & tCIDWnd::EWndStyle_ClipSiblings)
        c4Ret |= WS_CLIPSIBLINGS;

    if (eStyles & tCIDWnd::EWndStyle_Disabled)
        c4Ret |= WS_DISABLED;

    if (eStyles & tCIDWnd::EWndStyle_Group)
        c4Ret |= WS_GROUP;

    if (eStyles & tCIDWnd::EWndStyle_TabStop)
        c4Ret |= WS_TABSTOP;

    if (eStyles & tCIDWnd::EWndStyle_Visible)
        c4Ret |= WS_VISIBLE;

    return c4Ret;
}


tCIDLib::TVoid
TWindow::__InsertPtr(   const   tCIDWnd::TWindowHandle  hwndTarget
                        ,       TWindow* const          pwndToInsert)
{
    TKrnlThread::SetLastError(0);
    SetWindowLong(hwndTarget, 0, (tCIDLib::TInt4)pwndToInsert);
}

TWindow* TWindow::__pwndExtractPtr(const tCIDWnd::TWindowHandle hwndSource)
{
    TWindow* const pwndRet = (TWindow*)GetWindowLong(hwndSource, 0);
    return pwndRet;
}
