//
//  FILE NAME: CIDWnd_Type.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 05/27/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the types header for the CIDWnd facility. It contains all
//  of the non-class enums, structures, function prototypes, etc... that
//  are not totally class specific (class specific ones are nested within
//  that class.)
//
//  All of the types are within a standard facility types namespace,
//  named tCIDWnd in this case, so as to keep them out of the public name
//  space.
//
//  CAVEATS/GOTCHAS:
//


// ----------------------------------------------------------------------------
//  Forward reference some platform types
// ----------------------------------------------------------------------------
struct HBRUSH__;
struct HDC__;
struct HPEN__;
struct HWND__;

namespace tCIDWnd
{
    // ------------------------------------------------------------------------
    //  These are some types that are used by GUI applications, which we want
    //  to abstract in case of differences on other platforms.
    //
    //  Prefixes are: hbr, hdev, mres, hpen, wcr, hwnd, wid, wsz
    // ------------------------------------------------------------------------
    typedef HBRUSH__*           TBrushHandle;
    typedef HDC__*              TDeviceHandle;
    typedef tCIDLib::TInt4      TMsgResult;
    typedef HPEN__*             TPenHandle;
    typedef tCIDLib::TInt4      TWindowCoord;
    typedef HWND__*             TWindowHandle;
    typedef tCIDLib::TCard4     TWindowId;
    typedef tCIDLib::TCard4     TWindowMsg;
    typedef tCIDLib::TCard4     TWindowSize;


    // ------------------------------------------------------------------------
    //  The 3D borders that TPaintbrush knows how to draw
    // ------------------------------------------------------------------------
    enum E3DBorders
    {
        E3DBorder_None
        , E3DBorder_Raised
        , E3DBorder_Sunken
        , E3DBorder_3D
    };


    // ------------------------------------------------------------------------
    //  The available background modes
    // ------------------------------------------------------------------------
    enum EBackModes
    {
        EBackMode_Opaque
        , EBackMode_Transparent

        , EBackMode_Count
        , EBackMode_Min             = EBackMode_Opaque
        , EBackMode_Max             = EBackMode_Transparent
    };


    // ------------------------------------------------------------------------
    //  The special regions of a window border
    // ------------------------------------------------------------------------
    enum EBorderAreas
    {
        EBorderArea_None

        , EBorderArea_Bottom
        , EBorderArea_LeftSide
        , EBorderArea_LowerLeft
        , EBorderArea_LowerRight
        , EBorderArea_RightSide
        , EBorderArea_Top
        , EBorderArea_UpperLeft
        , EBorderArea_UpperRight

        , EBorderAreas_Count
        , EBorderAreas_Min          = EBorderArea_None
        , EBorderAreas_Max          = EBorderArea_UpperRight
    };


    // ------------------------------------------------------------------------
    //  The available types of brush patterns.
    // ------------------------------------------------------------------------
    enum EBrushPatterns
    {
        EBrushPat_BackDiagonal
        , EBrushPat_Cross
        , EBrushPat_DiagonalCross
        , EBrushPat_ForwardDiagonal
        , EBrushPat_Horizontal
        , EBrushPat_Vertical

        , EBrushPatterns_Count
        , EBrushPatterns_Min        = EBrushPat_BackDiagonal
        , EBrushPatterns_Max        = EBrushPat_Vertical
    };


    // ------------------------------------------------------------------------
    //  The ways an event can be responded to
    // ------------------------------------------------------------------------
    enum EEventResponses
    {
        EEventResponse_Handled
        , EEventResponse_Propogate

        , EEventResponses_Count
        , EEventResponses_Min       = EEventResponse_Handled
        , EEventResponses_Max       = EEventResponse_Propogate
    };


    // ------------------------------------------------------------------------
    //  The available styles for a frame window
    // ------------------------------------------------------------------------
    enum EFrameStyles
    {
        eFrameStyle_TitleBar        = 0x00000001
        , eFrameStyle_SystemMenu    = 0x00000002
        , eFrameStyle_MinMax        = 0x00000004
        , eFrameStyle_Restore       = 0x00000008
        , eFrameStyle_StatusBar     = 0x00000010
        , eFrameStyle_Sizeable      = 0x00000020
    };


    // ------------------------------------------------------------------------
    //  The available line drawing styles
    // ------------------------------------------------------------------------
    enum ELineEnds
    {
        ELineEnd_Flat
        , ELineEnd_Square
        , ELineEnd_Round

        , ELineEnds_Count
        , ELineEnds_Min             = ELineEnd_Flat
        , ELineEnds_Max             = ELineEnd_Round
    };


    // ------------------------------------------------------------------------
    //  The available line drawing styles
    // ------------------------------------------------------------------------
    enum ELineJoins
    {
        ELineJoin_Bevel
        , ELineJoin_Round
        , ELineJoin_Mitre

        , ELineJoins_Count
        , ELineJoins_Min            = ELineJoin_Bevel
        , ELineJoins_Max            = ELineJoin_Mitre
    };


    // ------------------------------------------------------------------------
    //  The available line drawing styles
    // ------------------------------------------------------------------------
    enum ELineStyles
    {
        ELineStyle_Solid
        , ELineStyle_Dot
        , ELineStyle_Dash
        , ELineStyle_DashDot
        , ELineStyle_DashDoubleDot
        , ELineStyle_Invisible

        , ELineStyles_Count
        , ELineStyles_Min           = ELineStyle_Solid
        , ELineStyles_Max           = ELineStyle_Invisible
    };


    // ------------------------------------------------------------------------
    //  The types of mouse buttons
    // ------------------------------------------------------------------------
    enum EMouseButtons
    {
        EMouseButton_Left
        , EMouseButton_Middle
        , EMouseButton_Right

        , EMouseButtons_Count
        , EMouseButtons_Min         = EMouseButton_Left
        , EMouseButtons_Max         = EMouseButton_Right
    };


    // ------------------------------------------------------------------------
    //  The types of mouse clicks
    // ------------------------------------------------------------------------
    enum EMouseClicks
    {
        EMouseClick_Down
        , EMouseClick_Up
        , EMouseClick_Double

        , EMouseClicks_Count
        , EMouseClicks_Min          = EMouseClick_Down
        , EMouseClicks_Max          = EMouseClick_Double
    };


    // ------------------------------------------------------------------------
    //  The flags for TWindow::Show()
    // ------------------------------------------------------------------------
    enum EShowStates
    {
        EShowState_Hide
        , EShowState_Maximize
        , EShowState_Minimize
        , EShowState_RestoreNoActivate
        , EShowState_Show
        , EShowState_ShowMaximized
        , EShowState_ShowMinimized
        , EShowState_ShowNoActivate
        , EShowState_ShowRestored

        , EShowStates_Count
        , EShowStates_Min           = EShowState_Hide
        , EShowStates_Max           = EShowState_ShowRestored
    };


    // ------------------------------------------------------------------------
    //  The flags available for text display
    // ------------------------------------------------------------------------
    enum ETextFmt
    {
        ETextFmt_None               = 0x0
        , ETextFmt_EndEllipsis      = 0x00000001
        , ETextFmt_PathEllipsis     = 0x00000002
        , ETextFmt_ExpandTabs       = 0x00000004
        , ETextFmt_NoClip           = 0x00000008
        , ETextFmt_NoMnemonic       = 0x00000010
        , ETextFmt_RightToLeft      = 0x00000020
        , ETextFmt_SingleLine       = 0x00000040
        , ETextFmt_WordBreak        = 0x00000080
        , ETextFmt_FillArea         = 0x00000100
    };


    // ------------------------------------------------------------------------
    //  The standard window styles supported
    // ------------------------------------------------------------------------
    enum EWndStyles
    {
        EWndStyle_None              = 0x0
        , EWndStyle_ClipChildren    = 0x00000001
        , EWndStyle_ClipSiblings    = 0x00000002
        , EWndStyle_Disabled        = 0x00000004
        , EWndStyle_Group           = 0x00000008
        , EWndStyle_TabStop         = 0x00000010
        , EWndStyle_Topmost         = 0x00000020
        , EWndStyle_Transparent     = 0x00000040
        , EWndStyle_Visible         = 0x00000080

        , EWndStyles_AllBits        = 0x000000FF
    };
};
