//
// NAME: CIDWnd_ThisFacility.Cpp
//
// DESCRIPTION: 
//
//  This module implements the facility class for this facility. It is a
//  derivative (as all facility objects are) of TFacility.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/04/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


// ----------------------------------------------------------------------------
//  Facility specific includes
// ----------------------------------------------------------------------------
#include    "CIDWnd_.Hpp"


// ----------------------------------------------------------------------------
//  Do our RTTI macros
// ----------------------------------------------------------------------------
RTTIData(TFacCIDWnd,TFacility)



// ----------------------------------------------------------------------------
//   CLASS: TFacCIDWnd
//  PREFIX: fac
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  TFacCIDWnd: Constructors and operators
// ----------------------------------------------------------------------------

TFacCIDWnd::TFacCIDWnd() :

    TFacility
    (
        L"CIDWnd"
        , tCIDLib::EModType_Dll
        , kCIDLib::c4MajVersion
        , kCIDLib::c4MinVersion
    )
{
}

TFacCIDWnd::~TFacCIDWnd()
{
}


// ----------------------------------------------------------------------------
//  TFacCIDWnd: Public, static methods
// ----------------------------------------------------------------------------

tCIDLib::TVoid TFacCIDWnd::ExitMessageLoop(const tCIDLib::TUInt uExitCode)
{
    PostQuitMessage(uExitCode);
}

tCIDLib::TUInt TFacCIDWnd::uMessageLoop()
{
    MSG msgCur;

    while (GetMessage(&msgCur, 0, 0, 0))
    {
        TranslateMessage(&msgCur);
        DispatchMessage(&msgCur);
    }
    return msgCur.wParam;
}
