//
//  FILE NAME: CIDWnd_Pen.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 06/01/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDWnd_Pen.Cpp module. This module
//  implements the TPen class. This class contains the information needed
//  to set up the line drawing attributes of a graphics output device.
//
//  The TGeomPen class is used for geometric pens, which has different
//  attributes than regular pens, which are always just single lines.
//
//  The TPenJanitor is a janitor object that saves the pen for a device
//  object and restores it when the janitor object destructs.
//
//  CAVEATS/GOTCHAS:
//

// -----------------------------------------------------------------------------
//  Forward reference
// -----------------------------------------------------------------------------
class   TGraphicDevice;


#pragma pack(push, CIDLIBPACK)


// -----------------------------------------------------------------------------
//  CLASS: TPen
// PREFIX: pen
// -----------------------------------------------------------------------------
class CIDWNDEXP TPen : public TObject
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and destructors
        // ---------------------------------------------------------------------
        TPen();

        TPen
        (
            const   TGraphicDevice&         gdevSource
        );

        TPen
        (
            const   tCIDWnd::ELineStyles    eStyle
            , const TRGBClr&                rgbFgn
        );

        TPen
        (
            const   TRGBClr&                rgbFgn
        );

        ~TPen();


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDWnd::TPenHandle hpenThis() const;


    private :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // ---------------------------------------------------------------------
        TPen(const TPen&);

        tCIDLib::TVoid operator=(const TPen&);


        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __hpenThis
        //      This is the pen handle. On NT this is literally a handle to
        //      to a system pen. On other platforms it might just be a pointer
        //      to an internal structure.
        // ---------------------------------------------------------------------
        tCIDWnd::TPenHandle     __hpenThis;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TPen,TObject)
};



// -----------------------------------------------------------------------------
//  CLASS: TPenJanitor
// PREFIX: jan
// -----------------------------------------------------------------------------
class CIDWNDEXP TPenJanitor : public TObject
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and destructors
        // ---------------------------------------------------------------------
        TPenJanitor
        (
                    TGraphicDevice* const   pgdevToSanitize
        );

        ~TPenJanitor();


    private :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // ---------------------------------------------------------------------
        TPenJanitor();

        TPenJanitor(const TPenJanitor&);

        tCIDLib::TVoid operator=(const TPenJanitor&);


        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __hpenSaved
        //      This is the pen handle we've saved.
        //
        //  __pgdevSanitize
        //      This is the device that we will replace the pen on when we
        //      destruct.
        // ---------------------------------------------------------------------
        tCIDWnd::TPenHandle     __hpenSaved;
        TGraphicDevice*         __pgdevSanitize;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TPenJanitor,TObject)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  TPen: Public, non-virtual methods
// -----------------------------------------------------------------------------
inline tCIDWnd::TPenHandle TPen::hpenThis() const
{
    return __hpenThis;
}
