//
//  FILE NAME: CIDWnd_FrameWindow.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 05/27/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDWnd_FrameWindow.Cpp module, which implements
//  the TFrameWindow class. All of the window classes from CIDWnd.Lib derive
//  from this class in order to get all of the host specific capabilities.
//
//
//  CAVEATS/GOTCHAS:
//


#pragma pack(push, CIDLIBPACK)


// -----------------------------------------------------------------------------
//  CLASS: TFrameWindow
// PREFIX: wnd
// -----------------------------------------------------------------------------
class CIDWNDEXP TFrameWindow : public TWindow
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and destructors
        // ---------------------------------------------------------------------
        TFrameWindow
        (
            const   tCIDWnd::TWindowId      widToUse
            ,       TWndBorder* const       pwndBorderToAdopt = 0
        );

        ~TFrameWindow();


        // ---------------------------------------------------------------------
        //  Public, virtual methods
        // ---------------------------------------------------------------------
        virtual const TRGBClr& rgbTitleBgn() const;

        virtual const TRGBClr& rgbTitleText() const;


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid Create
        (
            const   TWindow&                wndParent
            , const TString&                strTitleText
            , const tCIDWnd::EWndStyles     eStyles
            , const tCIDWnd::EFrameStyles   eFrameStyles
            , const TArea&                  areaInit = NUL_TArea
        );


    protected :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _Created
        (
            const   TArea&                  areaInit
        );


    private :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // ---------------------------------------------------------------------
        TFrameWindow();

        TFrameWindow(const TFrameWindow&);

        tCIDLib::TVoid operator=(const TFrameWindow&);


        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __clriActiveTitleBgn
        //      ...
        //  __clriInactiveTitleText
        //      These are storage for the color items we support at this
        //      level.
        //
        //  __eFrameStyles
        //      The styles that were set for the window during the create
        //      call.
        // ---------------------------------------------------------------------
        TWndClr                 __wclrActiveTitleBgn;
        TWndClr                 __wclrActiveTitleText;
        TWndClr                 __wclrInactiveTitleBgn;
        TWndClr                 __wclrInactiveTitleText;
        tCIDWnd::EFrameStyles   __eFrameStyles;


        // ---------------------------------------------------------------------
        //  Magic macors
        // ---------------------------------------------------------------------
        RTTIMacros(TFrameWindow,TWindow)
};

#pragma pack(pop)
