//
//  FILE NAME: CIDWnd_FrameWindow.Cpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 05/27/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This module implements the TFrameWindow class, which is a special class
//  for main windows. This is because the frame window will often have to
//  to be based on different host window class than other windows. So it
//  will likely register its own window class or use an existing one that
//  is provided by the host for this purpose.
//
//  CAVEATS/GOTCHAS:
//

// ----------------------------------------------------------------------------
//  Includes
// ----------------------------------------------------------------------------
#include    "CIDWnd_.Hpp"


// ----------------------------------------------------------------------------
//  Do our RTTI macros
// ----------------------------------------------------------------------------
RTTIData(TFrameWindow,TWindow)



// -----------------------------------------------------------------------------
//   CLASS: TFrameWindow
//  PREFIX: wnd
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//  TFrameWindow: Constructors and destructors
// -----------------------------------------------------------------------------

TFrameWindow::TFrameWindow( const   tCIDWnd::TWindowId  widToUse
                            ,       TWndBorder* const   pwndbToAdopt) :

    TWindow(widToUse, pwndbToAdopt)
    , __wclrActiveTitleBgn(tCIDLib::ESysClr_ActiveTitleBgn)
    , __wclrActiveTitleText(tCIDLib::ESysClr_ActiveTitleText)
    , __wclrInactiveTitleBgn(tCIDLib::ESysClr_InactiveTitleBgn)
    , __wclrInactiveTitleText(tCIDLib::ESysClr_InactiveTitleText)
{
    //
    //  Override the system color for the background, which is handled
    //  by our parent class. We call the protected method that gives access
    //  to the raw window color object and tell it to use a different
    //  system color for the background.
    //
    _wclrBgn().eSysColor(tCIDLib::ESysClr_DialogBgn);
}

TFrameWindow::~TFrameWindow()
{
}


// -----------------------------------------------------------------------------
//  TFrameWindow: Public, virtual methods
// -----------------------------------------------------------------------------

inline const TRGBClr& TFrameWindow::rgbTitleBgn() const
{
    // Return the correct title bar color for the current active state
    if (bIsActivated())
        return __wclrActiveTitleBgn.rgbColor();
    else
        return __wclrInactiveTitleBgn.rgbColor();
}

inline const TRGBClr& TFrameWindow::rgbTitleText() const
{
    // Return the correct title bar text color for the current active state
    if (bIsActivated())
        return __wclrActiveTitleText.rgbColor();
    else
        return __wclrInactiveTitleText.rgbColor();
}


// -----------------------------------------------------------------------------
//  TFrameWindow: Public, inherited methods
// -----------------------------------------------------------------------------

tCIDLib::TVoid TFrameWindow::_Created(const TArea& areaInit)
{
    //
    //  Look at the stored frame styles and see what extra stuff we need
    //  to create.
    //
}


// -----------------------------------------------------------------------------
//  TFrameWindow: Public, non-virtual methods
// -----------------------------------------------------------------------------

tCIDLib::TVoid TFrameWindow::Create(const   TWindow&                wndParent
                                    , const TString&                strTitleText
                                    , const tCIDWnd::EWndStyles     eStyles
                                    , const tCIDWnd::EFrameStyles   eFrameStyles
                                    , const TArea&                  areaInit)
{
    // Store the frame specific styles
    __eFrameStyles = eFrameStyles;

    // Call our parent class to create the object
    _Create(wndParent, strTitleText, eStyles, areaInit);
}
