//
//  FILE NAME: CIDWnd_DeviceJanitor.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 05/27/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDWnd_DeviceJanitor.Cpp module. This
//  module implements the TDeviceJan class, which is simple janitor
//  class that will save and restore the state of a graphics device.
//
//  CAVEATS/GOTCHAS:
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TGraphicDevJanitor
// PREFIX: jan
// -----------------------------------------------------------------------------
class CIDWNDEXP TGraphicDevJanitor : public TObject
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and destructors
        // ---------------------------------------------------------------------
        TGraphicDevJanitor
        (
                    TGraphicDevice* const   pgdevToSanitize
        );

        ~TGraphicDevJanitor();


    private :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // ---------------------------------------------------------------------
        TGraphicDevJanitor(const TGraphicDevJanitor&);

        tCIDLib::TVoid operator=(const TGraphicDevJanitor&);


        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __i4StateId
        //      This is a state id that represents the saved state. Its passed
        //      back to the restore operation.
        //
        //  __pgdevSanitize
        //      This is the device object that we are to restore the state of
        //      when we die.
        // ---------------------------------------------------------------------
        tCIDLib::TInt4  __i4StateId;
        TGraphicDevice* __pgdevSanitize;


        // ---------------------------------------------------------------------
        //  Magic macros
        // ---------------------------------------------------------------------
        RTTIMacros(TGraphicDevJanitor,TObject)
};

#pragma pack(pop)
