//
//  FILE NAME: CIDWnd_DeviceJanitor.Cpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 05/27/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This module implements the TGraphicDevJanitor class, which is a janitor
//  class for saving and restoring the state of a device.
//
//  CAVEATS/GOTCHAS:
//

// ----------------------------------------------------------------------------
//  Includes
// ----------------------------------------------------------------------------
#include    "CIDWnd_.Hpp"


// ----------------------------------------------------------------------------
//  RTTI macros
// ----------------------------------------------------------------------------
RTTIData(TGraphicDevJanitor,TObject)


// -----------------------------------------------------------------------------
//  CLASS: TGraphicDevJanitor
// PREFIX: jan
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//  TGraphicDevJanitor: Constructors and destructors
// -----------------------------------------------------------------------------

TGraphicDevJanitor::TGraphicDevJanitor(TGraphicDevice* const pgdevToSanitize) :

    __i4StateId(0)
    , __pgdevSanitize(0)
{
    tCIDLib::TInt4 i4Tmp = SaveDC(pgdevToSanitize->hdevThis());
    if (!i4Tmp)
        throw TKrnlError();

    // It worked so save the state id and the device object
    __i4StateId = i4Tmp;
    __pgdevSanitize = pgdevToSanitize;
}

TGraphicDevJanitor::~TGraphicDevJanitor()
{
    if (__pgdevSanitize)
    {
        // <TBD> Log a warning error here but don't throw!
        RestoreDC(__pgdevSanitize->hdevThis(), __i4StateId);
        __pgdevSanitize = 0;
    }
}
