//
//  FILE NAME: CIDWnd_Device.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 05/27/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDWnd_Device.Cpp module. This module
//  implements the TGraphicDevice class, which is a wrapper for the host
//  OS graphics output device handle, a DC in the NT platform.
//
//  CAVEATS/GOTCHAS:
//
//


// -----------------------------------------------------------------------------
//  Map a host paint information structure to our name
// -----------------------------------------------------------------------------
struct  tagPAINTSTRUCT;
#define THostPaintInfo  tagPAINTSTRUCT


// -----------------------------------------------------------------------------
//  Forward references
// -----------------------------------------------------------------------------
class   TWindow;


#pragma pack(push, CIDLIBPACK)


// -----------------------------------------------------------------------------
//  CLASS: TGraphicDevice
// PREFIX: gdev
// -----------------------------------------------------------------------------
class CIDWNDEXP TGraphicDevice : public TObject
{
    public  :
        // ---------------------------------------------------------------------
        //  Public class specific types
        // ---------------------------------------------------------------------
        enum EDevType
        {
            EDevType_Paint
            , EDevType_Gotten
            , EDevType_Created
        };


        // ---------------------------------------------------------------------
        // Constructors and destructors
        // ---------------------------------------------------------------------
        TGraphicDevice
        (
            const   tCIDWnd::TDeviceHandle  hdevToUse
            , const EDevType                eType
            , const tCIDLib::EAdoptOpts     eAdopt = tCIDLib::EAdoptOpt_Adopt
        );

        TGraphicDevice
        (
            const   TWindow&                wndSource
        );

        TGraphicDevice
        (
            const   tCIDWnd::TDeviceHandle  hdevPaint
            , const THostPaintInfo&         hpiToUse
        );

        ~TGraphicDevice();


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        TArea areaBounds
        (
            const   tCIDLib::TBoolean       bReset = kCIDLib::False
        )   const;

        TArea areaString
        (
            const   TString&                strText
            , const tCIDLib::TBoolean       bSkipMnemonic = kCIDLib::True
        )   const;

        TArea areaString
        (
            const   TString&                strText
            , const tCIDLib::TCard4         c4Start
            , const tCIDLib::TCard4         c4Len = kCIDLib::c4MaxCard
            , const tCIDLib::TBoolean       bSkipMnemonic = kCIDLib::True
        )   const;

        tCIDLib::TBoolean bBoundsEnabled() const;

        tCIDLib::TCard4 c4DrawText
        (
            const   TString&                strText
            , const TPoint&                 pntAlign
        );

        tCIDLib::TCard4 c4DrawText
        (
            const   TString&                strText
            , const TArea&                  areaFormat
            , const tCIDLib::EHJustify      eHJustify
            , const tCIDLib::EVJustify      eVJustify
            , const tCIDWnd::ETextFmt       eFormat = tCIDWnd::ETextFmt_None
        );

        tCIDLib::TVoid Draw3DBorder
        (
            const   tCIDWnd::E3DBorders     eBorder
            , const TArea&                  areaPos
            , const tCIDLib::TCard4         c4Width
            , const TRGBClr&                rgbFgn
            , const TRGBClr&                rgbBgn
        );

        tCIDLib::TVoid DrawBox
        (
            const   TPoint&                 pntFrom
            , const TPoint&                 pntTo
            , const tCIDLib::TCard4         c4Rounding = 0
        );

        tCIDLib::TVoid DrawBox
        (
            const   TArea&                  areaBox
            , const tCIDLib::TCard4         c4Rounding = 0
        );

        tCIDLib::TVoid DrawFocusArea
        (
            const   TArea&                  areaToDraw
        );

        tCIDLib::EAdoptOpts eAdopted() const;

        tCIDWnd::EBackModes eBackMode() const;

        tCIDLib::TVoid EnableBoundsAccumulation();

        tCIDLib::TVoid DisableBoundsAccumulation();

        tCIDLib::TVoid Fill
        (
            const   TArea&                  areaToFill
            , const TRGBClr&                rgbToUse
        );

        tCIDLib::TVoid Fill
        (
            const   TPoint&                 pntFrom
            , const TPoint&                 pntTo
            , const TRGBClr&                rgbToUse
        );

        tCIDWnd::TDeviceHandle hdevThis() const;

        tCIDLib::TVoid ResetBoundsArea();

        TRGBClr rgbBackColor() const;

        tCIDLib::TVoid SetBackColor
        (
            const   TRGBClr&                rgbToSet
        );

        tCIDLib::TVoid SetBackMode
        (
            const   tCIDWnd::EBackModes     eMode
        );

        tCIDLib::TVoid SetTextColor
        (
            const   TRGBClr&                rgbToSet
        );

        tCIDLib::TVoid Stroke
        (
            const   TArea&                  areaToStroke
            , const TPen&                   penToUse
            , const tCIDLib::TCard4         c4Width = 1
        );

        tCIDLib::TVoid UseBrush
        (
            const   TBrush&                 brToUse
        );

        tCIDLib::TVoid UsePen
        (
            const   TPen&                   penToUse
        );


    private :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // ---------------------------------------------------------------------
        TGraphicDevice();

        // ---------------------------------------------------------------------
        //  Private, static methods
        // ---------------------------------------------------------------------
        static tCIDLib::TVoid __DeleteObject
        (
            const   tCIDLib::THandle    hToDelete
            , const tCIDLib::Tch* const pszType
        );

        static tCIDWnd::TBrushHandle __hbrCreateBrush
        (
            const   TRGBClr&            rgbFill
        );

        static tCIDWnd::TPenHandle __hpenCreatePen
        (
            const   TRGBClr&            rgbPen
        );


        // ---------------------------------------------------------------------
        //  Private, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid __Draw3DBorder
        (
            const   tCIDLib::TBoolean   bRaised
            ,       TArea&              areaPos
            , const tCIDLib::TInt4      i4Width
            , const TRGBClr&            rgbFgn
            , const TRGBClr&            rgbBgn
        );

        tCIDLib::TVoid __SelectObject
        (
            const   tCIDLib::THandle    hToSelect
            , const tCIDLib::Tch* const pszType
        );


        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __eAdopt
        //      This indicates whether we adopted the device or are just
        //      referencing it.
        //
        //  __eType
        //      This indicates the type of the device, which really means
        //      how it was obtained. This tells us how to clean it up later
        //      when we destruct.
        //
        //  __hdevThis
        //      This is the device handle that we are wrapping. Pretty much
        //      all of the methods just massage parameters then call a system
        //      API, passing this handle on.
        //
        //  __phpiThis
        //      For paint devices, this is some extra info needed to clean
        //      the thing up. On other platforms, this may just be a dummy
        //      structure with nothing in it. Its allocated when needed so
        //      that every object does not pay the cost.
        // ---------------------------------------------------------------------
        tCIDLib::EAdoptOpts     __eAdopt;
        EDevType                __eType;
        tCIDWnd::TDeviceHandle  __hdevThis;
        THostPaintInfo*         __phpiThis;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TGraphicDevice,TObject)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  TGraphicDevice: Public, non-virtual inlines
// -----------------------------------------------------------------------------
inline TArea
TGraphicDevice::areaString( const   TString&            strText
                            , const tCIDLib::TBoolean   bSkipMnemonic) const
{
    return areaString(strText, 0, kCIDLib::c4MaxCard, bSkipMnemonic);
}

inline tCIDLib::EAdoptOpts TGraphicDevice::eAdopted() const
{
    return __eAdopt;
}

inline tCIDWnd::TDeviceHandle TGraphicDevice::hdevThis() const
{
    return __hdevThis;
}
