//
//  FILE NAME: CIDWnd_Constant.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 05/27/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This header contains all of the constant values of the facility. They
//  are all within the kCIDWnd namespace, as is the convention for CIDLib
//  facilities.
//
//  CAVEATS/GOTCHAS:
//

namespace kCIDWnd
{
    // ------------------------------------------------------------------------
    //  These are the invalid values for some GUI oriented types
    // ------------------------------------------------------------------------
    const tCIDWnd::TBrushHandle     hbrInvalid      = 0;
    const tCIDWnd::TPenHandle       hpenInvalid     = 0;
    const tCIDWnd::TWindowHandle    hwndInvalid     = 0;
    const tCIDWnd::TWindowId        widInvalid      = kCIDLib::c4MaxCard;


    // ------------------------------------------------------------------------
    //  Defaults for window sizes and positions.
    // ------------------------------------------------------------------------
    const tCIDWnd::TWindowCoord     wcrDefault      = kCIDLib::i4MaxInt;
    const tCIDWnd::TWindowSize      wszDefault      = kCIDLib::c4MaxCard;


    // ------------------------------------------------------------------------
    //  Some GUI oriented character constants
    // ------------------------------------------------------------------------
    const tCIDLib::Tch              chMnemonic      = L'$';
};
