//
//  FILE NAME: CIDWnd_Brush.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 06/01/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDWnd_Brush.Cpp module. This module
//  implements the TBrush class. This class contains the information
//  needed to set up the area filling attributes of a graphics output
//  device.
//
//  The TBrushJanitor is a janitor object that saves the brush for a
//  device object and restores it when the janitor object destructs.
//
//  CAVEATS/GOTCHAS:
//
//  1)  One brush constructor creates a solid color brush. One creates a
//      two color scheme using various predefined hatching patterns. And
//      another allows the use of a user provided bitmap for the fill.
//

// -----------------------------------------------------------------------------
//  Forward reference
// -----------------------------------------------------------------------------
class   TGraphicDevice;


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TBrush
// PREFIX: br
// -----------------------------------------------------------------------------
class CIDWNDEXP TBrush : public TObject
{
    public  :
        // ---------------------------------------------------------------------
        //  Class specific types
        // ---------------------------------------------------------------------
        enum EBrushTypes
        {
            EBrushType_Solid
            , EBrushType_Hatched
            , EBrushType_Pattern
        };


        // ---------------------------------------------------------------------
        //  Constructors and destructors
        // ---------------------------------------------------------------------
        TBrush();

        TBrush
        (
            const   TGraphicDevice&         gdevSource
        );

        TBrush
        (
            const   TRGBClr&                rgbFill
        );

        TBrush
        (
            const   tCIDWnd::EBrushPatterns ePattern
            , const TRGBClr&                rgbFill
        );

        // <TBD> Add the one that uses a bitmap, when bitmap support is ready

        ~TBrush();


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        TBrush::EBrushTypes eType() const;

        tCIDWnd::TBrushHandle hbrThis() const;


    private :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // ---------------------------------------------------------------------
        TBrush(const TBrush&);

        tCIDLib::TVoid operator=(const TBrush&);


        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __eType
        //      This indicates what type of brush this is.
        //
        //  __hbrThis
        //      This is the brush handle. On NT this is literally a handle to
        //      to a system brush. On other platforms it might just be a
        //      pointer to an internal structure.
        // ---------------------------------------------------------------------
        EBrushTypes             __eType;
        tCIDWnd::TBrushHandle   __hbrThis;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TBrush,TObject)
};


// -----------------------------------------------------------------------------
//  CLASS: TBrushJanitor
// PREFIX: jan
// -----------------------------------------------------------------------------
class CIDWNDEXP TBrushJanitor : public TObject
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and destructors
        // ---------------------------------------------------------------------
        TBrushJanitor
        (
                    TGraphicDevice* const   pgdevToSanitize
        );

        ~TBrushJanitor();


    private :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // ---------------------------------------------------------------------
        TBrushJanitor();

        TBrushJanitor(const TBrushJanitor&);

        tCIDLib::TVoid operator=(const TBrushJanitor&);


        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __hbrSaved
        //      This is the brush handle we've saved.
        //
        //  __pgdevSanitize
        //      This is the device that we will replace the brush on when we
        //      destruct.
        // ---------------------------------------------------------------------
        tCIDWnd::TBrushHandle   __hbrSaved;
        TGraphicDevice*         __pgdevSanitize;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TBrushJanitor,TObject)
};

#pragma pack(pop)



// -----------------------------------------------------------------------------
//  TBrush: Public, non-virtual methods
// -----------------------------------------------------------------------------
inline TBrush::EBrushTypes TBrush::eType() const
{
    return __eType;
}

inline tCIDWnd::TBrushHandle TBrush::hbrThis() const
{
    return __hbrThis;
}
