//
// NAME: CIDWKnd_Border.Hpp
//
// DESCRIPTION: 
//
//  This header defines an abstract class from which defines a window border.
//  Each TWindow object can have a winodw border object installed on it. It
//  will be drawn by the TWindow::_Paint() event handler if derived classes
//  don't override it (or if they do and call it.)
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/09/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//
//  1)  This guys has no Cpp file so its RTTI macros are done in the main
//      module.
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//   CLASS: TWndBorder
//  PREFIX: wbord
// -----------------------------------------------------------------------------
class CIDWNDEXP TWndBorder : public TObject, public MDuplicable
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors
        // ---------------------------------------------------------------------
        TWndBorder();

        TWndBorder
        (
            const   TWndBorder&             wbordToCopy
        );

        ~TWndBorder();


        // ---------------------------------------------------------------------
        //  Public, virtual methods
        // ---------------------------------------------------------------------
        virtual tCIDLib::TCard4 c4Width() const = 0;

        virtual tCIDLib::TVoid Depress() = 0;

        virtual tCIDLib::TVoid DrawBorder
        (
            const   TWindow&                wndTarget
            ,       TGraphicDevice&         gdevToUse
            , const TArea&                  areaBorder
        )   = 0;

        virtual tCIDLib::TVoid Raise() = 0;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TWndBorder,TObject)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  TWndBorder: Constructors and destructors
// -----------------------------------------------------------------------------
inline TWndBorder::TWndBorder()
{
}

inline TWndBorder::TWndBorder(const TWndBorder&)
{
}

inline TWndBorder::~TWndBorder()
{
}
