//
//  FILE NAME: CIDWnd_.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/23/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the main internal header for the facility. It includes the main
//  public header, and any internal ones that are needed. It also includes
//  the system headers, which are only used internally.
//
//  CAVEATS/GOTCHAS:
//


// ----------------------------------------------------------------------------
//  Include the Windoze headers for internal use
// ----------------------------------------------------------------------------
#include    <windows.h>


// ----------------------------------------------------------------------------
//  Include our own public header
// ----------------------------------------------------------------------------
#include    "CIDWnd.Hpp"


// ----------------------------------------------------------------------------
//  Include any needed internal headers
// ----------------------------------------------------------------------------
#include    "CIDWnd_MessageIds.Hpp"


// ----------------------------------------------------------------------------
//  This is the intra-facilities types namespace. It contains non-class types
//  for use within the facility.
// ----------------------------------------------------------------------------
namespace tCIDWnd_
{
    // ------------------------------------------------------------------------
    //  These are the indexes for the CIDWnd core metrics. These must be
    //  contiguous since they are used ot index an array of metrics
    //  structures.
    // ------------------------------------------------------------------------
    enum eCoreMetrics
    {
        eCoreMetric_WindowCount
        , eCoreMetric_GraphicDevCount

        // This one must be last!!!
        , eCoreMetric_Count
    };
};


// ----------------------------------------------------------------------------
//  This is the intra-facility constants namespace.
// ----------------------------------------------------------------------------
namespace kCIDWnd_
{
    // ------------------------------------------------------------------------
    //  These are the strings used in emergency popups. These are the default
    //  values but they are, unless something goes wrong, overridden by
    //  strings loaded from resources.
    // ------------------------------------------------------------------------
    const tCIDLib::Tch* const pszTitle1 = L"CIDLib Core GUI Layer";          
    const tCIDLib::Tch* const pszTitle2 = L"Copyright (c) CIDLib 1992..1997";

    
    // ------------------------------------------------------------------------
    //  The window class used for all CIDLib windows
    // ------------------------------------------------------------------------
    const tCIDLib::Tch* const pszCIDLibClass = L"CIDLibWndClass";
};


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDWnd.Cpp
// ----------------------------------------------------------------------------
extern TMetricGroup*        _pmtrgCore;


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDWnd_Window.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _InitTermWindow
(
    const  tCIDLib::EInitTerm       eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const TModule&                modInit
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);


// ----------------------------------------------------------------------------
//  Macros to aid with error popups
// ----------------------------------------------------------------------------
#define _ERRPOPUP_(meth,msg,err) \
TKrnlPopUp::Show \
( \
    __FILE__ \
    , meth \
    , __LINE__ \
    , kCIDWnd_::pszTitle1 \
    , kCIDWnd_::pszTitle2 \
    , msg \
    , kCIDLib::pszEmptyZStr \
    , err \
    , tCIDLib::eRadix_Dec \
);

#define _SYSERRPOPUP_(meth,msg,err) \
TKrnlPopUp::Show \
( \
    __FILE__ \
    , meth \
    , __LINE__ \
    , kCIDWnd_::pszTitle1 \
    , kCIDWnd_::pszTitle2 \
    , msg \
    , L"The error code is a host OS error" \
    , err \
    , tCIDLib::eRadix_Dec \
);

#define _MSGPOPUP_(meth,msg) \
TKrnlPopUp::Show \
( \
    __FILE__ \
    , meth \
    , __LINE__ \
    , kCIDWnd_::pszTitle1 \
    , kCIDWnd_::pszTitle2 \
    , msg \
    , kCIDLib::pszEmptyZStr \
);
