//
//  FILE NAME: CIDWnd.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 05/27/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the main public header for the facility. It is the single point
//  of contact for the outside world. By including it, they get what we
//  have to offer. It also insures consistent order of inclusion which
//  is needed for the precompiled headers stuff to work.
//
//  CAVEATS/GOTCHAS:
//

#if         !defined(_CIDWND_)
#define     _CIDWND_

// ----------------------------------------------------------------------------
//  Set up our import/export attributes
// ----------------------------------------------------------------------------
#if     defined(PROJ_CIDWND)
#define CIDWNDEXP   DLLEXPORT
#else
#define CIDWNDEXP   DLLIMPORT
#endif


// ----------------------------------------------------------------------------
//  Include the needed underlying headers
// ----------------------------------------------------------------------------
#include    "CIDLib.Hpp"


// ----------------------------------------------------------------------------
//  Provide null references for some classes
// ----------------------------------------------------------------------------
#define     NUL_TBrush      (*(TBrush*)0)
#define     NUL_TDevice     (*(TDevice*)0)
#define     NUL_TPen        (*(TPen*)0)
#define     NUL_TWindow     (*(TWindow*)0)
#define     NUL_TWndBorder  (*(TWndBorder*)0)
#define     NUL_TWndClr     (*(TWndClr*)0)


// ----------------------------------------------------------------------------
//  Now subinclude our other headers, in the needed order.
// ----------------------------------------------------------------------------
#include    "CIDWnd_Type.Hpp"
#include    "CIDWnd_Constants.Hpp"
#include    "CIDWnd_ErrorIds.Hpp"

#include    "CIDWnd_Brush.Hpp"
#include    "CIDWnd_Pen.Hpp"
#include    "CIDWnd_Device.Hpp"
#include    "CIDWnd_DeviceJanitor.Hpp"
#include    "CIDWnd_Border.Hpp"
#include    "CIDWnd_WindowClr.Hpp"
#include    "CIDWnd_Window.Hpp"
#include    "CIDWnd_ThisFacility.Hpp"

#include    "CIDWnd_FrameWindow.Hpp"



// ----------------------------------------------------------------------------
//  Export the facility object
// ----------------------------------------------------------------------------
extern CIDWNDEXP    TFacCIDWnd  facCIDWnd;


// ----------------------------------------------------------------------------
//  The magic main module code for a GUI app.
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid CIDWNDEXP CIDWnd_InitShowState
(
    const   tCIDLib::TSInt      sShowState
);

#define CIDLib_MainGUIModule(thrCtor) \
int _stdcall WinMain(   tCIDLib::TModHandle     hmodThis \
                        , tCIDLib::TModHandle\
                        , tCIDLib::Tsch* \
                        , tCIDLib::TSInt        sShowState) \
{ \
    CIDLib_Init(); \
    TThread* pthrMain = new thrCtor; \
    CIDLib_MakePrimary(pthrMain); \
    CIDWnd_InitShowState(sShowState); \
    pthrMain->Start(); \
    return CIDLib_MTHibernate(); \
}

#endif
