//
// NAME: CIDTracer_Type.Hpp
//
// DESCRIPTION:
//
//  This is the type header for the CIDTracer facility. Like all CIDLib
//  facilities all non-class types are encapsulated in a name space.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 03/04/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//


namespace tCIDTracer
{
    // ------------------------------------------------------------------------
    //  These are the valid CSG operations
    // ------------------------------------------------------------------------
    enum ECSGOps
    {
        ECSGOp_Intersection
        , ECSGOp_Union
        , ECSGOp_Difference

        , ECSGOps_Count
        , ECSGOps_Min           = ECSGOp_Intersection
        , ECSGOps_Max           = ECSGOp_Difference
    };


    // --------------------------------------------------------------------
    //  The possible states of a ray, which is either not a refracted
    //  ray, or a refracted ray coming into an object or going out of an
    //  object.
    // --------------------------------------------------------------------
    enum EInOut
    {
        EInOut_Neither
        , EInOut_In
        , EInOut_Out

        , EInOut_Count
        , EInOut_Min            = EInOut_Neither
        , EInOut_Max            = EInOut_Out
    };


    // --------------------------------------------------------------------
    //  The possible types of objects. This is used by the TSceneItem
    //  class.
    // --------------------------------------------------------------------
    enum EObjTypes
    {
        EObjType_None
        , EObjType_Color
        , EObjType_LightInstance
        , EObjType_LightTemplate
        , EObjType_Matrix
        , EObjType_ObjInstance
        , EObjType_ObjTemplate
        , EObjType_TxtrInstance
        , EObjType_TxtrTemplate
        , EObjType_Vector

        , EObjTypes_Count
        , EObjTypes_Min         = EObjType_None
        , EObjTypes_Max         = EObjType_Vector
    };


    // ------------------------------------------------------------------------
    //  The valid quality levels
    // ------------------------------------------------------------------------
    enum EQualityLevels
    {
        eQuality_0
        , eQuality_1
        , eQuality_2
        , eQuality_3
        , eQuality_4
        , eQuality_5

        , EQualityLevels_Count
        , EQualityLevels_Min    = eQuality_0
        , EQualityLevels_Max    = eQuality_5
    };


    // ------------------------------------------------------------------------
    //  The valid sampling stategies
    // ------------------------------------------------------------------------
    enum ESampleModes
    {
        ESampleMode_Normal
        , ESampleMode_Stochastic
        , ESampleMode_Statistical

        , ESampleModes_Count
        , ESampleModes_Min      = ESampleMode_Normal
        , ESampleModes_Max      = ESampleMode_Statistical
    };
};


// -----------------------------------------------------------------------------
//  Some globals for streaming enums in and out
// -----------------------------------------------------------------------------
#if !defined(CIDTRACER_NOCLASSES)
EnumStreamMacros(tCIDTracer::ECSGOps)
EnumStreamMacros(tCIDTracer::EInOut)
EnumStreamMacros(tCIDTracer::EObjTypes)
EnumStreamMacros(tCIDTracer::EQualityLevels)
EnumStreamMacros(tCIDTracer::ESampleModes)
#endif


// ---------------------------------------------------------------------------
//  Generate the standard enum manipulation methods for some of the enums.
//  Do the ones that are likely to be used because there is already plenty
//  of header overhead.
//
//  All of these have the standard required entries and have sequentially
//  numbered items, so this macro can do all the work.
// ---------------------------------------------------------------------------
StdEnumTricks(tCIDTracer::ECSGOps)
StdEnumTricks(tCIDTracer::EInOut)
StdEnumTricks(tCIDTracer::EObjTypes)
StdEnumTricks(tCIDTracer::EQualityLevels)
StdEnumTricks(tCIDTracer::ESampleModes)
