//
// NAME: CIDTracer_Type.Cpp
//
// DESCRIPTION: 
//
//  This module provides the usual formatting code for facility enums.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 10/28/95
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


// -----------------------------------------------------------------------------
//  Facility includes
// -----------------------------------------------------------------------------
#include    "CIDTracer_.Hpp"



// -----------------------------------------------------------------------------
//  Global functions
// -----------------------------------------------------------------------------

//
// FUNCTION/METHOD NAME: operator<<
//
// DESCRIPTION:
//
//  These methods will format the passed enum value into a text stream.
// ---------------------------------------
//   INPUT: eXXXX is the enum to format.
//
//  OUTPUT: strmToWriteTo is the stream to format into
//
//  RETURN: A reference to the text stream.
//
TTextStream&
operator<<(TTextStream& strmToWriteTo, const tCIDTracer::ECSGOps eOperation)
{
    // Format the string
    if (eOperation == tCIDTracer::ECSGOp_Intersection)
        strmToWriteTo << L"Intersection";
    else if (eOperation == tCIDTracer::ECSGOp_Union)
        strmToWriteTo << L"Union";
    else if (eOperation == tCIDTracer::ECSGOp_Difference)
        strmToWriteTo << L"Difference";
    else
        facCIDTracer.LogErr
        (
            __FILE__
            , __LINE__
            , kTracerErrs::errcGen_NotValidValue
            , tCIDLib::ESev_ProcessFatal
            , tCIDLib::EClass_BadParms
            , TInteger(eOperation)
            , TString(L"CSG operation")
        );

    return strmToWriteTo;
}

TTextStream&
operator<<(TTextStream& strmToWriteTo, const tCIDTracer::EObjTypes eType)
{
    // Format the string
    if (eType == tCIDTracer::EObjType_None)
        strmToWriteTo << L"None";
    else if (eType == tCIDTracer::EObjType_Color)
        strmToWriteTo << L"Color";
    else if (eType == tCIDTracer::EObjType_LightInstance)
        strmToWriteTo << L"Light Instance";
    else if (eType == tCIDTracer::EObjType_LightTemplate)
        strmToWriteTo << L"Light Template";
    else if (eType == tCIDTracer::EObjType_Matrix)
        strmToWriteTo << L"Matrix";
    else if (eType == tCIDTracer::EObjType_ObjInstance)
        strmToWriteTo << L"Object Instance";
    else if (eType == tCIDTracer::EObjType_ObjTemplate)
        strmToWriteTo << L"Object Template";
    else if (eType == tCIDTracer::EObjType_TxtrInstance)
        strmToWriteTo << L"Texture Instance";
    else if (eType == tCIDTracer::EObjType_TxtrTemplate)
        strmToWriteTo << L"Texture Template";
    else if (eType == tCIDTracer::EObjType_Vector)
        strmToWriteTo << L"Vector";
    else
        facCIDTracer.LogErr
        (
            __FILE__
            , __LINE__
            , kTracerErrs::errcGen_NotValidValue
            , tCIDLib::ESev_ProcessFatal
            , tCIDLib::EClass_BadParms
            , TInteger(eType)
            , TString(L"object type")
        );

    return strmToWriteTo;
}

TTextStream&
operator<<(TTextStream& strmToWriteTo, const tCIDTracer::EQualityLevels eQuality)
{
    if (eQuality > tCIDTracer::EQualityLevels_Max)
    {
        facCIDTracer.LogErr
        (
            __FILE__
            , __LINE__
            , kTracerErrs::errcGen_NotValidValue
            , tCIDLib::ESev_ProcessFatal
            , tCIDLib::EClass_BadParms
            , TInteger(eQuality)
            , TString(L"rendering quality")
        );
    }

    // Format the string
    strmToWriteTo << TCardinal(eQuality);

    return strmToWriteTo;
}

TTextStream&
operator<<(TTextStream& strmToWriteTo, const tCIDTracer::ESampleModes eSampleMode)
{
    // Format the string
    if (eSampleMode == tCIDTracer::ESampleMode_Normal)
        strmToWriteTo << L"Normal";
    else if (eSampleMode == tCIDTracer::ESampleMode_Stochastic)
        strmToWriteTo << L"Stochastic";
    else if (eSampleMode == tCIDTracer::ESampleMode_Statistical)
        strmToWriteTo << L"Statistical";
    else
        facCIDTracer.LogErr
        (
            __FILE__
            , __LINE__
            , kTracerErrs::errcGen_NotValidValue
            , tCIDLib::ESev_ProcessFatal
            , tCIDLib::EClass_BadParms
            , TInteger(eSampleMode)
            , TString(L"pixel sampling")
        );

    return strmToWriteTo;
}
