//
// NAME: CIDTracer_Transform.Hpp
//
// DESCRIPTION: 
//
//  This is the header file for the CIDTracer_Transform.Cpp module. This module
//  implements the TTransform class, which provides object/texture
//  transformation services. There is a large amount of common functionality
//  that is done for all objects and textures, so it makes sense to have a
//  class for it. A transformation object consists of a matrix (which is used
//  to keep track of the cumulative transformations that have been applied to
//  the object or texture) and the inverse of that matrix which is needed
//  often enough that it is worth precalcing it every time that the regular
//  matrix is modified and keeping it around all the time.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 05/14/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TTransform
// PREFIX: trns
// -----------------------------------------------------------------------------
class CIDTRACEREXP TTransform :

    public TObject, public MStreamable, public MDuplicable, public MFormattable
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and Destructors
        // ---------------------------------------------------------------------
        TTransform();

        TTransform
        (
            const   T4By4Matrix&            mtrxNormal
            , const T4By4Matrix&            mtrxInverse
        );

        TTransform
        (
            const   TTransform&             trnsToCopy
        );

        ~TTransform();



        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        friend TTransform operator*
        (
            const   TTransform&             trns1
            , const TTransform&             trns2
        );

        tCIDLib::TVoid operator*=
        (
            const   TTransform&             trnsSrc
        );

        TTransform& operator=
        (
            const   TTransform&             trnsToAssign
        );

        tCIDLib::TBoolean operator==
        (
            const   TTransform&             trnsToTest
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   TTransform&             trnsToTest
        )   const;


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        tCIDLib::TVoid Reset();

        tCIDLib::TVoid Rotate
        (
            const   T3DVector&              vecRotate
        );

        tCIDLib::TVoid Scale
        (
            const   T3DVector&              vecScale
        );

        tCIDLib::TVoid Translate
        (
            const   T3DVector&              vecTranslate
        );


        // ---------------------------------------------------------------------
        //  Public data members
        // ---------------------------------------------------------------------
        T4By4Matrix     mtrxInvTrans;
        T4By4Matrix     mtrxTrans;


    protected   :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmToWriteTo
        )   const;

        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TTransform,TObject)
        DefPolyDup(TTransform)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  Constructors and destructors
// -----------------------------------------------------------------------------
inline TTransform::TTransform()
{
}

inline TTransform::~TTransform()
{
}


// -----------------------------------------------------------------------------
//  Public operators
// -----------------------------------------------------------------------------
inline tCIDLib::TBoolean
TTransform::operator!=(const TTransform& trnsToTest) const
{
    return !operator==(trnsToTest);
}
