//
// NAME: CIDTracer_ThisFac.Hpp
//
// DESCRIPTION:
//
//  This is the header for the CIDTracer_ThisFac.Cpp module. This module
//  implements the facility class for this facility.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 03/04/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TFacCIDTracer
// PREFIX: fac
// -----------------------------------------------------------------------------
class CIDTRACEREXP TFacCIDTracer : public TFacility
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors.
        //
        //  The constructor handles the initialization of the facility data.
        //  Note that these constructors and destructors should not be
        //  exported so that clients cannot accidentally create another one
        //  or destroy the official one.
        // ---------------------------------------------------------------------
        TFacCIDTracer();
        ~TFacCIDTracer();


        // ---------------------------------------------------------------------
        //  Public, static, constant data members
        // ---------------------------------------------------------------------
        static const TFRGBClr   frgbWhite;
        static const TFRGBClr   frgbRed;
        static const TFRGBClr   frgbGreen;
        static const TFRGBClr   frgbBlue;
        static const TFRGBClr   frgbYellow;
        static const TFRGBClr   frgbCyan;
        static const TFRGBClr   frgbMagenta;
        static const TFRGBClr   frgbBlack;
        static const TFRGBClr   frgbAquamarine;
        static const TFRGBClr   frgbBlueViolet;
        static const TFRGBClr   frgbBrown;
        static const TFRGBClr   frgbCadetBlue;
        static const TFRGBClr   frgbCoral;
        static const TFRGBClr   frgbCornflowerBlue;
        static const TFRGBClr   frgbDarkGreen;
        static const TFRGBClr   frgbDarkOliveGreen;
        static const TFRGBClr   frgbDarkOrchid;
        static const TFRGBClr   frgbDarkSlateBlue;
        static const TFRGBClr   frgbDarkSlateGrey;
        static const TFRGBClr   frgbDarkTurquoise;
        static const TFRGBClr   frgbDimGrey;
        static const TFRGBClr   frgbFirebrick;
        static const TFRGBClr   frgbForestGreen;
        static const TFRGBClr   frgbGold;
        static const TFRGBClr   frgbGoldenrod;
        static const TFRGBClr   frgbGreenYellow;
        static const TFRGBClr   frgbGrey;
        static const TFRGBClr   frgbIndianRed;
        static const TFRGBClr   frgbKhaki;
        static const TFRGBClr   frgbLightBlue;
        static const TFRGBClr   frgbLightGrey;
        static const TFRGBClr   frgbLightSteelBlue;
        static const TFRGBClr   frgbLimeGreen;
        static const TFRGBClr   frgbMaroon;
        static const TFRGBClr   frgbMediumAquamarine;
        static const TFRGBClr   frgbMediumBlue;
        static const TFRGBClr   frgbMediumForestGreen;
        static const TFRGBClr   frgbMediumGoldenrod;
        static const TFRGBClr   frgbMediumOrchid;
        static const TFRGBClr   frgbMediumSeaGreen;
        static const TFRGBClr   frgbMediumSlateBlue;
        static const TFRGBClr   frgbMediumSpringGreen;
        static const TFRGBClr   frgbMediumTurquoise;
        static const TFRGBClr   frgbMediumVioletRed;
        static const TFRGBClr   frgbMidnightBlue;
        static const TFRGBClr   frgbNavy;
        static const TFRGBClr   frgbNavyBlue;
        static const TFRGBClr   frgbOldGold;
        static const TFRGBClr   frgbOrange;
        static const TFRGBClr   frgbOrangeRed;
        static const TFRGBClr   frgbOrchid;
        static const TFRGBClr   frgbPaleGreen;
        static const TFRGBClr   frgbPink;
        static const TFRGBClr   frgbPlum;
        static const TFRGBClr   frgbSalmon;
        static const TFRGBClr   frgbSeaGreen;
        static const TFRGBClr   frgbSienna;
        static const TFRGBClr   frgbSkyBlue;
        static const TFRGBClr   frgbSlateBlue;
        static const TFRGBClr   frgbSpringGreen;
        static const TFRGBClr   frgbSteelBlue;
        static const TFRGBClr   frgbTan;
        static const TFRGBClr   frgbThistle;
        static const TFRGBClr   frgbTurquoise;
        static const TFRGBClr   frgbViolet;
        static const TFRGBClr   frgbVioletRed;
        static const TFRGBClr   frgbWheat;
        static const TFRGBClr   frgbYellowGreen;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TFacCIDTracer,TFacility);
};

#pragma pack(pop)
