//
// NAME: CIDTracer_ThisFacility.Cpp
//
// DESCRIPTION: 
//
//  This module implements the facility class for this facility. It is a
//  derivative (as all facility objects are) of TFacility.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 11/26/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


// ----------------------------------------------------------------------------
//  Facility specific includes
// ----------------------------------------------------------------------------
#include    "CIDTracer_.Hpp"

// ----------------------------------------------------------------------------
//  Do our RTTI macros
// ----------------------------------------------------------------------------
RTTIData(TFacCIDTracer,TFacility)


// -----------------------------------------------------------------------------
//   CLASS: TFacCIDTracer
//  PREFIX: fac
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//  TFacCIDTracer: Static data members.
// -----------------------------------------------------------------------------
#define CLRPRFX const TFRGBClr
CLRPRFX TFacCIDTracer::frgbBlack(0, 0, 0);
CLRPRFX TFacCIDTracer::frgbBlue(0, 0, 1);
CLRPRFX TFacCIDTracer::frgbCyan(0, 1, 1);
CLRPRFX TFacCIDTracer::frgbGreen(0, 1, 0);
CLRPRFX TFacCIDTracer::frgbMagenta(1, 0, 1);
CLRPRFX TFacCIDTracer::frgbRed(1, 0, 0);
CLRPRFX TFacCIDTracer::frgbWhite(1, 1, 1);
CLRPRFX TFacCIDTracer::frgbYellow(1, 1, 0);

CLRPRFX TFacCIDTracer::frgbAquamarine(0.439216, 0.858824, 0.576471);
CLRPRFX TFacCIDTracer::frgbBlueViolet(0.62352, 0.372549, 0.623529);
CLRPRFX TFacCIDTracer::frgbBrown(0.647059, 0.164706, 0.164706);
CLRPRFX TFacCIDTracer::frgbCadetBlue(0.372549, 0.623529, 0.623529);
CLRPRFX TFacCIDTracer::frgbCoral(1.0, 0.498039, 0.0);
CLRPRFX TFacCIDTracer::frgbCornflowerBlue(0.258824, 0.258824, 0.435294);
CLRPRFX TFacCIDTracer::frgbDarkGreen(0.184314, 0.309804, 0.184314);
CLRPRFX TFacCIDTracer::frgbDarkOliveGreen(0.309804, 0.309804, 0.184314);
CLRPRFX TFacCIDTracer::frgbDarkOrchid(0.6, 0.196078, 0.8);
CLRPRFX TFacCIDTracer::frgbDarkSlateBlue(0.419608, 0.137255, 0.556863);
CLRPRFX TFacCIDTracer::frgbDarkSlateGrey(0.184314, 0.309804, 0.309804);
CLRPRFX TFacCIDTracer::frgbDarkTurquoise(0.439216, 0.576471, 0.858824);
CLRPRFX TFacCIDTracer::frgbDimGrey(0.329412, 0.329412, 0.329412);
CLRPRFX TFacCIDTracer::frgbFirebrick(0.556863, 0.137255, 0.137255);
CLRPRFX TFacCIDTracer::frgbForestGreen(0.137255, 0.556863, 0.137255);
CLRPRFX TFacCIDTracer::frgbGold(0.8, 0.498039, 0.196078);
CLRPRFX TFacCIDTracer::frgbGoldenrod(0.858824, 0.858824, 0.439216);
CLRPRFX TFacCIDTracer::frgbGreenYellow(0.576471, 0.858824, 0.439216);
CLRPRFX TFacCIDTracer::frgbGrey(0.752941, 0.752941, 0.752941);
CLRPRFX TFacCIDTracer::frgbIndianRed(0.309804, 0.184314, 0.184314);
CLRPRFX TFacCIDTracer::frgbKhaki(0.623529, 0.623529, 0.372549);
CLRPRFX TFacCIDTracer::frgbLightBlue(0.74902, 0.847059, 0.847059);
CLRPRFX TFacCIDTracer::frgbLightGrey(0.658824, 0.658824, 0.658824);
CLRPRFX TFacCIDTracer::frgbLightSteelBlue(0.560784, 0.560784, 0.737255);
CLRPRFX TFacCIDTracer::frgbLimeGreen(0.196078, 0.8, 0.196078);
CLRPRFX TFacCIDTracer::frgbMaroon(0.556863, 0.137255, 0.419608);
CLRPRFX TFacCIDTracer::frgbMediumAquamarine(0.196078, 0.8, 0.6);
CLRPRFX TFacCIDTracer::frgbMediumBlue(0.196078, 0.196078, 0.8);
CLRPRFX TFacCIDTracer::frgbMediumForestGreen(0.419608, 0.556863, 0.137255);
CLRPRFX TFacCIDTracer::frgbMediumGoldenrod(0.917647, 0.917647, 0.678431);
CLRPRFX TFacCIDTracer::frgbMediumOrchid(0.576471, 0.439216, 0.858824);
CLRPRFX TFacCIDTracer::frgbMediumSeaGreen(0.258824, 0.435294, 0.258824);
CLRPRFX TFacCIDTracer::frgbMediumSlateBlue(0.498039, 0, 1.0);
CLRPRFX TFacCIDTracer::frgbMediumSpringGreen(0.498039, 1, 0); 
CLRPRFX TFacCIDTracer::frgbMediumTurquoise(0.439216, 0.858824, 0.858824);
CLRPRFX TFacCIDTracer::frgbMediumVioletRed(0.858824, 0.439216, 0.576471);
CLRPRFX TFacCIDTracer::frgbMidnightBlue(0.184314, 0.184314, 0.309804);
CLRPRFX TFacCIDTracer::frgbNavy(0.137255, 0.137255, 0.556863);
CLRPRFX TFacCIDTracer::frgbNavyBlue(0.137255, 0.137255, 0.556863);
CLRPRFX TFacCIDTracer::frgbOrange(0.8, 0.196078, 0.196078);
CLRPRFX TFacCIDTracer::frgbOrangeRed(1, 0, 0.498039);
CLRPRFX TFacCIDTracer::frgbOrchid(0.858824, 0.439216, 0.858824);
CLRPRFX TFacCIDTracer::frgbPaleGreen(0.560784, 0.737255, 0.560784);
CLRPRFX TFacCIDTracer::frgbPink(0.737255, 0.560784, 0.560784);
CLRPRFX TFacCIDTracer::frgbPlum(0.917647, 0.678431, 0.917647);
CLRPRFX TFacCIDTracer::frgbSalmon(0.435294, 0.258824, 0.258824);
CLRPRFX TFacCIDTracer::frgbSeaGreen(0.137255, 0.556863, 0.419608);
CLRPRFX TFacCIDTracer::frgbSienna(0.556863, 0.419608, 0.137255);
CLRPRFX TFacCIDTracer::frgbSkyBlue(0.196078, 0.6, 0.8);
CLRPRFX TFacCIDTracer::frgbSlateBlue(0, 0.498039, 1.0);
CLRPRFX TFacCIDTracer::frgbSpringGreen(0, 1, 0.498039);
CLRPRFX TFacCIDTracer::frgbSteelBlue(0.137255, 0.419608, 0.556863);
CLRPRFX TFacCIDTracer::frgbTan(0.858824, 0.576471, 0.439216);
CLRPRFX TFacCIDTracer::frgbThistle(0.847059, 0.74902, 0.847059);
CLRPRFX TFacCIDTracer::frgbTurquoise(0.678431, 0.917647, 0.917647);
CLRPRFX TFacCIDTracer::frgbViolet(0.309804, 0.184314, 0.309804);
CLRPRFX TFacCIDTracer::frgbVioletRed(0.8, 0.196078, 0.6);
CLRPRFX TFacCIDTracer::frgbWheat(0.847059, 0.847059, 0.74902);
CLRPRFX TFacCIDTracer::frgbYellowGreen(0.6, 0.8, 0.196078);
CLRPRFX TFacCIDTracer::frgbOldGold(0.81, 0.71, 0.23);
#undef  CLRPRFX



// -----------------------------------------------------------------------------
//  TFacCIDTracer: Constructors and Destructors
// -----------------------------------------------------------------------------

//
// FUNCTION/METHOD NAME: TFacCIDTracer
//                       ~TFacCIDTracer
//
// DESCRIPTION:
//
//  This is the constructor for the Facility class. This guy, like all
//  Facility classes, is based on TFacility so it calls the TFacility
//  constructor, passing it the name of this facility.
// -------------------------------------
//   INPUT: None
//
//  OUTPUT: None
//
//  RETURN: None
//
TFacCIDTracer::TFacCIDTracer() :

    TFacility
    (
        L"CIDTracer"
        , tCIDLib::EModType_Dll
        , kCIDLib::c4MajVersion
        , kCIDLib::c4MinVersion
    )
{
}

TFacCIDTracer::~TFacCIDTracer()
{
}
