//
// NAME: CIDTracer_Sphere.Hpp
//
// DESCRIPTION: 
//
//  This is the header file for the CIDTracer_Sphere.Cpp module. This module
//  module implements the TRTSphere class. Like all of the TRTObject derived
//  classes, this guy understands how to do all of the math operations to
//  handle intersections by a ray and calculating surface normals, etc...
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 03/05/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TRTSphere
// PREFIX: sphr
// -----------------------------------------------------------------------------
class CIDTRACEREXP TRTSphere : public TRTGeometricObj
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and Destructors
        // ---------------------------------------------------------------------
        TRTSphere();

        TRTSphere
        (
            const   TRTSphere&              sphrSrc
        );

        ~TRTSphere();


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid CalcSurfaceNormal
        (
            const   TIntersect* const       pintrSrc
            ,       T3DVector&               vecNormal
        )   const;

        tCIDLib::TVoid Invert();

        tCIDLib::TVoid ParseMethod
        (
                    TParseInfo&             prsiSource
        );

        tCIDLib::TVoid Transform
        (
            const   TTransform&             trnsApply
        );


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TRTSphere& operator=
        (
            const   TRTSphere&              sphrSrc
        );


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TFloat8 f8Radius() const;

        tCIDLib::TFloat8 f8Radius
        (
            const   tCIDLib::TFloat8        f8Radius
        );

        tCIDLib::TFloat8 f8RadiusSqr() const;

        T3DVector vecCenter() const;

        const T3DVector& vecCenter
        (
            const   T3DVector&              vecCenter
        );


    protected   :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _AllIntersects
        (
            const   TLightRay&              lrayTest
            ,       TIntersectArray&        intraIntersects
        )   const;

        tCIDLib::TBoolean _bPointInObj
        (
            const   T3DVector&              vecPoint
        )   const;

        tCIDLib::TBoolean _bTestIntersect
        (
            const   TLightRay&              lrayTest
            ,       tCIDLib::TFloat8&       f8Distance1
            ,       tCIDLib::TFloat8&       f8Distance2
        )   const;

        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmToWriteTo
        )   const;

        tCIDLib::TVoid _Rotate
        (
            const   T3DVector&              vecRotate
            , const TTransform&             trnsRotate
        );

        tCIDLib::TVoid _Scale
        (
            const   T3DVector&              vecScale
            , const TTransform&             trnsScale
        );

        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;

        tCIDLib::TVoid _Translate
        (
            const   T3DVector&              vecTrans
            , const TTransform&             trnsTranslate
        );


    private :
        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __f8Radius
        //      The radius of the sphere
        //
        //  __f8RadiusSqr
        //      The radius squared, which is maintained for speed. When the
        //      object is construtced or the radius is changed, this is
        //      updated.
        //
        //  __vecCenter
        //      The vector that represents the center point of the sphere.
        // ---------------------------------------------------------------------
        tCIDLib::TFloat8        __f8Radius;
        tCIDLib::TFloat8        __f8RadiusSqr;
        T3DVector               __vecCenter;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TRTSphere,TRTGeometricObj)
        DefPolyDup(TRTSphere)
};

#pragma pack(pop)



// -----------------------------------------------------------------------------
//  Constructors and destructors
// -----------------------------------------------------------------------------
inline TRTSphere::~TRTSphere()
{
}


// -----------------------------------------------------------------------------
//  Public, non-virtual methods
// -----------------------------------------------------------------------------
inline tCIDLib::TFloat8 TRTSphere::f8Radius() const
{
    return __f8Radius;
}

inline tCIDLib::TFloat8 TRTSphere::f8Radius(const tCIDLib::TFloat8 f8Radius)
{
    __f8Radius = f8Radius;
    __f8RadiusSqr = f8Radius * f8Radius;
    return __f8Radius;
}

inline tCIDLib::TFloat8 TRTSphere::f8RadiusSqr() const
{
    return __f8RadiusSqr;
}

inline T3DVector TRTSphere::vecCenter() const
{
    return __vecCenter;
}

inline const T3DVector& TRTSphere::vecCenter(const T3DVector& vecCenter)
{
    __vecCenter=vecCenter;
    return __vecCenter;
}
