//
// NAME: CIDTracer_Quadric.Hpp
//
// DESCRIPTION: 
//
//  This is the header file for the CIDTracer_Quadric.Cpp module. This module
//  module implements the TRTQuadric class. Like all of the TRTObject derived
//  classes, this guy understands how to do all of the math operations to
//  handle intersections by a ray and calculating surface normals, etc...
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 03/12/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TRTQuadric
// PREFIX: pln
// -----------------------------------------------------------------------------
class CIDTRACEREXP TRTQuadric : public TRTGeometricObj
{
    public              :
        // ---------------------------------------------------------------------
        // Constructors and Destructors
        // ---------------------------------------------------------------------
        TRTQuadric();

        TRTQuadric
        (
            const   TRTQuadric&             quadSrc
        );

        TRTQuadric
        (
            const   T3DVector&              vecABC
            , const T3DVector&              vecDEF
            , const T3DVector&              vecGHI
            , const tCIDLib::TFloat8        f8Constant
        );

        ~TRTQuadric();


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TRTQuadric& operator=
        (
            const   TRTQuadric&             quadSrc
        );


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid AppendTexture
        (
                    TRTTexture* const       ptxtrAppend
            , const TString&                strName = NUL_TString
            , const TString&                strNameSpace = NUL_TString
        );

        tCIDLib::TVoid CalcSurfaceNormal
        (
            const   TIntersect* const       pintrSrc
            ,       T3DVector&              vecNormal
        )   const;

        tCIDLib::TVoid Invert();

        tCIDLib::TVoid ParseMethod
        (
                    TParseInfo&             prsiSrc
        );

        tCIDLib::TVoid PrependTexture
        (
                    TRTTexture* const       ptxtrPrepend
            , const TString&                strName = NUL_TString
            , const TString&                strNameSpace = NUL_TString
        );

        tCIDLib::TVoid Transform
        (
            const   TTransform&             trnsApply
        );


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        TRTPlane* pplnClip1();

        TRTPlane* pplnClip2();

        tCIDLib::TVoid SetClipPlane1
        (
            const   TRTPlane&               plnClip
        );

        tCIDLib::TVoid SetClipPlane2
        (
            const   TRTPlane&               plnClip
        );



    protected   :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _AllIntersects
        (
            const   TLightRay&              lrayTest
            ,       TIntersectArray&        intraIntersects
        )   const;

        tCIDLib::TBoolean _bPointInObj
        (
            const   T3DVector&              vecPoint
        )   const;

        tCIDLib::TBoolean _bTestIntersect
        (
            const   TLightRay&              lrayTest
            ,       tCIDLib::TFloat8&       f8Dist1
            ,       tCIDLib::TFloat8&       f8Dist2
        )   const;

        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmToWriteTo
        )   const;

        tCIDLib::TVoid _Rotate
        (
            const   T3DVector&              vecRotate
            , const TTransform&             trnsRotate
        );

        tCIDLib::TVoid _Scale
        (
            const   T3DVector&              vecScale
            , const TTransform&             trnsScale
        );

        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;

        tCIDLib::TVoid _Translate
        (
            const   T3DVector&              vecTrans
            , const TTransform&             trnsTranslate
        );

        // ---------------------------------------------------------------------
        //  Protected, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _ToMatrix
        (
                    T4By4Matrix&            mtrxTarget
        );

        tCIDLib::TVoid _FromMatrix
        (
            const   T4By4Matrix&            mtrxSrc
        );


    private :
        // ---------------------------------------------------------------------
        //  Private, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TBoolean __bPointInClipArea
        (
            const   T3DVector&              vecTest
        )   const;

        tCIDLib::TBoolean __bPointInObject
        (
            const   T3DVector&              vecTest
        )   const;

        tCIDLib::TBoolean __bTestIntersect
        (
            const   TLightRay&              lrayTest
            ,       tCIDLib::TFloat8&       f8Dist1
            ,       tCIDLib::TFloat8&       f8Dist2
        )   const;


        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __bNonZero
        //      This is a flag that is set if both the eye and direction
        //      vectors are non-zero.
        //
        //  __f8Constant
        //      This is the quadric constant. It goes into the EMatrix_44
        //      position when the quadric is transformed.
        //
        //  __pplnClip1
        //  __pplnClip2
        //      These are the two optional clipping planes for the quadric.
        //      These are used to control the extent of the quadric in
        //      its infinite direction. They are set to 0 initially. They
        //      are pointers to avoid a header dependency.
        //
        //  __vecABC
        //  __vecDEF
        //  __vecGHI
        //      These are the vectors that determine the quadric shape and
        //      orientation.
        // ---------------------------------------------------------------------
        tCIDLib::TBoolean       __bNonZero;
        tCIDLib::TFloat8        __f8Constant;
        TRTPlane*               __pplnClip1;
        TRTPlane*               __pplnClip2;
        T3DVector               __vecABC;
        T3DVector               __vecDEF;
        T3DVector               __vecGHI;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TRTQuadric,TRTGeometricObj)
        DefPolyDup(TRTQuadric)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  Public, non-virtual methods
// -----------------------------------------------------------------------------
inline TRTPlane* TRTQuadric::pplnClip1()
{
    return __pplnClip1;
}

inline TRTPlane* TRTQuadric::pplnClip2()
{
    return __pplnClip2;
}
