//
// NAME: CIDTracer_Plane.Hpp
//
// DESCRIPTION: 
//
//  This is the header for CIDTracer_Plane.Cpp. This module implements an
//  infinite, one-sided plane.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 03/05/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: TRTPlane
// PREFIX: pln
// -----------------------------------------------------------------------------
class CIDTRACEREXP TRTPlane : public TRTGeometricObj
{
    public  :
        // ---------------------------------------------------------------------
        // Constructors and Destructors
        // ---------------------------------------------------------------------
        TRTPlane();

        TRTPlane
        (
            const   TRTPlane&               plnSrc
        );

        TRTPlane
        (
            const   T3DVector&              vecNormal
            , const tCIDLib::TFloat8        f8Distance
        );

        ~TRTPlane();


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        TRTPlane& operator=
        (
            const   TRTPlane&               plnSrc
        );


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid CalcSurfaceNormal
        (
            const   TIntersect* const       pintrSrc
            ,       T3DVector&              vecNormal
        )   const;

        tCIDLib::TVoid Invert();

        tCIDLib::TVoid ParseMethod
        (
                    TParseInfo&             prsiSource
        );

        tCIDLib::TVoid Transform
        (
            const   TTransform&             trnsApply
        );


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TFloat8 f8Distance
        (
            const   tCIDLib::TFloat8        f8New
        );

        tCIDLib::TFloat8 f8Distance() const;

        const T3DVector& vecNormal
        (
            const   T3DVector&              vecNew
        );

        const T3DVector& vecNormal() const;


    protected           :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _AllIntersects
        (
            const   TLightRay&              lrayTest
            ,       TIntersectArray&        intraIntersects
        )   const;

        tCIDLib::TBoolean _bPointInObj
        (
            const   T3DVector&              vecPoint
        )   const;

        tCIDLib::TBoolean _bTestIntersect
        (
            const   TLightRay&              lrayTest
            ,       tCIDLib::TFloat8&       f8Dist1
            ,       tCIDLib::TFloat8&       f8Dist2
        )   const;

        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmToWriteTo
        )   const;

        tCIDLib::TVoid _Rotate
        (
            const   T3DVector&              vecRotate
            , const TTransform&             trnsRotate
        );

        tCIDLib::TVoid _Scale
        (
            const   T3DVector&              vecScale
            , const TTransform&             trnsScale
        );

        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&          strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&          strmToWriteTo
        )   const;

        tCIDLib::TVoid _Translate
        (
            const   T3DVector&              vecTrans
            , const TTransform&             trnsTranslate
        );


    private :
        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __f8Distance
        //      The distance from the origin, in the direction of the
        //      normal.
        //
        //  __vecNormal
        //      The vector that represents the plane normal, i.e. a ray
        //      sticking straight up out of the plane.
        // ---------------------------------------------------------------------
        tCIDLib::TFloat8        __f8Distance;
        T3DVector                __vecNormal;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TRTPlane,TRTGeometricObj)
        DefPolyDup(TRTPlane)
};

#pragma pack(pop)



// -----------------------------------------------------------------------------
//  Constructors and Destructors
// -----------------------------------------------------------------------------
inline TRTPlane::~TRTPlane()
{
}


// -----------------------------------------------------------------------------
//  Public, inherited methods
// -----------------------------------------------------------------------------
inline tCIDLib::TVoid
TRTPlane::CalcSurfaceNormal(const   TIntersect* const   pintrSrc
                            ,       T3DVector&          vecNormal) const
{
    vecNormal = __vecNormal;
}


// -----------------------------------------------------------------------------
//  Public, non-virtual methods
// -----------------------------------------------------------------------------
inline tCIDLib::TFloat8 TRTPlane::f8Distance(const tCIDLib::TFloat8 f8New)
{
    __f8Distance = -f8New;
    return __f8Distance;
}

inline tCIDLib::TFloat8 TRTPlane::f8Distance() const
{
    return __f8Distance;
}

inline const T3DVector& TRTPlane::vecNormal(const T3DVector& vecNew)
{
    __vecNormal = vecNew;
    return __vecNormal;
}

inline const T3DVector& TRTPlane::vecNormal() const
{
    return __vecNormal;
}
