//
// NAME: CIDRay_Parse_.Hpp
//
// DESCRIPTION: 
//
//  This is a private header for CIDRay_Parse.Cpp which uses a couple of
//  private classes and types. Defining them all in the .Cpp file would
//  clutter it up unnecessarily, so they are put here.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/12/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//
//  1)  The lists of predefined names created below have hash value members,
//      but those cannot be calculated until the Dll is initialized. So the
//      module init code in the parser module handles calculating the hashes
//      for all of them.
//


// -----------------------------------------------------------------------------
//  Only include in the CIDRay_Parse.Cpp module. We put it here because it
//  just gets in the way there.
// -----------------------------------------------------------------------------
struct  TTokenList
{
    tCIDLib::Tch            szName[65];
    TParseInfo::eTokens     eToken;
};



// -----------------------------------------------------------------------------
//  Local, constant data declarations with CIDRay_Parse.Cpp
//
//  __atokList
//      This is a list of the valid syntax tokens and their text. This list
//      is used to look up tokens as they are parsed.
//      Note that we have to duplicate __aszTokens here because we also need
//      to have a way to map them to our enum.
//
//  __aszTokens
//      This is an array of string pointers. Each element is a syntax
//      character. This array is downloaded to the stream parser as our
//      syntax set so that he will always distinguish them as separate
//      tokens even if not surrounded by white space.
// -----------------------------------------------------------------------------
const   TTokenList   __atokList[] =
{
      { L"AddObject"        , TParseInfo::eToken_AddObject      }
    , { L"AddLight"         , TParseInfo::eToken_AddLight       }
    , { L"AltColor"         , TParseInfo::eToken_AltColor       }
    , { L"Ambient"          , TParseInfo::eToken_Ambient        }
    , { L"AppendBand"       , TParseInfo::eToken_AppendBand     }
    , { L"AppendTexture"    , TParseInfo::eToken_AppendTexture  }
    , { L"Bounding"         , TParseInfo::eToken_Bounding       }
    , { L"Brilliance"       , TParseInfo::eToken_Brilliance     }
    , { L"Bump"             , TParseInfo::eToken_BumpAmount     }
    , { L"Center"           , TParseInfo::eToken_Center         }
    , { L"Clip1"            , TParseInfo::eToken_Clip1          }
    , { L"Clip2"            , TParseInfo::eToken_Clip2          }
    , { L"Color"            , TParseInfo::eToken_Color          }
    , { L"Constant"         , TParseInfo::eToken_Constant       }
    , { L"CSGOp"            , TParseInfo::eToken_CSGOperation   }
    , { L"Diffuse"          , TParseInfo::eToken_Diffuse        }
    , { L"Distance"         , TParseInfo::eToken_Distance       }
    , { L"EyePos"           , TParseInfo::eToken_EyePosition    }
    , { L"FogColor"         , TParseInfo::eToken_FogColor       }
    , { L"Frequency"        , TParseInfo::eToken_Frequency      }
    , { L"Import"           , TParseInfo::eToken_Import         }
    , { L"Invert"           , TParseInfo::eToken_Invert         }
    , { L"Lens"             , TParseInfo::eToken_Lens           }
    , { L"LookAt"           , TParseInfo::eToken_LookAt         }
    , { L"Matrix"           , TParseInfo::eToken_Matrix         }
    , { L"MaxDepth"         , TParseInfo::eToken_Depth          }
    , { L"Metallic"         , TParseInfo::eToken_Metallic       }
    , { L"Normal"           , TParseInfo::eToken_Normal         }
    , { L"Object"           , TParseInfo::eToken_Object         }
    , { L"Phase"            , TParseInfo::eToken_Phase          }
    , { L"Phong"            , TParseInfo::eToken_Phong          }
    , { L"PhongSize"        , TParseInfo::eToken_PhongSize      }
    , { L"PrependBand"      , TParseInfo::eToken_PrependBand    }
    , { L"PrependTexture"   , TParseInfo::eToken_PrependTexture }
    , { L"QuadVals"         , TParseInfo::eToken_QuadricValues  }
    , { L"Quality"          , TParseInfo::eToken_Quality        }
    , { L"Radius"           , TParseInfo::eToken_Radius         }
    , { L"Randomness"       , TParseInfo::eToken_Randomness     }
    , { L"Reflection"       , TParseInfo::eToken_Reflection     }
    , { L"Refraction"       , TParseInfo::eToken_Refraction     }
    , { L"RefracIndex"      , TParseInfo::eToken_RefractionIndex}
    , { L"RightDir"         , TParseInfo::eToken_RightVector    }
    , { L"Rotate"           , TParseInfo::eToken_Rotate         }
    , { L"Roughness"        , TParseInfo::eToken_Roughness      }
    , { L"Sample"           , TParseInfo::eToken_Sample         }
    , { L"Scale"            , TParseInfo::eToken_Scale          }
    , { L"Scene"            , TParseInfo::eToken_Scene          }
    , { L"Specular"         , TParseInfo::eToken_Specular       }
    , { L"Texture"          , TParseInfo::eToken_Texture        }
    , { L"Translate"        , TParseInfo::eToken_Translate      }
    , { L"Turbulence"       , TParseInfo::eToken_Turbulence     }
    , { L"UpDir"            , TParseInfo::eToken_UpVector       }
    , { L"Vector"           , TParseInfo::eToken_Vector         }
    , { L"Visible"          , TParseInfo::eToken_Visibility     }

    , { L"}"                , TParseInfo::eToken_CloseBrace     }
    , { L">"                , TParseInfo::eToken_CloseBracket   }
    , { L")"                , TParseInfo::eToken_CloseParen     }
    , { L"{"                , TParseInfo::eToken_OpenBrace      }
    , { L"<"                , TParseInfo::eToken_OpenBracket    }
    , { L"("                , TParseInfo::eToken_OpenParen      }
    , { L","                , TParseInfo::eToken_Comma          }
    , { L";"                , TParseInfo::eToken_SemiColon      }
    , { L"//"               , TParseInfo::eToken_Comment        }
    , { L"."                , TParseInfo::eToken_Period         }
    , { L"::"               , TParseInfo::eToken_DoubleColon    }
};                          
const tCIDLib::TCard4  __c4TokenCount  = c4ArrayElems(__atokList);


const   tCIDLib::Tch* __aszTokens[] =
{
    L"{"
    , L"}"
    , L"("
    , L")"
    , L"<"
    , L">"
    , L","
    , L";"
    , L"//"
    , L"."
    , L"::"
};
const tCIDLib::TCard4  __c4SyntaxCount =   c4ArrayElems(__aszTokens);
